```
git clone https://github.com/borrmann-dev/construct-x-edge-k8s.git
```

# replace edc/values.yaml with the following:

```yaml
configuration:  
 postgresuser: &postgresuser testuser  
 postgrespass: &postgrespass testpass  
 edcKey: &edcKey TEST  
   
nameOverride: "dataprovider-x"  
fullnameOverride: ""  
seedTestdata: true 
testdataConfigMap: ""
backendUrl: "http://{{ .Release.Name }}-dataprovider-x-submodelserver:8080" 
registryUrl: "http://{{ .Release.Name }}-dataprovider-x-dtr:8080/api/v3"  Override the digital twin registry url  
controlplanePublicUrl: "http://{{ .Release.Name }}-dataprovider-x-edc-controlplane:8084" 
controlplaneManagementUrl: "http://{{ .Release.Name }}-dataprovider-x-edc-controlplane:8081" 
dataplaneUrl: "http://{{ .Release.Name }}-dataprovider-x-edc-dataplane:8081" 
secrets:  
 edc-wallet-secret: changeme  
   
tractusx-connector:  
 nameOverride: dataprovider-x-edc  
 enabled: true  
 install:  
   postgresql: true  
   vault: false  
 participant:  
   id: BPNL00000000061Z  
 iatp:  
   id: did:web:ssi-dim-wallet-stub.construct-x.net:BPNL00000000061Z  
   trustedIssuers:  
     - did:web:ssi-dim-wallet-stub.construct-x.net:BPNL00000003CRHK  
   sts:  
     dim:  
       url: https://ssi-dim-wallet-stub.construct-x.net/api/sts  
     oauth:  
       token_url: https://ssi-dim-wallet-stub.construct-x.net/oauth/token  
       client:  
         id: BPNL00000000061Z  
         secret_alias: edc-wallet-secret  
 controlplane:  
   env:  
     TX_IAM_IATP_CREDENTIALSERVICE_URL: https://ssi-dim-wallet-stub.construct-x.net/api  
     EDC_IAM_DID_WEB_USE_HTTPS: false  
   bdrs:  
     server:  
       url: https://ssi-dim-wallet-stub.construct-x.net/api/v1/directory  
   endpoints:  
     management:  
       authKey: TEST2  
   ingresses:  
     - enabled: true  
       annotations:  
         nginx.ingress.kubernetes.io/ssl-redirect: "false"  
         cert-manager.io/cluster-issuer: letsencrypt-prod  
       hostname: "dataprovider-x-controlplane.construct-x.ub-edge-one.de"  
       endpoints:  
         - default  
         - protocol  
         - management  
       className: "nginx"  
       tls:  
         enabled: false  
   securityContext:  
     readOnlyRootFilesystem: false  
   resources:  
     limits:  
       cpu: 1.5  
       memory: 1024Mi  
     requests:  
       cpu: 500m  
       memory: 1024Mi  
 dataplane:  
   env:  
     TX_IAM_IATP_CREDENTIALSERVICE_URL: https://ssi-dim-wallet-stub.construct-x.net/api  
     EDC_IAM_DID_WEB_USE_HTTPS: false  
   ingresses:  
     - enabled: true  
       annotations:  
         nginx.ingress.kubernetes.io/ssl-redirect: "false"  
         cert-manager.io/cluster-issuer: letsencrypt-prod  
       hostname: "dataprovider-x-dataplane.construct-x.ub-edge-one.de"  
       endpoints:  
         - default  
         - public  
       className: "nginx"  
       tls:  
         enabled: true  
   token:  
     signer:  
       privatekey_alias: tokenSignerPrivateKey  
     verifier:  
       publickey_alias: tokenSignerPublicKey  
   resources:  
     limits:  
       cpu: 1.5  
       memory: 1024Mi  
     requests:  
       cpu: 500m  
       memory: 1024Mi  
   
 vault:  
   hashicorp:  
     url: http://edc-dataprovider-x-vault:8200  
     token: "root"  
   secretNames:  
     transferProxyTokenSignerPrivateKey: tokenSignerPrivateKey  
     transferProxyTokenSignerPublicKey: tokenSignerPublicKey  
     transferProxyTokenEncryptionAesKey: tokenEncryptionAesKey  
   
 postgresql:  
   nameOverride: dataprovider-x-db  
   image:  
     repository: bitnamilegacy/postgresql  
     tag: 16.2.0-debian-12-r10  
   jdbcUrl: "jdbc:postgresql://{{ .Release.Name }}-dataprovider-x-db:5432/edc"  
   primary:  
     persistence:  
       enabled: false  
       size: 1Gi  
   auth:  
     database: edc  
     username: *postgresuser  
     password: "dbpasswordtxdataprovider-x"  
     postgresPassword: "dbpasswordtxdataprovider-x"  
   username: *postgresuser  
   password: "dbpasswordtxdataprovider-x"  
   resources:  
     limits:  
         cpu: 500m  
         memory: 500Mi  
     requests:  
       cpu: 250m  
       memory: 256Mi  
   
digital-twin-registry:  
 nameOverride: dataprovider-x-dtr  
 enabled: false  
 enableKeycloak: false  
   
 postgresql:  
   nameOverride: dataprovider-x-dtr-db  
   auth:  
     password: "dbpassworddtrdataprovider-x"  
     existingSecret: dataprovider-x-secret-dtr-postgres-init  
   primary:  
     persistence:  
       enabled: false  
       size: 1Gi  
   resources:  
     limits:  
         cpu: 500m  
         memory: 500Mi  
     requests:  
       cpu: 250m  
       memory: 256Mi  
   
 registry:  
   ingress:  
     enabled: true  
     className: "nginx"  
     tls: true  
     annotations:  
       nginx.ingress.kubernetes.io/ssl-redirect: "false"  
       cert-manager.io/cluster-issuer: letsencrypt-prod  
   host: dataprovider-x-dtr.construct-x.ub-edge-one.de  
   authentication: false  
   livenessProbe:  
     failureThreshold: 10  
     initialDelaySeconds: 60  
     periodSeconds: 10  
   readinessProbe:  
     failureThreshold: 10  
     initialDelaySeconds: 60  
     periodSeconds: 10  
   
simple-data-backend:  
 nameOverride: dataprovider-x-submodelserver  
 enabled: false  
 image:  
   tag: "main"  
 ingress:  
   enabled: true  
   annotations:  
     nginx.ingress.kubernetes.io/ssl-redirect: "false"  
     cert-manager.io/cluster-issuer: letsencrypt-prod  
   className: "nginx"  
   tls:  
     - secretName: "submodelserver.tx.constructx-tls"  
       hosts:  
         - "dataprovider-x-submodelserver.construct-x.ub-edge-one.de"  
   hosts:  
     - host: "dataprovider-x-submodelserver.construct-x.ub-edge-one.de"  
       paths:  
         - path: "/"  
           pathType: "Prefix"  
 resources:  
   limits:  
     cpu: 500m  
     memory: 1024Mi  
   requests:  
     cpu: 500m  
     memory: 1024Mi  
   
vault:  
 nameOverride: edc-dataprovider-x-vault  
 fullnameOverride: edc-dataprovider-x-vault  
 enabled: true  
 injector:  
   enabled: false  
 server:  
   postStart: 
	 - /bin/sh - -c 
     - | apk add jq 
       vault login root 
       vault kv put secret/data/edc-wallet-secret secret="TEST2"  
   dev:  
     enabled: true  
     devRootToken: root  
   ingress:  
     enabled: false
```

# kill everything that has something to do with traefik

```shell

kubectl delete helmchart traefik traefik-crd -n kube-system
helm uninstall traefik -n kube-system
helm uninstall traefik-crd -n kube-system

```

perfect

# now install ingress by executing the script in the folder

```shell
./install-ingress.sh
```

# go into the edc folder and execute

```shell
./install.sh
```

(takes some time)
