# Manuals and Spec Sheets

## Purpose & Ownership
- Placeholder: Describe scope (hardware datasheets, certifications, regulatory notes) and who keeps this index current.
- Placeholder: Note where source files are stored (SharePoint, GitLab, vendor portals) and access permissions.

## Document Library Template
- Placeholder: Provide a table schema (device, vendor link, local copy, last verified) to standardize entries.
- Placeholder: Include guidance on version control (how to track datasheet updates, change logs).

## Zyxel APs
The datasheet is a meme, so read the code instead
https://github.com/openwrt/mt76/blob/master/mt7915/init.c
https://github.com/openwrt/mt76/blob/master/mt7915/mt7915.h

- Placeholder: Link to official Zyxel manuals or support portal once verified.
- Placeholder: Capture mechanical drawings, PoE budget specs, and mounting requirements.

## Teltonika RUTX50
- Placeholder: Add current firmware datasheet, OpenWrt compatibility matrix, and antenna specs.
- Placeholder: Include environmental tolerances (temperature, IP rating) and compliance certificates.

## Hardware Limitations

One SSID is used for mgmt and one for meshing, leaving 6x SSIDs for the customers.
For Client stations we can offer 32 stations per AP.

Technical Reason: Our zyxel APs (mt7915) and our Teltonika (ath10k 2ndgen) technically have a limit of 16 encrypted SSIDs.
Many other chipsets have a limit of 8 (e.g. ath10k 1gen). To be on the safe side, let's consider this our hard limit.

For the client stations connected to zyxel we found a hard limit of 288x in the mt7915.h
<pre>#define MT7915_WTBL_SIZE		288</pre>
We estimate 288/2 = 128 stations should work, but we didn't test it so let's advertise 64.
The Teltonika out of the box supports only 32 stations.

### Maximum Limits

 - 128 Stations per Radio
 - 16 SSIDs per Radio

In external communication, we need to consider to keep flexibility to also use hardware which uses lower limits for each. As long as we do not have to assert spec-sheet tender compliance:

 - 64 Stations per Radio (Easy to communicate, spread over both bands)
 - 6 SSIDs per Radio
   - Other Hardware can have a limit of 8 SSIDs (1 for Setup, 1 for Mesh)

- Placeholder: Document validated performance numbers vs. theoretical limits and note test methodologies.

## Certification & Compliance
- Placeholder: Collect CE/FCC certificates, SIM regulations, and country-specific approvals required for deployments.
- Placeholder: Track expiration/renewal dates and responsible contacts.

## Revision Notes
The topic got duplicated. i moved it today from the other wiki page to here. Resolution:

I found a conflict: 32 vs. 64.
we should not advertise 64 because teltonika cannot provide 64 but only 32 stations.

- Placeholder: Create a structured change log for future edits (date, author, summary, impacted docs).
