# Software Packages

This page aims at providing information about the multiple packages involved in building Software for UB-EDGE One

## uconfig

uconfig is a single-source of truth config renderer for OpenWrt. It renders the entire system configuration from a single JSON file.

This allows idempotent configuration of the devices.

We are using an older fork located in our GitLab.

## uconfigd

uconfigd is the daemon running on the device, requesting device state and configuration from the controller. It calls uconfig to apply configuration.

## uconfigd-role-ap

Provides specific files and default configuration for APs providing non-controller functionality.

## uconfigd-role-controller

Provides specific files and default configuration for gateways providing controller functionality.

## uniberg-auther

This application provides the per-device PSK functionality. It is called by hostapd and calls HTTP encpoints on the controller.

## uniberg-cloud-manager

This package provides the WireGuard remote management VPN tunnel establishment tools.

## uniberg-frontend

This package contains the frontend for the local device based frontend

## uniberg-provisioning

This package contains tools required for the provisioning volume.

## uniberg-statsd

Collects statistics for the controller.

## uniberg-wifi-mesh-qos

This package contains script to enable flow-queueing on the wireless mesh interfaces.

## External Feeds
### controller-go

The controller is a software component running on the Gateway.
It provides configuration JSON files to all devices and collects metrics.

- Placeholder: Add build instructions, dependency graph, and test coverage status for each package.
- Placeholder: Document release cadence, maintainers, and open technical debt per package.
- Placeholder: Include table summarizing package responsibilities and repo links for quick navigation.
