# Controller API & Services

UB-EDGE Wireless Controller API specification **v1.0.0**. Use the controller management address (`https://<controller>:8844` by default) with authentication as configured on the device.

## Runtime Services

```sh
service

/etc/init.d/uniberg-auther              enabled   running
/etc/init.d/uniberg-statsd              enabled   running
/etc/init.d/uniberg-ub-edge-api         enabled   running
/etc/init.d/uniberg-uconfigd            enabled   running
/etc/init.d/uniberg-uconfigd-controller enabled   running

# Common operations
service uniberg-statsd status
service uniberg-statsd start|stop|restart
service uniberg-statsd enable|disable
```

- Keep all services enabled and running on production controllers.
- Placeholder: Add log locations and recovery guidance for each daemon.

## API Summary

Base URL: `https://<controller>:8844` or `http://192.168.133.1:8844` when connected to the downstream management LAN.

### Configuration Management

#### GET `/config` — Fetch Network Configuration
- Returns the complete configuration payload (see **NetworkConfig schema**).
- Success `200`: JSON document with `UUID`, `Networks`, and `Wireless` arrays.
- Errors: `500` if the configuration file cannot be read.

#### POST `/config` — Replace Configuration
- Request body (`application/json`, schema **NetworkConfig**):
  - `UUID` *(integer)* — Configuration revision id.
  - `Networks` *(array<Network>)* — VLAN definitions with names and UUIDs.
  - `Wireless` *(array<WirelessNetwork>)* — SSIDs mapped to networks and encryption settings.
- Success `200`: configuration persisted.
- Errors: `400` invalid structure, `500` save failure.

### Node Inventory & Metrics

#### GET `/nodes`
- Returns a list of registered devices (controllers and access points) with their metadata.
- Success `200`: array of **Device** objects.

#### GET `/nodes/{node_id}/config`
- Path parameter: `node_id` *(string, required)* — Node MAC address.
- Success `200`: rendered configuration for the node.
- Errors: `400` invalid node id, `404` not found.

#### GET `/nodes/{node_id}/metrics`
- Path parameter: `node_id` *(string, required)*.
- Success `200`: stored metrics (device telemetry snapshot).
- Errors: `400` device not found, `404` no data for the node.

#### POST `/nodes/{node_id}/metrics`
- Path parameter: `node_id` *(string, required)*.
- Request body (`application/json`): arbitrary JSON metrics blob posted by the node.
- Success `200`: metrics persisted.
- Errors: `400` device not found or malformed JSON, `500` read/parse failure.

### Network Secrets

#### GET `/network/{network_id}/passwords`
- Path parameter: `network_id` *(string, required).* 
- Success `200`: array of **Password** objects.

#### POST `/network/{network_id}/password`
- Path parameter: `network_id` *(string, required).* 
- Request body (`application/json`): array of **Password** objects (passphrase rotation/PPSK updates).
- Success `200` on update.
- Errors: `400` invalid payload (e.g., password length), `500` database update failure.

### Client Operations

#### POST `/wireless/client/bind`
- Request body (`application/json`):
  - `mac_address` *(string)* — Client MAC.
  - `password_hash_type` *(string)* — Hashing scheme expected by the controller.
  - `password_hash` *(string)* — Hashed credential.
  - `ssid` *(string)* — Target SSID.
- Success `200`: binding status payload.
- Errors: `400` invalid request, `404` SSID or passkey not found.

### Node Lifecycle

#### POST `/node/subscribe`
- Request body (`application/json`):
  - `name` *(string)* — Human readable node name.
  - `mac` *(string)* — Node MAC address.
  - `serial` *(string)* — Hardware serial number.
  - `ip_address` *(string)* — Node IP.
  - `radios` *(array<WirelessRadio>)* — Per-radio capabilities.
  - `setup` *(object)* — Setup metadata (see **DeviceConfigServices/DeviceConfigSSH** for structure).
  - `device` *(object)* — Device descriptor (see **Device**).
- Success `200`: subscription successful.
- Errors: `400` invalid MAC or radio properties, `500` key generation failure.

#### GET `/node/test`
- Lightweight health endpoint returning `200` if the controller is reachable.

### System Metrics

#### GET `/system/metrics`
- Returns controller system metrics (memory usage, uptime, cellular statistics).
- Success `200`: metrics object.

## Data Models

### NetworkConfig
- `UUID` *(integer)* — Configuration revision id.
- `Networks` *(array<Network>)* — VLAN definitions.
- `Wireless` *(array<WirelessNetwork>)* — SSIDs mapped to networks and encryption.

### Network
- `Name` *(string)* — VLAN name.
- `UUID` *(string)* — Network UUID.
- `VlanId` *(integer)* — VLAN identifier.

### WirelessNetwork
- `SSID` *(string)* — Broadcast name.
- `NetworkUUID` *(string)* — Associated network.
- `Encryption` *(Encryption)* — Security settings.

### Encryption
- `Method` *(string)* — Encryption method (e.g., `psk2`).
- `Passphrase` *(string, optional)* — Shared PSK.
- `Passkeys` *(array<PPSKPasskey>)* — Per-device PSKs when PPSK is used.

### PPSKPasskey
- `MacAddress` *(string)* — Device MAC.
- `Passkey` *(string)* — PPSK credential.
- `NetworkUUID` *(string)* — Associated network.

### Password
- `MacAddress` *(string)* — Device MAC associated with the password.
- `NetworkId` *(string)* — Network identifier.
- `Password` *(string)* — Credential.

### Device
- `DeviceName` *(string)* — Friendly name.
- `MacAddress` *(string)* — Node MAC.
- `IpAddress` *(string)* — Management IP.
- `EncryptionKey` *(string)* — Provisioned key material.
- `ModelType`, `ModelName` *(string)* — Hardware identification.
- `Role` *(string)* — Controller/AP role.
- `SetupWiFiSSID`, `SetupWiFiKey` *(string)* — Setup network credentials.
- `Radios` *(array<WirelessRadio>)* — Capabilities per radio.

### WirelessRadio
- `Generation` *(integer)* — Wi-Fi generation (4/5/6).
- `Band` *(integer)* — Frequency in GHz (2 or 5).
- `Bandwidth` *(integer)* — Channel width (20/40/80 MHz).
- `DeviceID` *(integer)* — Internal reference.

### Password Rotation Payload
- When rotating secrets via `/network/{network_id}/password`, supply an array of **Password** objects or PPSK entries depending on the network type.

## TODOs
- Document authentication & authorization model for controller endpoints.
- Add sample curl requests including certificate handling and credentials.
- Record log locations for each controller service.
