# Edge [[API]]

Edge-API specification version **1.0.0**. All endpoints require a bearer token obtained via the login flow unless explicitly noted.

## Authentication

### POST `/auth/login` — Authenticate
- Description: Authenticates a user and returns a JWT.
- Request body (`application/json`):
  - `email` *(string, required, email format)* — User email.
  - `password` *(string, required)* — User password.
- Successful response `200` (`application/json`): `{ "apiKey": "<jwt>" }`.
- Error responses:
  - `400` — Invalid request payload.
  - `401` — Invalid credentials.
  - `500` — Could not generate API key.

### GET `/auth/users` — List Users
- Description: Returns all registered users.
- Successful response `200` (`application/json`): array of objects `{ id, email }` (the hashed password is omitted in responses).
- Error responses: `401` unauthorized, `500` fetch failed.

## Network Management

### GET `/edge/networks` — List Networks
- Returns an array of networks with high-level metrics.
- Each item:
  - `id` *(string)* — Network UUID.
  - `name` *(string)* — Display name.
  - `type` *(string)* — `guest` or `business`.
  - `total_clients`, `authenticated_clients`, `online_clients`, `offline_clients` *(integer)* — Client counters.
  - `total_download`, `total_upload` *(integer)* — Aggregate traffic in bytes.
- Errors: `401` unauthorized, `500` fetch failure.

### POST `/edge/networks` — Create Network
- Request body (`application/json`):
  - `name` *(string, required)* — New network name.
  - `type` *(string, required)* — `guest` or `business`.
- Success `200`: network object as described above.
- Errors: `400` validation issues, `401` unauthorized, `409` duplicate configuration, `500` create/update failure.

### GET `/edge/networks/{network_id}` — Network Details
- Path parameter: `network_id` *(string, required)* — Network UUID.
- Success `200`: network object with counters.
- Errors: `401` unauthorized, `404` not found, `500` unable to populate client info.

### DELETE `/edge/networks/{network_id}` — Delete Network
- Path parameter: `network_id` *(string, required)*.
- Success `200`: `{ "message": "Network deleted successfully." }`.
- Errors: `401` unauthorized, `404` not found/failed delete, `500` delete/update failure.

### GET `/edge/networks/{network_id}/guest-password` — Guest WiFi Secret
- Path parameter: `network_id` *(string, required)*.
- Success `200`: `{ "password": "<guest-psk>" }`.
- Errors: `401` unauthorized, `404` network not found, `405` when the network is not of type `guest`.

## Device Management (per Network)

### GET `/edge/networks/{network_id}/devices`
- Path parameter: `network_id` *(string, required)*.
- Success `200`: array of devices (see **Device Model** below).
- Errors: `401` unauthorized, `500` network not found or fetch failure.

### POST `/edge/networks/{network_id}/devices`
- Path parameter: `network_id` *(string, required)*.
- Request body (`application/json`):
  - `name` *(string, required)* — Device label.
  - `type` *(string, required)* — One of `phone`, `laptop`, `pc`, `printer`, `iot`.
- Success `200`: created device object.
- Errors: `400` invalid network ID or payload, `401` unauthorized, `403` cannot add to guest network, `409` duplicate device, `500` add/update failure.

## Device Management (global)

### GET `/edge/devices` — Fleet Overview
- Returns all devices across networks with fields described in **Device Model**.
- Errors: `401` unauthorized, `500` fetch failure.

### GET `/edge/devices/{device_id}` — Device Details
- Path parameter: `device_id` *(string, required)* — Device UUID.
- Success `200`: device object.
- Errors: `401` unauthorized, `404` not found.

### DELETE `/edge/devices/{device_id}` — Delete Device
- Path parameter: `device_id` *(string, required)*.
- Success `200`: `{ "message": "Device deleted successfully." }`.
- Errors: `401` unauthorized, `404` not found/failed delete, `500` deletion failure.

## Access Point Inventory

### GET `/edge/aps`
- Returns all detected access points.
- Each item:
  - `id` *(string)* — AP UUID.
  - `name` *(string)* — Friendly name (e.g., `ap-<mac>`).
  - `mac` *(string)* — MAC address.
  - `firstConnectedAt`, `lastConnectedAt` *(string, ISO timestamp)*.
  - `meshConnections` *(array)* — Mesh peers and signal quality (`bad`, `moderate`, `great`).
  - `connectedDevices` *(integer)* — Connected client count.
  - `online` *(boolean)* — Up/down state.
  - `signal` *(integer)* — Signal strength indicator.
- Errors: `401` unauthorized, `500` fetch failure.

### GET `/edge/aps/{ap_id}` — Access Point Details
- Path parameter: `ap_id` *(string, required)*.
- Success `200`: access point object as above.
- Errors: `401` unauthorized, `404` AP not found.

## Data Models

### Network
- `id` *(string)* — Network UUID.
- `name` *(string)* — Display name.
- `type` *(string)* — `guest` or `business`.
- Client counters: `total_clients`, `authenticated_clients`, `online_clients`, `offline_clients` *(integer)*.
- Traffic counters: `total_download`, `total_upload` *(integer, bytes).* 

### Device
- Identity: `id` *(string)*, `name` *(string)*, `type` *(string: `phone` | `laptop` | `pc` | `printer` | `iot`).
- Credentials: `password` *(string, may be masked).* 
- Connectivity: `mac`, `ip`, `currentAP`, `currentAP_name` *(strings).* 
- Metadata: `addedBy` *(string UUID)*, `addedAt`, `firstConnectedAt`, `lastConnectedAt` *(ISO timestamps).* 
- State: `network` *(string UUID)*, `online` *(boolean)*, `last_checked_at` *(timestamp)*, `auth` *(boolean)*, `authorized` *(boolean)*, `signal` *(integer RSSI).* 
- Telemetry: `bytes_rx`, `bytes_tx`, `packets_rx`, `packets_tx`, `rate_rx`, `rate_tx` *(integers).* 

### Access Point (AP)
- `id`, `name`, `mac` *(strings).* 
- Lifecycle timestamps: `firstConnectedAt`, `lastConnectedAt`.
- `meshConnections` *(array of objects with `otherAP` and `signalStrength` values `bad`/`moderate`/`great`).*
- `connectedDevices` *(integer)*.
- `online` *(boolean)*.
- `signal` *(integer RSSI).* 

### Error Response
- All error responses use `{ "error": "<message>" }` with HTTP status indicating the failure reason.

### Message Response
- Successful delete operations return `{ "message": "..." }`.

### Guest Password Response
- `{ "password": "<guest-psk>" }`.

## Notes & Follow-up
- Validate the JWT token format and expiry handling in client implementations.
- Document sample curl/HTTPie invocations including authorization headers.
