---
title: Firmware
description:
published: true
date: 2025-09-08T14:29:41.561Z
tags:
editor: markdown
dateCreated: 2025-01-14T17:22:15.515Z
---

# Index
- [Index](#index)
- [Firmware](#firmware)
  - [Customization](#customization)

# Firmware

Based on OpenWRT

## Customization

## Installation

Fist, prepare your Computer with the steps from `Preperation`. Proceed with the instructions for your device.

### Preperation

Connect your MacBook using a USB Ethernet adapter to LAN1 of your device.
Power on your device and wait for the Ethernet Link to come up.

Configure the Ethernet Interface accordingly. Navigate in MacOS system settings to your ethernet adapter.

> This step needs to be done for every Ethernet adapter. Changing Adapters will reset this step.
{.is-info}


![screenshot_2025-09-03_at_14.24.38.png](screenshot_2025-09-03_at_14.24.38.png)

![screenshot_2025-09-03_at_14.24.42.png](screenshot_2025-09-03_at_14.24.42.png)

Click on `Details` in the top right corner, navigate to the `TCP/IP` tab and assign the IP-Address `192.168.1.10` and Subnet Mask `255.255.255.0`.

![screenshot_2025-09-03_at_14.24.51.png](screenshot_2025-09-03_at_14.24.51.png)

### Teltonika RUTX50

 1. Complete the setup wizard. Assign the Password `Uniberg123!`

 2. Enable SSH in the Teltonika UI (System --> Administration --> Access Control)
 
    ![screenshot_2025-09-03_at_14.49.31.png](screenshot_2025-09-03_at_14.49.31.png)
    
 3. Connect to the device using SSH
    ```
    ssh -o UserKnownHostsFile=/dev/null root@192.168.1.1
    ```
    
 4. Check from which partition set the device is currently running from.
    ```
    cat /proc/boot_info/rootfs/primaryboot
    ```
    
    In case this command returns 0, flash a Upgrade from Teltonika which can be obtained here and start again from step 1: https://wiki.teltonika-networks.com/view/RUTX50_Firmware_Downloads
    
 5. Transfer the Factory image from the CI to the device using `scp`.
    ```
    scp -oUserKnownHostsFile=/dev/null -O Downloads/openwrt-ipq40xx-generic-teltonika_rutx50-squashfs-factory.ubi root@192.168.1.1:/tmp/openwrt-factory.bin
    ```

 6. Install OpenWrt by writing factory image to flash
 
    ```
    ubiformat /dev/mtd16 -y -f /tmp/openwrt-factory.bin
    ```
    
 7. Activate the flashed firmware
 
    ```
    echo 0 > /proc/boot_info/rootfs/primaryboot
    cat /proc/boot_info/getbinary_bootconfig > /tmp/bootconfig.bin
    cat /proc/boot_info/getbinary_bootconfig1 > /tmp/bootconfig1.bin
    mtd write /tmp/bootconfig.bin /dev/mtd2
    mtd write /tmp/bootconfig1.bin /dev/mtd3
    ```

## Build Process
- Placeholder: Document CI pipeline stages, required toolchains, and artifact locations.
- Placeholder: Include instructions for reproducing builds locally and verifying signatures.

## Release Management
- Placeholder: Capture versioning scheme, changelog expectations, and compatibility matrix.
- Placeholder: Note how firmware updates are communicated to Operations and customers.
