# Components

## [[uconfig]]

uconfig is a single-source of truth config renderer for OpenWrt. It renders the entire system configuration from a single JSON file.

This allows idempotent configuration of the devices.

We are using an older fork located in our GitLab.

## [[uconfigd]]

uconfigd is the daemon running on the device, requesting device state and configuration from the controller. It calls uconfig to apply configuration.

## [[uconfigd-role-ap]]

Provides specific files and default configuration for APs providing non-controller functionality.

## [[uconfigd-role-controller]]

Provides specific files and default configuration for gateways providing controller functionality.

## [[uniberg-auther]]

This application provides the per-device PSK functionality. It is called by hostapd and calls HTTP encpoints on the controller.

## [[uniberg-cloud-manager]]

This package provides the WireGuard remote management VPN tunnel establishment tools.

## [[uniberg-frontend]]

This package contains the frontend for the local device based frontend

## [[uniberg-provisioning]]

This package contains tools required for the provisioning volume.

## uniberg-statsd

Collects statistics for the controller.

## uniberg-wifi-mesh-qos

This package contains script to enable flow-queueing on the wireless mesh interfaces.

## External Feeds
### controller-go

The controller is a software component running on the Gateway.
It provides configuration JSON files to all devices and collects metrics.

## Component Inventory
- Placeholder: Provide table of all logical components (controller, AP agent, frontend, VPN) with owners and repositories.
- Placeholder: Include hardware dependencies (Teltonika router, Zyxel AP) with firmware alignment.

## Responsibilities Matrix
- Placeholder: Describe boundaries between components and what each is responsible for.
- Placeholder: Capture communication protocols/interface contracts between components.

## Deployment Footprint
- Placeholder: Document where each component runs (edge device, cloud VM, customer infrastructure).
- Placeholder: Note scaling units and constraints for each component.

## Health & Monitoring
- Placeholder: List critical health checks and metrics per component.
- Placeholder: Define logging expectations and retention requirements.


[text](https://git.uniberg.com/ub-edge/wiki/-/wikis/10-System-Architecture-Overview)# System Architecture Overview
![UB-EDGE_One_System_Architecture_Overview.svg](UB-EDGE_One_System_Architecture_Overview.svg)


## Example Network Config
```json
{
  "uuid": 1,
  "networks": [
    {
      "uuid": "5b653e09-a261-4da4-8c2f-b604f9cb3f6a",
      "name": "Employees",
      "vlan_id": 10
    },
    {
      "uuid": "5b653e09-a261-4da4-8c2f-b604f9cb3f6b",
      "name": "Guests",
      "vlan_id": 20
    }
  ],
  "wireless_networks": [
    {
      "ssid": "Employees",
      "network_uuid": "5b653e09-a261-4da4-8c2f-b604f9cb3f6a",
      "encryption": {
        "method": "psk2",
        "passphrase": "password"
      }
    },
    {
        "ssid": "Guests",
        "network_uuid": "5b653e09-a261-4da4-8c2f-b604f9cb3f6b",
        "encryption": {
            "method": "open"
        }
    }
  ]
}
```

## Example Controller Config

```json
{
    "uuid": 100,
    "unit": {
        "name": "Controller-1",
        "location": "Gartenhaus",
        "timezone": "Europe/Berlin",
        "leds-active": false
    },
    "services": {
        "ssh": {
            "authorized-keys": [
                "ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAICfnCPGWR8aocwv8TwjLrrR81W+deqeNEuSlvR4xbcgr ub-edge-provisioning@uniberg.com",
                "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABgQDhUUBHJNYw2iuLHJXveX1R+TiZD0XxlXFxnbeSXsF56YV+SlhHnT1/0h5fQua3p1aTLHYO9kNErnRTHxnFzUnH9hOl8raBGTUjmO6SQ2fdkPUkHarFXWVOWApZQ8DW4rkOU6nGiEkBuKQ9H6N23jY+06j4FU7/muw2wCA+BZ9XgSP3J4NWTEY5yAOv7dMVlDAeeeviveuzfrc8rzv2yG9OBK+LWyJ3eagJzOs59RPd6ICTuO7nu+45eLcAN/JhIYt/HodSBAn/btM3ZJ519ur8zZn4aUX8yMdRQHXq1+vq7EKDdwqW0bGQmpIBWpd91sgN2VyaIsw7uOkZ6z3bQIu2bCugRQUFjXdbScMK9JpOyiwDKIYL4RMV7YDpJfj+9oHNffzXHA6EJRyA3c2HC4Lxw4MdbIAX7Pk7nlqLo8mc4qBZ0gQfwgLO7NsPWYc6ja+4UPGMKBiEe223tUYL6nvWu1GG+MWskg3rgngf3/g/+Dir29qYlF2kX7wjQJKs0Js= arthur"
            ]
        }
    },
    "country-code": "DE",
    "radios": {
        "2G": {
            "channel-mode": "HE",
            "channel-width": 20,
            "channel": 1
        },
        "5G": {
            "channel-mode": "HE",
            "channel-width": 20,
            "channel": 36
        }
    },
    "interfaces": {
        "wan": {
            "role": "upstream",
            "services": [
                "ssh"
            ],
            "ports": {
                "wan*": "auto"
            },
            "ipv4": {
                "addressing": "dynamic"
            },
            "ipv6": {
                "addressing": "dynamic"
            },
            "ssids": {
                "main": {
                    "ssid": "ArthurNet",
                    "wifi-radios": [
                        "2G",
                        "5G"
                    ],
                    "bss-mode": "ap",
                    "encryption": {
                        "proto": "psk2",
                        "key": "aaaaaaaa",
                        "ieee80211w": "optional"
                    }
                }
            }
        },
        "lan": {
            "role": "downstream",
            "services": [
                "ssh"
            ],
            "ports": {
                "lan*": "auto"
            },
            "ipv4": {
                "addressing": "static",
                "subnet": "192.168.133.1/24",
                "dhcp": {
                    "lease-first": 10,
                    "lease-count": 100,
                    "lease-time": "5d"
                }
            },
            "ssids": {
                "main": {
                    "ssid": "UB-EDGE Setup",
                    "wifi-radios": [
                        "2G",
                        "5G"
                    ],
                    "bss-mode": "ap"
                }
            }
        }
    }
}
```
