---
title: teltonika estrel
mac:
remote_address: 192.168.201.35
password:
status: live
owner: andreas
last_update: 2025-10-15
---
# ZRD-Estrel

## General Information
- **Location:** Berlin  
- **Address:** Sonnenallee 228, 12043 Berlin  
- **Responsible Person:** Jannis Kahle  
- **Date of Installation:** -  
- **Purpose:** First testing setup for Zeppelin Rental (ZRD).  
- **SIM:** Telekom UNKNOWN  
- **IP:** 192.168.201.35

## Hardware Components

| Component              | Serial No. | MAC Address | WireGuard IP | OS/Firmware | Notes                      |
|------------------------|------------|-------------|--------------|-------------|----------------------------|
| Teltonika RUTX50       |            |             |              |             | ANT1-1                     |
| QuWireless QuMax       |            |             |              |             | directional                 |
| Domino-Clamp Kit       |            |             |              |             |                            |
| Ubiquiti INS-3AF       |            |             |              |             | gigabit adapter passive     |
| Outdoor-Switch         |            |             |              |             |                            |
| NWA55AXE               |            |             |              |             | WAP1-2                      |
| NWA55AXE               |            |             |              |             | WAP1-3                      |
| NWA55AXE               |            |             |              |             | WAP1-4                      |
| Outdoor-POE Injector   |            |             |              |             |                            |

## Maintenance
- **Known issues:** Regular power outages  
- **Special config:** Outdoor switch installed  

- Placeholder: Add maintenance schedule (site visits, remote checks) and responsible technician.


## Access & Credentials
Global password used (change in future).  

- Placeholder: Document credential rotation plan and secure storage location.

## References
- [Photos](https://uniberg-my.sharepoint.com/:f:/p/lukas_kirner/Euy2okngWCNBrVSxgeN8RAsB7NjgXJPefQ4n0n18b4jBZA?e=XqgVmU)
	(anmerkung der redaktion:
	lukas ist 1 schnieker, ich wollte den link hier einfügen, war aber schon da)

## Outstanding Data
- Placeholder: Record missing serial numbers, MACs, and SIM ICCIDs.
- Placeholder: Capture contact details for site owner and access restrictions.

## Speedtest

repo: https://git.uniberg.com/ub-edge/irl-test-results
### AP Bauleitung

```shell
System Information
====================
NAME="OpenWrt"
VERSION="24.10-SNAPSHOT"
ID="openwrt"
ID_LIKE="lede openwrt"
PRETTY_NAME="OpenWrt 24.10-SNAPSHOT"
VERSION_ID="24.10-snapshot"
HOME_URL="https://openwrt.org/"
BUG_URL="https://bugs.openwrt.org/"
SUPPORT_URL="https://forum.openwrt.org/"
BUILD_ID="r0-e6677e14"
OPENWRT_BOARD="ramips/mt7621"
OPENWRT_ARCH="mipsel_24kc"
OPENWRT_TAINTS="no-all"
OPENWRT_DEVICE_MANUFACTURER="OpenWrt"
OPENWRT_DEVICE_MANUFACTURER_URL="https://openwrt.org/"
OPENWRT_DEVICE_PRODUCT="Generic"
OPENWRT_DEVICE_REVISION="v0"
OPENWRT_RELEASE="OpenWrt 24.10-SNAPSHOT r0-e6677e14"
OPENWRT_BUILD_DATE="1750175455"
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣀⣀⣤⣀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣀⣠⣀⣀⡀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣠⣾⣿⣿⣿⣿⣿⣿⣆⠀⢀⣀⣀⣤⣤⣤⣦⣦⣤⣤⣄⣀⣀⠀⢠⣾⣿⣿⣿⣿⣿⣷⣦⡀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣰⣿⣿⣿⣿⣿⣿⣿⣿⡿⠟⠛⠉⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠙⠛⠿⣿⣿⣿⣿⣿⣿⣿⣿⣷⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣿⣿⣿⣿⣿⣿⣿⠟⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠙⢿⣿⣿⣿⣿⣿⣿⡇⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⢻⣿⣿⣿⣿⡟⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠙⣿⣿⣿⣿⣿⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠻⢿⣿⠟⠀⠀⠀⠀⠀⣀⣤⣤⣤⡀⠀⠀⠀⠀⠀⢀⣤⣤⣤⣄⡀⠀⠀⠀⠀⠘⣿⡿⠿⠃⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⢠⡟⠀⠀⠀⠀⣠⣾⣿⣿⣟⣿⡇⠀⠀⠀⠀⠀⢸⣿⣿⣻⣿⣿⣦⠀⠀⠀⠀⠸⣧⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣼⠁⠀⠀⠀⠀⣿⣿⣿⣿⣿⡟⢠⣶⣾⣿⣿⣷⣤⢽⣿⣿⣿⣿⣿⡇⠀⠀⣀⣤⣿⣷⣴⣶⣦⣀⡀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⢀⣠⣤⣤⣠⣇⠀⠀⠀⠀⠀⣿⣿⣿⣿⣿⠀⠘⠻⣿⣿⣿⡿⠋⠀⢹⣿⣿⣿⣿⡇⠀⣿⣿⣿⡏⢹⣿⠉⣿⣿⣿⣷⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⢠⣾⣿⣿⣿⣿⣿⣿⣿⣶⣄⠀⠀⠹⣿⣿⠿⠋⠀⢤⣀⢀⣼⡄⠀⣠⠀⠈⠻⣿⣿⠟⠀⢸⣿⣇⣽⣿⠿⠿⠿⣿⣅⣽⣿⡇⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣆⠀⠀⠀⠀⠀⠀⠀⠀⠈⠉⠁⠉⠉⠀⠀⠀⠀⠀⠀⠀⠀⠈⣿⣿⣟⠁⠀⠀⠀⠈⣿⣿⣿⡇⠀⠀⠀⠀⢀
⠛⠛⠛⠛⠛⠛⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛
⠀⠀⠀⠀⠀⠀⠘⠛⠻⢿⣿⣿⣿⣿⣿⠟⠛⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠀⠈⠉⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀

UB-EDGE - 2025-06-17 - 6a5e2b7
Linux d43df3fef361 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips GNU/Linux
Network Configuration
======================
1: lo: <LOOPBACK,UP,LOWER_UP> mtu 65536 state UNKNOWN qlen 1000
    inet6 ::1/128 scope host proto kernel_lo 
       valid_lft forever preferred_lft forever
2: eth0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1540 state UP qlen 1000
    inet6 fe80::d63d:f3ff:fefe:f361/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
9: up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::4c2d:7ff:fe3b:1320/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
10: up0v11@up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::4c2d:7ff:fe3b:1320/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
11: up1v12@up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::4c2d:7ff:fe3b:1320/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
12: up2v3@up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fd42:dead:c0de:1337:0:d43d:f3fe:f361/64 scope global 
       valid_lft forever preferred_lft forever
    inet6 fe80::4c2d:7ff:fe3b:1320/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
13: batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UNKNOWN qlen 1000
    inet6 fe80::4c2d:7ff:fe3b:1320/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
14: batman.11@batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::4c2d:7ff:fe3b:1320/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
15: batman.12@batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::4c2d:7ff:fe3b:1320/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
16: batman.3@batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::4c2d:7ff:fe3b:1320/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
20: phy0-mesh0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1532 state UP qlen 1000
    inet6 fe80::d03d:f3ff:fefe:f362/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
21: phy1-mesh0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1532 state UP qlen 1000
    inet6 fe80::d03d:f3ff:fefe:f363/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
fd42:dead:c0de:1337::/64 dev up2v3 proto static metric 5 pref medium
unreachable fda0:5e44:a37e::/48 dev lo proto static metric 2147483647 pref medium
fe80::/64 dev eth0 proto kernel metric 256 pref medium
fe80::/64 dev batman proto kernel metric 256 pref medium
fe80::/64 dev batman.11 proto kernel metric 256 pref medium
fe80::/64 dev up proto kernel metric 256 pref medium
fe80::/64 dev up0v11 proto kernel metric 256 pref medium
fe80::/64 dev up1v12 proto kernel metric 256 pref medium
fe80::/64 dev up2v3 proto kernel metric 256 pref medium
fe80::/64 dev batman.12 proto kernel metric 256 pref medium
fe80::/64 dev batman.3 proto kernel metric 256 pref medium
fe80::/64 dev phy0-mesh0 proto kernel metric 256 pref medium
fe80::/64 dev phy1-mesh0 proto kernel metric 256 pref medium
Speed Test Report
==================
Test Started at Wed Jun 18 15:53:03 UTC 2025
Running iperf3 (Upload) test to fd42:dead:c0de:1337::1
iperf 3.17.1
Linux d43df3fef361 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips
Control connection MSS 1368
Time: Wed, 18 Jun 2025 15:53:03 UTC
Connecting to host fd42:dead:c0de:1337::1, port 5201
      Cookie: 5fwgomjpx3gdxhngnmaqfluebrgtex3bbnnb
      TCP MSS: 1368 (default)
[  5] local fd42:dead:c0de:1337:0:d43d:f3fe:f361 port 59950 connected to fd42:dead:c0de:1337::1 port 5201
Starting Test: protocol: TCP, 1 streams, 131072 byte blocks, omitting 0 seconds, 10 second test, tos 0
[ ID] Interval           Transfer     Bitrate         Retr  Cwnd
[  5]   0.00-1.00   sec  3.75 MBytes  31.4 Mbits/sec    0    210 KBytes       
[  5]   1.00-2.00   sec  2.75 MBytes  23.1 Mbits/sec    0    246 KBytes       
[  5]   2.00-3.00   sec  3.25 MBytes  27.3 Mbits/sec    0    299 KBytes       
[  5]   3.00-4.00   sec  1.00 MBytes  8.39 Mbits/sec    1    208 KBytes       
[  5]   4.00-5.00   sec  1.88 MBytes  15.7 Mbits/sec    1    159 KBytes       
[  5]   5.00-6.00   sec  3.12 MBytes  26.2 Mbits/sec    0    171 KBytes       
[  5]   6.00-7.00   sec   768 KBytes  6.29 Mbits/sec    1    120 KBytes       
[  5]   7.00-8.00   sec   384 KBytes  3.15 Mbits/sec    4   58.8 KBytes       
[  5]   8.00-9.00   sec  0.00 Bytes  0.00 bits/sec    1   40.1 KBytes       
[  5]   9.00-10.00  sec   384 KBytes  3.14 Mbits/sec    2   29.4 KBytes       
- - - - - - - - - - - - - - - - - - - - - - - - -
Test Complete. Summary Results:
[ ID] Interval           Transfer     Bitrate         Retr
[  5]   0.00-10.00  sec  17.2 MBytes  14.5 Mbits/sec   10             sender
[  5]   0.00-10.00  sec  16.2 MBytes  13.6 Mbits/sec                  receiver
CPU Utilization: local/sender 2.2% (0.0%u/2.2%s), remote/receiver 18.4% (1.0%u/17.4%s)
snd_tcp_congestion cubic
rcv_tcp_congestion cubic

iperf Done.
Test Completed at Wed Jun 18 15:53:13 UTC 2025
Test iperf3 (Download) to fd42:dead:c0de:1337::1
iperf 3.17.1
Linux d43df3fef361 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips
Control connection MSS 1368
Time: Wed, 18 Jun 2025 15:53:13 UTC
Connecting to host fd42:dead:c0de:1337::1, port 5201
Reverse mode, remote host fd42:dead:c0de:1337::1 is sending
      Cookie: lbljjovrbyeas6dpw5cwjgplq4h5wj23ojtz
      TCP MSS: 1368 (default)
[  5] local fd42:dead:c0de:1337:0:d43d:f3fe:f361 port 41894 connected to fd42:dead:c0de:1337::1 port 5201
Starting Test: protocol: TCP, 1 streams, 131072 byte blocks, omitting 0 seconds, 10 second test, tos 0
[ ID] Interval           Transfer     Bitrate
[  5]   0.00-1.00   sec  3.62 MBytes  30.4 Mbits/sec                  
[  5]   1.00-2.00   sec  4.25 MBytes  35.7 Mbits/sec                  
[  5]   2.00-3.00   sec  2.50 MBytes  21.0 Mbits/sec                  
[  5]   3.00-4.00   sec  2.50 MBytes  21.0 Mbits/sec                  
[  5]   4.00-5.00   sec  3.50 MBytes  29.4 Mbits/sec                  
[  5]   5.00-6.00   sec  4.12 MBytes  34.6 Mbits/sec                  
[  5]   6.00-7.00   sec  4.62 MBytes  38.7 Mbits/sec                  
[  5]   7.00-8.00   sec  4.00 MBytes  33.6 Mbits/sec                  
[  5]   8.00-9.00   sec  4.50 MBytes  37.8 Mbits/sec                  
[  5]   9.00-10.00  sec  2.75 MBytes  23.1 Mbits/sec                  
- - - - - - - - - - - - - - - - - - - - - - - - -
Test Complete. Summary Results:
[ ID] Interval           Transfer     Bitrate         Retr
[  5]   0.00-10.01  sec  37.5 MBytes  31.4 Mbits/sec  271             sender
[  5]   0.00-10.00  sec  36.5 MBytes  30.6 Mbits/sec                  receiver
snd_tcp_congestion cubic
rcv_tcp_congestion cubic

iperf Done.
Test Completed at Wed Jun 18 15:53:23 UTC 2025
Test iperf3 (Bidirectional) to fd42:dead:c0de:1337::1
iperf 3.17.1
Linux d43df3fef361 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips
Control connection MSS 1368
send_parameters:
{
	"tcp":	true,
	"omit":	0,
	"time":	10,
	"num":	0,
	"blockcount":	0,
	"parallel":	1,
	"len":	131072,
	"pacing_timer":	1000,
	"client_version":	"3.17.1"
}
Time: Wed, 18 Jun 2025 15:53:23 UTC
Connecting to host fd42:dead:c0de:1337::1, port 5201
      Cookie: wgtp3bdf6whh55xrcfodgrnxkqsoy2bttuvy
      TCP MSS: 1368 (default)
SNDBUF is 16384, expecting 0
RCVBUF is 131072, expecting 0
Congestion algorithm is cubic
[  5] local fd42:dead:c0de:1337:0:d43d:f3fe:f361 port 52724 connected to fd42:dead:c0de:1337::1 port 5201
Starting Test: protocol: TCP, 1 streams, 131072 byte blocks, omitting 0 seconds, 10 second test, tos 0
Thread FD 5 created
All threads created
sent 131072 bytes of 131072, pending 0, total 131072
sent 131072 bytes of 131072, pending 0, total 262144
sent 131072 bytes of 131072, pending 0, total 393216
sent 131072 bytes of 131072, pending 0, total 524288
sent 131072 bytes of 131072, pending 0, total 655360
sent 131072 bytes of 131072, pending 0, total 786432
sent 131072 bytes of 131072, pending 0, total 917504
sent 131072 bytes of 131072, pending 0, total 1048576
sent 131072 bytes of 131072, pending 0, total 1179648
sent 131072 bytes of 131072, pending 0, total 1310720
sent 131072 bytes of 131072, pending 0, total 1441792
sent 131072 bytes of 131072, pending 0, total 1572864
sent 131072 bytes of 131072, pending 0, total 1703936
sent 131072 bytes of 131072, pending 0, total 1835008
sent 131072 bytes of 131072, pending 0, total 1966080
sent 131072 bytes of 131072, pending 0, total 2097152
sent 131072 bytes of 131072, pending 0, total 2228224
sent 131072 bytes of 131072, pending 0, total 2359296
sent 131072 bytes of 131072, pending 0, total 2490368
sent 131072 bytes of 131072, pending 0, total 2621440
sent 131072 bytes of 131072, pending 0, total 2752512
sent 131072 bytes of 131072, pending 0, total 2883584
sent 131072 bytes of 131072, pending 0, total 3014656
sent 131072 bytes of 131072, pending 0, total 3145728
sent 131072 bytes of 131072, pending 0, total 3276800
sent 131072 bytes of 131072, pending 0, total 3407872
sent 131072 bytes of 131072, pending 0, total 3538944
sent 131072 bytes of 131072, pending 0, total 3670016
tcpi_snd_cwnd 136 tcpi_snd_mss 1368 tcpi_rtt 25864
interval_len 1.001160 bytes_transferred 3670016
interval forces keep
[ ID] Interval           Transfer     Bitrate         Retr  Cwnd
[  5]   0.00-1.00   sec  3.50 MBytes  29.3 Mbits/sec    0    182 KBytes       
sent 131072 bytes of 131072, pending 0, total 3801088
sent 131072 bytes of 131072, pending 0, total 3932160
sent 131072 bytes of 131072, pending 0, total 4063232
sent 131072 bytes of 131072, pending 0, total 4194304
sent 131072 bytes of 131072, pending 0, total 4325376
sent 131072 bytes of 131072, pending 0, total 4456448
sent 131072 bytes of 131072, pending 0, total 4587520
sent 131072 bytes of 131072, pending 0, total 4718592
sent 131072 bytes of 131072, pending 0, total 4849664
sent 131072 bytes of 131072, pending 0, total 4980736
sent 131072 bytes of 131072, pending 0, total 5111808
sent 131072 bytes of 131072, pending 0, total 5242880
sent 131072 bytes of 131072, pending 0, total 5373952
sent 131072 bytes of 131072, pending 0, total 5505024
sent 131072 bytes of 131072, pending 0, total 5636096
sent 131072 bytes of 131072, pending 0, total 5767168
sent 131072 bytes of 131072, pending 0, total 5898240
sent 131072 bytes of 131072, pending 0, total 6029312
sent 131072 bytes of 131072, pending 0, total 6160384
sent 131072 bytes of 131072, pending 0, total 6291456
sent 131072 bytes of 131072, pending 0, total 6422528
sent 131072 bytes of 131072, pending 0, total 6553600
tcpi_snd_cwnd 198 tcpi_snd_mss 1368 tcpi_rtt 41445
interval_len 0.999926 bytes_transferred 2883584
interval forces keep
[  5]   1.00-2.00   sec  2.75 MBytes  23.1 Mbits/sec    0    265 KBytes       
sent 131072 bytes of 131072, pending 0, total 6684672
sent 131072 bytes of 131072, pending 0, total 6815744
sent 131072 bytes of 131072, pending 0, total 6946816
sent 131072 bytes of 131072, pending 0, total 7077888
sent 131072 bytes of 131072, pending 0, total 7208960
sent 131072 bytes of 131072, pending 0, total 7340032
sent 131072 bytes of 131072, pending 0, total 7471104
sent 131072 bytes of 131072, pending 0, total 7602176
sent 131072 bytes of 131072, pending 0, total 7733248
sent 131072 bytes of 131072, pending 0, total 7864320
sent 131072 bytes of 131072, pending 0, total 7995392
sent 131072 bytes of 131072, pending 0, total 8126464
sent 131072 bytes of 131072, pending 0, total 8257536
sent 131072 bytes of 131072, pending 0, total 8388608
sent 131072 bytes of 131072, pending 0, total 8519680
sent 131072 bytes of 131072, pending 0, total 8650752
sent 131072 bytes of 131072, pending 0, total 8781824
sent 131072 bytes of 131072, pending 0, total 8912896
sent 131072 bytes of 131072, pending 0, total 9043968
sent 131072 bytes of 131072, pending 0, total 9175040
sent 131072 bytes of 131072, pending 0, total 9306112
sent 131072 bytes of 131072, pending 0, total 9437184
sent 131072 bytes of 131072, pending 0, total 9568256
sent 131072 bytes of 131072, pending 0, total 9699328
sent 131072 bytes of 131072, pending 0, total 9830400
sent 131072 bytes of 131072, pending 0, total 9961472
tcpi_snd_cwnd 210 tcpi_snd_mss 1368 tcpi_rtt 38353
interval_len 1.000134 bytes_transferred 3407872
interval forces keep
[  5]   2.00-3.00   sec  3.25 MBytes  27.3 Mbits/sec    0    281 KBytes       
sent 131072 bytes of 131072, pending 0, total 10092544
sent 131072 bytes of 131072, pending 0, total 10223616
sent 131072 bytes of 131072, pending 0, total 10354688
sent 131072 bytes of 131072, pending 0, total 10485760
sent 131072 bytes of 131072, pending 0, total 10616832
sent 131072 bytes of 131072, pending 0, total 10747904
sent 131072 bytes of 131072, pending 0, total 10878976
sent 131072 bytes of 131072, pending 0, total 11010048
sent 131072 bytes of 131072, pending 0, total 11141120
sent 131072 bytes of 131072, pending 0, total 11272192
sent 131072 bytes of 131072, pending 0, total 11403264
sent 131072 bytes of 131072, pending 0, total 11534336
sent 131072 bytes of 131072, pending 0, total 11665408
sent 131072 bytes of 131072, pending 0, total 11796480
sent 131072 bytes of 131072, pending 0, total 11927552
sent 131072 bytes of 131072, pending 0, total 12058624
sent 131072 bytes of 131072, pending 0, total 12189696
sent 131072 bytes of 131072, pending 0, total 12320768
sent 131072 bytes of 131072, pending 0, total 12451840
sent 131072 bytes of 131072, pending 0, total 12582912
sent 131072 bytes of 131072, pending 0, total 12713984
sent 131072 bytes of 131072, pending 0, total 12845056
sent 131072 bytes of 131072, pending 0, total 12976128
sent 131072 bytes of 131072, pending 0, total 13107200
tcpi_snd_cwnd 232 tcpi_snd_mss 1368 tcpi_rtt 35708
interval_len 0.999936 bytes_transferred 3145728
interval forces keep
[  5]   3.00-4.00   sec  3.00 MBytes  25.2 Mbits/sec    0    310 KBytes       
sent 131072 bytes of 131072, pending 0, total 13238272
sent 131072 bytes of 131072, pending 0, total 13369344
sent 131072 bytes of 131072, pending 0, total 13500416
sent 131072 bytes of 131072, pending 0, total 13631488
sent 131072 bytes of 131072, pending 0, total 13762560
sent 131072 bytes of 131072, pending 0, total 13893632
sent 131072 bytes of 131072, pending 0, total 14024704
sent 131072 bytes of 131072, pending 0, total 14155776
sent 131072 bytes of 131072, pending 0, total 14286848
sent 131072 bytes of 131072, pending 0, total 14417920
sent 131072 bytes of 131072, pending 0, total 14548992
sent 131072 bytes of 131072, pending 0, total 14680064
sent 131072 bytes of 131072, pending 0, total 14811136
sent 131072 bytes of 131072, pending 0, total 14942208
sent 131072 bytes of 131072, pending 0, total 15073280
sent 131072 bytes of 131072, pending 0, total 15204352
sent 131072 bytes of 131072, pending 0, total 15335424
sent 131072 bytes of 131072, pending 0, total 15466496
sent 131072 bytes of 131072, pending 0, total 15597568
sent 131072 bytes of 131072, pending 0, total 15728640
sent 131072 bytes of 131072, pending 0, total 15859712
sent 131072 bytes of 131072, pending 0, total 15990784
sent 131072 bytes of 131072, pending 0, total 16121856
sent 131072 bytes of 131072, pending 0, total 16252928
sent 131072 bytes of 131072, pending 0, total 16384000
tcpi_snd_cwnd 244 tcpi_snd_mss 1368 tcpi_rtt 28077
interval_len 0.999993 bytes_transferred 3276800
interval forces keep
[  5]   4.00-5.00   sec  3.12 MBytes  26.2 Mbits/sec    0    326 KBytes       
sent 131072 bytes of 131072, pending 0, total 16515072
sent 131072 bytes of 131072, pending 0, total 16646144
sent 131072 bytes of 131072, pending 0, total 16777216
sent 131072 bytes of 131072, pending 0, total 16908288
sent 131072 bytes of 131072, pending 0, total 17039360
sent 131072 bytes of 131072, pending 0, total 17170432
sent 131072 bytes of 131072, pending 0, total 17301504
sent 131072 bytes of 131072, pending 0, total 17432576
sent 131072 bytes of 131072, pending 0, total 17563648
sent 131072 bytes of 131072, pending 0, total 17694720
sent 131072 bytes of 131072, pending 0, total 17825792
sent 131072 bytes of 131072, pending 0, total 17956864
sent 131072 bytes of 131072, pending 0, total 18087936
tcpi_snd_cwnd 244 tcpi_snd_mss 1368 tcpi_rtt 112168
interval_len 1.000062 bytes_transferred 1703936
interval forces keep
[  5]   5.00-6.00   sec  1.62 MBytes  13.6 Mbits/sec    0    326 KBytes       
sent 131072 bytes of 131072, pending 0, total 18219008
sent 131072 bytes of 131072, pending 0, total 18350080
sent 131072 bytes of 131072, pending 0, total 18481152
tcpi_snd_cwnd 2 tcpi_snd_mss 1368 tcpi_rtt 221895
interval_len 0.999928 bytes_transferred 393216
interval forces keep
[  5]   6.00-7.00   sec   384 KBytes  3.15 Mbits/sec    4   2.67 KBytes       
tcpi_snd_cwnd 10 tcpi_snd_mss 1368 tcpi_rtt 57966
interval_len 0.999954 bytes_transferred 0
interval forces keep
[  5]   7.00-8.00   sec  0.00 Bytes  0.00 bits/sec    5   13.4 KBytes       
sent 131072 bytes of 131072, pending 0, total 18612224
sent 131072 bytes of 131072, pending 0, total 18743296
sent 131072 bytes of 131072, pending 0, total 18874368
tcpi_snd_cwnd 10 tcpi_snd_mss 1368 tcpi_rtt 31831
interval_len 1.000017 bytes_transferred 393216
interval forces keep
[  5]   8.00-9.00   sec   384 KBytes  3.15 Mbits/sec    2   13.4 KBytes       
sent 131072 bytes of 131072, pending 0, total 19005440
sent 131072 bytes of 131072, pending 0, total 19136512
sent 131072 bytes of 131072, pending 0, total 19267584
Thread FD 5 stopped
Sender threads stopped
tcpi_snd_cwnd 11 tcpi_snd_mss 1368 tcpi_rtt 39540
send_results
{
	"cpu_util_total":	2.0478867350148788,
	"cpu_util_user":	0.110396626748028,
	"cpu_util_system":	1.9375096474928239,
	"sender_has_retransmits":	1,
	"congestion_used":	"cubic",
	"streams":	[{
			"id":	1,
			"bytes":	19267584,
			"retransmits":	13,
			"jitter":	0,
			"errors":	0,
			"omitted_errors":	0,
			"packets":	0,
			"omitted_packets":	0,
			"start_time":	0,
			"end_time":	10.00153
		}]
}
get_results
{
	"cpu_util_total":	19.077740230304546,
	"cpu_util_user":	0.682369427694631,
	"cpu_util_system":	18.395390756390974,
	"sender_has_retransmits":	-1,
	"congestion_used":	"cubic",
	"streams":	[{
			"id":	1,
			"bytes":	18087936,
			"retransmits":	-1,
			"jitter":	0,
			"errors":	0,
			"omitted_errors":	0,
			"packets":	0,
			"omitted_packets":	0,
			"start_time":	0,
			"end_time":	10.022861
		}]
}
interval_len 1.000420 bytes_transferred 393216
interval forces keep
[  5]   9.00-10.00  sec   384 KBytes  3.14 Mbits/sec    2   14.7 KBytes       
- - - - - - - - - - - - - - - - - - - - - - - - -
Test Complete. Summary Results:
[ ID] Interval           Transfer     Bitrate         Retr
[  5]   0.00-10.00  sec  18.4 MBytes  15.4 Mbits/sec   13             sender
[  5]   0.00-10.02  sec  17.2 MBytes  14.4 Mbits/sec                  receiver
CPU Utilization: local/sender 2.0% (0.1%u/1.9%s), remote/receiver 19.1% (0.7%u/18.4%s)
snd_tcp_congestion cubic
rcv_tcp_congestion cubic
Receiver threads stopped

iperf Done.
Test Completed at Wed Jun 18 15:53:33 UTC 2025
Batman/Batctl Report
====================
Batctl neighbors
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: phy0-mesh0/d2:3d:f3:fe:f3:62 (batman/4e:2d:07:3b:13:20 BATMAN_IV)]
IF             Neighbor              last-seen
   phy0-mesh0	  f2:4d:5c:fd:a2:fd   60.200s
   phy0-mesh0	  f2:4d:5c:fe:51:65   29.450s
   phy0-mesh0	  d2:3d:f3:fe:f3:53    4.060s
   phy0-mesh0	  f2:4d:5c:fc:25:8d   32.300s
   phy0-mesh0	  f2:4d:5c:fd:9d:f0    4.160s
   phy0-mesh0	  2a:97:27:52:6c:ad    2.520s
   phy1-mesh0	  f2:4d:5c:fd:9d:f1   10.400s
   phy1-mesh0	  2a:97:27:52:6c:ae   15.640s
   phy1-mesh0	  f2:4d:5c:fe:51:66   14.650s
Batctl originators
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: phy0-mesh0/d2:3d:f3:fe:f3:62 (batman/4e:2d:07:3b:13:20 BATMAN_IV)]
   Originator        last-seen (#/255) Nexthop           [outgoingIF]
   f4:4d:5c:fd:9d:ef    0.140s   (  0) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f4:4d:5c:fd:9d:ef    0.140s   ( 89) f2:4d:5c:fc:25:8d [phy0-mesh0]
   f4:4d:5c:fd:9d:ef    0.140s   (241) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f4:4d:5c:fd:9d:ef    0.140s   (200) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f4:4d:5c:fd:9d:ef    0.140s   (187) 2a:97:27:52:6c:ad [phy0-mesh0]
   f4:4d:5c:fd:9d:ef    0.140s   (208) 2a:97:27:52:6c:ae [phy1-mesh0]
 * f4:4d:5c:fd:9d:ef    0.140s   (255) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    0.820s   ( 25) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    0.820s   ( 98) f2:4d:5c:fc:25:8d [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    0.820s   (208) 2a:97:27:52:6c:ae [phy1-mesh0]
   f4:4d:5c:fd:a2:fc    0.820s   (210) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f4:4d:5c:fd:a2:fc    0.820s   (199) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f4:4d:5c:fd:a2:fc    0.820s   (190) 2a:97:27:52:6c:ad [phy0-mesh0]
 * f4:4d:5c:fd:a2:fc    0.820s   (225) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   f2:4d:5c:fc:25:8e   13.630s   (163) 2a:97:27:52:6c:ae [phy1-mesh0]
 * f2:4d:5c:fc:25:8e   13.630s   (167) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f2:4d:5c:fe:51:65    4.140s   (  0) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f2:4d:5c:fe:51:65    4.140s   (  0) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f2:4d:5c:fe:51:65    4.140s   ( 84) f2:4d:5c:fc:25:8d [phy0-mesh0]
   f2:4d:5c:fe:51:65    4.140s   (  0) f2:4d:5c:fe:51:65 [phy0-mesh0]
 * f2:4d:5c:fe:51:65    4.140s   (152) 2a:97:27:52:6c:ad [phy0-mesh0]
   f2:4d:5c:fe:51:65    4.140s   (144) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
 * f2:4d:5c:fd:a2:fe   10.290s   (184) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f2:4d:5c:fd:a2:fe   10.290s   (170) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f2:4d:5c:fd:a2:fe   10.290s   (185) 2a:97:27:52:6c:ae [phy1-mesh0]
   2a:97:27:52:6c:ae    5.450s   (186) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   2a:97:27:52:6c:ae    5.450s   (174) f2:4d:5c:fe:51:66 [phy1-mesh0]
 * 2a:97:27:52:6c:ae    5.450s   (239) 2a:97:27:52:6c:ae [phy1-mesh0]
   d2:3d:f3:fe:f3:53    4.070s   (  0) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   d2:3d:f3:fe:f3:53    4.070s   (  0) f2:4d:5c:fc:25:8d [phy0-mesh0]
   d2:3d:f3:fe:f3:53    4.070s   (188) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   d2:3d:f3:fe:f3:53    4.070s   ( 32) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   d2:3d:f3:fe:f3:53    4.070s   (209) 2a:97:27:52:6c:ae [phy1-mesh0]
   d2:3d:f3:fe:f3:53    4.070s   (192) f2:4d:5c:fe:51:66 [phy1-mesh0]
   d2:3d:f3:fe:f3:53    4.070s   (192) 2a:97:27:52:6c:ad [phy0-mesh0]
 * d2:3d:f3:fe:f3:53    4.070s   (215) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   2a:97:27:52:6c:ad    2.410s   (  0) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   2a:97:27:52:6c:ad    2.410s   ( 18) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   2a:97:27:52:6c:ad    2.410s   (185) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
 * 2a:97:27:52:6c:ad    2.410s   (214) 2a:97:27:52:6c:ad [phy0-mesh0]
   f2:4d:5c:fd:9d:f1   10.290s   (157) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f2:4d:5c:fd:9d:f1   10.290s   (178) 2a:97:27:52:6c:ae [phy1-mesh0]
 * f2:4d:5c:fd:9d:f1   10.290s   (244) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f2:4d:5c:fc:25:8d    1.440s   (  0) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f2:4d:5c:fc:25:8d    1.440s   (185) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f2:4d:5c:fc:25:8d    1.440s   (180) 2a:97:27:52:6c:ae [phy1-mesh0]
   f2:4d:5c:fc:25:8d    1.440s   (  0) f2:4d:5c:fc:25:8d [phy0-mesh0]
   f2:4d:5c:fc:25:8d    1.440s   (199) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f2:4d:5c:fc:25:8d    1.440s   (164) 2a:97:27:52:6c:ad [phy0-mesh0]
 * f2:4d:5c:fc:25:8d    1.440s   (198) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   f2:4d:5c:fd:a2:fd    9.700s   (  0) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f2:4d:5c:fd:a2:fd    9.700s   ( 29) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f2:4d:5c:fd:a2:fd    9.700s   ( 86) f2:4d:5c:fc:25:8d [phy0-mesh0]
 * f2:4d:5c:fd:a2:fd    9.700s   (153) 2a:97:27:52:6c:ad [phy0-mesh0]
   f2:4d:5c:fd:a2:fd    9.700s   (150) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   f2:4d:5c:fe:51:66    9.500s   (173) 2a:97:27:52:6c:ae [phy1-mesh0]
   f2:4d:5c:fe:51:66    9.500s   (185) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
 * f2:4d:5c:fe:51:66    9.500s   (227) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f2:4d:5c:fd:9d:f0    4.170s   (  0) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f2:4d:5c:fd:9d:f0    4.170s   (  0) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f2:4d:5c:fd:9d:f0    4.170s   (164) 2a:97:27:52:6c:ad [phy0-mesh0]
 * f2:4d:5c:fd:9d:f0    4.170s   (254) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   20:97:27:52:6c:ab    4.410s   (  0) f2:4d:5c:fc:25:8d [phy0-mesh0]
   20:97:27:52:6c:ab    4.410s   (  0) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   20:97:27:52:6c:ab    4.410s   (210) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
 * 20:97:27:52:6c:ab    4.410s   (234) 2a:97:27:52:6c:ae [phy1-mesh0]
   20:97:27:52:6c:ab    4.410s   (  0) f2:4d:5c:fe:51:66 [phy1-mesh0]
   20:97:27:52:6c:ab    4.410s   (215) 2a:97:27:52:6c:ad [phy0-mesh0]
   20:97:27:52:6c:ab    4.410s   (225) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   f4:4d:5c:fe:51:64    0.610s   (  0) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f4:4d:5c:fe:51:64    0.610s   (103) f2:4d:5c:fc:25:8d [phy0-mesh0]
   f4:4d:5c:fe:51:64    0.610s   (  0) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f4:4d:5c:fe:51:64    0.610s   (206) 2a:97:27:52:6c:ae [phy1-mesh0]
   f4:4d:5c:fe:51:64    0.610s   (210) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
 * f4:4d:5c:fe:51:64    0.610s   (227) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f4:4d:5c:fe:51:64    0.610s   (188) 2a:97:27:52:6c:ad [phy0-mesh0]
   f4:4d:5c:fe:51:64    0.610s   (225) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   d2:3d:f3:fe:f3:54    7.090s   (184) 2a:97:27:52:6c:ae [phy1-mesh0]
 * d2:3d:f3:fe:f3:54    7.090s   (188) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   d2:3d:f3:fe:f3:54    7.090s   (170) f2:4d:5c:fe:51:66 [phy1-mesh0]
Batctl transglobal
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: phy0-mesh0/d2:3d:f3:fe:f3:62 (batman/4e:2d:07:3b:13:20 BATMAN_IV)]
   Client             VID Flags Last ttvn     Via        ttvn  (CRC       )
 * 33:33:ff:99:79:f6   -1 [....] (  5) d2:3d:f3:fe:f3:53 ( 10) (0xc85e1bd6)
 * e6:b5:a1:87:27:54    0 [....] ( 22) 20:97:27:52:6c:ab ( 22) (0x4edbbb86)
 * 16:87:5f:85:10:d4    0 [....] (  3) f4:4d:5c:fe:51:64 (  3) (0xff7b8a9d)
 * e6:b5:a1:87:27:54    3 [....] ( 22) 20:97:27:52:6c:ab ( 22) (0xd70f86fe)
 * 2a:1b:08:b6:0e:40    3 [....] (  4) f4:4d:5c:fd:a2:fc (  4) (0xc9b01d7f)
 * 16:87:5f:85:10:d4    3 [....] (  3) f4:4d:5c:fe:51:64 (  3) (0x243f0df4)
 * 33:33:ff:85:10:d4   -1 [....] (  3) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
 * 20:97:27:52:6c:ad   12 [....] ( 22) 20:97:27:52:6c:ab ( 22) (0x5c5d6f23)
 * 16:87:5f:85:10:d4   11 [....] (  3) f4:4d:5c:fe:51:64 (  3) (0x6604092e)
   33:33:00:00:00:02   -1 [....] ( 22) 20:97:27:52:6c:ab ( 22) (0xfaf54e6c)
   33:33:00:00:00:02   -1 [....] (  4) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
   33:33:00:00:00:02   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
 * 33:33:00:00:00:02   -1 [....] ( 25) f4:4d:5c:fd:9d:ef ( 31) (0x6babf43b)
   33:33:00:00:00:02   -1 [....] (  3) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
   33:33:00:00:00:02   -1 [....] (  5) d2:3d:f3:fe:f3:53 ( 10) (0xc85e1bd6)
 * e6:b5:a1:87:27:54   12 [....] ( 22) 20:97:27:52:6c:ab ( 22) (0x5c5d6f23)
 * e6:b5:a1:87:27:54   11 [....] ( 22) 20:97:27:52:6c:ab ( 22) (0x5c5d6f23)
 * 33:33:ff:87:27:54   -1 [....] ( 22) 20:97:27:52:6c:ab ( 22) (0xfaf54e6c)
 * b6:1d:b2:47:cd:26   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
 * 9a:58:fd:e4:aa:99    3 [.W..] ( 22) 20:97:27:52:6c:ab ( 22) (0xd70f86fe)
 * 20:97:27:52:6c:ad   11 [....] ( 22) 20:97:27:52:6c:ab ( 22) (0x5c5d6f23)
 * 02:22:f3:35:3e:d3   -1 [....] ( 25) f4:4d:5c:fd:9d:ef ( 31) (0x6babf43b)
 * 2a:1b:08:b6:0e:40   12 [....] (  4) f4:4d:5c:fd:a2:fc (  4) (0x71d21ca1)
 * b6:1d:b2:47:cd:26   12 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0xc531fab3)
 * 2a:1b:08:b6:0e:40   -1 [....] (  4) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
 * b6:1d:b2:47:cd:26   11 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x3f68ffb7)
 * e6:b5:a1:87:27:54   -1 [....] ( 22) 20:97:27:52:6c:ab ( 22) (0xfaf54e6c)
 * 2a:1b:08:b6:0e:40    0 [....] (  4) f4:4d:5c:fd:a2:fc (  4) (0x12f49a16)
 * b6:1d:b2:47:cd:26    0 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0xa6177c04)
 * b6:1d:b2:47:cd:26    3 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x7d53fb6d)
 * 16:87:5f:85:10:d4   -1 [....] (  3) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
 * ca:4a:dc:99:79:f6   12 [....] (  5) d2:3d:f3:fe:f3:53 ( 10) (0xf16dbd8d)
 * ca:4a:dc:99:79:f6    0 [....] (  5) d2:3d:f3:fe:f3:53 ( 10) (0x924b3b3a)
   01:00:5e:00:00:01   -1 [....] ( 22) 20:97:27:52:6c:ab ( 22) (0xfaf54e6c)
   01:00:5e:00:00:01   -1 [....] (  4) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
   01:00:5e:00:00:01   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
 * 01:00:5e:00:00:01   -1 [....] ( 25) f4:4d:5c:fd:9d:ef ( 31) (0x6babf43b)
   01:00:5e:00:00:01   -1 [....] (  3) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
   01:00:5e:00:00:01   -1 [....] (  5) d2:3d:f3:fe:f3:53 ( 10) (0xc85e1bd6)
 * 02:22:f3:35:3e:d3   12 [....] ( 25) f4:4d:5c:fd:9d:ef ( 31) (0x0e42d16b)
   33:33:ff:00:00:00   -1 [....] ( 22) 20:97:27:52:6c:ab ( 22) (0xfaf54e6c)
   33:33:ff:00:00:00   -1 [....] (  4) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
   33:33:ff:00:00:00   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
 * 33:33:ff:00:00:00   -1 [....] ( 25) f4:4d:5c:fd:9d:ef ( 31) (0x6babf43b)
   33:33:ff:00:00:00   -1 [....] (  3) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
   33:33:ff:00:00:00   -1 [....] (  5) d2:3d:f3:fe:f3:53 ( 10) (0xc85e1bd6)
 * ca:4a:dc:99:79:f6   -1 [....] (  5) d2:3d:f3:fe:f3:53 ( 10) (0xc85e1bd6)
 * 02:22:f3:35:3e:d3    3 [....] ( 25) f4:4d:5c:fd:9d:ef ( 31) (0xb620d0b5)
 * 33:33:ff:35:3e:d3   -1 [....] ( 25) f4:4d:5c:fd:9d:ef ( 31) (0x6babf43b)
 * 16:87:5f:85:10:d4   12 [....] (  3) f4:4d:5c:fe:51:64 (  3) (0x9c5d0c2a)
 * 02:22:f3:35:3e:d3   11 [....] ( 25) f4:4d:5c:fd:9d:ef ( 31) (0xf41bd46f)
 * 2a:1b:08:b6:0e:40   11 [....] (  4) f4:4d:5c:fd:a2:fc (  4) (0x8b8b19a5)
 * 33:33:ff:b6:0e:40   -1 [....] (  4) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
 * 33:33:ff:47:cd:26   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
 * 20:97:27:52:6c:ad    3 [....] ( 22) 20:97:27:52:6c:ab ( 22) (0xd70f86fe)
 * ca:4a:dc:99:79:f6   11 [....] (  5) d2:3d:f3:fe:f3:53 ( 10) (0x80e2205c)
 * 02:22:f3:35:3e:d3    0 [....] ( 25) f4:4d:5c:fd:9d:ef ( 31) (0x6d6457dc)
 * 06:88:e7:a1:63:64   11 [.W..] ( 10) d2:3d:f3:fe:f3:53 ( 10) (0x80e2205c)
 * ca:4a:dc:99:79:f6    3 [....] (  5) d2:3d:f3:fe:f3:53 ( 10) (0x490fbc53)
   33:33:00:00:00:01   -1 [....] ( 22) 20:97:27:52:6c:ab ( 22) (0xfaf54e6c)
   33:33:00:00:00:01   -1 [....] (  4) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
   33:33:00:00:00:01   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
 * 33:33:00:00:00:01   -1 [....] ( 25) f4:4d:5c:fd:9d:ef ( 31) (0x6babf43b)
   33:33:00:00:00:01   -1 [....] (  3) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
   33:33:00:00:00:01   -1 [....] (  5) d2:3d:f3:fe:f3:53 ( 10) (0xc85e1bd6)
Batctl translocal
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: phy0-mesh0/d2:3d:f3:fe:f3:62 (batman/4e:2d:07:3b:13:20 BATMAN_IV), TTVN: 7]
Client             VID Flags    Last seen (CRC       )
4e:2d:07:3b:13:20   -1 [.P....]   0.000   (0x662887f0)
06:3a:b0:85:82:c4   11 [....W.]  13.830   (0xd383b50d)
33:33:ff:3b:13:20   -1 [.P....]   0.000   (0x662887f0)
33:33:00:00:00:02   -1 [.P....]   0.000   (0x662887f0)
4e:2d:07:3b:13:20   12 [.P....]   0.000   (0xb5a82fe2)
01:00:5e:00:00:01   -1 [.P....]   0.000   (0x662887f0)
33:33:ff:00:00:00   -1 [.P....]   0.000   (0x662887f0)
4e:2d:07:3b:13:20   11 [.P....]   0.000   (0xd383b50d)
4e:2d:07:3b:13:20    0 [.P....]   0.000   (0xd68ea955)
a6:c5:67:2d:44:a5   11 [....W.]   0.190   (0xd383b50d)
4e:2d:07:3b:13:20    3 [.P....]   0.000   (0x0dca2e3c)
33:33:00:00:00:01   -1 [.P....]   0.000   (0x662887f0)

```


### AP Leer
```shell
System Information
====================
NAME="OpenWrt"
VERSION="24.10-SNAPSHOT"
ID="openwrt"
ID_LIKE="lede openwrt"
PRETTY_NAME="OpenWrt 24.10-SNAPSHOT"
VERSION_ID="24.10-snapshot"
HOME_URL="https://openwrt.org/"
BUG_URL="https://bugs.openwrt.org/"
SUPPORT_URL="https://forum.openwrt.org/"
BUILD_ID="r0-e6677e14"
OPENWRT_BOARD="ramips/mt7621"
OPENWRT_ARCH="mipsel_24kc"
OPENWRT_TAINTS="no-all"
OPENWRT_DEVICE_MANUFACTURER="OpenWrt"
OPENWRT_DEVICE_MANUFACTURER_URL="https://openwrt.org/"
OPENWRT_DEVICE_PRODUCT="Generic"
OPENWRT_DEVICE_REVISION="v0"
OPENWRT_RELEASE="OpenWrt 24.10-SNAPSHOT r0-e6677e14"
OPENWRT_BUILD_DATE="1750175455"
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣀⣀⣤⣀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣀⣠⣀⣀⡀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣠⣾⣿⣿⣿⣿⣿⣿⣆⠀⢀⣀⣀⣤⣤⣤⣦⣦⣤⣤⣄⣀⣀⠀⢠⣾⣿⣿⣿⣿⣿⣷⣦⡀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣰⣿⣿⣿⣿⣿⣿⣿⣿⡿⠟⠛⠉⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠙⠛⠿⣿⣿⣿⣿⣿⣿⣿⣿⣷⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣿⣿⣿⣿⣿⣿⣿⠟⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠙⢿⣿⣿⣿⣿⣿⣿⡇⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⢻⣿⣿⣿⣿⡟⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠙⣿⣿⣿⣿⣿⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠻⢿⣿⠟⠀⠀⠀⠀⠀⣀⣤⣤⣤⡀⠀⠀⠀⠀⠀⢀⣤⣤⣤⣄⡀⠀⠀⠀⠀⠘⣿⡿⠿⠃⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⢠⡟⠀⠀⠀⠀⣠⣾⣿⣿⣟⣿⡇⠀⠀⠀⠀⠀⢸⣿⣿⣻⣿⣿⣦⠀⠀⠀⠀⠸⣧⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣼⠁⠀⠀⠀⠀⣿⣿⣿⣿⣿⡟⢠⣶⣾⣿⣿⣷⣤⢽⣿⣿⣿⣿⣿⡇⠀⠀⣀⣤⣿⣷⣴⣶⣦⣀⡀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⢀⣠⣤⣤⣠⣇⠀⠀⠀⠀⠀⣿⣿⣿⣿⣿⠀⠘⠻⣿⣿⣿⡿⠋⠀⢹⣿⣿⣿⣿⡇⠀⣿⣿⣿⡏⢹⣿⠉⣿⣿⣿⣷⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⢠⣾⣿⣿⣿⣿⣿⣿⣿⣶⣄⠀⠀⠹⣿⣿⠿⠋⠀⢤⣀⢀⣼⡄⠀⣠⠀⠈⠻⣿⣿⠟⠀⢸⣿⣇⣽⣿⠿⠿⠿⣿⣅⣽⣿⡇⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣆⠀⠀⠀⠀⠀⠀⠀⠀⠈⠉⠁⠉⠉⠀⠀⠀⠀⠀⠀⠀⠀⠈⣿⣿⣟⠁⠀⠀⠀⠈⣿⣿⣿⡇⠀⠀⠀⠀⢀
⠛⠛⠛⠛⠛⠛⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛
⠀⠀⠀⠀⠀⠀⠘⠛⠻⢿⣿⣿⣿⣿⣿⠟⠛⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠀⠈⠉⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀

UB-EDGE - 2025-06-17 - 6a5e2b7
Linux d43df3fef352 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips GNU/Linux
Network Configuration
======================
1: lo: <LOOPBACK,UP,LOWER_UP> mtu 65536 state UNKNOWN qlen 1000
    inet6 ::1/128 scope host proto kernel_lo 
       valid_lft forever preferred_lft forever
2: eth0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1540 state UP qlen 1000
    inet6 fe80::d63d:f3ff:fefe:f352/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
9: up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::c84a:dcff:fe99:79f6/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
10: up0v11@up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::c84a:dcff:fe99:79f6/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
11: up1v12@up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::c84a:dcff:fe99:79f6/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
12: up2v3@up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fd42:dead:c0de:1337:0:d43d:f3fe:f352/64 scope global 
       valid_lft forever preferred_lft forever
    inet6 fe80::c84a:dcff:fe99:79f6/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
13: batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UNKNOWN qlen 1000
    inet6 fe80::c84a:dcff:fe99:79f6/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
14: batman.11@batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::c84a:dcff:fe99:79f6/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
15: batman.12@batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::c84a:dcff:fe99:79f6/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
16: batman.3@batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::c84a:dcff:fe99:79f6/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
20: phy0-mesh0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1532 state UP qlen 1000
    inet6 fe80::d03d:f3ff:fefe:f353/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
21: phy1-mesh0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1532 state UP qlen 1000
    inet6 fe80::d03d:f3ff:fefe:f354/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
fd42:dead:c0de:1337::/64 dev up2v3 proto static metric 5 pref medium
unreachable fd64:fff2:90d0::/48 dev lo proto static metric 2147483647 pref medium
fe80::/64 dev eth0 proto kernel metric 256 pref medium
fe80::/64 dev batman proto kernel metric 256 pref medium
fe80::/64 dev batman.11 proto kernel metric 256 pref medium
fe80::/64 dev up proto kernel metric 256 pref medium
fe80::/64 dev up0v11 proto kernel metric 256 pref medium
fe80::/64 dev up1v12 proto kernel metric 256 pref medium
fe80::/64 dev up2v3 proto kernel metric 256 pref medium
fe80::/64 dev batman.12 proto kernel metric 256 pref medium
fe80::/64 dev batman.3 proto kernel metric 256 pref medium
fe80::/64 dev phy0-mesh0 proto kernel metric 256 pref medium
fe80::/64 dev phy1-mesh0 proto kernel metric 256 pref medium
Speed Test Report
==================
Test Started at Wed Jun 18 15:41:05 UTC 2025
Running iperf3 (Upload) test to fd42:dead:c0de:1337::1
iperf 3.17.1
Linux d43df3fef352 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips
Control connection MSS 1368
Time: Wed, 18 Jun 2025 15:41:05 UTC
Connecting to host fd42:dead:c0de:1337::1, port 5201
      Cookie: adnr5kjbbgj7mrvzh5jcetgyt6rnumc5z6ph
      TCP MSS: 1368 (default)
[  5] local fd42:dead:c0de:1337:0:d43d:f3fe:f352 port 49104 connected to fd42:dead:c0de:1337::1 port 5201
Starting Test: protocol: TCP, 1 streams, 131072 byte blocks, omitting 0 seconds, 10 second test, tos 0
[ ID] Interval           Transfer     Bitrate         Retr  Cwnd
[  5]   0.00-1.00   sec  2.88 MBytes  24.1 Mbits/sec    0    203 KBytes       
[  5]   1.00-2.00   sec  1.25 MBytes  10.5 Mbits/sec    1    259 KBytes       
[  5]   2.00-3.00   sec  1.38 MBytes  11.5 Mbits/sec    0    322 KBytes       
[  5]   3.00-4.00   sec   384 KBytes  3.15 Mbits/sec    0    350 KBytes       
[  5]   4.00-5.00   sec  4.88 MBytes  40.9 Mbits/sec    0    367 KBytes       
[  5]   5.00-6.00   sec  2.62 MBytes  22.0 Mbits/sec    0    425 KBytes       
[  5]   6.00-7.00   sec  2.12 MBytes  17.8 Mbits/sec    0    514 KBytes       
[  5]   7.00-8.00   sec  1.12 MBytes  9.44 Mbits/sec    0    560 KBytes       
[  5]   8.00-9.00   sec  1.88 MBytes  15.7 Mbits/sec    0    607 KBytes       
[  5]   9.00-10.00  sec  2.00 MBytes  16.8 Mbits/sec    0    651 KBytes       
- - - - - - - - - - - - - - - - - - - - - - - - -
Test Complete. Summary Results:
[ ID] Interval           Transfer     Bitrate         Retr
[  5]   0.00-10.00  sec  20.5 MBytes  17.2 Mbits/sec    1             sender
[  5]   0.00-10.01  sec  19.5 MBytes  16.3 Mbits/sec                  receiver
CPU Utilization: local/sender 2.5% (0.0%u/2.5%s), remote/receiver 14.6% (0.9%u/13.8%s)
snd_tcp_congestion cubic
rcv_tcp_congestion cubic

iperf Done.
Test Completed at Wed Jun 18 15:41:16 UTC 2025
Test iperf3 (Download) to fd42:dead:c0de:1337::1
iperf 3.17.1
Linux d43df3fef352 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips
Control connection MSS 1368
Time: Wed, 18 Jun 2025 15:41:17 UTC
Connecting to host fd42:dead:c0de:1337::1, port 5201
Reverse mode, remote host fd42:dead:c0de:1337::1 is sending
      Cookie: kyvkpo246ngqsgspedegxngtdjvrwwhv2pr4
      TCP MSS: 1368 (default)
[  5] local fd42:dead:c0de:1337:0:d43d:f3fe:f352 port 58130 connected to fd42:dead:c0de:1337::1 port 5201
Starting Test: protocol: TCP, 1 streams, 131072 byte blocks, omitting 0 seconds, 10 second test, tos 0
[ ID] Interval           Transfer     Bitrate
[  5]   0.00-1.00   sec  2.00 MBytes  16.8 Mbits/sec                  
[  5]   1.00-2.00   sec  2.88 MBytes  24.1 Mbits/sec                  
[  5]   2.00-3.00   sec  2.75 MBytes  23.1 Mbits/sec                  
[  5]   3.00-4.00   sec  2.88 MBytes  24.1 Mbits/sec                  
[  5]   4.00-5.00   sec  3.00 MBytes  25.2 Mbits/sec                  
[  5]   5.00-6.00   sec  3.12 MBytes  26.2 Mbits/sec                  
[  5]   6.00-7.00   sec  3.00 MBytes  25.2 Mbits/sec                  
[  5]   7.00-8.00   sec  2.88 MBytes  24.1 Mbits/sec                  
[  5]   8.00-9.00   sec  3.00 MBytes  25.2 Mbits/sec                  
[  5]   9.00-10.00  sec  3.25 MBytes  27.3 Mbits/sec                  
- - - - - - - - - - - - - - - - - - - - - - - - -
Test Complete. Summary Results:
[ ID] Interval           Transfer     Bitrate         Retr
[  5]   0.00-10.05  sec  29.6 MBytes  24.7 Mbits/sec    0             sender
[  5]   0.00-10.00  sec  28.8 MBytes  24.1 Mbits/sec                  receiver
snd_tcp_congestion cubic
rcv_tcp_congestion cubic

iperf Done.
Test Completed at Wed Jun 18 15:41:27 UTC 2025
Test iperf3 (Bidirectional) to fd42:dead:c0de:1337::1
iperf 3.17.1
Linux d43df3fef352 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips
Control connection MSS 1368
send_parameters:
{
	"tcp":	true,
	"omit":	0,
	"time":	10,
	"num":	0,
	"blockcount":	0,
	"parallel":	1,
	"len":	131072,
	"pacing_timer":	1000,
	"client_version":	"3.17.1"
}
Time: Wed, 18 Jun 2025 15:41:27 UTC
Connecting to host fd42:dead:c0de:1337::1, port 5201
      Cookie: rybl5o5aw2g7b5ieqszmcrwmwlyjcemomqjp
      TCP MSS: 1368 (default)
SNDBUF is 16384, expecting 0
RCVBUF is 131072, expecting 0
Congestion algorithm is cubic
[  5] local fd42:dead:c0de:1337:0:d43d:f3fe:f352 port 49398 connected to fd42:dead:c0de:1337::1 port 5201
Starting Test: protocol: TCP, 1 streams, 131072 byte blocks, omitting 0 seconds, 10 second test, tos 0
Thread FD 5 created
All threads created
sent 131072 bytes of 131072, pending 0, total 131072
sent 131072 bytes of 131072, pending 0, total 262144
sent 131072 bytes of 131072, pending 0, total 393216
sent 131072 bytes of 131072, pending 0, total 524288
sent 131072 bytes of 131072, pending 0, total 655360
sent 131072 bytes of 131072, pending 0, total 786432
sent 131072 bytes of 131072, pending 0, total 917504
sent 131072 bytes of 131072, pending 0, total 1048576
sent 131072 bytes of 131072, pending 0, total 1179648
sent 131072 bytes of 131072, pending 0, total 1310720
sent 131072 bytes of 131072, pending 0, total 1441792
sent 131072 bytes of 131072, pending 0, total 1572864
sent 131072 bytes of 131072, pending 0, total 1703936
sent 131072 bytes of 131072, pending 0, total 1835008
sent 131072 bytes of 131072, pending 0, total 1966080
sent 131072 bytes of 131072, pending 0, total 2097152
sent 131072 bytes of 131072, pending 0, total 2228224
sent 131072 bytes of 131072, pending 0, total 2359296
sent 131072 bytes of 131072, pending 0, total 2490368
sent 131072 bytes of 131072, pending 0, total 2621440
sent 131072 bytes of 131072, pending 0, total 2752512
sent 131072 bytes of 131072, pending 0, total 2883584
sent 131072 bytes of 131072, pending 0, total 3014656
sent 131072 bytes of 131072, pending 0, total 3145728
sent 131072 bytes of 131072, pending 0, total 3276800
sent 131072 bytes of 131072, pending 0, total 3407872
sent 131072 bytes of 131072, pending 0, total 3538944
sent 131072 bytes of 131072, pending 0, total 3670016
sent 131072 bytes of 131072, pending 0, total 3801088
sent 131072 bytes of 131072, pending 0, total 3932160
sent 131072 bytes of 131072, pending 0, total 4063232
sent 131072 bytes of 131072, pending 0, total 4194304
sent 131072 bytes of 131072, pending 0, total 4325376
sent 131072 bytes of 131072, pending 0, total 4456448
sent 131072 bytes of 131072, pending 0, total 4587520
sent 131072 bytes of 131072, pending 0, total 4718592
sent 131072 bytes of 131072, pending 0, total 4849664
sent 131072 bytes of 131072, pending 0, total 4980736
sent 131072 bytes of 131072, pending 0, total 5111808
tcpi_snd_cwnd 217 tcpi_snd_mss 1368 tcpi_rtt 28358
interval_len 1.001146 bytes_transferred 5111808
interval forces keep
[ ID] Interval           Transfer     Bitrate         Retr  Cwnd
[  5]   0.00-1.00   sec  4.88 MBytes  40.8 Mbits/sec    0    290 KBytes       
sent 131072 bytes of 131072, pending 0, total 5242880
sent 131072 bytes of 131072, pending 0, total 5373952
sent 131072 bytes of 131072, pending 0, total 5505024
sent 131072 bytes of 131072, pending 0, total 5636096
sent 131072 bytes of 131072, pending 0, total 5767168
sent 131072 bytes of 131072, pending 0, total 5898240
sent 131072 bytes of 131072, pending 0, total 6029312
sent 131072 bytes of 131072, pending 0, total 6160384
sent 131072 bytes of 131072, pending 0, total 6291456
sent 131072 bytes of 131072, pending 0, total 6422528
sent 131072 bytes of 131072, pending 0, total 6553600
sent 131072 bytes of 131072, pending 0, total 6684672
sent 131072 bytes of 131072, pending 0, total 6815744
sent 131072 bytes of 131072, pending 0, total 6946816
sent 131072 bytes of 131072, pending 0, total 7077888
sent 131072 bytes of 131072, pending 0, total 7208960
sent 131072 bytes of 131072, pending 0, total 7340032
sent 131072 bytes of 131072, pending 0, total 7471104
sent 131072 bytes of 131072, pending 0, total 7602176
sent 131072 bytes of 131072, pending 0, total 7733248
sent 131072 bytes of 131072, pending 0, total 7864320
sent 131072 bytes of 131072, pending 0, total 7995392
sent 131072 bytes of 131072, pending 0, total 8126464
sent 131072 bytes of 131072, pending 0, total 8257536
sent 131072 bytes of 131072, pending 0, total 8388608
sent 131072 bytes of 131072, pending 0, total 8519680
sent 131072 bytes of 131072, pending 0, total 8650752
sent 131072 bytes of 131072, pending 0, total 8781824
sent 131072 bytes of 131072, pending 0, total 8912896
sent 131072 bytes of 131072, pending 0, total 9043968
sent 131072 bytes of 131072, pending 0, total 9175040
sent 131072 bytes of 131072, pending 0, total 9306112
tcpi_snd_cwnd 228 tcpi_snd_mss 1368 tcpi_rtt 20297
interval_len 1.000022 bytes_transferred 4194304
interval forces keep
[  5]   1.00-2.00   sec  4.00 MBytes  33.6 Mbits/sec    0    305 KBytes       
sent 131072 bytes of 131072, pending 0, total 9437184
sent 131072 bytes of 131072, pending 0, total 9568256
sent 131072 bytes of 131072, pending 0, total 9699328
sent 131072 bytes of 131072, pending 0, total 9830400
sent 131072 bytes of 131072, pending 0, total 9961472
sent 131072 bytes of 131072, pending 0, total 10092544
sent 131072 bytes of 131072, pending 0, total 10223616
sent 131072 bytes of 131072, pending 0, total 10354688
sent 131072 bytes of 131072, pending 0, total 10485760
sent 131072 bytes of 131072, pending 0, total 10616832
sent 131072 bytes of 131072, pending 0, total 10747904
sent 131072 bytes of 131072, pending 0, total 10878976
sent 131072 bytes of 131072, pending 0, total 11010048
sent 131072 bytes of 131072, pending 0, total 11141120
sent 131072 bytes of 131072, pending 0, total 11272192
sent 131072 bytes of 131072, pending 0, total 11403264
sent 131072 bytes of 131072, pending 0, total 11534336
sent 131072 bytes of 131072, pending 0, total 11665408
sent 131072 bytes of 131072, pending 0, total 11796480
sent 131072 bytes of 131072, pending 0, total 11927552
sent 131072 bytes of 131072, pending 0, total 12058624
sent 131072 bytes of 131072, pending 0, total 12189696
sent 131072 bytes of 131072, pending 0, total 12320768
sent 131072 bytes of 131072, pending 0, total 12451840
sent 131072 bytes of 131072, pending 0, total 12582912
sent 131072 bytes of 131072, pending 0, total 12713984
sent 131072 bytes of 131072, pending 0, total 12845056
sent 131072 bytes of 131072, pending 0, total 12976128
sent 131072 bytes of 131072, pending 0, total 13107200
sent 131072 bytes of 131072, pending 0, total 13238272
sent 131072 bytes of 131072, pending 0, total 13369344
sent 131072 bytes of 131072, pending 0, total 13500416
sent 131072 bytes of 131072, pending 0, total 13631488
sent 131072 bytes of 131072, pending 0, total 13762560
sent 131072 bytes of 131072, pending 0, total 13893632
tcpi_snd_cwnd 228 tcpi_snd_mss 1368 tcpi_rtt 24576
interval_len 0.999983 bytes_transferred 4587520
interval forces keep
[  5]   2.00-3.00   sec  4.38 MBytes  36.7 Mbits/sec    0    305 KBytes       
sent 131072 bytes of 131072, pending 0, total 14024704
sent 131072 bytes of 131072, pending 0, total 14155776
sent 131072 bytes of 131072, pending 0, total 14286848
sent 131072 bytes of 131072, pending 0, total 14417920
sent 131072 bytes of 131072, pending 0, total 14548992
sent 131072 bytes of 131072, pending 0, total 14680064
sent 131072 bytes of 131072, pending 0, total 14811136
sent 131072 bytes of 131072, pending 0, total 14942208
sent 131072 bytes of 131072, pending 0, total 15073280
sent 131072 bytes of 131072, pending 0, total 15204352
sent 131072 bytes of 131072, pending 0, total 15335424
sent 131072 bytes of 131072, pending 0, total 15466496
sent 131072 bytes of 131072, pending 0, total 15597568
sent 131072 bytes of 131072, pending 0, total 15728640
sent 131072 bytes of 131072, pending 0, total 15859712
sent 131072 bytes of 131072, pending 0, total 15990784
sent 131072 bytes of 131072, pending 0, total 16121856
sent 131072 bytes of 131072, pending 0, total 16252928
sent 131072 bytes of 131072, pending 0, total 16384000
sent 131072 bytes of 131072, pending 0, total 16515072
sent 131072 bytes of 131072, pending 0, total 16646144
sent 131072 bytes of 131072, pending 0, total 16777216
sent 131072 bytes of 131072, pending 0, total 16908288
sent 131072 bytes of 131072, pending 0, total 17039360
sent 131072 bytes of 131072, pending 0, total 17170432
sent 131072 bytes of 131072, pending 0, total 17301504
sent 131072 bytes of 131072, pending 0, total 17432576
sent 131072 bytes of 131072, pending 0, total 17563648
sent 131072 bytes of 131072, pending 0, total 17694720
sent 131072 bytes of 131072, pending 0, total 17825792
sent 131072 bytes of 131072, pending 0, total 17956864
sent 131072 bytes of 131072, pending 0, total 18087936
sent 131072 bytes of 131072, pending 0, total 18219008
tcpi_snd_cwnd 228 tcpi_snd_mss 1368 tcpi_rtt 32384
interval_len 0.999981 bytes_transferred 4325376
interval forces keep
[  5]   3.00-4.00   sec  4.12 MBytes  34.6 Mbits/sec    0    305 KBytes       
sent 131072 bytes of 131072, pending 0, total 18350080
sent 131072 bytes of 131072, pending 0, total 18481152
sent 131072 bytes of 131072, pending 0, total 18612224
sent 131072 bytes of 131072, pending 0, total 18743296
sent 131072 bytes of 131072, pending 0, total 18874368
sent 131072 bytes of 131072, pending 0, total 19005440
sent 131072 bytes of 131072, pending 0, total 19136512
sent 131072 bytes of 131072, pending 0, total 19267584
sent 131072 bytes of 131072, pending 0, total 19398656
sent 131072 bytes of 131072, pending 0, total 19529728
sent 131072 bytes of 131072, pending 0, total 19660800
sent 131072 bytes of 131072, pending 0, total 19791872
sent 131072 bytes of 131072, pending 0, total 19922944
sent 131072 bytes of 131072, pending 0, total 20054016
sent 131072 bytes of 131072, pending 0, total 20185088
sent 131072 bytes of 131072, pending 0, total 20316160
sent 131072 bytes of 131072, pending 0, total 20447232
sent 131072 bytes of 131072, pending 0, total 20578304
sent 131072 bytes of 131072, pending 0, total 20709376
sent 131072 bytes of 131072, pending 0, total 20840448
sent 131072 bytes of 131072, pending 0, total 20971520
sent 131072 bytes of 131072, pending 0, total 21102592
sent 131072 bytes of 131072, pending 0, total 21233664
sent 131072 bytes of 131072, pending 0, total 21364736
sent 131072 bytes of 131072, pending 0, total 21495808
sent 131072 bytes of 131072, pending 0, total 21626880
sent 131072 bytes of 131072, pending 0, total 21757952
sent 131072 bytes of 131072, pending 0, total 21889024
sent 131072 bytes of 131072, pending 0, total 22020096
sent 131072 bytes of 131072, pending 0, total 22151168
sent 131072 bytes of 131072, pending 0, total 22282240
sent 131072 bytes of 131072, pending 0, total 22413312
sent 131072 bytes of 131072, pending 0, total 22544384
sent 131072 bytes of 131072, pending 0, total 22675456
sent 131072 bytes of 131072, pending 0, total 22806528
sent 131072 bytes of 131072, pending 0, total 22937600
sent 131072 bytes of 131072, pending 0, total 23068672
tcpi_snd_cwnd 244 tcpi_snd_mss 1368 tcpi_rtt 31358
interval_len 1.000001 bytes_transferred 4849664
interval forces keep
[  5]   4.00-5.00   sec  4.62 MBytes  38.8 Mbits/sec    0    326 KBytes       
sent 131072 bytes of 131072, pending 0, total 23199744
sent 131072 bytes of 131072, pending 0, total 23330816
sent 131072 bytes of 131072, pending 0, total 23461888
sent 131072 bytes of 131072, pending 0, total 23592960
sent 131072 bytes of 131072, pending 0, total 23724032
sent 131072 bytes of 131072, pending 0, total 23855104
sent 131072 bytes of 131072, pending 0, total 23986176
sent 131072 bytes of 131072, pending 0, total 24117248
sent 131072 bytes of 131072, pending 0, total 24248320
sent 131072 bytes of 131072, pending 0, total 24379392
sent 131072 bytes of 131072, pending 0, total 24510464
sent 131072 bytes of 131072, pending 0, total 24641536
sent 131072 bytes of 131072, pending 0, total 24772608
sent 131072 bytes of 131072, pending 0, total 24903680
sent 131072 bytes of 131072, pending 0, total 25034752
sent 131072 bytes of 131072, pending 0, total 25165824
sent 131072 bytes of 131072, pending 0, total 25296896
sent 131072 bytes of 131072, pending 0, total 25427968
sent 131072 bytes of 131072, pending 0, total 25559040
sent 131072 bytes of 131072, pending 0, total 25690112
sent 131072 bytes of 131072, pending 0, total 25821184
sent 131072 bytes of 131072, pending 0, total 25952256
sent 131072 bytes of 131072, pending 0, total 26083328
sent 131072 bytes of 131072, pending 0, total 26214400
sent 131072 bytes of 131072, pending 0, total 26345472
sent 131072 bytes of 131072, pending 0, total 26476544
sent 131072 bytes of 131072, pending 0, total 26607616
sent 131072 bytes of 131072, pending 0, total 26738688
sent 131072 bytes of 131072, pending 0, total 26869760
sent 131072 bytes of 131072, pending 0, total 27000832
sent 131072 bytes of 131072, pending 0, total 27131904
sent 131072 bytes of 131072, pending 0, total 27262976
sent 131072 bytes of 131072, pending 0, total 27394048
tcpi_snd_cwnd 244 tcpi_snd_mss 1368 tcpi_rtt 62651
interval_len 0.999999 bytes_transferred 4325376
interval forces keep
[  5]   5.00-6.00   sec  4.12 MBytes  34.6 Mbits/sec    0    326 KBytes       
sent 131072 bytes of 131072, pending 0, total 27525120
sent 131072 bytes of 131072, pending 0, total 27656192
sent 131072 bytes of 131072, pending 0, total 27787264
sent 131072 bytes of 131072, pending 0, total 27918336
sent 131072 bytes of 131072, pending 0, total 28049408
sent 131072 bytes of 131072, pending 0, total 28180480
sent 131072 bytes of 131072, pending 0, total 28311552
sent 131072 bytes of 131072, pending 0, total 28442624
sent 131072 bytes of 131072, pending 0, total 28573696
sent 131072 bytes of 131072, pending 0, total 28704768
sent 131072 bytes of 131072, pending 0, total 28835840
sent 131072 bytes of 131072, pending 0, total 28966912
sent 131072 bytes of 131072, pending 0, total 29097984
sent 131072 bytes of 131072, pending 0, total 29229056
sent 131072 bytes of 131072, pending 0, total 29360128
tcpi_snd_cwnd 170 tcpi_snd_mss 1368 tcpi_rtt 27760
interval_len 1.000005 bytes_transferred 1966080
interval forces keep
[  5]   6.00-7.00   sec  1.88 MBytes  15.7 Mbits/sec    1    227 KBytes       
sent 131072 bytes of 131072, pending 0, total 29491200
sent 131072 bytes of 131072, pending 0, total 29622272
sent 131072 bytes of 131072, pending 0, total 29753344
sent 131072 bytes of 131072, pending 0, total 29884416
sent 131072 bytes of 131072, pending 0, total 30015488
sent 131072 bytes of 131072, pending 0, total 30146560
sent 131072 bytes of 131072, pending 0, total 30277632
sent 131072 bytes of 131072, pending 0, total 30408704
sent 131072 bytes of 131072, pending 0, total 30539776
sent 131072 bytes of 131072, pending 0, total 30670848
sent 131072 bytes of 131072, pending 0, total 30801920
sent 131072 bytes of 131072, pending 0, total 30932992
sent 131072 bytes of 131072, pending 0, total 31064064
sent 131072 bytes of 131072, pending 0, total 31195136
sent 131072 bytes of 131072, pending 0, total 31326208
sent 131072 bytes of 131072, pending 0, total 31457280
sent 131072 bytes of 131072, pending 0, total 31588352
sent 131072 bytes of 131072, pending 0, total 31719424
tcpi_snd_cwnd 170 tcpi_snd_mss 1368 tcpi_rtt 26460
interval_len 1.000019 bytes_transferred 2359296
interval forces keep
[  5]   7.00-8.00   sec  2.25 MBytes  18.9 Mbits/sec    0    227 KBytes       
sent 131072 bytes of 131072, pending 0, total 31850496
sent 131072 bytes of 131072, pending 0, total 31981568
sent 131072 bytes of 131072, pending 0, total 32112640
sent 131072 bytes of 131072, pending 0, total 32243712
sent 131072 bytes of 131072, pending 0, total 32374784
sent 131072 bytes of 131072, pending 0, total 32505856
sent 131072 bytes of 131072, pending 0, total 32636928
sent 131072 bytes of 131072, pending 0, total 32768000
sent 131072 bytes of 131072, pending 0, total 32899072
sent 131072 bytes of 131072, pending 0, total 33030144
sent 131072 bytes of 131072, pending 0, total 33161216
sent 131072 bytes of 131072, pending 0, total 33292288
sent 131072 bytes of 131072, pending 0, total 33423360
sent 131072 bytes of 131072, pending 0, total 33554432
sent 131072 bytes of 131072, pending 0, total 33685504
sent 131072 bytes of 131072, pending 0, total 33816576
sent 131072 bytes of 131072, pending 0, total 33947648
sent 131072 bytes of 131072, pending 0, total 34078720
tcpi_snd_cwnd 171 tcpi_snd_mss 1368 tcpi_rtt 50920
interval_len 0.999966 bytes_transferred 2359296
interval forces keep
[  5]   8.00-9.00   sec  2.25 MBytes  18.9 Mbits/sec    0    228 KBytes       
sent 131072 bytes of 131072, pending 0, total 34209792
sent 131072 bytes of 131072, pending 0, total 34340864
sent 131072 bytes of 131072, pending 0, total 34471936
sent 131072 bytes of 131072, pending 0, total 34603008
sent 131072 bytes of 131072, pending 0, total 34734080
sent 131072 bytes of 131072, pending 0, total 34865152
sent 131072 bytes of 131072, pending 0, total 34996224
sent 131072 bytes of 131072, pending 0, total 35127296
sent 131072 bytes of 131072, pending 0, total 35258368
sent 131072 bytes of 131072, pending 0, total 35389440
sent 131072 bytes of 131072, pending 0, total 35520512
sent 131072 bytes of 131072, pending 0, total 35651584
sent 131072 bytes of 131072, pending 0, total 35782656
sent 131072 bytes of 131072, pending 0, total 35913728
sent 131072 bytes of 131072, pending 0, total 36044800
sent 131072 bytes of 131072, pending 0, total 36175872
sent 131072 bytes of 131072, pending 0, total 36306944
sent 131072 bytes of 131072, pending 0, total 36438016
Thread FD 5 stopped
Sender threads stopped
tcpi_snd_cwnd 171 tcpi_snd_mss 1368 tcpi_rtt 32235
send_results
{
	"cpu_util_total":	4.11294953276909,
	"cpu_util_user":	0.49534145612434316,
	"cpu_util_system":	3.6177457288487558,
	"sender_has_retransmits":	1,
	"congestion_used":	"cubic",
	"streams":	[{
			"id":	1,
			"bytes":	36438016,
			"retransmits":	1,
			"jitter":	0,
			"errors":	0,
			"omitted_errors":	0,
			"packets":	0,
			"omitted_packets":	0,
			"start_time":	0,
			"end_time":	10.003811
		}]
}
get_results
{
	"cpu_util_total":	29.881362039670872,
	"cpu_util_user":	1.1924250523408615,
	"cpu_util_system":	28.68893698733001,
	"sender_has_retransmits":	-1,
	"congestion_used":	"cubic",
	"streams":	[{
			"id":	1,
			"bytes":	35651584,
			"retransmits":	-1,
			"jitter":	0,
			"errors":	0,
			"omitted_errors":	0,
			"packets":	0,
			"omitted_packets":	0,
			"start_time":	0,
			"end_time":	10.056846
		}]
}
interval_len 1.002689 bytes_transferred 2359296
interval forces keep
[  5]   9.00-10.00  sec  2.25 MBytes  18.8 Mbits/sec    0    228 KBytes       
- - - - - - - - - - - - - - - - - - - - - - - - -
Test Complete. Summary Results:
[ ID] Interval           Transfer     Bitrate         Retr
[  5]   0.00-10.00  sec  34.8 MBytes  29.1 Mbits/sec    1             sender
[  5]   0.00-10.06  sec  34.0 MBytes  28.4 Mbits/sec                  receiver
CPU Utilization: local/sender 4.1% (0.5%u/3.6%s), remote/receiver 29.9% (1.2%u/28.7%s)
snd_tcp_congestion cubic
rcv_tcp_congestion cubic
Receiver threads stopped

iperf Done.
Test Completed at Wed Jun 18 15:41:38 UTC 2025
Batman/Batctl Report
====================
Batctl neighbors
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: phy0-mesh0/d2:3d:f3:fe:f3:53 (batman/ca:4a:dc:99:79:f6 BATMAN_IV)]
IF             Neighbor              last-seen
   phy0-mesh0	  f2:4d:5c:fd:a2:fd    4.970s
   phy0-mesh0	  f2:4d:5c:fe:51:65    4.450s
   phy0-mesh0	  2a:97:27:52:6c:ad   22.880s
   phy0-mesh0	  f2:4d:5c:fc:25:8d    2.250s
   phy0-mesh0	  d2:3d:f3:fe:f3:62    7.900s
   phy0-mesh0	  f2:4d:5c:fd:9d:f0   14.410s
   phy1-mesh0	  f2:4d:5c:fd:a2:fe    0.570s
   phy1-mesh0	  f2:4d:5c:fe:51:66    4.760s
   phy1-mesh0	  2a:97:27:52:6c:ae    0.720s
   phy1-mesh0	  f2:4d:5c:fc:25:8e    3.860s
   phy1-mesh0	  f2:4d:5c:fd:9d:f1    0.460s
Batctl originators
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: phy0-mesh0/d2:3d:f3:fe:f3:53 (batman/ca:4a:dc:99:79:f6 BATMAN_IV)]
   Originator        last-seen (#/255) Nexthop           [outgoingIF]
   f4:4d:5c:fd:9d:ef    0.210s   (188) 2a:97:27:52:6c:ad [phy0-mesh0]
   f4:4d:5c:fd:9d:ef    0.210s   (184) 2a:97:27:52:6c:ae [phy1-mesh0]
   f4:4d:5c:fd:9d:ef    0.210s   (  0) f2:4d:5c:fc:25:8e [phy1-mesh0]
   f4:4d:5c:fd:9d:ef    0.210s   (188) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f4:4d:5c:fd:9d:ef    0.210s   (  0) d2:3d:f3:fe:f3:62 [phy0-mesh0]
   f4:4d:5c:fd:9d:ef    0.210s   (194) f2:4d:5c:fc:25:8d [phy0-mesh0]
   f4:4d:5c:fd:9d:ef    0.210s   (186) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
 * f4:4d:5c:fd:9d:ef    0.210s   (225) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f4:4d:5c:fd:9d:ef    0.210s   (191) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   f4:4d:5c:fd:9d:ef    0.210s   (217) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f4:4d:5c:fd:9d:ef    0.210s   (215) f2:4d:5c:fe:51:65 [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    0.970s   (  0) f2:4d:5c:fc:25:8e [phy1-mesh0]
   f4:4d:5c:fd:a2:fc    0.970s   (  0) d2:3d:f3:fe:f3:62 [phy0-mesh0]
 * f4:4d:5c:fd:a2:fc    0.970s   (255) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    0.970s   (222) f2:4d:5c:fc:25:8d [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    0.970s   (187) 2a:97:27:52:6c:ad [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    0.970s   (186) 2a:97:27:52:6c:ae [phy1-mesh0]
   f4:4d:5c:fd:a2:fc    0.970s   (217) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   f4:4d:5c:fd:a2:fc    0.970s   (217) f2:4d:5c:fe:51:65 [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    0.970s   (217) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f4:4d:5c:fd:a2:fc    0.970s   (161) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    0.970s   (165) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
 * d2:3d:f3:fe:f3:62    2.520s   (198) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   d2:3d:f3:fe:f3:62    2.520s   (168) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   d2:3d:f3:fe:f3:62    2.520s   (  0) f2:4d:5c:fc:25:8e [phy1-mesh0]
   d2:3d:f3:fe:f3:62    2.520s   (167) f2:4d:5c:fc:25:8d [phy0-mesh0]
   d2:3d:f3:fe:f3:62    2.520s   (191) f2:4d:5c:fe:51:66 [phy1-mesh0]
   d2:3d:f3:fe:f3:62    2.520s   (191) f2:4d:5c:fe:51:65 [phy0-mesh0]
   d2:3d:f3:fe:f3:62    2.520s   (168) 2a:97:27:52:6c:ad [phy0-mesh0]
   d2:3d:f3:fe:f3:62    2.520s   (177) 2a:97:27:52:6c:ae [phy1-mesh0]
   d2:3d:f3:fe:f3:62    2.520s   (165) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   d2:3d:f3:fe:f3:62    2.520s   (165) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   d2:3d:f3:fe:f3:62    2.520s   (151) d2:3d:f3:fe:f3:62 [phy0-mesh0]
   f2:4d:5c:fc:25:8e    3.750s   (120) 2a:97:27:52:6c:ae [phy1-mesh0]
   f2:4d:5c:fc:25:8e    3.750s   (151) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   f2:4d:5c:fc:25:8e    3.750s   (180) f2:4d:5c:fe:51:66 [phy1-mesh0]
 * f2:4d:5c:fc:25:8e    3.750s   (218) f2:4d:5c:fc:25:8e [phy1-mesh0]
   f2:4d:5c:fe:51:65    4.330s   (124) 2a:97:27:52:6c:ad [phy0-mesh0]
   f2:4d:5c:fe:51:65    4.330s   (112) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   f2:4d:5c:fe:51:65    4.330s   (179) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f2:4d:5c:fe:51:65    4.330s   (168) f2:4d:5c:fc:25:8d [phy0-mesh0]
 * f2:4d:5c:fe:51:65    4.330s   (244) f2:4d:5c:fe:51:65 [phy0-mesh0]
   f2:4d:5c:fd:a2:fe    0.460s   (106) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f2:4d:5c:fd:a2:fe    0.460s   (115) 2a:97:27:52:6c:ae [phy1-mesh0]
   f2:4d:5c:fd:a2:fe    0.460s   (180) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f2:4d:5c:fd:a2:fe    0.460s   (169) f2:4d:5c:fc:25:8e [phy1-mesh0]
 * f2:4d:5c:fd:a2:fe    0.460s   (218) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   2a:97:27:52:6c:ae    0.460s   (156) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   2a:97:27:52:6c:ae    0.460s   (161) f2:4d:5c:fe:51:66 [phy1-mesh0]
   2a:97:27:52:6c:ae    0.460s   (136) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
 * 2a:97:27:52:6c:ae    0.460s   (211) 2a:97:27:52:6c:ae [phy1-mesh0]
   d2:3d:f3:fe:f3:63    4.750s   (  0) f2:4d:5c:fe:51:66 [phy1-mesh0]
 * d2:3d:f3:fe:f3:63    4.750s   (154) 2a:97:27:52:6c:ae [phy1-mesh0]
   d2:3d:f3:fe:f3:63    4.750s   (144) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   2a:97:27:52:6c:ad    7.650s   (133) f2:4d:5c:fc:25:8d [phy0-mesh0]
   2a:97:27:52:6c:ad    7.650s   (165) f2:4d:5c:fe:51:65 [phy0-mesh0]
   2a:97:27:52:6c:ad    7.650s   (146) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   2a:97:27:52:6c:ad    7.650s   ( 86) d2:3d:f3:fe:f3:62 [phy0-mesh0]
 * 2a:97:27:52:6c:ad    7.650s   (215) 2a:97:27:52:6c:ad [phy0-mesh0]
   f2:4d:5c:fd:9d:f1    0.340s   (149) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   f2:4d:5c:fd:9d:f1    0.340s   (157) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f2:4d:5c:fd:9d:f1    0.340s   (158) 2a:97:27:52:6c:ae [phy1-mesh0]
 * f2:4d:5c:fd:9d:f1    0.340s   (188) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f2:4d:5c:fc:25:8d    1.990s   (159) 2a:97:27:52:6c:ad [phy0-mesh0]
   f2:4d:5c:fc:25:8d    1.990s   (182) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   f2:4d:5c:fc:25:8d    1.990s   (202) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f2:4d:5c:fc:25:8d    1.990s   (138) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   f2:4d:5c:fc:25:8d    1.990s   (140) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f2:4d:5c:fc:25:8d    1.990s   (157) 2a:97:27:52:6c:ae [phy1-mesh0]
   f2:4d:5c:fc:25:8d    1.990s   (209) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f2:4d:5c:fc:25:8d    1.990s   (204) f2:4d:5c:fe:51:65 [phy0-mesh0]
   f2:4d:5c:fc:25:8d    1.990s   ( 92) d2:3d:f3:fe:f3:62 [phy0-mesh0]
   f2:4d:5c:fc:25:8d    1.990s   (214) f2:4d:5c:fc:25:8e [phy1-mesh0]
 * f2:4d:5c:fc:25:8d    1.990s   (250) f2:4d:5c:fc:25:8d [phy0-mesh0]
   f2:4d:5c:fd:a2:fd    4.860s   (134) 2a:97:27:52:6c:ad [phy0-mesh0]
   f2:4d:5c:fd:a2:fd    4.860s   (142) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   f2:4d:5c:fd:a2:fd    4.860s   (187) f2:4d:5c:fe:51:65 [phy0-mesh0]
   f2:4d:5c:fd:a2:fd    4.860s   (182) f2:4d:5c:fc:25:8d [phy0-mesh0]
 * f2:4d:5c:fd:a2:fd    4.860s   (255) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f2:4d:5c:fe:51:66    4.650s   (168) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   f2:4d:5c:fe:51:66    4.650s   (153) 2a:97:27:52:6c:ae [phy1-mesh0]
   f2:4d:5c:fe:51:66    4.650s   (149) f2:4d:5c:fc:25:8e [phy1-mesh0]
   f2:4d:5c:fe:51:66    4.650s   (131) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
 * f2:4d:5c:fe:51:66    4.650s   (247) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f2:4d:5c:fd:9d:f0   14.420s   (147) 2a:97:27:52:6c:ad [phy0-mesh0]
   f2:4d:5c:fd:9d:f0   14.420s   (150) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f2:4d:5c:fd:9d:f0   14.420s   (100) d2:3d:f3:fe:f3:62 [phy0-mesh0]
   f2:4d:5c:fd:9d:f0   14.420s   (169) f2:4d:5c:fe:51:65 [phy0-mesh0]
 * f2:4d:5c:fd:9d:f0   14.420s   (192) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
 * 20:97:27:52:6c:ab    4.600s   (225) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   20:97:27:52:6c:ab    4.600s   (191) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   20:97:27:52:6c:ab    4.600s   (  0) f2:4d:5c:fc:25:8e [phy1-mesh0]
   20:97:27:52:6c:ab    4.600s   (198) f2:4d:5c:fc:25:8d [phy0-mesh0]
   20:97:27:52:6c:ab    4.600s   (215) f2:4d:5c:fe:51:65 [phy0-mesh0]
   20:97:27:52:6c:ab    4.600s   (217) f2:4d:5c:fe:51:66 [phy1-mesh0]
   20:97:27:52:6c:ab    4.600s   (  0) d2:3d:f3:fe:f3:62 [phy0-mesh0]
   20:97:27:52:6c:ab    4.600s   (215) 2a:97:27:52:6c:ae [phy1-mesh0]
   20:97:27:52:6c:ab    4.600s   (214) 2a:97:27:52:6c:ad [phy0-mesh0]
   20:97:27:52:6c:ab    4.600s   (170) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   20:97:27:52:6c:ab    4.600s   (165) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f4:4d:5c:fe:51:64    0.810s   (225) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f4:4d:5c:fe:51:64    0.810s   (191) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   f4:4d:5c:fe:51:64    0.810s   (189) f2:4d:5c:fc:25:8d [phy0-mesh0]
   f4:4d:5c:fe:51:64    0.810s   (164) f2:4d:5c:fc:25:8e [phy1-mesh0]
   f4:4d:5c:fe:51:64    0.810s   (170) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
 * f4:4d:5c:fe:51:64    0.810s   (246) f2:4d:5c:fe:51:65 [phy0-mesh0]
   f4:4d:5c:fe:51:64    0.810s   (246) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f4:4d:5c:fe:51:64    0.810s   (103) d2:3d:f3:fe:f3:62 [phy0-mesh0]
   f4:4d:5c:fe:51:64    0.810s   (165) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f4:4d:5c:fe:51:64    0.810s   (188) 2a:97:27:52:6c:ad [phy0-mesh0]
   f4:4d:5c:fe:51:64    0.810s   (186) 2a:97:27:52:6c:ae [phy1-mesh0]
Batctl transglobal
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: phy0-mesh0/d2:3d:f3:fe:f3:53 (batman/ca:4a:dc:99:79:f6 BATMAN_IV)]
   Client             VID Flags Last ttvn     Via        ttvn  (CRC       )
 * e6:b5:a1:87:27:54    0 [....] (  1) 20:97:27:52:6c:ab ( 13) (0x4edbbb86)
 * 16:87:5f:85:10:d4    0 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xff7b8a9d)
 * e6:b5:a1:87:27:54    3 [....] (  1) 20:97:27:52:6c:ab ( 13) (0xd70f86fe)
 * 2a:1b:08:b6:0e:40    3 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xc9b01d7f)
 * 0a:9f:f2:07:5b:66   -1 [....] (  1) d2:3d:f3:fe:f3:62 ( 60) (0x31f39dc9)
 * 33:33:ff:29:ce:72   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
 * 06:3a:b0:85:82:c4   11 [.W..] ( 58) d2:3d:f3:fe:f3:62 ( 60) (0x4e7ef6c6)
 * 16:87:5f:85:10:d4    3 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0x243f0df4)
 * 33:33:ff:85:10:d4   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
 * 20:97:27:52:6c:ad   12 [....] (  2) 20:97:27:52:6c:ab ( 13) (0x5c5d6f23)
 * 16:87:5f:85:10:d4   11 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0x6604092e)
   33:33:00:00:00:02   -1 [....] (  1) 20:97:27:52:6c:ab ( 13) (0xfaf54e6c)
   33:33:00:00:00:02   -1 [....] (  1) f4:4d:5c:fd:9d:ef (  9) (0x6babf43b)
   33:33:00:00:00:02   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
 * 33:33:00:00:00:02   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
   33:33:00:00:00:02   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
   33:33:00:00:00:02   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
   33:33:00:00:00:02   -1 [....] (  1) d2:3d:f3:fe:f3:62 ( 60) (0x31f39dc9)
 * e6:b5:a1:87:27:54   12 [....] (  1) 20:97:27:52:6c:ab ( 13) (0x5c5d6f23)
 * 33:33:ff:87:27:54   -1 [....] (  1) 20:97:27:52:6c:ab ( 13) (0xfaf54e6c)
 * e6:b5:a1:87:27:54   11 [....] (  1) 20:97:27:52:6c:ab ( 13) (0x2f1d4dad)
 * b6:1d:b2:47:cd:26   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
 * 9a:58:fd:e4:aa:99    3 [.W..] (  2) 20:97:27:52:6c:ab ( 13) (0xd70f86fe)
 * 3a:ed:be:29:ce:72    3 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x9e2e0cfa)
 * 20:97:27:52:6c:ad   11 [....] (  2) 20:97:27:52:6c:ab ( 13) (0x2f1d4dad)
 * 02:22:f3:35:3e:d3   -1 [....] (  1) f4:4d:5c:fd:9d:ef (  9) (0x6babf43b)
 * 2a:1b:08:b6:0e:40   12 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0x71d21ca1)
 * b6:1d:b2:47:cd:26   12 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0xc531fab3)
 * 2a:1b:08:b6:0e:40   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
 * 33:33:ff:07:5b:66   -1 [....] (  1) d2:3d:f3:fe:f3:62 ( 60) (0x31f39dc9)
 * b6:1d:b2:47:cd:26   11 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x3f68ffb7)
 * e6:b5:a1:87:27:54   -1 [....] (  1) 20:97:27:52:6c:ab ( 13) (0xfaf54e6c)
 * 3a:ed:be:29:ce:72   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
 * 2a:1b:08:b6:0e:40    0 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0x12f49a16)
 * b6:1d:b2:47:cd:26    0 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0xa6177c04)
 * 0a:9f:f2:07:5b:66    0 [....] (  1) d2:3d:f3:fe:f3:62 ( 60) (0xb3e550c5)
 * b6:1d:b2:47:cd:26    3 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x7d53fb6d)
 * 0a:9f:f2:07:5b:66    3 [....] (  1) d2:3d:f3:fe:f3:62 ( 60) (0x68a1d7ac)
 * 16:87:5f:85:10:d4   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
   01:00:5e:00:00:01   -1 [....] (  1) 20:97:27:52:6c:ab ( 13) (0xfaf54e6c)
   01:00:5e:00:00:01   -1 [....] (  1) f4:4d:5c:fd:9d:ef (  9) (0x6babf43b)
   01:00:5e:00:00:01   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
 * 01:00:5e:00:00:01   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
   01:00:5e:00:00:01   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
   01:00:5e:00:00:01   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
   01:00:5e:00:00:01   -1 [....] (  1) d2:3d:f3:fe:f3:62 ( 60) (0x31f39dc9)
 * 02:22:f3:35:3e:d3   12 [....] (  1) f4:4d:5c:fd:9d:ef (  9) (0x0e42d16b)
   33:33:ff:00:00:00   -1 [....] (  1) 20:97:27:52:6c:ab ( 13) (0xfaf54e6c)
   33:33:ff:00:00:00   -1 [....] (  1) f4:4d:5c:fd:9d:ef (  9) (0x6babf43b)
   33:33:ff:00:00:00   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
 * 33:33:ff:00:00:00   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
   33:33:ff:00:00:00   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
   33:33:ff:00:00:00   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
   33:33:ff:00:00:00   -1 [....] (  1) d2:3d:f3:fe:f3:62 ( 60) (0x31f39dc9)
 * 02:22:f3:35:3e:d3    3 [....] (  1) f4:4d:5c:fd:9d:ef (  9) (0xb620d0b5)
 * 33:33:ff:35:3e:d3   -1 [....] (  1) f4:4d:5c:fd:9d:ef (  9) (0x6babf43b)
 * 0a:9f:f2:07:5b:66   12 [....] (  1) d2:3d:f3:fe:f3:62 ( 60) (0xd0c3d672)
 * 3a:ed:be:29:ce:72   12 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x264c0d24)
 * 16:87:5f:85:10:d4   12 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0x9c5d0c2a)
 * 02:22:f3:35:3e:d3   11 [....] (  1) f4:4d:5c:fd:9d:ef (  9) (0xf41bd46f)
 * 0a:9f:f2:07:5b:66   11 [....] (  1) d2:3d:f3:fe:f3:62 ( 60) (0x4e7ef6c6)
 * 3a:ed:be:29:ce:72    0 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x456a8b93)
 * 2a:1b:08:b6:0e:40   11 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0x8b8b19a5)
 * 3a:ed:be:29:ce:72   11 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0xdc150820)
 * 33:33:ff:b6:0e:40   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
 * 33:33:ff:47:cd:26   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
 * 20:97:27:52:6c:ad    3 [....] (  2) 20:97:27:52:6c:ab ( 13) (0xd70f86fe)
 * a6:c5:67:2d:44:a5   11 [.W..] ( 13) 20:97:27:52:6c:ab ( 13) (0x2f1d4dad)
 * 02:22:f3:35:3e:d3    0 [....] (  1) f4:4d:5c:fd:9d:ef (  9) (0x6d6457dc)
 * 06:88:e7:a1:63:64   11 [.W..] ( 60) d2:3d:f3:fe:f3:62 ( 60) (0x4e7ef6c6)
   33:33:00:00:00:01   -1 [....] (  1) 20:97:27:52:6c:ab ( 13) (0xfaf54e6c)
   33:33:00:00:00:01   -1 [....] (  1) f4:4d:5c:fd:9d:ef (  9) (0x6babf43b)
   33:33:00:00:00:01   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
 * 33:33:00:00:00:01   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
   33:33:00:00:00:01   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
   33:33:00:00:00:01   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
   33:33:00:00:00:01   -1 [....] (  1) d2:3d:f3:fe:f3:62 ( 60) (0x31f39dc9)
Batctl translocal
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: phy0-mesh0/d2:3d:f3:fe:f3:53 (batman/ca:4a:dc:99:79:f6 BATMAN_IV), TTVN: 5]
Client             VID Flags    Last seen (CRC       )
33:33:ff:99:79:f6   -1 [.P....]   0.000   (0xc85e1bd6)
33:33:00:00:00:02   -1 [.P....]   0.000   (0xc85e1bd6)
ca:4a:dc:99:79:f6   12 [.P....]   0.000   (0xf16dbd8d)
ca:4a:dc:99:79:f6    0 [.P....]   0.000   (0x924b3b3a)
01:00:5e:00:00:01   -1 [.P....]   0.000   (0xc85e1bd6)
33:33:ff:00:00:00   -1 [.P....]   0.000   (0xc85e1bd6)
ca:4a:dc:99:79:f6   -1 [.P....]   0.000   (0xc85e1bd6)
ca:4a:dc:99:79:f6   11 [.P....]   0.000   (0x0b34b889)
ca:4a:dc:99:79:f6    3 [.P....]   0.000   (0x490fbc53)
33:33:00:00:00:01   -1 [.P....]   0.000   (0xc85e1bd6)

```


### AP Rhoen
```shell
System Information
====================
NAME="OpenWrt"
VERSION="24.10-SNAPSHOT"
ID="openwrt"
ID_LIKE="lede openwrt"
PRETTY_NAME="OpenWrt 24.10-SNAPSHOT"
VERSION_ID="24.10-snapshot"
HOME_URL="https://openwrt.org/"
BUG_URL="https://bugs.openwrt.org/"
SUPPORT_URL="https://forum.openwrt.org/"
BUILD_ID="r0-e6677e14"
OPENWRT_BOARD="ramips/mt7621"
OPENWRT_ARCH="mipsel_24kc"
OPENWRT_TAINTS="no-all"
OPENWRT_DEVICE_MANUFACTURER="OpenWrt"
OPENWRT_DEVICE_MANUFACTURER_URL="https://openwrt.org/"
OPENWRT_DEVICE_PRODUCT="Generic"
OPENWRT_DEVICE_REVISION="v0"
OPENWRT_RELEASE="OpenWrt 24.10-SNAPSHOT r0-e6677e14"
OPENWRT_BUILD_DATE="1750175455"
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣀⣀⣤⣀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣀⣠⣀⣀⡀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣠⣾⣿⣿⣿⣿⣿⣿⣆⠀⢀⣀⣀⣤⣤⣤⣦⣦⣤⣤⣄⣀⣀⠀⢠⣾⣿⣿⣿⣿⣿⣷⣦⡀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣰⣿⣿⣿⣿⣿⣿⣿⣿⡿⠟⠛⠉⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠙⠛⠿⣿⣿⣿⣿⣿⣿⣿⣿⣷⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣿⣿⣿⣿⣿⣿⣿⠟⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠙⢿⣿⣿⣿⣿⣿⣿⡇⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⢻⣿⣿⣿⣿⡟⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠙⣿⣿⣿⣿⣿⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠻⢿⣿⠟⠀⠀⠀⠀⠀⣀⣤⣤⣤⡀⠀⠀⠀⠀⠀⢀⣤⣤⣤⣄⡀⠀⠀⠀⠀⠘⣿⡿⠿⠃⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⢠⡟⠀⠀⠀⠀⣠⣾⣿⣿⣟⣿⡇⠀⠀⠀⠀⠀⢸⣿⣿⣻⣿⣿⣦⠀⠀⠀⠀⠸⣧⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣼⠁⠀⠀⠀⠀⣿⣿⣿⣿⣿⡟⢠⣶⣾⣿⣿⣷⣤⢽⣿⣿⣿⣿⣿⡇⠀⠀⣀⣤⣿⣷⣴⣶⣦⣀⡀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⢀⣠⣤⣤⣠⣇⠀⠀⠀⠀⠀⣿⣿⣿⣿⣿⠀⠘⠻⣿⣿⣿⡿⠋⠀⢹⣿⣿⣿⣿⡇⠀⣿⣿⣿⡏⢹⣿⠉⣿⣿⣿⣷⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⢠⣾⣿⣿⣿⣿⣿⣿⣿⣶⣄⠀⠀⠹⣿⣿⠿⠋⠀⢤⣀⢀⣼⡄⠀⣠⠀⠈⠻⣿⣿⠟⠀⢸⣿⣇⣽⣿⠿⠿⠿⣿⣅⣽⣿⡇⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣆⠀⠀⠀⠀⠀⠀⠀⠀⠈⠉⠁⠉⠉⠀⠀⠀⠀⠀⠀⠀⠀⠈⣿⣿⣟⠁⠀⠀⠀⠈⣿⣿⣿⡇⠀⠀⠀⠀⢀
⠛⠛⠛⠛⠛⠛⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛
⠀⠀⠀⠀⠀⠀⠘⠛⠻⢿⣿⣿⣿⣿⣿⠟⠛⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠀⠈⠉⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀

UB-EDGE - 2025-06-17 - 6a5e2b7
Linux f44d5cfc258c 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips GNU/Linux
Network Configuration
======================
1: lo: <LOOPBACK,UP,LOWER_UP> mtu 65536 state UNKNOWN qlen 1000
    inet6 ::1/128 scope host proto kernel_lo 
       valid_lft forever preferred_lft forever
2: eth0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1540 state UP qlen 1000
    inet6 fe80::f64d:5cff:fefc:258c/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
9: up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::b41d:b2ff:fe47:cd26/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
10: up0v11@up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::b41d:b2ff:fe47:cd26/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
11: up1v12@up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::b41d:b2ff:fe47:cd26/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
12: up2v3@up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fd42:dead:c0de:1337:0:f44d:5cfc:258c/64 scope global 
       valid_lft forever preferred_lft forever
    inet6 fe80::b41d:b2ff:fe47:cd26/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
13: batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UNKNOWN qlen 1000
    inet6 fe80::b41d:b2ff:fe47:cd26/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
14: batman.11@batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::b41d:b2ff:fe47:cd26/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
15: batman.12@batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::b41d:b2ff:fe47:cd26/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
16: batman.3@batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::b41d:b2ff:fe47:cd26/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
18: phy0-mesh0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1532 state UP qlen 1000
    inet6 fe80::f04d:5cff:fefc:258d/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
21: phy1-mesh0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1532 state UP qlen 1000
    inet6 fe80::f04d:5cff:fefc:258e/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
fd42:dead:c0de:1337::/64 dev up2v3 proto static metric 5 pref medium
unreachable fd72:cf7f:2e40::/48 dev lo proto static metric 2147483647 pref medium
fe80::/64 dev eth0 proto kernel metric 256 pref medium
fe80::/64 dev batman proto kernel metric 256 pref medium
fe80::/64 dev batman.11 proto kernel metric 256 pref medium
fe80::/64 dev up proto kernel metric 256 pref medium
fe80::/64 dev up0v11 proto kernel metric 256 pref medium
fe80::/64 dev up1v12 proto kernel metric 256 pref medium
fe80::/64 dev up2v3 proto kernel metric 256 pref medium
fe80::/64 dev batman.12 proto kernel metric 256 pref medium
fe80::/64 dev batman.3 proto kernel metric 256 pref medium
fe80::/64 dev phy0-mesh0 proto kernel metric 256 pref medium
fe80::/64 dev phy1-mesh0 proto kernel metric 256 pref medium
Speed Test Report
==================
Test Started at Wed Jun 18 15:39:53 UTC 2025
Running iperf3 (Upload) test to fd42:dead:c0de:1337::1
iperf 3.17.1
Linux f44d5cfc258c 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips
Control connection MSS 1368
Time: Wed, 18 Jun 2025 15:39:53 UTC
Connecting to host fd42:dead:c0de:1337::1, port 5201
      Cookie: 226xhveubiyycc4lik4zibhkma4gec6yeah4
      TCP MSS: 1368 (default)
[  5] local fd42:dead:c0de:1337:0:f44d:5cfc:258c port 51814 connected to fd42:dead:c0de:1337::1 port 5201
Starting Test: protocol: TCP, 1 streams, 131072 byte blocks, omitting 0 seconds, 10 second test, tos 0
[ ID] Interval           Transfer     Bitrate         Retr  Cwnd
[  5]   0.00-1.00   sec  3.88 MBytes  32.5 Mbits/sec    0    206 KBytes       
[  5]   1.00-2.00   sec  4.38 MBytes  36.7 Mbits/sec    0    315 KBytes       
[  5]   2.00-3.00   sec  3.75 MBytes  31.5 Mbits/sec    0    329 KBytes       
[  5]   3.00-4.00   sec  4.00 MBytes  33.6 Mbits/sec    0    343 KBytes       
[  5]   4.00-5.00   sec  3.62 MBytes  30.4 Mbits/sec    0    343 KBytes       
[  5]   5.00-6.00   sec  3.50 MBytes  29.4 Mbits/sec    0    399 KBytes       
[  5]   6.00-7.00   sec  3.88 MBytes  32.5 Mbits/sec    0    464 KBytes       
[  5]   7.00-8.00   sec  4.25 MBytes  35.7 Mbits/sec    0    464 KBytes       
[  5]   8.00-9.00   sec  3.38 MBytes  28.3 Mbits/sec    0    464 KBytes       
[  5]   9.00-10.00  sec  3.88 MBytes  32.5 Mbits/sec    0    464 KBytes       
- - - - - - - - - - - - - - - - - - - - - - - - -
Test Complete. Summary Results:
[ ID] Interval           Transfer     Bitrate         Retr
[  5]   0.00-10.00  sec  38.5 MBytes  32.3 Mbits/sec    0             sender
[  5]   0.00-10.03  sec  37.6 MBytes  31.5 Mbits/sec                  receiver
CPU Utilization: local/sender 4.4% (0.0%u/4.4%s), remote/receiver 27.9% (1.8%u/26.1%s)
snd_tcp_congestion cubic
rcv_tcp_congestion cubic

iperf Done.
Test Completed at Wed Jun 18 15:40:03 UTC 2025
Test iperf3 (Download) to fd42:dead:c0de:1337::1
iperf 3.17.1
Linux f44d5cfc258c 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips
Control connection MSS 1368
Time: Wed, 18 Jun 2025 15:40:03 UTC
Connecting to host fd42:dead:c0de:1337::1, port 5201
Reverse mode, remote host fd42:dead:c0de:1337::1 is sending
      Cookie: 4rmsatqy3w3kdb25lzqxzv4lqhl7yrlpudrd
      TCP MSS: 1368 (default)
[  5] local fd42:dead:c0de:1337:0:f44d:5cfc:258c port 60768 connected to fd42:dead:c0de:1337::1 port 5201
Starting Test: protocol: TCP, 1 streams, 131072 byte blocks, omitting 0 seconds, 10 second test, tos 0
[ ID] Interval           Transfer     Bitrate
[  5]   0.00-1.00   sec  3.62 MBytes  30.4 Mbits/sec                  
[  5]   1.00-2.00   sec  3.88 MBytes  32.5 Mbits/sec                  
[  5]   2.00-3.00   sec  3.88 MBytes  32.5 Mbits/sec                  
[  5]   3.00-4.00   sec  3.75 MBytes  31.4 Mbits/sec                  
[  5]   4.00-5.00   sec  3.88 MBytes  32.5 Mbits/sec                  
[  5]   5.00-6.00   sec  3.75 MBytes  31.5 Mbits/sec                  
[  5]   6.00-7.00   sec  3.75 MBytes  31.5 Mbits/sec                  
[  5]   7.00-8.00   sec  3.62 MBytes  30.4 Mbits/sec                  
[  5]   8.00-9.00   sec  3.62 MBytes  30.4 Mbits/sec                  
[  5]   9.00-10.00  sec  3.50 MBytes  29.3 Mbits/sec                  
- - - - - - - - - - - - - - - - - - - - - - - - -
Test Complete. Summary Results:
[ ID] Interval           Transfer     Bitrate         Retr
[  5]   0.00-10.00  sec  38.1 MBytes  32.0 Mbits/sec    3             sender
[  5]   0.00-10.00  sec  37.2 MBytes  31.2 Mbits/sec                  receiver
snd_tcp_congestion cubic
rcv_tcp_congestion cubic

iperf Done.
Test Completed at Wed Jun 18 15:40:13 UTC 2025
Test iperf3 (Bidirectional) to fd42:dead:c0de:1337::1
iperf 3.17.1
Linux f44d5cfc258c 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips
Control connection MSS 1368
send_parameters:
{
	"tcp":	true,
	"omit":	0,
	"time":	10,
	"num":	0,
	"blockcount":	0,
	"parallel":	1,
	"len":	131072,
	"pacing_timer":	1000,
	"client_version":	"3.17.1"
}
Time: Wed, 18 Jun 2025 15:40:14 UTC
Connecting to host fd42:dead:c0de:1337::1, port 5201
      Cookie: a2qd65cmqofrsidknhufaxupgqmtihlllmzm
      TCP MSS: 1368 (default)
SNDBUF is 16384, expecting 0
RCVBUF is 131072, expecting 0
Congestion algorithm is cubic
[  5] local fd42:dead:c0de:1337:0:f44d:5cfc:258c port 58512 connected to fd42:dead:c0de:1337::1 port 5201
Starting Test: protocol: TCP, 1 streams, 131072 byte blocks, omitting 0 seconds, 10 second test, tos 0
Thread FD 5 created
All threads created
sent 131072 bytes of 131072, pending 0, total 131072
sent 131072 bytes of 131072, pending 0, total 262144
sent 131072 bytes of 131072, pending 0, total 393216
sent 131072 bytes of 131072, pending 0, total 524288
sent 131072 bytes of 131072, pending 0, total 655360
sent 131072 bytes of 131072, pending 0, total 786432
sent 131072 bytes of 131072, pending 0, total 917504
sent 131072 bytes of 131072, pending 0, total 1048576
sent 131072 bytes of 131072, pending 0, total 1179648
sent 131072 bytes of 131072, pending 0, total 1310720
sent 131072 bytes of 131072, pending 0, total 1441792
sent 131072 bytes of 131072, pending 0, total 1572864
sent 131072 bytes of 131072, pending 0, total 1703936
sent 131072 bytes of 131072, pending 0, total 1835008
sent 131072 bytes of 131072, pending 0, total 1966080
sent 131072 bytes of 131072, pending 0, total 2097152
sent 131072 bytes of 131072, pending 0, total 2228224
sent 131072 bytes of 131072, pending 0, total 2359296
sent 131072 bytes of 131072, pending 0, total 2490368
sent 131072 bytes of 131072, pending 0, total 2621440
sent 131072 bytes of 131072, pending 0, total 2752512
sent 131072 bytes of 131072, pending 0, total 2883584
sent 131072 bytes of 131072, pending 0, total 3014656
sent 131072 bytes of 131072, pending 0, total 3145728
tcpi_snd_cwnd 108 tcpi_snd_mss 1368 tcpi_rtt 38684
interval_len 1.001144 bytes_transferred 3145728
interval forces keep
[ ID] Interval           Transfer     Bitrate         Retr  Cwnd
[  5]   0.00-1.00   sec  3.00 MBytes  25.1 Mbits/sec    0    144 KBytes       
sent 131072 bytes of 131072, pending 0, total 3276800
sent 131072 bytes of 131072, pending 0, total 3407872
sent 131072 bytes of 131072, pending 0, total 3538944
sent 131072 bytes of 131072, pending 0, total 3670016
sent 131072 bytes of 131072, pending 0, total 3801088
sent 131072 bytes of 131072, pending 0, total 3932160
sent 131072 bytes of 131072, pending 0, total 4063232
sent 131072 bytes of 131072, pending 0, total 4194304
sent 131072 bytes of 131072, pending 0, total 4325376
sent 131072 bytes of 131072, pending 0, total 4456448
sent 131072 bytes of 131072, pending 0, total 4587520
sent 131072 bytes of 131072, pending 0, total 4718592
sent 131072 bytes of 131072, pending 0, total 4849664
sent 131072 bytes of 131072, pending 0, total 4980736
sent 131072 bytes of 131072, pending 0, total 5111808
sent 131072 bytes of 131072, pending 0, total 5242880
sent 131072 bytes of 131072, pending 0, total 5373952
sent 131072 bytes of 131072, pending 0, total 5505024
sent 131072 bytes of 131072, pending 0, total 5636096
sent 131072 bytes of 131072, pending 0, total 5767168
sent 131072 bytes of 131072, pending 0, total 5898240
sent 131072 bytes of 131072, pending 0, total 6029312
sent 131072 bytes of 131072, pending 0, total 6160384
sent 131072 bytes of 131072, pending 0, total 6291456
sent 131072 bytes of 131072, pending 0, total 6422528
sent 131072 bytes of 131072, pending 0, total 6553600
sent 131072 bytes of 131072, pending 0, total 6684672
sent 131072 bytes of 131072, pending 0, total 6815744
sent 131072 bytes of 131072, pending 0, total 6946816
sent 131072 bytes of 131072, pending 0, total 7077888
sent 131072 bytes of 131072, pending 0, total 7208960
sent 131072 bytes of 131072, pending 0, total 7340032
sent 131072 bytes of 131072, pending 0, total 7471104
sent 131072 bytes of 131072, pending 0, total 7602176
sent 131072 bytes of 131072, pending 0, total 7733248
sent 131072 bytes of 131072, pending 0, total 7864320
sent 131072 bytes of 131072, pending 0, total 7995392
sent 131072 bytes of 131072, pending 0, total 8126464
sent 131072 bytes of 131072, pending 0, total 8257536
sent 131072 bytes of 131072, pending 0, total 8388608
sent 131072 bytes of 131072, pending 0, total 8519680
tcpi_snd_cwnd 187 tcpi_snd_mss 1368 tcpi_rtt 25860
interval_len 1.000037 bytes_transferred 5373952
interval forces keep
[  5]   1.00-2.00   sec  5.12 MBytes  43.0 Mbits/sec    0    250 KBytes       
sent 131072 bytes of 131072, pending 0, total 8650752
sent 131072 bytes of 131072, pending 0, total 8781824
sent 131072 bytes of 131072, pending 0, total 8912896
sent 131072 bytes of 131072, pending 0, total 9043968
sent 131072 bytes of 131072, pending 0, total 9175040
sent 131072 bytes of 131072, pending 0, total 9306112
sent 131072 bytes of 131072, pending 0, total 9437184
sent 131072 bytes of 131072, pending 0, total 9568256
sent 131072 bytes of 131072, pending 0, total 9699328
sent 131072 bytes of 131072, pending 0, total 9830400
sent 131072 bytes of 131072, pending 0, total 9961472
sent 131072 bytes of 131072, pending 0, total 10092544
sent 131072 bytes of 131072, pending 0, total 10223616
sent 131072 bytes of 131072, pending 0, total 10354688
sent 131072 bytes of 131072, pending 0, total 10485760
sent 131072 bytes of 131072, pending 0, total 10616832
sent 131072 bytes of 131072, pending 0, total 10747904
sent 131072 bytes of 131072, pending 0, total 10878976
sent 131072 bytes of 131072, pending 0, total 11010048
sent 131072 bytes of 131072, pending 0, total 11141120
sent 131072 bytes of 131072, pending 0, total 11272192
sent 131072 bytes of 131072, pending 0, total 11403264
sent 131072 bytes of 131072, pending 0, total 11534336
sent 131072 bytes of 131072, pending 0, total 11665408
sent 131072 bytes of 131072, pending 0, total 11796480
sent 131072 bytes of 131072, pending 0, total 11927552
sent 131072 bytes of 131072, pending 0, total 12058624
sent 131072 bytes of 131072, pending 0, total 12189696
sent 131072 bytes of 131072, pending 0, total 12320768
sent 131072 bytes of 131072, pending 0, total 12451840
sent 131072 bytes of 131072, pending 0, total 12582912
sent 131072 bytes of 131072, pending 0, total 12713984
sent 131072 bytes of 131072, pending 0, total 12845056
sent 131072 bytes of 131072, pending 0, total 12976128
sent 131072 bytes of 131072, pending 0, total 13107200
sent 131072 bytes of 131072, pending 0, total 13238272
sent 131072 bytes of 131072, pending 0, total 13369344
sent 131072 bytes of 131072, pending 0, total 13500416
sent 131072 bytes of 131072, pending 0, total 13631488
sent 131072 bytes of 131072, pending 0, total 13762560
sent 131072 bytes of 131072, pending 0, total 13893632
sent 131072 bytes of 131072, pending 0, total 14024704
sent 131072 bytes of 131072, pending 0, total 14155776
sent 131072 bytes of 131072, pending 0, total 14286848
tcpi_snd_cwnd 221 tcpi_snd_mss 1368 tcpi_rtt 20281
interval_len 1.000053 bytes_transferred 5636096
interval forces keep
[  5]   2.00-3.00   sec  5.38 MBytes  45.1 Mbits/sec    0    295 KBytes       
sent 131072 bytes of 131072, pending 0, total 14417920
sent 131072 bytes of 131072, pending 0, total 14548992
sent 131072 bytes of 131072, pending 0, total 14680064
sent 131072 bytes of 131072, pending 0, total 14811136
sent 131072 bytes of 131072, pending 0, total 14942208
sent 131072 bytes of 131072, pending 0, total 15073280
sent 131072 bytes of 131072, pending 0, total 15204352
sent 131072 bytes of 131072, pending 0, total 15335424
sent 131072 bytes of 131072, pending 0, total 15466496
sent 131072 bytes of 131072, pending 0, total 15597568
sent 131072 bytes of 131072, pending 0, total 15728640
sent 131072 bytes of 131072, pending 0, total 15859712
sent 131072 bytes of 131072, pending 0, total 15990784
sent 131072 bytes of 131072, pending 0, total 16121856
sent 131072 bytes of 131072, pending 0, total 16252928
sent 131072 bytes of 131072, pending 0, total 16384000
sent 131072 bytes of 131072, pending 0, total 16515072
sent 131072 bytes of 131072, pending 0, total 16646144
sent 131072 bytes of 131072, pending 0, total 16777216
sent 131072 bytes of 131072, pending 0, total 16908288
sent 131072 bytes of 131072, pending 0, total 17039360
sent 131072 bytes of 131072, pending 0, total 17170432
sent 131072 bytes of 131072, pending 0, total 17301504
sent 131072 bytes of 131072, pending 0, total 17432576
sent 131072 bytes of 131072, pending 0, total 17563648
sent 131072 bytes of 131072, pending 0, total 17694720
sent 131072 bytes of 131072, pending 0, total 17825792
sent 131072 bytes of 131072, pending 0, total 17956864
sent 131072 bytes of 131072, pending 0, total 18087936
sent 131072 bytes of 131072, pending 0, total 18219008
sent 131072 bytes of 131072, pending 0, total 18350080
sent 131072 bytes of 131072, pending 0, total 18481152
sent 131072 bytes of 131072, pending 0, total 18612224
sent 131072 bytes of 131072, pending 0, total 18743296
sent 131072 bytes of 131072, pending 0, total 18874368
sent 131072 bytes of 131072, pending 0, total 19005440
sent 131072 bytes of 131072, pending 0, total 19136512
sent 131072 bytes of 131072, pending 0, total 19267584
tcpi_snd_cwnd 221 tcpi_snd_mss 1368 tcpi_rtt 31259
interval_len 0.999893 bytes_transferred 4980736
interval forces keep
[  5]   3.00-4.00   sec  4.75 MBytes  39.9 Mbits/sec    0    295 KBytes       
sent 131072 bytes of 131072, pending 0, total 19398656
sent 131072 bytes of 131072, pending 0, total 19529728
sent 131072 bytes of 131072, pending 0, total 19660800
sent 131072 bytes of 131072, pending 0, total 19791872
sent 131072 bytes of 131072, pending 0, total 19922944
sent 131072 bytes of 131072, pending 0, total 20054016
sent 131072 bytes of 131072, pending 0, total 20185088
sent 131072 bytes of 131072, pending 0, total 20316160
sent 131072 bytes of 131072, pending 0, total 20447232
sent 131072 bytes of 131072, pending 0, total 20578304
sent 131072 bytes of 131072, pending 0, total 20709376
sent 131072 bytes of 131072, pending 0, total 20840448
sent 131072 bytes of 131072, pending 0, total 20971520
sent 131072 bytes of 131072, pending 0, total 21102592
sent 131072 bytes of 131072, pending 0, total 21233664
sent 131072 bytes of 131072, pending 0, total 21364736
sent 131072 bytes of 131072, pending 0, total 21495808
sent 131072 bytes of 131072, pending 0, total 21626880
sent 131072 bytes of 131072, pending 0, total 21757952
sent 131072 bytes of 131072, pending 0, total 21889024
sent 131072 bytes of 131072, pending 0, total 22020096
sent 131072 bytes of 131072, pending 0, total 22151168
sent 131072 bytes of 131072, pending 0, total 22282240
sent 131072 bytes of 131072, pending 0, total 22413312
sent 131072 bytes of 131072, pending 0, total 22544384
sent 131072 bytes of 131072, pending 0, total 22675456
sent 131072 bytes of 131072, pending 0, total 22806528
sent 131072 bytes of 131072, pending 0, total 22937600
sent 131072 bytes of 131072, pending 0, total 23068672
sent 131072 bytes of 131072, pending 0, total 23199744
tcpi_snd_cwnd 221 tcpi_snd_mss 1368 tcpi_rtt 41028
interval_len 1.000019 bytes_transferred 3932160
interval forces keep
[  5]   4.00-5.00   sec  3.75 MBytes  31.5 Mbits/sec    0    295 KBytes       
sent 131072 bytes of 131072, pending 0, total 23330816
sent 131072 bytes of 131072, pending 0, total 23461888
sent 131072 bytes of 131072, pending 0, total 23592960
sent 131072 bytes of 131072, pending 0, total 23724032
sent 131072 bytes of 131072, pending 0, total 23855104
sent 131072 bytes of 131072, pending 0, total 23986176
sent 131072 bytes of 131072, pending 0, total 24117248
sent 131072 bytes of 131072, pending 0, total 24248320
sent 131072 bytes of 131072, pending 0, total 24379392
sent 131072 bytes of 131072, pending 0, total 24510464
sent 131072 bytes of 131072, pending 0, total 24641536
sent 131072 bytes of 131072, pending 0, total 24772608
sent 131072 bytes of 131072, pending 0, total 24903680
sent 131072 bytes of 131072, pending 0, total 25034752
sent 131072 bytes of 131072, pending 0, total 25165824
sent 131072 bytes of 131072, pending 0, total 25296896
sent 131072 bytes of 131072, pending 0, total 25427968
sent 131072 bytes of 131072, pending 0, total 25559040
sent 131072 bytes of 131072, pending 0, total 25690112
sent 131072 bytes of 131072, pending 0, total 25821184
sent 131072 bytes of 131072, pending 0, total 25952256
sent 131072 bytes of 131072, pending 0, total 26083328
sent 131072 bytes of 131072, pending 0, total 26214400
sent 131072 bytes of 131072, pending 0, total 26345472
sent 131072 bytes of 131072, pending 0, total 26476544
sent 131072 bytes of 131072, pending 0, total 26607616
sent 131072 bytes of 131072, pending 0, total 26738688
sent 131072 bytes of 131072, pending 0, total 26869760
sent 131072 bytes of 131072, pending 0, total 27000832
tcpi_snd_cwnd 221 tcpi_snd_mss 1368 tcpi_rtt 32404
interval_len 0.999991 bytes_transferred 3801088
interval forces keep
[  5]   5.00-6.00   sec  3.62 MBytes  30.4 Mbits/sec    0    295 KBytes       
sent 131072 bytes of 131072, pending 0, total 27131904
sent 131072 bytes of 131072, pending 0, total 27262976
sent 131072 bytes of 131072, pending 0, total 27394048
sent 131072 bytes of 131072, pending 0, total 27525120
sent 131072 bytes of 131072, pending 0, total 27656192
sent 131072 bytes of 131072, pending 0, total 27787264
sent 131072 bytes of 131072, pending 0, total 27918336
sent 131072 bytes of 131072, pending 0, total 28049408
sent 131072 bytes of 131072, pending 0, total 28180480
sent 131072 bytes of 131072, pending 0, total 28311552
sent 131072 bytes of 131072, pending 0, total 28442624
sent 131072 bytes of 131072, pending 0, total 28573696
sent 131072 bytes of 131072, pending 0, total 28704768
sent 131072 bytes of 131072, pending 0, total 28835840
sent 131072 bytes of 131072, pending 0, total 28966912
sent 131072 bytes of 131072, pending 0, total 29097984
sent 131072 bytes of 131072, pending 0, total 29229056
sent 131072 bytes of 131072, pending 0, total 29360128
sent 131072 bytes of 131072, pending 0, total 29491200
sent 131072 bytes of 131072, pending 0, total 29622272
sent 131072 bytes of 131072, pending 0, total 29753344
sent 131072 bytes of 131072, pending 0, total 29884416
sent 131072 bytes of 131072, pending 0, total 30015488
sent 131072 bytes of 131072, pending 0, total 30146560
sent 131072 bytes of 131072, pending 0, total 30277632
sent 131072 bytes of 131072, pending 0, total 30408704
sent 131072 bytes of 131072, pending 0, total 30539776
tcpi_snd_cwnd 221 tcpi_snd_mss 1368 tcpi_rtt 38475
interval_len 1.000015 bytes_transferred 3538944
interval forces keep
[  5]   6.00-7.00   sec  3.38 MBytes  28.3 Mbits/sec    0    295 KBytes       
sent 131072 bytes of 131072, pending 0, total 30670848
sent 131072 bytes of 131072, pending 0, total 30801920
sent 131072 bytes of 131072, pending 0, total 30932992
sent 131072 bytes of 131072, pending 0, total 31064064
sent 131072 bytes of 131072, pending 0, total 31195136
sent 131072 bytes of 131072, pending 0, total 31326208
sent 131072 bytes of 131072, pending 0, total 31457280
sent 131072 bytes of 131072, pending 0, total 31588352
sent 131072 bytes of 131072, pending 0, total 31719424
sent 131072 bytes of 131072, pending 0, total 31850496
sent 131072 bytes of 131072, pending 0, total 31981568
sent 131072 bytes of 131072, pending 0, total 32112640
sent 131072 bytes of 131072, pending 0, total 32243712
sent 131072 bytes of 131072, pending 0, total 32374784
sent 131072 bytes of 131072, pending 0, total 32505856
sent 131072 bytes of 131072, pending 0, total 32636928
sent 131072 bytes of 131072, pending 0, total 32768000
sent 131072 bytes of 131072, pending 0, total 32899072
sent 131072 bytes of 131072, pending 0, total 33030144
sent 131072 bytes of 131072, pending 0, total 33161216
sent 131072 bytes of 131072, pending 0, total 33292288
sent 131072 bytes of 131072, pending 0, total 33423360
sent 131072 bytes of 131072, pending 0, total 33554432
sent 131072 bytes of 131072, pending 0, total 33685504
sent 131072 bytes of 131072, pending 0, total 33816576
sent 131072 bytes of 131072, pending 0, total 33947648
sent 131072 bytes of 131072, pending 0, total 34078720
sent 131072 bytes of 131072, pending 0, total 34209792
sent 131072 bytes of 131072, pending 0, total 34340864
sent 131072 bytes of 131072, pending 0, total 34471936
sent 131072 bytes of 131072, pending 0, total 34603008
sent 131072 bytes of 131072, pending 0, total 34734080
sent 131072 bytes of 131072, pending 0, total 34865152
sent 131072 bytes of 131072, pending 0, total 34996224
sent 131072 bytes of 131072, pending 0, total 35127296
sent 131072 bytes of 131072, pending 0, total 35258368
sent 131072 bytes of 131072, pending 0, total 35389440
sent 131072 bytes of 131072, pending 0, total 35520512
tcpi_snd_cwnd 221 tcpi_snd_mss 1368 tcpi_rtt 19508
interval_len 1.000033 bytes_transferred 4980736
interval forces keep
[  5]   7.00-8.00   sec  4.75 MBytes  39.8 Mbits/sec    0    295 KBytes       
sent 131072 bytes of 131072, pending 0, total 35651584
sent 131072 bytes of 131072, pending 0, total 35782656
sent 131072 bytes of 131072, pending 0, total 35913728
sent 131072 bytes of 131072, pending 0, total 36044800
sent 131072 bytes of 131072, pending 0, total 36175872
sent 131072 bytes of 131072, pending 0, total 36306944
sent 131072 bytes of 131072, pending 0, total 36438016
sent 131072 bytes of 131072, pending 0, total 36569088
sent 131072 bytes of 131072, pending 0, total 36700160
sent 131072 bytes of 131072, pending 0, total 36831232
sent 131072 bytes of 131072, pending 0, total 36962304
sent 131072 bytes of 131072, pending 0, total 37093376
sent 131072 bytes of 131072, pending 0, total 37224448
sent 131072 bytes of 131072, pending 0, total 37355520
sent 131072 bytes of 131072, pending 0, total 37486592
sent 131072 bytes of 131072, pending 0, total 37617664
sent 131072 bytes of 131072, pending 0, total 37748736
sent 131072 bytes of 131072, pending 0, total 37879808
sent 131072 bytes of 131072, pending 0, total 38010880
sent 131072 bytes of 131072, pending 0, total 38141952
sent 131072 bytes of 131072, pending 0, total 38273024
sent 131072 bytes of 131072, pending 0, total 38404096
sent 131072 bytes of 131072, pending 0, total 38535168
sent 131072 bytes of 131072, pending 0, total 38666240
sent 131072 bytes of 131072, pending 0, total 38797312
sent 131072 bytes of 131072, pending 0, total 38928384
sent 131072 bytes of 131072, pending 0, total 39059456
sent 131072 bytes of 131072, pending 0, total 39190528
sent 131072 bytes of 131072, pending 0, total 39321600
sent 131072 bytes of 131072, pending 0, total 39452672
sent 131072 bytes of 131072, pending 0, total 39583744
sent 131072 bytes of 131072, pending 0, total 39714816
sent 131072 bytes of 131072, pending 0, total 39845888
sent 131072 bytes of 131072, pending 0, total 39976960
sent 131072 bytes of 131072, pending 0, total 40108032
sent 131072 bytes of 131072, pending 0, total 40239104
sent 131072 bytes of 131072, pending 0, total 40370176
sent 131072 bytes of 131072, pending 0, total 40501248
sent 131072 bytes of 131072, pending 0, total 40632320
sent 131072 bytes of 131072, pending 0, total 40763392
sent 131072 bytes of 131072, pending 0, total 40894464
sent 131072 bytes of 131072, pending 0, total 41025536
sent 131072 bytes of 131072, pending 0, total 41156608
tcpi_snd_cwnd 267 tcpi_snd_mss 1368 tcpi_rtt 26878
interval_len 0.999970 bytes_transferred 5636096
interval forces keep
[  5]   8.00-9.00   sec  5.38 MBytes  45.1 Mbits/sec    0    357 KBytes       
sent 131072 bytes of 131072, pending 0, total 41287680
sent 131072 bytes of 131072, pending 0, total 41418752
sent 131072 bytes of 131072, pending 0, total 41549824
sent 131072 bytes of 131072, pending 0, total 41680896
sent 131072 bytes of 131072, pending 0, total 41811968
sent 131072 bytes of 131072, pending 0, total 41943040
sent 131072 bytes of 131072, pending 0, total 42074112
sent 131072 bytes of 131072, pending 0, total 42205184
sent 131072 bytes of 131072, pending 0, total 42336256
sent 131072 bytes of 131072, pending 0, total 42467328
sent 131072 bytes of 131072, pending 0, total 42598400
sent 131072 bytes of 131072, pending 0, total 42729472
sent 131072 bytes of 131072, pending 0, total 42860544
sent 131072 bytes of 131072, pending 0, total 42991616
sent 131072 bytes of 131072, pending 0, total 43122688
sent 131072 bytes of 131072, pending 0, total 43253760
sent 131072 bytes of 131072, pending 0, total 43384832
sent 131072 bytes of 131072, pending 0, total 43515904
sent 131072 bytes of 131072, pending 0, total 43646976
sent 131072 bytes of 131072, pending 0, total 43778048
sent 131072 bytes of 131072, pending 0, total 43909120
sent 131072 bytes of 131072, pending 0, total 44040192
sent 131072 bytes of 131072, pending 0, total 44171264
sent 131072 bytes of 131072, pending 0, total 44302336
sent 131072 bytes of 131072, pending 0, total 44433408
sent 131072 bytes of 131072, pending 0, total 44564480
sent 131072 bytes of 131072, pending 0, total 44695552
sent 131072 bytes of 131072, pending 0, total 44826624
sent 131072 bytes of 131072, pending 0, total 44957696
sent 131072 bytes of 131072, pending 0, total 45088768
sent 131072 bytes of 131072, pending 0, total 45219840
sent 131072 bytes of 131072, pending 0, total 45350912
sent 131072 bytes of 131072, pending 0, total 45481984
sent 131072 bytes of 131072, pending 0, total 45613056
Thread FD 5 stopped
Sender threads stopped
tcpi_snd_cwnd 267 tcpi_snd_mss 1368 tcpi_rtt 27344
send_results
{
	"cpu_util_total":	5.2887937031781922,
	"cpu_util_user":	0.21630075672374222,
	"cpu_util_system":	5.0724431121634339,
	"sender_has_retransmits":	1,
	"congestion_used":	"cubic",
	"streams":	[{
			"id":	1,
			"bytes":	45613056,
			"retransmits":	0,
			"jitter":	0,
			"errors":	0,
			"omitted_errors":	0,
			"packets":	0,
			"omitted_packets":	0,
			"start_time":	0,
			"end_time":	10.001766
		}]
}
get_results
{
	"cpu_util_total":	31.057407879453375,
	"cpu_util_user":	2.0572935016437071,
	"cpu_util_system":	29.00015430025632,
	"sender_has_retransmits":	-1,
	"congestion_used":	"cubic",
	"streams":	[{
			"id":	1,
			"bytes":	44826624,
			"retransmits":	-1,
			"jitter":	0,
			"errors":	0,
			"omitted_errors":	0,
			"packets":	0,
			"omitted_packets":	0,
			"start_time":	0,
			"end_time":	10.019194
		}]
}
interval_len 1.000611 bytes_transferred 4456448
interval forces keep
[  5]   9.00-10.00  sec  4.25 MBytes  35.6 Mbits/sec    0    357 KBytes       
- - - - - - - - - - - - - - - - - - - - - - - - -
Test Complete. Summary Results:
[ ID] Interval           Transfer     Bitrate         Retr
[  5]   0.00-10.00  sec  43.5 MBytes  36.5 Mbits/sec    0             sender
[  5]   0.00-10.02  sec  42.8 MBytes  35.8 Mbits/sec                  receiver
CPU Utilization: local/sender 5.3% (0.2%u/5.1%s), remote/receiver 31.1% (2.1%u/29.0%s)
snd_tcp_congestion cubic
rcv_tcp_congestion cubic
Receiver threads stopped

iperf Done.
Test Completed at Wed Jun 18 15:40:24 UTC 2025
Batman/Batctl Report
====================
Batctl neighbors
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: phy0-mesh0/f2:4d:5c:fc:25:8d (batman/b6:1d:b2:47:cd:26 BATMAN_IV)]
IF             Neighbor              last-seen
   phy0-mesh0	  f2:4d:5c:fd:a2:fd    1.410s
   phy0-mesh0	  f2:4d:5c:fe:51:65    0.900s
   phy0-mesh0	  2a:97:27:52:6c:ad   14.290s
   phy0-mesh0	  f2:4d:5c:fd:9d:f0   10.880s
   phy0-mesh0	  d2:3d:f3:fe:f3:62    4.350s
   phy0-mesh0	  d2:3d:f3:fe:f3:53    0.710s
   phy1-mesh0	  d2:3d:f3:fe:f3:63  132.350s
   phy1-mesh0	  f2:4d:5c:fd:9d:f1   57.370s
   phy1-mesh0	  f2:4d:5c:fd:a2:fe    2.060s
   phy1-mesh0	  f2:4d:5c:fe:51:66    1.220s
   phy1-mesh0	  2a:97:27:52:6c:ae   12.270s
   phy1-mesh0	  d2:3d:f3:fe:f3:54   18.950s
Batctl originators
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: phy0-mesh0/f2:4d:5c:fc:25:8d (batman/b6:1d:b2:47:cd:26 BATMAN_IV)]
   Originator        last-seen (#/255) Nexthop           [outgoingIF]
   f4:4d:5c:fd:9d:ef    1.810s   (  0) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f4:4d:5c:fd:9d:ef    1.810s   (168) 2a:97:27:52:6c:ad [phy0-mesh0]
   f4:4d:5c:fd:9d:ef    1.810s   ( 99) 2a:97:27:52:6c:ae [phy1-mesh0]
   f4:4d:5c:fd:9d:ef    1.810s   (194) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   f4:4d:5c:fd:9d:ef    1.810s   (131) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   f4:4d:5c:fd:9d:ef    1.810s   (170) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f4:4d:5c:fd:9d:ef    1.810s   (118) d2:3d:f3:fe:f3:62 [phy0-mesh0]
   f4:4d:5c:fd:9d:ef    1.810s   (213) f2:4d:5c:fd:a2:fd [phy0-mesh0]
 * f4:4d:5c:fd:9d:ef    1.810s   (225) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   f4:4d:5c:fd:9d:ef    1.810s   (200) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f4:4d:5c:fd:9d:ef    1.810s   (202) f2:4d:5c:fe:51:65 [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    2.390s   (  0) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f4:4d:5c:fd:a2:fc    2.390s   (220) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   f4:4d:5c:fd:a2:fc    2.390s   (  0) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    2.390s   (106) d2:3d:f3:fe:f3:62 [phy0-mesh0]
 * f4:4d:5c:fd:a2:fc    2.390s   (255) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   f4:4d:5c:fd:a2:fc    2.390s   ( 92) 2a:97:27:52:6c:ae [phy1-mesh0]
   f4:4d:5c:fd:a2:fc    2.390s   (242) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    2.390s   (202) f2:4d:5c:fe:51:65 [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    2.390s   (200) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f4:4d:5c:fd:a2:fc    2.390s   (169) 2a:97:27:52:6c:ad [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    2.390s   (116) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   d2:3d:f3:fe:f3:62    3.990s   (  0) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
 * d2:3d:f3:fe:f3:62    3.990s   (198) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   d2:3d:f3:fe:f3:62    3.990s   (187) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   d2:3d:f3:fe:f3:62    3.990s   (176) f2:4d:5c:fe:51:65 [phy0-mesh0]
   d2:3d:f3:fe:f3:62    3.990s   (178) f2:4d:5c:fe:51:66 [phy1-mesh0]
   d2:3d:f3:fe:f3:62    3.990s   (116) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   d2:3d:f3:fe:f3:62    3.990s   (148) 2a:97:27:52:6c:ad [phy0-mesh0]
   d2:3d:f3:fe:f3:62    3.990s   (  0) 2a:97:27:52:6c:ae [phy1-mesh0]
   d2:3d:f3:fe:f3:62    3.990s   (149) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   d2:3d:f3:fe:f3:62    3.990s   (171) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   d2:3d:f3:fe:f3:62    3.990s   (151) d2:3d:f3:fe:f3:62 [phy0-mesh0]
   f2:4d:5c:fe:51:65    0.760s   (124) 2a:97:27:52:6c:ad [phy0-mesh0]
   f2:4d:5c:fe:51:65    0.760s   (171) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f2:4d:5c:fe:51:65    0.760s   ( 72) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   f2:4d:5c:fe:51:65    0.760s   (168) d2:3d:f3:fe:f3:53 [phy0-mesh0]
 * f2:4d:5c:fe:51:65    0.760s   (228) f2:4d:5c:fe:51:65 [phy0-mesh0]
   f2:4d:5c:fd:a2:fe    1.820s   (  0) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f2:4d:5c:fd:a2:fe    1.820s   ( 78) 2a:97:27:52:6c:ae [phy1-mesh0]
   f2:4d:5c:fd:a2:fe    1.820s   (170) f2:4d:5c:fe:51:66 [phy1-mesh0]
 * f2:4d:5c:fd:a2:fe    1.820s   (255) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   f2:4d:5c:fd:a2:fe    1.820s   (176) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   2a:97:27:52:6c:ae    2.060s   (  0) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   2a:97:27:52:6c:ae    2.060s   (  0) f2:4d:5c:fd:a2:fe [phy1-mesh0]
 * 2a:97:27:52:6c:ae    2.060s   (148) f2:4d:5c:fe:51:66 [phy1-mesh0]
   2a:97:27:52:6c:ae    2.060s   (170) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   2a:97:27:52:6c:ae    2.060s   (116) 2a:97:27:52:6c:ae [phy1-mesh0]
   d2:3d:f3:fe:f3:63    1.230s   (  0) d2:3d:f3:fe:f3:63 [phy1-mesh0]
   d2:3d:f3:fe:f3:63    1.230s   (  0) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
 * d2:3d:f3:fe:f3:63    1.230s   (112) f2:4d:5c:fe:51:66 [phy1-mesh0]
   d2:3d:f3:fe:f3:63    1.230s   ( 75) 2a:97:27:52:6c:ae [phy1-mesh0]
   d2:3d:f3:fe:f3:53    0.610s   (  0) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   d2:3d:f3:fe:f3:53    0.610s   (  0) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   d2:3d:f3:fe:f3:53    0.610s   (210) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   d2:3d:f3:fe:f3:53    0.610s   (  0) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   d2:3d:f3:fe:f3:53    0.610s   (  0) f2:4d:5c:fe:51:65 [phy0-mesh0]
   d2:3d:f3:fe:f3:53    0.610s   (189) f2:4d:5c:fe:51:66 [phy1-mesh0]
   d2:3d:f3:fe:f3:53    0.610s   (  0) 2a:97:27:52:6c:ad [phy0-mesh0]
   d2:3d:f3:fe:f3:53    0.610s   (  0) 2a:97:27:52:6c:ae [phy1-mesh0]
   d2:3d:f3:fe:f3:53    0.610s   ( 87) d2:3d:f3:fe:f3:62 [phy0-mesh0]
 * d2:3d:f3:fe:f3:53    0.610s   (255) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   d2:3d:f3:fe:f3:53    0.610s   (227) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   2a:97:27:52:6c:ad    9.140s   (145) f2:4d:5c:fe:51:65 [phy0-mesh0]
   2a:97:27:52:6c:ad    9.140s   (  0) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   2a:97:27:52:6c:ad    9.140s   ( 96) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   2a:97:27:52:6c:ad    9.140s   ( 94) d2:3d:f3:fe:f3:62 [phy0-mesh0]
   2a:97:27:52:6c:ad    9.140s   (139) d2:3d:f3:fe:f3:53 [phy0-mesh0]
 * 2a:97:27:52:6c:ad    9.140s   (191) 2a:97:27:52:6c:ad [phy0-mesh0]
   f2:4d:5c:fd:9d:f1    1.820s   (  0) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
 * f2:4d:5c:fd:9d:f1    1.820s   (173) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   f2:4d:5c:fd:9d:f1    1.820s   (154) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f2:4d:5c:fd:9d:f1    1.820s   ( 88) 2a:97:27:52:6c:ae [phy1-mesh0]
   f2:4d:5c:fd:9d:f1    1.820s   (139) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   f2:4d:5c:fd:a2:fd    1.290s   (115) 2a:97:27:52:6c:ad [phy0-mesh0]
   f2:4d:5c:fd:a2:fd    1.290s   ( 93) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   f2:4d:5c:fd:a2:fd    1.290s   (172) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f2:4d:5c:fd:a2:fd    1.290s   (177) f2:4d:5c:fe:51:65 [phy0-mesh0]
 * f2:4d:5c:fd:a2:fd    1.290s   (242) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f2:4d:5c:fe:51:66    1.110s   (198) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   f2:4d:5c:fe:51:66    1.110s   (189) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   f2:4d:5c:fe:51:66    1.110s   (  0) 2a:97:27:52:6c:ae [phy1-mesh0]
 * f2:4d:5c:fe:51:66    1.110s   (230) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f2:4d:5c:fd:9d:f0    0.690s   (144) 2a:97:27:52:6c:ad [phy0-mesh0]
 * f2:4d:5c:fd:9d:f0    0.690s   (164) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f2:4d:5c:fd:9d:f0    0.690s   (159) f2:4d:5c:fe:51:65 [phy0-mesh0]
   f2:4d:5c:fd:9d:f0    0.690s   (109) d2:3d:f3:fe:f3:62 [phy0-mesh0]
   f2:4d:5c:fd:9d:f0    0.690s   (135) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f2:4d:5c:fd:9d:f0    0.690s   (132) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   20:97:27:52:6c:ab    1.060s   (  0) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
 * 20:97:27:52:6c:ab    1.060s   (225) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   20:97:27:52:6c:ab    1.060s   (213) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   20:97:27:52:6c:ab    1.060s   (202) f2:4d:5c:fe:51:66 [phy1-mesh0]
   20:97:27:52:6c:ab    1.060s   (202) f2:4d:5c:fe:51:65 [phy0-mesh0]
   20:97:27:52:6c:ab    1.060s   (116) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   20:97:27:52:6c:ab    1.060s   (191) 2a:97:27:52:6c:ad [phy0-mesh0]
   20:97:27:52:6c:ab    1.060s   (104) 2a:97:27:52:6c:ae [phy1-mesh0]
   20:97:27:52:6c:ab    1.060s   (117) d2:3d:f3:fe:f3:62 [phy0-mesh0]
   20:97:27:52:6c:ab    1.060s   (170) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   20:97:27:52:6c:ab    1.060s   (194) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   f4:4d:5c:fe:51:64    2.310s   (225) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   f4:4d:5c:fe:51:64    2.310s   (213) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f4:4d:5c:fe:51:64    2.310s   (116) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   f4:4d:5c:fe:51:64    2.310s   (103) d2:3d:f3:fe:f3:62 [phy0-mesh0]
   f4:4d:5c:fe:51:64    2.310s   (227) f2:4d:5c:fe:51:65 [phy0-mesh0]
 * f4:4d:5c:fe:51:64    2.310s   (230) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f4:4d:5c:fe:51:64    2.310s   (167) 2a:97:27:52:6c:ad [phy0-mesh0]
   f4:4d:5c:fe:51:64    2.310s   (  0) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f4:4d:5c:fe:51:64    2.310s   (217) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   f4:4d:5c:fe:51:64    2.310s   (  0) 2a:97:27:52:6c:ae [phy1-mesh0]
   d2:3d:f3:fe:f3:54    8.760s   (  0) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   d2:3d:f3:fe:f3:54    8.760s   (190) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   d2:3d:f3:fe:f3:54    8.760s   (156) f2:4d:5c:fe:51:66 [phy1-mesh0]
   d2:3d:f3:fe:f3:54    8.760s   ( 87) 2a:97:27:52:6c:ae [phy1-mesh0]
 * d2:3d:f3:fe:f3:54    8.760s   (255) d2:3d:f3:fe:f3:54 [phy1-mesh0]
Batctl transglobal
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: phy0-mesh0/f2:4d:5c:fc:25:8d (batman/b6:1d:b2:47:cd:26 BATMAN_IV)]
   Client             VID Flags Last ttvn     Via        ttvn  (CRC       )
 * 33:33:ff:99:79:f6   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
 * e6:b5:a1:87:27:54    0 [....] (  1) 20:97:27:52:6c:ab ( 13) (0x4edbbb86)
 * 16:87:5f:85:10:d4    0 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xff7b8a9d)
 * e6:b5:a1:87:27:54    3 [....] (  1) 20:97:27:52:6c:ab ( 13) (0xd70f86fe)
 * 2a:1b:08:b6:0e:40    3 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xc9b01d7f)
 * 0a:9f:f2:07:5b:66   -1 [....] (  1) d2:3d:f3:fe:f3:62 ( 57) (0x31f39dc9)
 * 33:33:ff:29:ce:72   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
 * 06:3a:b0:85:82:c4   11 [.W..] ( 54) d2:3d:f3:fe:f3:62 ( 57) (0x4e7ef6c6)
 * 16:87:5f:85:10:d4    3 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0x243f0df4)
 * 33:33:ff:85:10:d4   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
 * 20:97:27:52:6c:ad   12 [....] (  2) 20:97:27:52:6c:ab ( 13) (0x5c5d6f23)
 * 16:87:5f:85:10:d4   11 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0x6604092e)
   33:33:00:00:00:02   -1 [....] (  1) 20:97:27:52:6c:ab ( 13) (0xfaf54e6c)
   33:33:00:00:00:02   -1 [....] (  1) f4:4d:5c:fd:9d:ef (  9) (0x6babf43b)
   33:33:00:00:00:02   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
 * 33:33:00:00:00:02   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
   33:33:00:00:00:02   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
   33:33:00:00:00:02   -1 [....] (  1) d2:3d:f3:fe:f3:62 ( 57) (0x31f39dc9)
   33:33:00:00:00:02   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
 * e6:b5:a1:87:27:54   12 [....] (  1) 20:97:27:52:6c:ab ( 13) (0x5c5d6f23)
 * 33:33:ff:87:27:54   -1 [....] (  1) 20:97:27:52:6c:ab ( 13) (0xfaf54e6c)
 * e6:b5:a1:87:27:54   11 [....] (  1) 20:97:27:52:6c:ab ( 13) (0x2f1d4dad)
 * 9a:58:fd:e4:aa:99    3 [.W..] (  2) 20:97:27:52:6c:ab ( 13) (0xd70f86fe)
 * 3a:ed:be:29:ce:72    3 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x9e2e0cfa)
 * 20:97:27:52:6c:ad   11 [....] (  2) 20:97:27:52:6c:ab ( 13) (0x2f1d4dad)
 * 02:22:f3:35:3e:d3   -1 [....] (  1) f4:4d:5c:fd:9d:ef (  9) (0x6babf43b)
 * 2a:1b:08:b6:0e:40   12 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0x71d21ca1)
 * 2a:1b:08:b6:0e:40   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
 * 33:33:ff:07:5b:66   -1 [....] (  1) d2:3d:f3:fe:f3:62 ( 57) (0x31f39dc9)
 * e6:b5:a1:87:27:54   -1 [....] (  1) 20:97:27:52:6c:ab ( 13) (0xfaf54e6c)
 * 3a:ed:be:29:ce:72   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
 * 2a:1b:08:b6:0e:40    0 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0x12f49a16)
 * 0a:9f:f2:07:5b:66    0 [....] (  1) d2:3d:f3:fe:f3:62 ( 57) (0xb3e550c5)
 * 0a:9f:f2:07:5b:66    3 [....] (  1) d2:3d:f3:fe:f3:62 ( 57) (0x68a1d7ac)
 * 16:87:5f:85:10:d4   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
 * ca:4a:dc:99:79:f6   12 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xf16dbd8d)
 * ca:4a:dc:99:79:f6    0 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0x924b3b3a)
   01:00:5e:00:00:01   -1 [....] (  1) 20:97:27:52:6c:ab ( 13) (0xfaf54e6c)
   01:00:5e:00:00:01   -1 [....] (  1) f4:4d:5c:fd:9d:ef (  9) (0x6babf43b)
   01:00:5e:00:00:01   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
 * 01:00:5e:00:00:01   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
   01:00:5e:00:00:01   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
   01:00:5e:00:00:01   -1 [....] (  1) d2:3d:f3:fe:f3:62 ( 57) (0x31f39dc9)
   01:00:5e:00:00:01   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
 * 02:22:f3:35:3e:d3   12 [....] (  1) f4:4d:5c:fd:9d:ef (  9) (0x0e42d16b)
   33:33:ff:00:00:00   -1 [....] (  1) 20:97:27:52:6c:ab ( 13) (0xfaf54e6c)
   33:33:ff:00:00:00   -1 [....] (  1) f4:4d:5c:fd:9d:ef (  9) (0x6babf43b)
   33:33:ff:00:00:00   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
 * 33:33:ff:00:00:00   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
   33:33:ff:00:00:00   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
   33:33:ff:00:00:00   -1 [....] (  1) d2:3d:f3:fe:f3:62 ( 57) (0x31f39dc9)
   33:33:ff:00:00:00   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
 * ca:4a:dc:99:79:f6   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
 * 02:22:f3:35:3e:d3    3 [....] (  1) f4:4d:5c:fd:9d:ef (  9) (0xb620d0b5)
 * 33:33:ff:35:3e:d3   -1 [....] (  1) f4:4d:5c:fd:9d:ef (  9) (0x6babf43b)
 * 0a:9f:f2:07:5b:66   12 [....] (  1) d2:3d:f3:fe:f3:62 ( 57) (0xd0c3d672)
 * 3a:ed:be:29:ce:72   12 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x264c0d24)
 * 16:87:5f:85:10:d4   12 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0x9c5d0c2a)
 * 02:22:f3:35:3e:d3   11 [....] (  1) f4:4d:5c:fd:9d:ef (  9) (0xf41bd46f)
 * 0a:9f:f2:07:5b:66   11 [....] (  1) d2:3d:f3:fe:f3:62 ( 57) (0x4e7ef6c6)
 * 3a:ed:be:29:ce:72    0 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x456a8b93)
 * 2a:1b:08:b6:0e:40   11 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0x8b8b19a5)
 * 3a:ed:be:29:ce:72   11 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0xdc150820)
 * 33:33:ff:b6:0e:40   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
 * 20:97:27:52:6c:ad    3 [....] (  2) 20:97:27:52:6c:ab ( 13) (0xd70f86fe)
 * a6:c5:67:2d:44:a5   11 [.W..] ( 13) 20:97:27:52:6c:ab ( 13) (0x2f1d4dad)
 * ca:4a:dc:99:79:f6   11 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0x0b34b889)
 * 02:22:f3:35:3e:d3    0 [....] (  1) f4:4d:5c:fd:9d:ef (  9) (0x6d6457dc)
 * 06:88:e7:a1:63:64   11 [.W..] ( 57) d2:3d:f3:fe:f3:62 ( 57) (0x4e7ef6c6)
 * ca:4a:dc:99:79:f6    3 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0x490fbc53)
   33:33:00:00:00:01   -1 [....] (  1) 20:97:27:52:6c:ab ( 13) (0xfaf54e6c)
   33:33:00:00:00:01   -1 [....] (  1) f4:4d:5c:fd:9d:ef (  9) (0x6babf43b)
   33:33:00:00:00:01   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
 * 33:33:00:00:00:01   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
   33:33:00:00:00:01   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
   33:33:00:00:00:01   -1 [....] (  1) d2:3d:f3:fe:f3:62 ( 57) (0x31f39dc9)
   33:33:00:00:00:01   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
Batctl translocal
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: phy0-mesh0/f2:4d:5c:fc:25:8d (batman/b6:1d:b2:47:cd:26 BATMAN_IV), TTVN: 1]
Client             VID Flags    Last seen (CRC       )
33:33:00:00:00:02   -1 [.P....]   0.000   (0x0fd67627)
b6:1d:b2:47:cd:26   -1 [.P....]   0.000   (0x0fd67627)
b6:1d:b2:47:cd:26   12 [.P....]   0.000   (0xc531fab3)
b6:1d:b2:47:cd:26   11 [.P....]   0.000   (0x3f68ffb7)
b6:1d:b2:47:cd:26    0 [.P....]   0.000   (0xa6177c04)
b6:1d:b2:47:cd:26    3 [.P....]   0.000   (0x7d53fb6d)
01:00:5e:00:00:01   -1 [.P....]   0.000   (0x0fd67627)
33:33:ff:00:00:00   -1 [.P....]   0.000   (0x0fd67627)
33:33:ff:47:cd:26   -1 [.P....]   0.000   (0x0fd67627)
33:33:00:00:00:01   -1 [.P....]   0.000   (0x0fd67627)

```

### wap12
```shell
System Information
====================
NAME="OpenWrt"
VERSION="24.10-SNAPSHOT"
ID="openwrt"
ID_LIKE="lede openwrt"
PRETTY_NAME="OpenWrt 24.10-SNAPSHOT"
VERSION_ID="24.10-snapshot"
HOME_URL="https://openwrt.org/"
BUG_URL="https://bugs.openwrt.org/"
SUPPORT_URL="https://forum.openwrt.org/"
BUILD_ID="r0-e6677e14"
OPENWRT_BOARD="ramips/mt7621"
OPENWRT_ARCH="mipsel_24kc"
OPENWRT_TAINTS="no-all"
OPENWRT_DEVICE_MANUFACTURER="OpenWrt"
OPENWRT_DEVICE_MANUFACTURER_URL="https://openwrt.org/"
OPENWRT_DEVICE_PRODUCT="Generic"
OPENWRT_DEVICE_REVISION="v0"
OPENWRT_RELEASE="OpenWrt 24.10-SNAPSHOT r0-e6677e14"
OPENWRT_BUILD_DATE="1750175455"
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣀⣀⣤⣀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣀⣠⣀⣀⡀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣠⣾⣿⣿⣿⣿⣿⣿⣆⠀⢀⣀⣀⣤⣤⣤⣦⣦⣤⣤⣄⣀⣀⠀⢠⣾⣿⣿⣿⣿⣿⣷⣦⡀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣰⣿⣿⣿⣿⣿⣿⣿⣿⡿⠟⠛⠉⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠙⠛⠿⣿⣿⣿⣿⣿⣿⣿⣿⣷⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣿⣿⣿⣿⣿⣿⣿⠟⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠙⢿⣿⣿⣿⣿⣿⣿⡇⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⢻⣿⣿⣿⣿⡟⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠙⣿⣿⣿⣿⣿⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠻⢿⣿⠟⠀⠀⠀⠀⠀⣀⣤⣤⣤⡀⠀⠀⠀⠀⠀⢀⣤⣤⣤⣄⡀⠀⠀⠀⠀⠘⣿⡿⠿⠃⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⢠⡟⠀⠀⠀⠀⣠⣾⣿⣿⣟⣿⡇⠀⠀⠀⠀⠀⢸⣿⣿⣻⣿⣿⣦⠀⠀⠀⠀⠸⣧⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣼⠁⠀⠀⠀⠀⣿⣿⣿⣿⣿⡟⢠⣶⣾⣿⣿⣷⣤⢽⣿⣿⣿⣿⣿⡇⠀⠀⣀⣤⣿⣷⣴⣶⣦⣀⡀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⢀⣠⣤⣤⣠⣇⠀⠀⠀⠀⠀⣿⣿⣿⣿⣿⠀⠘⠻⣿⣿⣿⡿⠋⠀⢹⣿⣿⣿⣿⡇⠀⣿⣿⣿⡏⢹⣿⠉⣿⣿⣿⣷⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⢠⣾⣿⣿⣿⣿⣿⣿⣿⣶⣄⠀⠀⠹⣿⣿⠿⠋⠀⢤⣀⢀⣼⡄⠀⣠⠀⠈⠻⣿⣿⠟⠀⢸⣿⣇⣽⣿⠿⠿⠿⣿⣅⣽⣿⡇⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣆⠀⠀⠀⠀⠀⠀⠀⠀⠈⠉⠁⠉⠉⠀⠀⠀⠀⠀⠀⠀⠀⠈⣿⣿⣟⠁⠀⠀⠀⠈⣿⣿⣿⡇⠀⠀⠀⠀⢀
⠛⠛⠛⠛⠛⠛⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛
⠀⠀⠀⠀⠀⠀⠘⠛⠻⢿⣿⣿⣿⣿⣿⠟⠛⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠀⠈⠉⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀

UB-EDGE - 2025-06-17 - 6a5e2b7
Linux f44d5cfda2fc 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips GNU/Linux
Network Configuration
======================
1: lo: <LOOPBACK,UP,LOWER_UP> mtu 65536 state UNKNOWN qlen 1000
    inet6 ::1/128 scope host proto kernel_lo 
       valid_lft forever preferred_lft forever
2: eth0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1540 state UP qlen 1000
    inet6 fe80::f64d:5cff:fefd:a2fc/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
3: lan@eth0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1536 state UP qlen 1000
    inet6 fe80::f64d:5cff:fefd:a2fc/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
9: up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::281b:8ff:feb6:e40/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
10: up0v11@up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::281b:8ff:feb6:e40/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
11: up1v12@up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::281b:8ff:feb6:e40/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
12: up2v3@up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fd42:dead:c0de:1337:0:f44d:5cfd:a2fc/64 scope global 
       valid_lft forever preferred_lft forever
    inet6 fe80::281b:8ff:feb6:e40/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
13: batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UNKNOWN qlen 1000
    inet6 fe80::281b:8ff:feb6:e40/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
14: batman.11@batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::281b:8ff:feb6:e40/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
15: batman.12@batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::281b:8ff:feb6:e40/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
16: batman.3@batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::281b:8ff:feb6:e40/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
18: phy0-mesh0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1532 state UP qlen 1000
    inet6 fe80::f04d:5cff:fefd:a2fd/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
21: phy1-mesh0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1532 state UP qlen 1000
    inet6 fe80::f04d:5cff:fefd:a2fe/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
unreachable fd04:1957:657c::/48 dev lo proto static metric 2147483647 pref medium
fd42:dead:c0de:1337::/64 dev up2v3 proto static metric 5 pref medium
fe80::/64 dev eth0 proto kernel metric 256 pref medium
fe80::/64 dev batman proto kernel metric 256 pref medium
fe80::/64 dev batman.11 proto kernel metric 256 pref medium
fe80::/64 dev up proto kernel metric 256 pref medium
fe80::/64 dev up0v11 proto kernel metric 256 pref medium
fe80::/64 dev up1v12 proto kernel metric 256 pref medium
fe80::/64 dev up2v3 proto kernel metric 256 pref medium
fe80::/64 dev batman.12 proto kernel metric 256 pref medium
fe80::/64 dev batman.3 proto kernel metric 256 pref medium
fe80::/64 dev lan proto kernel metric 256 pref medium
fe80::/64 dev phy0-mesh0 proto kernel metric 256 pref medium
fe80::/64 dev phy1-mesh0 proto kernel metric 256 pref medium
Speed Test Report
==================
Test Started at Wed Jun 18 15:43:17 UTC 2025
Running iperf3 (Upload) test to fd42:dead:c0de:1337::1
iperf 3.17.1
Linux f44d5cfda2fc 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips
Control connection MSS 1368
Time: Wed, 18 Jun 2025 15:43:17 UTC
Connecting to host fd42:dead:c0de:1337::1, port 5201
      Cookie: 7r26as7c3dsxzz2uyffnphp43tiqrwh3bewi
      TCP MSS: 1368 (default)
[  5] local fd42:dead:c0de:1337:0:f44d:5cfd:a2fc port 32930 connected to fd42:dead:c0de:1337::1 port 5201
Starting Test: protocol: TCP, 1 streams, 131072 byte blocks, omitting 0 seconds, 10 second test, tos 0
[ ID] Interval           Transfer     Bitrate         Retr  Cwnd
[  5]   0.00-1.00   sec  17.2 MBytes   145 Mbits/sec    0    848 KBytes       
[  5]   1.00-2.00   sec  17.5 MBytes   147 Mbits/sec    0   1.25 MBytes       
[  5]   2.00-3.00   sec  17.0 MBytes   143 Mbits/sec    0   1.25 MBytes       
[  5]   3.00-4.00   sec  17.4 MBytes   146 Mbits/sec    0   1.25 MBytes       
[  5]   4.00-5.00   sec  15.1 MBytes   127 Mbits/sec    0   1.25 MBytes       
[  5]   5.00-6.00   sec  17.2 MBytes   145 Mbits/sec    0   1.25 MBytes       
[  5]   6.00-7.00   sec  17.0 MBytes   143 Mbits/sec    0   1.25 MBytes       
[  5]   7.00-8.00   sec  16.1 MBytes   135 Mbits/sec    0   1.25 MBytes       
[  5]   8.00-9.00   sec  15.8 MBytes   132 Mbits/sec    0   1.25 MBytes       
[  5]   9.00-10.01  sec  17.8 MBytes   148 Mbits/sec    0   1.25 MBytes       
- - - - - - - - - - - - - - - - - - - - - - - - -
Test Complete. Summary Results:
[ ID] Interval           Transfer     Bitrate         Retr
[  5]   0.00-10.01  sec   172 MBytes   144 Mbits/sec    0             sender
[  5]   0.00-10.06  sec   172 MBytes   143 Mbits/sec                  receiver
CPU Utilization: local/sender 73.7% (0.2%u/73.5%s), remote/receiver 72.6% (3.9%u/68.7%s)
snd_tcp_congestion cubic
rcv_tcp_congestion cubic

iperf Done.
Test Completed at Wed Jun 18 15:43:27 UTC 2025
Test iperf3 (Download) to fd42:dead:c0de:1337::1
iperf 3.17.1
Linux f44d5cfda2fc 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips
Control connection MSS 1368
Time: Wed, 18 Jun 2025 15:43:27 UTC
Connecting to host fd42:dead:c0de:1337::1, port 5201
Reverse mode, remote host fd42:dead:c0de:1337::1 is sending
      Cookie: jujqcuuset6iubmt46t7m4e6wxqqugctitdy
      TCP MSS: 1368 (default)
[  5] local fd42:dead:c0de:1337:0:f44d:5cfd:a2fc port 58126 connected to fd42:dead:c0de:1337::1 port 5201
Starting Test: protocol: TCP, 1 streams, 131072 byte blocks, omitting 0 seconds, 10 second test, tos 0
[ ID] Interval           Transfer     Bitrate
[  5]   0.00-1.00   sec  16.0 MBytes   134 Mbits/sec                  
[  5]   1.00-2.00   sec  17.0 MBytes   143 Mbits/sec                  
[  5]   2.00-3.00   sec  17.0 MBytes   143 Mbits/sec                  
[  5]   3.00-4.00   sec  17.4 MBytes   146 Mbits/sec                  
[  5]   4.00-5.00   sec  17.4 MBytes   146 Mbits/sec                  
[  5]   5.00-6.00   sec  18.4 MBytes   154 Mbits/sec                  
[  5]   6.00-7.00   sec  17.0 MBytes   143 Mbits/sec                  
[  5]   7.00-8.00   sec  16.9 MBytes   142 Mbits/sec                  
[  5]   8.00-9.00   sec  17.5 MBytes   147 Mbits/sec                  
[  5]   9.00-10.00  sec  18.1 MBytes   152 Mbits/sec                  
- - - - - - - - - - - - - - - - - - - - - - - - -
Test Complete. Summary Results:
[ ID] Interval           Transfer     Bitrate         Retr
[  5]   0.00-10.01  sec   174 MBytes   146 Mbits/sec    0             sender
[  5]   0.00-10.00  sec   173 MBytes   145 Mbits/sec                  receiver
snd_tcp_congestion cubic
rcv_tcp_congestion cubic

iperf Done.
Test Completed at Wed Jun 18 15:43:37 UTC 2025
Test iperf3 (Bidirectional) to fd42:dead:c0de:1337::1
iperf 3.17.1
Linux f44d5cfda2fc 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips
Control connection MSS 1368
send_parameters:
{
	"tcp":	true,
	"omit":	0,
	"time":	10,
	"num":	0,
	"blockcount":	0,
	"parallel":	1,
	"len":	131072,
	"pacing_timer":	1000,
	"client_version":	"3.17.1"
}
Time: Wed, 18 Jun 2025 15:43:37 UTC
Connecting to host fd42:dead:c0de:1337::1, port 5201
      Cookie: vpt45t3te2exza2wcqjxoi3keve5sujhhjis
      TCP MSS: 1368 (default)
SNDBUF is 16384, expecting 0
RCVBUF is 131072, expecting 0
Congestion algorithm is cubic
[  5] local fd42:dead:c0de:1337:0:f44d:5cfd:a2fc port 36302 connected to fd42:dead:c0de:1337::1 port 5201
Starting Test: protocol: TCP, 1 streams, 131072 byte blocks, omitting 0 seconds, 10 second test, tos 0
Thread FD 5 created
All threads created
sent 131072 bytes of 131072, pending 0, total 131072
sent 131072 bytes of 131072, pending 0, total 262144
sent 131072 bytes of 131072, pending 0, total 393216
sent 131072 bytes of 131072, pending 0, total 524288
sent 131072 bytes of 131072, pending 0, total 655360
sent 131072 bytes of 131072, pending 0, total 786432
sent 131072 bytes of 131072, pending 0, total 917504
sent 131072 bytes of 131072, pending 0, total 1048576
sent 131072 bytes of 131072, pending 0, total 1179648
sent 131072 bytes of 131072, pending 0, total 1310720
sent 131072 bytes of 131072, pending 0, total 1441792
sent 131072 bytes of 131072, pending 0, total 1572864
sent 131072 bytes of 131072, pending 0, total 1703936
sent 131072 bytes of 131072, pending 0, total 1835008
sent 131072 bytes of 131072, pending 0, total 1966080
sent 131072 bytes of 131072, pending 0, total 2097152
sent 131072 bytes of 131072, pending 0, total 2228224
sent 131072 bytes of 131072, pending 0, total 2359296
sent 131072 bytes of 131072, pending 0, total 2490368
sent 131072 bytes of 131072, pending 0, total 2621440
sent 131072 bytes of 131072, pending 0, total 2752512
sent 131072 bytes of 131072, pending 0, total 2883584
sent 131072 bytes of 131072, pending 0, total 3014656
sent 131072 bytes of 131072, pending 0, total 3145728
sent 131072 bytes of 131072, pending 0, total 3276800
sent 131072 bytes of 131072, pending 0, total 3407872
sent 131072 bytes of 131072, pending 0, total 3538944
sent 131072 bytes of 131072, pending 0, total 3670016
sent 131072 bytes of 131072, pending 0, total 3801088
sent 131072 bytes of 131072, pending 0, total 3932160
sent 131072 bytes of 131072, pending 0, total 4063232
sent 131072 bytes of 131072, pending 0, total 4194304
sent 131072 bytes of 131072, pending 0, total 4325376
sent 131072 bytes of 131072, pending 0, total 4456448
sent 131072 bytes of 131072, pending 0, total 4587520
sent 131072 bytes of 131072, pending 0, total 4718592
sent 131072 bytes of 131072, pending 0, total 4849664
sent 131072 bytes of 131072, pending 0, total 4980736
sent 131072 bytes of 131072, pending 0, total 5111808
sent 131072 bytes of 131072, pending 0, total 5242880
sent 131072 bytes of 131072, pending 0, total 5373952
sent 131072 bytes of 131072, pending 0, total 5505024
sent 131072 bytes of 131072, pending 0, total 5636096
sent 131072 bytes of 131072, pending 0, total 5767168
sent 131072 bytes of 131072, pending 0, total 5898240
sent 131072 bytes of 131072, pending 0, total 6029312
sent 131072 bytes of 131072, pending 0, total 6160384
sent 131072 bytes of 131072, pending 0, total 6291456
sent 131072 bytes of 131072, pending 0, total 6422528
sent 131072 bytes of 131072, pending 0, total 6553600
sent 131072 bytes of 131072, pending 0, total 6684672
sent 131072 bytes of 131072, pending 0, total 6815744
sent 131072 bytes of 131072, pending 0, total 6946816
sent 131072 bytes of 131072, pending 0, total 7077888
sent 131072 bytes of 131072, pending 0, total 7208960
sent 131072 bytes of 131072, pending 0, total 7340032
sent 131072 bytes of 131072, pending 0, total 7471104
sent 131072 bytes of 131072, pending 0, total 7602176
sent 131072 bytes of 131072, pending 0, total 7733248
sent 131072 bytes of 131072, pending 0, total 7864320
sent 131072 bytes of 131072, pending 0, total 7995392
sent 131072 bytes of 131072, pending 0, total 8126464
sent 131072 bytes of 131072, pending 0, total 8257536
sent 131072 bytes of 131072, pending 0, total 8388608
sent 131072 bytes of 131072, pending 0, total 8519680
sent 131072 bytes of 131072, pending 0, total 8650752
sent 131072 bytes of 131072, pending 0, total 8781824
sent 131072 bytes of 131072, pending 0, total 8912896
sent 131072 bytes of 131072, pending 0, total 9043968
sent 131072 bytes of 131072, pending 0, total 9175040
sent 131072 bytes of 131072, pending 0, total 9306112
sent 131072 bytes of 131072, pending 0, total 9437184
sent 131072 bytes of 131072, pending 0, total 9568256
sent 131072 bytes of 131072, pending 0, total 9699328
sent 131072 bytes of 131072, pending 0, total 9830400
sent 131072 bytes of 131072, pending 0, total 9961472
sent 131072 bytes of 131072, pending 0, total 10092544
sent 131072 bytes of 131072, pending 0, total 10223616
sent 131072 bytes of 131072, pending 0, total 10354688
sent 131072 bytes of 131072, pending 0, total 10485760
sent 131072 bytes of 131072, pending 0, total 10616832
sent 131072 bytes of 131072, pending 0, total 10747904
sent 131072 bytes of 131072, pending 0, total 10878976
sent 131072 bytes of 131072, pending 0, total 11010048
sent 131072 bytes of 131072, pending 0, total 11141120
sent 131072 bytes of 131072, pending 0, total 11272192
sent 131072 bytes of 131072, pending 0, total 11403264
sent 131072 bytes of 131072, pending 0, total 11534336
sent 131072 bytes of 131072, pending 0, total 11665408
sent 131072 bytes of 131072, pending 0, total 11796480
sent 131072 bytes of 131072, pending 0, total 11927552
sent 131072 bytes of 131072, pending 0, total 12058624
sent 131072 bytes of 131072, pending 0, total 12189696
sent 131072 bytes of 131072, pending 0, total 12320768
sent 131072 bytes of 131072, pending 0, total 12451840
sent 131072 bytes of 131072, pending 0, total 12582912
sent 131072 bytes of 131072, pending 0, total 12713984
sent 131072 bytes of 131072, pending 0, total 12845056
sent 131072 bytes of 131072, pending 0, total 12976128
sent 131072 bytes of 131072, pending 0, total 13107200
sent 131072 bytes of 131072, pending 0, total 13238272
sent 131072 bytes of 131072, pending 0, total 13369344
sent 131072 bytes of 131072, pending 0, total 13500416
sent 131072 bytes of 131072, pending 0, total 13631488
sent 131072 bytes of 131072, pending 0, total 13762560
sent 131072 bytes of 131072, pending 0, total 13893632
sent 131072 bytes of 131072, pending 0, total 14024704
sent 131072 bytes of 131072, pending 0, total 14155776
sent 131072 bytes of 131072, pending 0, total 14286848
sent 131072 bytes of 131072, pending 0, total 14417920
sent 131072 bytes of 131072, pending 0, total 14548992
sent 131072 bytes of 131072, pending 0, total 14680064
sent 131072 bytes of 131072, pending 0, total 14811136
sent 131072 bytes of 131072, pending 0, total 14942208
sent 131072 bytes of 131072, pending 0, total 15073280
sent 131072 bytes of 131072, pending 0, total 15204352
sent 131072 bytes of 131072, pending 0, total 15335424
sent 131072 bytes of 131072, pending 0, total 15466496
sent 131072 bytes of 131072, pending 0, total 15597568
sent 131072 bytes of 131072, pending 0, total 15728640
sent 131072 bytes of 131072, pending 0, total 15859712
sent 131072 bytes of 131072, pending 0, total 15990784
sent 131072 bytes of 131072, pending 0, total 16121856
sent 131072 bytes of 131072, pending 0, total 16252928
sent 131072 bytes of 131072, pending 0, total 16384000
sent 131072 bytes of 131072, pending 0, total 16515072
sent 131072 bytes of 131072, pending 0, total 16646144
sent 131072 bytes of 131072, pending 0, total 16777216
sent 131072 bytes of 131072, pending 0, total 16908288
sent 131072 bytes of 131072, pending 0, total 17039360
sent 131072 bytes of 131072, pending 0, total 17170432
sent 131072 bytes of 131072, pending 0, total 17301504
sent 131072 bytes of 131072, pending 0, total 17432576
sent 131072 bytes of 131072, pending 0, total 17563648
tcpi_snd_cwnd 576 tcpi_snd_mss 1368 tcpi_rtt 28052
interval_len 1.001679 bytes_transferred 17432576
interval forces keep
[ ID] Interval           Transfer     Bitrate         Retr  Cwnd
[  5]   0.00-1.00   sec  16.6 MBytes   139 Mbits/sec    0    770 KBytes       
sent 131072 bytes of 131072, pending 0, total 17694720
sent 131072 bytes of 131072, pending 0, total 17825792
sent 131072 bytes of 131072, pending 0, total 17956864
sent 131072 bytes of 131072, pending 0, total 18087936
sent 131072 bytes of 131072, pending 0, total 18219008
sent 131072 bytes of 131072, pending 0, total 18350080
sent 131072 bytes of 131072, pending 0, total 18481152
sent 131072 bytes of 131072, pending 0, total 18612224
sent 131072 bytes of 131072, pending 0, total 18743296
sent 131072 bytes of 131072, pending 0, total 18874368
sent 131072 bytes of 131072, pending 0, total 19005440
sent 131072 bytes of 131072, pending 0, total 19136512
sent 131072 bytes of 131072, pending 0, total 19267584
sent 131072 bytes of 131072, pending 0, total 19398656
sent 131072 bytes of 131072, pending 0, total 19529728
sent 131072 bytes of 131072, pending 0, total 19660800
sent 131072 bytes of 131072, pending 0, total 19791872
sent 131072 bytes of 131072, pending 0, total 19922944
sent 131072 bytes of 131072, pending 0, total 20054016
sent 131072 bytes of 131072, pending 0, total 20185088
sent 131072 bytes of 131072, pending 0, total 20316160
sent 131072 bytes of 131072, pending 0, total 20447232
sent 131072 bytes of 131072, pending 0, total 20578304
sent 131072 bytes of 131072, pending 0, total 20709376
sent 131072 bytes of 131072, pending 0, total 20840448
sent 131072 bytes of 131072, pending 0, total 20971520
sent 131072 bytes of 131072, pending 0, total 21102592
sent 131072 bytes of 131072, pending 0, total 21233664
sent 131072 bytes of 131072, pending 0, total 21364736
sent 131072 bytes of 131072, pending 0, total 21495808
sent 131072 bytes of 131072, pending 0, total 21626880
sent 131072 bytes of 131072, pending 0, total 21757952
sent 131072 bytes of 131072, pending 0, total 21889024
sent 131072 bytes of 131072, pending 0, total 22020096
sent 131072 bytes of 131072, pending 0, total 22151168
sent 131072 bytes of 131072, pending 0, total 22282240
sent 131072 bytes of 131072, pending 0, total 22413312
sent 131072 bytes of 131072, pending 0, total 22544384
sent 131072 bytes of 131072, pending 0, total 22675456
sent 131072 bytes of 131072, pending 0, total 22806528
sent 131072 bytes of 131072, pending 0, total 22937600
sent 131072 bytes of 131072, pending 0, total 23068672
sent 131072 bytes of 131072, pending 0, total 23199744
sent 131072 bytes of 131072, pending 0, total 23330816
sent 131072 bytes of 131072, pending 0, total 23461888
sent 131072 bytes of 131072, pending 0, total 23592960
sent 131072 bytes of 131072, pending 0, total 23724032
sent 131072 bytes of 131072, pending 0, total 23855104
sent 131072 bytes of 131072, pending 0, total 23986176
sent 131072 bytes of 131072, pending 0, total 24117248
sent 131072 bytes of 131072, pending 0, total 24248320
sent 131072 bytes of 131072, pending 0, total 24379392
sent 131072 bytes of 131072, pending 0, total 24510464
sent 131072 bytes of 131072, pending 0, total 24641536
sent 131072 bytes of 131072, pending 0, total 24772608
sent 131072 bytes of 131072, pending 0, total 24903680
sent 131072 bytes of 131072, pending 0, total 25034752
sent 131072 bytes of 131072, pending 0, total 25165824
sent 131072 bytes of 131072, pending 0, total 25296896
sent 131072 bytes of 131072, pending 0, total 25427968
sent 131072 bytes of 131072, pending 0, total 25559040
sent 131072 bytes of 131072, pending 0, total 25690112
sent 131072 bytes of 131072, pending 0, total 25821184
sent 131072 bytes of 131072, pending 0, total 25952256
sent 131072 bytes of 131072, pending 0, total 26083328
sent 131072 bytes of 131072, pending 0, total 26214400
sent 131072 bytes of 131072, pending 0, total 26345472
sent 131072 bytes of 131072, pending 0, total 26476544
sent 131072 bytes of 131072, pending 0, total 26607616
sent 131072 bytes of 131072, pending 0, total 26738688
sent 131072 bytes of 131072, pending 0, total 26869760
sent 131072 bytes of 131072, pending 0, total 27000832
sent 131072 bytes of 131072, pending 0, total 27131904
sent 131072 bytes of 131072, pending 0, total 27262976
sent 131072 bytes of 131072, pending 0, total 27394048
sent 131072 bytes of 131072, pending 0, total 27525120
sent 131072 bytes of 131072, pending 0, total 27656192
sent 131072 bytes of 131072, pending 0, total 27787264
sent 131072 bytes of 131072, pending 0, total 27918336
sent 131072 bytes of 131072, pending 0, total 28049408
sent 131072 bytes of 131072, pending 0, total 28180480
sent 131072 bytes of 131072, pending 0, total 28311552
sent 131072 bytes of 131072, pending 0, total 28442624
sent 131072 bytes of 131072, pending 0, total 28573696
sent 131072 bytes of 131072, pending 0, total 28704768
sent 131072 bytes of 131072, pending 0, total 28835840
sent 131072 bytes of 131072, pending 0, total 28966912
sent 131072 bytes of 131072, pending 0, total 29097984
sent 131072 bytes of 131072, pending 0, total 29229056
sent 131072 bytes of 131072, pending 0, total 29360128
sent 131072 bytes of 131072, pending 0, total 29491200
sent 131072 bytes of 131072, pending 0, total 29622272
sent 131072 bytes of 131072, pending 0, total 29753344
sent 131072 bytes of 131072, pending 0, total 29884416
sent 131072 bytes of 131072, pending 0, total 30015488
sent 131072 bytes of 131072, pending 0, total 30146560
sent 131072 bytes of 131072, pending 0, total 30277632
sent 131072 bytes of 131072, pending 0, total 30408704
sent 131072 bytes of 131072, pending 0, total 30539776
sent 131072 bytes of 131072, pending 0, total 30670848
sent 131072 bytes of 131072, pending 0, total 30801920
sent 131072 bytes of 131072, pending 0, total 30932992
sent 131072 bytes of 131072, pending 0, total 31064064
sent 131072 bytes of 131072, pending 0, total 31195136
sent 131072 bytes of 131072, pending 0, total 31326208
sent 131072 bytes of 131072, pending 0, total 31457280
sent 131072 bytes of 131072, pending 0, total 31588352
sent 131072 bytes of 131072, pending 0, total 31719424
sent 131072 bytes of 131072, pending 0, total 31850496
sent 131072 bytes of 131072, pending 0, total 31981568
sent 131072 bytes of 131072, pending 0, total 32112640
sent 131072 bytes of 131072, pending 0, total 32243712
sent 131072 bytes of 131072, pending 0, total 32374784
sent 131072 bytes of 131072, pending 0, total 32505856
sent 131072 bytes of 131072, pending 0, total 32636928
sent 131072 bytes of 131072, pending 0, total 32768000
sent 131072 bytes of 131072, pending 0, total 32899072
sent 131072 bytes of 131072, pending 0, total 33030144
sent 131072 bytes of 131072, pending 0, total 33161216
sent 131072 bytes of 131072, pending 0, total 33292288
sent 131072 bytes of 131072, pending 0, total 33423360
sent 131072 bytes of 131072, pending 0, total 33554432
sent 131072 bytes of 131072, pending 0, total 33685504
sent 131072 bytes of 131072, pending 0, total 33816576
sent 131072 bytes of 131072, pending 0, total 33947648
sent 131072 bytes of 131072, pending 0, total 34078720
sent 131072 bytes of 131072, pending 0, total 34209792
sent 131072 bytes of 131072, pending 0, total 34340864
sent 131072 bytes of 131072, pending 0, total 34471936
sent 131072 bytes of 131072, pending 0, total 34603008
sent 131072 bytes of 131072, pending 0, total 34734080
sent 131072 bytes of 131072, pending 0, total 34865152
sent 131072 bytes of 131072, pending 0, total 34996224
sent 131072 bytes of 131072, pending 0, total 35127296
sent 131072 bytes of 131072, pending 0, total 35258368
sent 131072 bytes of 131072, pending 0, total 35389440
sent 131072 bytes of 131072, pending 0, total 35520512
sent 131072 bytes of 131072, pending 0, total 35651584
sent 131072 bytes of 131072, pending 0, total 35782656
sent 131072 bytes of 131072, pending 0, total 35913728
sent 131072 bytes of 131072, pending 0, total 36044800
tcpi_snd_cwnd 958 tcpi_snd_mss 1368 tcpi_rtt 74273
interval_len 0.999486 bytes_transferred 18481152
interval forces keep
[  5]   1.00-2.00   sec  17.6 MBytes   148 Mbits/sec    0   1.25 MBytes       
sent 131072 bytes of 131072, pending 0, total 36175872
sent 131072 bytes of 131072, pending 0, total 36306944
sent 131072 bytes of 131072, pending 0, total 36438016
sent 131072 bytes of 131072, pending 0, total 36569088
sent 131072 bytes of 131072, pending 0, total 36700160
sent 131072 bytes of 131072, pending 0, total 36831232
sent 131072 bytes of 131072, pending 0, total 36962304
sent 131072 bytes of 131072, pending 0, total 37093376
sent 131072 bytes of 131072, pending 0, total 37224448
sent 131072 bytes of 131072, pending 0, total 37355520
sent 131072 bytes of 131072, pending 0, total 37486592
sent 131072 bytes of 131072, pending 0, total 37617664
sent 131072 bytes of 131072, pending 0, total 37748736
sent 131072 bytes of 131072, pending 0, total 37879808
sent 131072 bytes of 131072, pending 0, total 38010880
sent 131072 bytes of 131072, pending 0, total 38141952
sent 131072 bytes of 131072, pending 0, total 38273024
sent 131072 bytes of 131072, pending 0, total 38404096
sent 131072 bytes of 131072, pending 0, total 38535168
sent 131072 bytes of 131072, pending 0, total 38666240
sent 131072 bytes of 131072, pending 0, total 38797312
sent 131072 bytes of 131072, pending 0, total 38928384
sent 131072 bytes of 131072, pending 0, total 39059456
sent 131072 bytes of 131072, pending 0, total 39190528
sent 131072 bytes of 131072, pending 0, total 39321600
sent 131072 bytes of 131072, pending 0, total 39452672
sent 131072 bytes of 131072, pending 0, total 39583744
sent 131072 bytes of 131072, pending 0, total 39714816
sent 131072 bytes of 131072, pending 0, total 39845888
sent 131072 bytes of 131072, pending 0, total 39976960
sent 131072 bytes of 131072, pending 0, total 40108032
sent 131072 bytes of 131072, pending 0, total 40239104
sent 131072 bytes of 131072, pending 0, total 40370176
sent 131072 bytes of 131072, pending 0, total 40501248
sent 131072 bytes of 131072, pending 0, total 40632320
sent 131072 bytes of 131072, pending 0, total 40763392
sent 131072 bytes of 131072, pending 0, total 40894464
sent 131072 bytes of 131072, pending 0, total 41025536
sent 131072 bytes of 131072, pending 0, total 41156608
sent 131072 bytes of 131072, pending 0, total 41287680
sent 131072 bytes of 131072, pending 0, total 41418752
sent 131072 bytes of 131072, pending 0, total 41549824
sent 131072 bytes of 131072, pending 0, total 41680896
sent 131072 bytes of 131072, pending 0, total 41811968
sent 131072 bytes of 131072, pending 0, total 41943040
sent 131072 bytes of 131072, pending 0, total 42074112
sent 131072 bytes of 131072, pending 0, total 42205184
sent 131072 bytes of 131072, pending 0, total 42336256
sent 131072 bytes of 131072, pending 0, total 42467328
sent 131072 bytes of 131072, pending 0, total 42598400
sent 131072 bytes of 131072, pending 0, total 42729472
sent 131072 bytes of 131072, pending 0, total 42860544
sent 131072 bytes of 131072, pending 0, total 42991616
sent 131072 bytes of 131072, pending 0, total 43122688
sent 131072 bytes of 131072, pending 0, total 43253760
sent 131072 bytes of 131072, pending 0, total 43384832
sent 131072 bytes of 131072, pending 0, total 43515904
sent 131072 bytes of 131072, pending 0, total 43646976
sent 131072 bytes of 131072, pending 0, total 43778048
sent 131072 bytes of 131072, pending 0, total 43909120
sent 131072 bytes of 131072, pending 0, total 44040192
sent 131072 bytes of 131072, pending 0, total 44171264
sent 131072 bytes of 131072, pending 0, total 44302336
sent 131072 bytes of 131072, pending 0, total 44433408
sent 131072 bytes of 131072, pending 0, total 44564480
sent 131072 bytes of 131072, pending 0, total 44695552
sent 131072 bytes of 131072, pending 0, total 44826624
sent 131072 bytes of 131072, pending 0, total 44957696
sent 131072 bytes of 131072, pending 0, total 45088768
sent 131072 bytes of 131072, pending 0, total 45219840
sent 131072 bytes of 131072, pending 0, total 45350912
sent 131072 bytes of 131072, pending 0, total 45481984
sent 131072 bytes of 131072, pending 0, total 45613056
sent 131072 bytes of 131072, pending 0, total 45744128
sent 131072 bytes of 131072, pending 0, total 45875200
sent 131072 bytes of 131072, pending 0, total 46006272
sent 131072 bytes of 131072, pending 0, total 46137344
sent 131072 bytes of 131072, pending 0, total 46268416
sent 131072 bytes of 131072, pending 0, total 46399488
sent 131072 bytes of 131072, pending 0, total 46530560
sent 131072 bytes of 131072, pending 0, total 46661632
sent 131072 bytes of 131072, pending 0, total 46792704
sent 131072 bytes of 131072, pending 0, total 46923776
sent 131072 bytes of 131072, pending 0, total 47054848
sent 131072 bytes of 131072, pending 0, total 47185920
sent 131072 bytes of 131072, pending 0, total 47316992
sent 131072 bytes of 131072, pending 0, total 47448064
sent 131072 bytes of 131072, pending 0, total 47579136
sent 131072 bytes of 131072, pending 0, total 47710208
sent 131072 bytes of 131072, pending 0, total 47841280
sent 131072 bytes of 131072, pending 0, total 47972352
sent 131072 bytes of 131072, pending 0, total 48103424
sent 131072 bytes of 131072, pending 0, total 48234496
sent 131072 bytes of 131072, pending 0, total 48365568
sent 131072 bytes of 131072, pending 0, total 48496640
sent 131072 bytes of 131072, pending 0, total 48627712
sent 131072 bytes of 131072, pending 0, total 48758784
sent 131072 bytes of 131072, pending 0, total 48889856
sent 131072 bytes of 131072, pending 0, total 49020928
sent 131072 bytes of 131072, pending 0, total 49152000
sent 131072 bytes of 131072, pending 0, total 49283072
sent 131072 bytes of 131072, pending 0, total 49414144
sent 131072 bytes of 131072, pending 0, total 49545216
sent 131072 bytes of 131072, pending 0, total 49676288
sent 131072 bytes of 131072, pending 0, total 49807360
sent 131072 bytes of 131072, pending 0, total 49938432
sent 131072 bytes of 131072, pending 0, total 50069504
sent 131072 bytes of 131072, pending 0, total 50200576
sent 131072 bytes of 131072, pending 0, total 50331648
sent 131072 bytes of 131072, pending 0, total 50462720
sent 131072 bytes of 131072, pending 0, total 50593792
sent 131072 bytes of 131072, pending 0, total 50724864
sent 131072 bytes of 131072, pending 0, total 50855936
sent 131072 bytes of 131072, pending 0, total 50987008
sent 131072 bytes of 131072, pending 0, total 51118080
sent 131072 bytes of 131072, pending 0, total 51249152
sent 131072 bytes of 131072, pending 0, total 51380224
sent 131072 bytes of 131072, pending 0, total 51511296
sent 131072 bytes of 131072, pending 0, total 51642368
sent 131072 bytes of 131072, pending 0, total 51773440
sent 131072 bytes of 131072, pending 0, total 51904512
sent 131072 bytes of 131072, pending 0, total 52035584
sent 131072 bytes of 131072, pending 0, total 52166656
sent 131072 bytes of 131072, pending 0, total 52297728
sent 131072 bytes of 131072, pending 0, total 52428800
sent 131072 bytes of 131072, pending 0, total 52559872
sent 131072 bytes of 131072, pending 0, total 52690944
sent 131072 bytes of 131072, pending 0, total 52822016
sent 131072 bytes of 131072, pending 0, total 52953088
sent 131072 bytes of 131072, pending 0, total 53084160
sent 131072 bytes of 131072, pending 0, total 53215232
sent 131072 bytes of 131072, pending 0, total 53346304
sent 131072 bytes of 131072, pending 0, total 53477376
sent 131072 bytes of 131072, pending 0, total 53608448
tcpi_snd_cwnd 958 tcpi_snd_mss 1368 tcpi_rtt 72056
interval_len 1.000000 bytes_transferred 17432576
interval forces keep
[  5]   2.00-3.00   sec  16.6 MBytes   139 Mbits/sec    0   1.25 MBytes       
sent 131072 bytes of 131072, pending 0, total 53739520
sent 131072 bytes of 131072, pending 0, total 53870592
sent 131072 bytes of 131072, pending 0, total 54001664
sent 131072 bytes of 131072, pending 0, total 54132736
sent 131072 bytes of 131072, pending 0, total 54263808
sent 131072 bytes of 131072, pending 0, total 54394880
sent 131072 bytes of 131072, pending 0, total 54525952
sent 131072 bytes of 131072, pending 0, total 54657024
sent 131072 bytes of 131072, pending 0, total 54788096
sent 131072 bytes of 131072, pending 0, total 54919168
sent 131072 bytes of 131072, pending 0, total 55050240
sent 131072 bytes of 131072, pending 0, total 55181312
sent 131072 bytes of 131072, pending 0, total 55312384
sent 131072 bytes of 131072, pending 0, total 55443456
sent 131072 bytes of 131072, pending 0, total 55574528
sent 131072 bytes of 131072, pending 0, total 55705600
sent 131072 bytes of 131072, pending 0, total 55836672
sent 131072 bytes of 131072, pending 0, total 55967744
sent 131072 bytes of 131072, pending 0, total 56098816
sent 131072 bytes of 131072, pending 0, total 56229888
sent 131072 bytes of 131072, pending 0, total 56360960
sent 131072 bytes of 131072, pending 0, total 56492032
sent 131072 bytes of 131072, pending 0, total 56623104
sent 131072 bytes of 131072, pending 0, total 56754176
sent 131072 bytes of 131072, pending 0, total 56885248
sent 131072 bytes of 131072, pending 0, total 57016320
sent 131072 bytes of 131072, pending 0, total 57147392
sent 131072 bytes of 131072, pending 0, total 57278464
sent 131072 bytes of 131072, pending 0, total 57409536
sent 131072 bytes of 131072, pending 0, total 57540608
sent 131072 bytes of 131072, pending 0, total 57671680
sent 131072 bytes of 131072, pending 0, total 57802752
sent 131072 bytes of 131072, pending 0, total 57933824
sent 131072 bytes of 131072, pending 0, total 58064896
sent 131072 bytes of 131072, pending 0, total 58195968
sent 131072 bytes of 131072, pending 0, total 58327040
sent 131072 bytes of 131072, pending 0, total 58458112
sent 131072 bytes of 131072, pending 0, total 58589184
sent 131072 bytes of 131072, pending 0, total 58720256
sent 131072 bytes of 131072, pending 0, total 58851328
sent 131072 bytes of 131072, pending 0, total 58982400
sent 131072 bytes of 131072, pending 0, total 59113472
sent 131072 bytes of 131072, pending 0, total 59244544
sent 131072 bytes of 131072, pending 0, total 59375616
sent 131072 bytes of 131072, pending 0, total 59506688
sent 131072 bytes of 131072, pending 0, total 59637760
sent 131072 bytes of 131072, pending 0, total 59768832
sent 131072 bytes of 131072, pending 0, total 59899904
sent 131072 bytes of 131072, pending 0, total 60030976
sent 131072 bytes of 131072, pending 0, total 60162048
sent 131072 bytes of 131072, pending 0, total 60293120
sent 131072 bytes of 131072, pending 0, total 60424192
sent 131072 bytes of 131072, pending 0, total 60555264
sent 131072 bytes of 131072, pending 0, total 60686336
sent 131072 bytes of 131072, pending 0, total 60817408
sent 131072 bytes of 131072, pending 0, total 60948480
sent 131072 bytes of 131072, pending 0, total 61079552
sent 131072 bytes of 131072, pending 0, total 61210624
sent 131072 bytes of 131072, pending 0, total 61341696
sent 131072 bytes of 131072, pending 0, total 61472768
sent 131072 bytes of 131072, pending 0, total 61603840
sent 131072 bytes of 131072, pending 0, total 61734912
sent 131072 bytes of 131072, pending 0, total 61865984
sent 131072 bytes of 131072, pending 0, total 61997056
sent 131072 bytes of 131072, pending 0, total 62128128
sent 131072 bytes of 131072, pending 0, total 62259200
sent 131072 bytes of 131072, pending 0, total 62390272
sent 131072 bytes of 131072, pending 0, total 62521344
sent 131072 bytes of 131072, pending 0, total 62652416
sent 131072 bytes of 131072, pending 0, total 62783488
sent 131072 bytes of 131072, pending 0, total 62914560
sent 131072 bytes of 131072, pending 0, total 63045632
sent 131072 bytes of 131072, pending 0, total 63176704
sent 131072 bytes of 131072, pending 0, total 63307776
sent 131072 bytes of 131072, pending 0, total 63438848
sent 131072 bytes of 131072, pending 0, total 63569920
sent 131072 bytes of 131072, pending 0, total 63700992
sent 131072 bytes of 131072, pending 0, total 63832064
sent 131072 bytes of 131072, pending 0, total 63963136
sent 131072 bytes of 131072, pending 0, total 64094208
sent 131072 bytes of 131072, pending 0, total 64225280
sent 131072 bytes of 131072, pending 0, total 64356352
sent 131072 bytes of 131072, pending 0, total 64487424
sent 131072 bytes of 131072, pending 0, total 64618496
sent 131072 bytes of 131072, pending 0, total 64749568
sent 131072 bytes of 131072, pending 0, total 64880640
sent 131072 bytes of 131072, pending 0, total 65011712
sent 131072 bytes of 131072, pending 0, total 65142784
sent 131072 bytes of 131072, pending 0, total 65273856
sent 131072 bytes of 131072, pending 0, total 65404928
sent 131072 bytes of 131072, pending 0, total 65536000
sent 131072 bytes of 131072, pending 0, total 65667072
sent 131072 bytes of 131072, pending 0, total 65798144
sent 131072 bytes of 131072, pending 0, total 65929216
sent 131072 bytes of 131072, pending 0, total 66060288
sent 131072 bytes of 131072, pending 0, total 66191360
sent 131072 bytes of 131072, pending 0, total 66322432
sent 131072 bytes of 131072, pending 0, total 66453504
sent 131072 bytes of 131072, pending 0, total 66584576
sent 131072 bytes of 131072, pending 0, total 66715648
sent 131072 bytes of 131072, pending 0, total 66846720
sent 131072 bytes of 131072, pending 0, total 66977792
sent 131072 bytes of 131072, pending 0, total 67108864
sent 131072 bytes of 131072, pending 0, total 67239936
sent 131072 bytes of 131072, pending 0, total 67371008
sent 131072 bytes of 131072, pending 0, total 67502080
sent 131072 bytes of 131072, pending 0, total 67633152
sent 131072 bytes of 131072, pending 0, total 67764224
sent 131072 bytes of 131072, pending 0, total 67895296
sent 131072 bytes of 131072, pending 0, total 68026368
sent 131072 bytes of 131072, pending 0, total 68157440
sent 131072 bytes of 131072, pending 0, total 68288512
sent 131072 bytes of 131072, pending 0, total 68419584
sent 131072 bytes of 131072, pending 0, total 68550656
sent 131072 bytes of 131072, pending 0, total 68681728
sent 131072 bytes of 131072, pending 0, total 68812800
sent 131072 bytes of 131072, pending 0, total 68943872
sent 131072 bytes of 131072, pending 0, total 69074944
sent 131072 bytes of 131072, pending 0, total 69206016
sent 131072 bytes of 131072, pending 0, total 69337088
sent 131072 bytes of 131072, pending 0, total 69468160
sent 131072 bytes of 131072, pending 0, total 69599232
sent 131072 bytes of 131072, pending 0, total 69730304
sent 131072 bytes of 131072, pending 0, total 69861376
sent 131072 bytes of 131072, pending 0, total 69992448
sent 131072 bytes of 131072, pending 0, total 70123520
sent 131072 bytes of 131072, pending 0, total 70254592
sent 131072 bytes of 131072, pending 0, total 70385664
sent 131072 bytes of 131072, pending 0, total 70516736
sent 131072 bytes of 131072, pending 0, total 70647808
sent 131072 bytes of 131072, pending 0, total 70778880
sent 131072 bytes of 131072, pending 0, total 70909952
sent 131072 bytes of 131072, pending 0, total 71041024
sent 131072 bytes of 131072, pending 0, total 71172096
tcpi_snd_cwnd 958 tcpi_snd_mss 1368 tcpi_rtt 65266
interval_len 1.000032 bytes_transferred 17432576
interval forces keep
[  5]   3.00-4.00   sec  16.6 MBytes   139 Mbits/sec    0   1.25 MBytes       
sent 131072 bytes of 131072, pending 0, total 71303168
sent 131072 bytes of 131072, pending 0, total 71434240
sent 131072 bytes of 131072, pending 0, total 71565312
sent 131072 bytes of 131072, pending 0, total 71696384
sent 131072 bytes of 131072, pending 0, total 71827456
sent 131072 bytes of 131072, pending 0, total 71958528
sent 131072 bytes of 131072, pending 0, total 72089600
sent 131072 bytes of 131072, pending 0, total 72220672
sent 131072 bytes of 131072, pending 0, total 72351744
sent 131072 bytes of 131072, pending 0, total 72482816
sent 131072 bytes of 131072, pending 0, total 72613888
sent 131072 bytes of 131072, pending 0, total 72744960
sent 131072 bytes of 131072, pending 0, total 72876032
sent 131072 bytes of 131072, pending 0, total 73007104
sent 131072 bytes of 131072, pending 0, total 73138176
sent 131072 bytes of 131072, pending 0, total 73269248
sent 131072 bytes of 131072, pending 0, total 73400320
sent 131072 bytes of 131072, pending 0, total 73531392
sent 131072 bytes of 131072, pending 0, total 73662464
sent 131072 bytes of 131072, pending 0, total 73793536
sent 131072 bytes of 131072, pending 0, total 73924608
sent 131072 bytes of 131072, pending 0, total 74055680
sent 131072 bytes of 131072, pending 0, total 74186752
sent 131072 bytes of 131072, pending 0, total 74317824
sent 131072 bytes of 131072, pending 0, total 74448896
sent 131072 bytes of 131072, pending 0, total 74579968
sent 131072 bytes of 131072, pending 0, total 74711040
sent 131072 bytes of 131072, pending 0, total 74842112
sent 131072 bytes of 131072, pending 0, total 74973184
sent 131072 bytes of 131072, pending 0, total 75104256
sent 131072 bytes of 131072, pending 0, total 75235328
sent 131072 bytes of 131072, pending 0, total 75366400
sent 131072 bytes of 131072, pending 0, total 75497472
sent 131072 bytes of 131072, pending 0, total 75628544
sent 131072 bytes of 131072, pending 0, total 75759616
sent 131072 bytes of 131072, pending 0, total 75890688
sent 131072 bytes of 131072, pending 0, total 76021760
sent 131072 bytes of 131072, pending 0, total 76152832
sent 131072 bytes of 131072, pending 0, total 76283904
sent 131072 bytes of 131072, pending 0, total 76414976
sent 131072 bytes of 131072, pending 0, total 76546048
sent 131072 bytes of 131072, pending 0, total 76677120
sent 131072 bytes of 131072, pending 0, total 76808192
sent 131072 bytes of 131072, pending 0, total 76939264
sent 131072 bytes of 131072, pending 0, total 77070336
sent 131072 bytes of 131072, pending 0, total 77201408
sent 131072 bytes of 131072, pending 0, total 77332480
sent 131072 bytes of 131072, pending 0, total 77463552
sent 131072 bytes of 131072, pending 0, total 77594624
sent 131072 bytes of 131072, pending 0, total 77725696
sent 131072 bytes of 131072, pending 0, total 77856768
sent 131072 bytes of 131072, pending 0, total 77987840
sent 131072 bytes of 131072, pending 0, total 78118912
sent 131072 bytes of 131072, pending 0, total 78249984
sent 131072 bytes of 131072, pending 0, total 78381056
sent 131072 bytes of 131072, pending 0, total 78512128
sent 131072 bytes of 131072, pending 0, total 78643200
sent 131072 bytes of 131072, pending 0, total 78774272
sent 131072 bytes of 131072, pending 0, total 78905344
sent 131072 bytes of 131072, pending 0, total 79036416
sent 131072 bytes of 131072, pending 0, total 79167488
sent 131072 bytes of 131072, pending 0, total 79298560
sent 131072 bytes of 131072, pending 0, total 79429632
sent 131072 bytes of 131072, pending 0, total 79560704
sent 131072 bytes of 131072, pending 0, total 79691776
sent 131072 bytes of 131072, pending 0, total 79822848
sent 131072 bytes of 131072, pending 0, total 79953920
sent 131072 bytes of 131072, pending 0, total 80084992
sent 131072 bytes of 131072, pending 0, total 80216064
sent 131072 bytes of 131072, pending 0, total 80347136
sent 131072 bytes of 131072, pending 0, total 80478208
sent 131072 bytes of 131072, pending 0, total 80609280
sent 131072 bytes of 131072, pending 0, total 80740352
sent 131072 bytes of 131072, pending 0, total 80871424
sent 131072 bytes of 131072, pending 0, total 81002496
sent 131072 bytes of 131072, pending 0, total 81133568
sent 131072 bytes of 131072, pending 0, total 81264640
sent 131072 bytes of 131072, pending 0, total 81395712
sent 131072 bytes of 131072, pending 0, total 81526784
sent 131072 bytes of 131072, pending 0, total 81657856
sent 131072 bytes of 131072, pending 0, total 81788928
sent 131072 bytes of 131072, pending 0, total 81920000
sent 131072 bytes of 131072, pending 0, total 82051072
sent 131072 bytes of 131072, pending 0, total 82182144
sent 131072 bytes of 131072, pending 0, total 82313216
sent 131072 bytes of 131072, pending 0, total 82444288
sent 131072 bytes of 131072, pending 0, total 82575360
sent 131072 bytes of 131072, pending 0, total 82706432
sent 131072 bytes of 131072, pending 0, total 82837504
sent 131072 bytes of 131072, pending 0, total 82968576
sent 131072 bytes of 131072, pending 0, total 83099648
sent 131072 bytes of 131072, pending 0, total 83230720
sent 131072 bytes of 131072, pending 0, total 83361792
sent 131072 bytes of 131072, pending 0, total 83492864
sent 131072 bytes of 131072, pending 0, total 83623936
sent 131072 bytes of 131072, pending 0, total 83755008
sent 131072 bytes of 131072, pending 0, total 83886080
sent 131072 bytes of 131072, pending 0, total 84017152
sent 131072 bytes of 131072, pending 0, total 84148224
sent 131072 bytes of 131072, pending 0, total 84279296
sent 131072 bytes of 131072, pending 0, total 84410368
sent 131072 bytes of 131072, pending 0, total 84541440
sent 131072 bytes of 131072, pending 0, total 84672512
sent 131072 bytes of 131072, pending 0, total 84803584
sent 131072 bytes of 131072, pending 0, total 84934656
sent 131072 bytes of 131072, pending 0, total 85065728
sent 131072 bytes of 131072, pending 0, total 85196800
sent 131072 bytes of 131072, pending 0, total 85327872
sent 131072 bytes of 131072, pending 0, total 85458944
sent 131072 bytes of 131072, pending 0, total 85590016
sent 131072 bytes of 131072, pending 0, total 85721088
sent 131072 bytes of 131072, pending 0, total 85852160
sent 131072 bytes of 131072, pending 0, total 85983232
sent 131072 bytes of 131072, pending 0, total 86114304
sent 131072 bytes of 131072, pending 0, total 86245376
sent 131072 bytes of 131072, pending 0, total 86376448
sent 131072 bytes of 131072, pending 0, total 86507520
sent 131072 bytes of 131072, pending 0, total 86638592
sent 131072 bytes of 131072, pending 0, total 86769664
sent 131072 bytes of 131072, pending 0, total 86900736
sent 131072 bytes of 131072, pending 0, total 87031808
tcpi_snd_cwnd 958 tcpi_snd_mss 1368 tcpi_rtt 70890
interval_len 0.999994 bytes_transferred 15728640
interval forces keep
[  5]   4.00-5.00   sec  15.0 MBytes   126 Mbits/sec    0   1.25 MBytes       
sent 131072 bytes of 131072, pending 0, total 87162880
sent 131072 bytes of 131072, pending 0, total 87293952
sent 131072 bytes of 131072, pending 0, total 87425024
sent 131072 bytes of 131072, pending 0, total 87556096
sent 131072 bytes of 131072, pending 0, total 87687168
sent 131072 bytes of 131072, pending 0, total 87818240
sent 131072 bytes of 131072, pending 0, total 87949312
sent 131072 bytes of 131072, pending 0, total 88080384
sent 131072 bytes of 131072, pending 0, total 88211456
sent 131072 bytes of 131072, pending 0, total 88342528
sent 131072 bytes of 131072, pending 0, total 88473600
sent 131072 bytes of 131072, pending 0, total 88604672
sent 131072 bytes of 131072, pending 0, total 88735744
sent 131072 bytes of 131072, pending 0, total 88866816
sent 131072 bytes of 131072, pending 0, total 88997888
sent 131072 bytes of 131072, pending 0, total 89128960
sent 131072 bytes of 131072, pending 0, total 89260032
sent 131072 bytes of 131072, pending 0, total 89391104
sent 131072 bytes of 131072, pending 0, total 89522176
sent 131072 bytes of 131072, pending 0, total 89653248
sent 131072 bytes of 131072, pending 0, total 89784320
sent 131072 bytes of 131072, pending 0, total 89915392
sent 131072 bytes of 131072, pending 0, total 90046464
sent 131072 bytes of 131072, pending 0, total 90177536
sent 131072 bytes of 131072, pending 0, total 90308608
sent 131072 bytes of 131072, pending 0, total 90439680
sent 131072 bytes of 131072, pending 0, total 90570752
sent 131072 bytes of 131072, pending 0, total 90701824
sent 131072 bytes of 131072, pending 0, total 90832896
sent 131072 bytes of 131072, pending 0, total 90963968
sent 131072 bytes of 131072, pending 0, total 91095040
sent 131072 bytes of 131072, pending 0, total 91226112
sent 131072 bytes of 131072, pending 0, total 91357184
sent 131072 bytes of 131072, pending 0, total 91488256
sent 131072 bytes of 131072, pending 0, total 91619328
sent 131072 bytes of 131072, pending 0, total 91750400
sent 131072 bytes of 131072, pending 0, total 91881472
sent 131072 bytes of 131072, pending 0, total 92012544
sent 131072 bytes of 131072, pending 0, total 92143616
sent 131072 bytes of 131072, pending 0, total 92274688
sent 131072 bytes of 131072, pending 0, total 92405760
sent 131072 bytes of 131072, pending 0, total 92536832
sent 131072 bytes of 131072, pending 0, total 92667904
sent 131072 bytes of 131072, pending 0, total 92798976
sent 131072 bytes of 131072, pending 0, total 92930048
sent 131072 bytes of 131072, pending 0, total 93061120
sent 131072 bytes of 131072, pending 0, total 93192192
sent 131072 bytes of 131072, pending 0, total 93323264
sent 131072 bytes of 131072, pending 0, total 93454336
sent 131072 bytes of 131072, pending 0, total 93585408
sent 131072 bytes of 131072, pending 0, total 93716480
sent 131072 bytes of 131072, pending 0, total 93847552
sent 131072 bytes of 131072, pending 0, total 93978624
sent 131072 bytes of 131072, pending 0, total 94109696
sent 131072 bytes of 131072, pending 0, total 94240768
sent 131072 bytes of 131072, pending 0, total 94371840
sent 131072 bytes of 131072, pending 0, total 94502912
sent 131072 bytes of 131072, pending 0, total 94633984
sent 131072 bytes of 131072, pending 0, total 94765056
sent 131072 bytes of 131072, pending 0, total 94896128
sent 131072 bytes of 131072, pending 0, total 95027200
sent 131072 bytes of 131072, pending 0, total 95158272
sent 131072 bytes of 131072, pending 0, total 95289344
sent 131072 bytes of 131072, pending 0, total 95420416
sent 131072 bytes of 131072, pending 0, total 95551488
sent 131072 bytes of 131072, pending 0, total 95682560
sent 131072 bytes of 131072, pending 0, total 95813632
sent 131072 bytes of 131072, pending 0, total 95944704
sent 131072 bytes of 131072, pending 0, total 96075776
sent 131072 bytes of 131072, pending 0, total 96206848
sent 131072 bytes of 131072, pending 0, total 96337920
sent 131072 bytes of 131072, pending 0, total 96468992
sent 131072 bytes of 131072, pending 0, total 96600064
sent 131072 bytes of 131072, pending 0, total 96731136
sent 131072 bytes of 131072, pending 0, total 96862208
sent 131072 bytes of 131072, pending 0, total 96993280
sent 131072 bytes of 131072, pending 0, total 97124352
sent 131072 bytes of 131072, pending 0, total 97255424
sent 131072 bytes of 131072, pending 0, total 97386496
sent 131072 bytes of 131072, pending 0, total 97517568
sent 131072 bytes of 131072, pending 0, total 97648640
sent 131072 bytes of 131072, pending 0, total 97779712
sent 131072 bytes of 131072, pending 0, total 97910784
sent 131072 bytes of 131072, pending 0, total 98041856
sent 131072 bytes of 131072, pending 0, total 98172928
sent 131072 bytes of 131072, pending 0, total 98304000
sent 131072 bytes of 131072, pending 0, total 98435072
sent 131072 bytes of 131072, pending 0, total 98566144
sent 131072 bytes of 131072, pending 0, total 98697216
sent 131072 bytes of 131072, pending 0, total 98828288
sent 131072 bytes of 131072, pending 0, total 98959360
sent 131072 bytes of 131072, pending 0, total 99090432
sent 131072 bytes of 131072, pending 0, total 99221504
sent 131072 bytes of 131072, pending 0, total 99352576
sent 131072 bytes of 131072, pending 0, total 99483648
sent 131072 bytes of 131072, pending 0, total 99614720
sent 131072 bytes of 131072, pending 0, total 99745792
sent 131072 bytes of 131072, pending 0, total 99876864
sent 131072 bytes of 131072, pending 0, total 100007936
sent 131072 bytes of 131072, pending 0, total 100139008
sent 131072 bytes of 131072, pending 0, total 100270080
sent 131072 bytes of 131072, pending 0, total 100401152
sent 131072 bytes of 131072, pending 0, total 100532224
sent 131072 bytes of 131072, pending 0, total 100663296
sent 131072 bytes of 131072, pending 0, total 100794368
sent 131072 bytes of 131072, pending 0, total 100925440
sent 131072 bytes of 131072, pending 0, total 101056512
sent 131072 bytes of 131072, pending 0, total 101187584
sent 131072 bytes of 131072, pending 0, total 101318656
sent 131072 bytes of 131072, pending 0, total 101449728
sent 131072 bytes of 131072, pending 0, total 101580800
sent 131072 bytes of 131072, pending 0, total 101711872
sent 131072 bytes of 131072, pending 0, total 101842944
sent 131072 bytes of 131072, pending 0, total 101974016
sent 131072 bytes of 131072, pending 0, total 102105088
sent 131072 bytes of 131072, pending 0, total 102236160
sent 131072 bytes of 131072, pending 0, total 102367232
sent 131072 bytes of 131072, pending 0, total 102498304
sent 131072 bytes of 131072, pending 0, total 102629376
sent 131072 bytes of 131072, pending 0, total 102760448
sent 131072 bytes of 131072, pending 0, total 102891520
sent 131072 bytes of 131072, pending 0, total 103022592
sent 131072 bytes of 131072, pending 0, total 103153664
sent 131072 bytes of 131072, pending 0, total 103284736
sent 131072 bytes of 131072, pending 0, total 103415808
sent 131072 bytes of 131072, pending 0, total 103546880
sent 131072 bytes of 131072, pending 0, total 103677952
sent 131072 bytes of 131072, pending 0, total 103809024
sent 131072 bytes of 131072, pending 0, total 103940096
sent 131072 bytes of 131072, pending 0, total 104071168
sent 131072 bytes of 131072, pending 0, total 104202240
sent 131072 bytes of 131072, pending 0, total 104333312
sent 131072 bytes of 131072, pending 0, total 104464384
sent 131072 bytes of 131072, pending 0, total 104595456
sent 131072 bytes of 131072, pending 0, total 104726528
sent 131072 bytes of 131072, pending 0, total 104857600
sent 131072 bytes of 131072, pending 0, total 104988672
sent 131072 bytes of 131072, pending 0, total 105119744
tcpi_snd_cwnd 958 tcpi_snd_mss 1368 tcpi_rtt 70759
interval_len 0.999992 bytes_transferred 18087936
interval forces keep
[  5]   5.00-6.00   sec  17.2 MBytes   145 Mbits/sec    0   1.25 MBytes       
sent 131072 bytes of 131072, pending 0, total 105250816
sent 131072 bytes of 131072, pending 0, total 105381888
sent 131072 bytes of 131072, pending 0, total 105512960
sent 131072 bytes of 131072, pending 0, total 105644032
sent 131072 bytes of 131072, pending 0, total 105775104
sent 131072 bytes of 131072, pending 0, total 105906176
sent 131072 bytes of 131072, pending 0, total 106037248
sent 131072 bytes of 131072, pending 0, total 106168320
sent 131072 bytes of 131072, pending 0, total 106299392
sent 131072 bytes of 131072, pending 0, total 106430464
sent 131072 bytes of 131072, pending 0, total 106561536
sent 131072 bytes of 131072, pending 0, total 106692608
sent 131072 bytes of 131072, pending 0, total 106823680
sent 131072 bytes of 131072, pending 0, total 106954752
sent 131072 bytes of 131072, pending 0, total 107085824
sent 131072 bytes of 131072, pending 0, total 107216896
sent 131072 bytes of 131072, pending 0, total 107347968
sent 131072 bytes of 131072, pending 0, total 107479040
sent 131072 bytes of 131072, pending 0, total 107610112
sent 131072 bytes of 131072, pending 0, total 107741184
sent 131072 bytes of 131072, pending 0, total 107872256
sent 131072 bytes of 131072, pending 0, total 108003328
sent 131072 bytes of 131072, pending 0, total 108134400
sent 131072 bytes of 131072, pending 0, total 108265472
sent 131072 bytes of 131072, pending 0, total 108396544
sent 131072 bytes of 131072, pending 0, total 108527616
sent 131072 bytes of 131072, pending 0, total 108658688
sent 131072 bytes of 131072, pending 0, total 108789760
sent 131072 bytes of 131072, pending 0, total 108920832
sent 131072 bytes of 131072, pending 0, total 109051904
sent 131072 bytes of 131072, pending 0, total 109182976
sent 131072 bytes of 131072, pending 0, total 109314048
sent 131072 bytes of 131072, pending 0, total 109445120
sent 131072 bytes of 131072, pending 0, total 109576192
sent 131072 bytes of 131072, pending 0, total 109707264
sent 131072 bytes of 131072, pending 0, total 109838336
sent 131072 bytes of 131072, pending 0, total 109969408
sent 131072 bytes of 131072, pending 0, total 110100480
sent 131072 bytes of 131072, pending 0, total 110231552
sent 131072 bytes of 131072, pending 0, total 110362624
sent 131072 bytes of 131072, pending 0, total 110493696
sent 131072 bytes of 131072, pending 0, total 110624768
sent 131072 bytes of 131072, pending 0, total 110755840
sent 131072 bytes of 131072, pending 0, total 110886912
sent 131072 bytes of 131072, pending 0, total 111017984
sent 131072 bytes of 131072, pending 0, total 111149056
sent 131072 bytes of 131072, pending 0, total 111280128
sent 131072 bytes of 131072, pending 0, total 111411200
sent 131072 bytes of 131072, pending 0, total 111542272
sent 131072 bytes of 131072, pending 0, total 111673344
sent 131072 bytes of 131072, pending 0, total 111804416
sent 131072 bytes of 131072, pending 0, total 111935488
sent 131072 bytes of 131072, pending 0, total 112066560
sent 131072 bytes of 131072, pending 0, total 112197632
sent 131072 bytes of 131072, pending 0, total 112328704
sent 131072 bytes of 131072, pending 0, total 112459776
sent 131072 bytes of 131072, pending 0, total 112590848
sent 131072 bytes of 131072, pending 0, total 112721920
sent 131072 bytes of 131072, pending 0, total 112852992
sent 131072 bytes of 131072, pending 0, total 112984064
sent 131072 bytes of 131072, pending 0, total 113115136
sent 131072 bytes of 131072, pending 0, total 113246208
sent 131072 bytes of 131072, pending 0, total 113377280
sent 131072 bytes of 131072, pending 0, total 113508352
sent 131072 bytes of 131072, pending 0, total 113639424
sent 131072 bytes of 131072, pending 0, total 113770496
sent 131072 bytes of 131072, pending 0, total 113901568
sent 131072 bytes of 131072, pending 0, total 114032640
sent 131072 bytes of 131072, pending 0, total 114163712
sent 131072 bytes of 131072, pending 0, total 114294784
sent 131072 bytes of 131072, pending 0, total 114425856
sent 131072 bytes of 131072, pending 0, total 114556928
sent 131072 bytes of 131072, pending 0, total 114688000
sent 131072 bytes of 131072, pending 0, total 114819072
sent 131072 bytes of 131072, pending 0, total 114950144
sent 131072 bytes of 131072, pending 0, total 115081216
sent 131072 bytes of 131072, pending 0, total 115212288
sent 131072 bytes of 131072, pending 0, total 115343360
sent 131072 bytes of 131072, pending 0, total 115474432
sent 131072 bytes of 131072, pending 0, total 115605504
sent 131072 bytes of 131072, pending 0, total 115736576
sent 131072 bytes of 131072, pending 0, total 115867648
sent 131072 bytes of 131072, pending 0, total 115998720
sent 131072 bytes of 131072, pending 0, total 116129792
sent 131072 bytes of 131072, pending 0, total 116260864
sent 131072 bytes of 131072, pending 0, total 116391936
sent 131072 bytes of 131072, pending 0, total 116523008
sent 131072 bytes of 131072, pending 0, total 116654080
sent 131072 bytes of 131072, pending 0, total 116785152
sent 131072 bytes of 131072, pending 0, total 116916224
sent 131072 bytes of 131072, pending 0, total 117047296
sent 131072 bytes of 131072, pending 0, total 117178368
sent 131072 bytes of 131072, pending 0, total 117309440
sent 131072 bytes of 131072, pending 0, total 117440512
sent 131072 bytes of 131072, pending 0, total 117571584
sent 131072 bytes of 131072, pending 0, total 117702656
sent 131072 bytes of 131072, pending 0, total 117833728
sent 131072 bytes of 131072, pending 0, total 117964800
sent 131072 bytes of 131072, pending 0, total 118095872
sent 131072 bytes of 131072, pending 0, total 118226944
sent 131072 bytes of 131072, pending 0, total 118358016
sent 131072 bytes of 131072, pending 0, total 118489088
sent 131072 bytes of 131072, pending 0, total 118620160
sent 131072 bytes of 131072, pending 0, total 118751232
sent 131072 bytes of 131072, pending 0, total 118882304
sent 131072 bytes of 131072, pending 0, total 119013376
sent 131072 bytes of 131072, pending 0, total 119144448
sent 131072 bytes of 131072, pending 0, total 119275520
sent 131072 bytes of 131072, pending 0, total 119406592
sent 131072 bytes of 131072, pending 0, total 119537664
sent 131072 bytes of 131072, pending 0, total 119668736
sent 131072 bytes of 131072, pending 0, total 119799808
sent 131072 bytes of 131072, pending 0, total 119930880
sent 131072 bytes of 131072, pending 0, total 120061952
sent 131072 bytes of 131072, pending 0, total 120193024
sent 131072 bytes of 131072, pending 0, total 120324096
sent 131072 bytes of 131072, pending 0, total 120455168
sent 131072 bytes of 131072, pending 0, total 120586240
sent 131072 bytes of 131072, pending 0, total 120717312
sent 131072 bytes of 131072, pending 0, total 120848384
sent 131072 bytes of 131072, pending 0, total 120979456
sent 131072 bytes of 131072, pending 0, total 121110528
sent 131072 bytes of 131072, pending 0, total 121241600
sent 131072 bytes of 131072, pending 0, total 121372672
sent 131072 bytes of 131072, pending 0, total 121503744
tcpi_snd_cwnd 958 tcpi_snd_mss 1368 tcpi_rtt 48578
sent 131072 bytes of 131072, pending 0, total 121634816
interval_len 0.999972 bytes_transferred 16384000
interval forces keep
[  5]   6.00-7.00   sec  15.6 MBytes   131 Mbits/sec    0   1.25 MBytes       
sent 131072 bytes of 131072, pending 0, total 121765888
sent 131072 bytes of 131072, pending 0, total 121896960
sent 131072 bytes of 131072, pending 0, total 122028032
sent 131072 bytes of 131072, pending 0, total 122159104
sent 131072 bytes of 131072, pending 0, total 122290176
sent 131072 bytes of 131072, pending 0, total 122421248
sent 131072 bytes of 131072, pending 0, total 122552320
sent 131072 bytes of 131072, pending 0, total 122683392
sent 131072 bytes of 131072, pending 0, total 122814464
sent 131072 bytes of 131072, pending 0, total 122945536
sent 131072 bytes of 131072, pending 0, total 123076608
sent 131072 bytes of 131072, pending 0, total 123207680
sent 131072 bytes of 131072, pending 0, total 123338752
sent 131072 bytes of 131072, pending 0, total 123469824
sent 131072 bytes of 131072, pending 0, total 123600896
sent 131072 bytes of 131072, pending 0, total 123731968
sent 131072 bytes of 131072, pending 0, total 123863040
sent 131072 bytes of 131072, pending 0, total 123994112
sent 131072 bytes of 131072, pending 0, total 124125184
sent 131072 bytes of 131072, pending 0, total 124256256
sent 131072 bytes of 131072, pending 0, total 124387328
sent 131072 bytes of 131072, pending 0, total 124518400
sent 131072 bytes of 131072, pending 0, total 124649472
sent 131072 bytes of 131072, pending 0, total 124780544
sent 131072 bytes of 131072, pending 0, total 124911616
sent 131072 bytes of 131072, pending 0, total 125042688
sent 131072 bytes of 131072, pending 0, total 125173760
sent 131072 bytes of 131072, pending 0, total 125304832
sent 131072 bytes of 131072, pending 0, total 125435904
sent 131072 bytes of 131072, pending 0, total 125566976
sent 131072 bytes of 131072, pending 0, total 125698048
sent 131072 bytes of 131072, pending 0, total 125829120
sent 131072 bytes of 131072, pending 0, total 125960192
sent 131072 bytes of 131072, pending 0, total 126091264
sent 131072 bytes of 131072, pending 0, total 126222336
sent 131072 bytes of 131072, pending 0, total 126353408
sent 131072 bytes of 131072, pending 0, total 126484480
sent 131072 bytes of 131072, pending 0, total 126615552
sent 131072 bytes of 131072, pending 0, total 126746624
sent 131072 bytes of 131072, pending 0, total 126877696
sent 131072 bytes of 131072, pending 0, total 127008768
sent 131072 bytes of 131072, pending 0, total 127139840
sent 131072 bytes of 131072, pending 0, total 127270912
sent 131072 bytes of 131072, pending 0, total 127401984
sent 131072 bytes of 131072, pending 0, total 127533056
sent 131072 bytes of 131072, pending 0, total 127664128
sent 131072 bytes of 131072, pending 0, total 127795200
sent 131072 bytes of 131072, pending 0, total 127926272
sent 131072 bytes of 131072, pending 0, total 128057344
sent 131072 bytes of 131072, pending 0, total 128188416
sent 131072 bytes of 131072, pending 0, total 128319488
sent 131072 bytes of 131072, pending 0, total 128450560
sent 131072 bytes of 131072, pending 0, total 128581632
sent 131072 bytes of 131072, pending 0, total 128712704
sent 131072 bytes of 131072, pending 0, total 128843776
sent 131072 bytes of 131072, pending 0, total 128974848
sent 131072 bytes of 131072, pending 0, total 129105920
sent 131072 bytes of 131072, pending 0, total 129236992
sent 131072 bytes of 131072, pending 0, total 129368064
sent 131072 bytes of 131072, pending 0, total 129499136
sent 131072 bytes of 131072, pending 0, total 129630208
sent 131072 bytes of 131072, pending 0, total 129761280
sent 131072 bytes of 131072, pending 0, total 129892352
sent 131072 bytes of 131072, pending 0, total 130023424
sent 131072 bytes of 131072, pending 0, total 130154496
sent 131072 bytes of 131072, pending 0, total 130285568
sent 131072 bytes of 131072, pending 0, total 130416640
sent 131072 bytes of 131072, pending 0, total 130547712
sent 131072 bytes of 131072, pending 0, total 130678784
sent 131072 bytes of 131072, pending 0, total 130809856
sent 131072 bytes of 131072, pending 0, total 130940928
sent 131072 bytes of 131072, pending 0, total 131072000
sent 131072 bytes of 131072, pending 0, total 131203072
sent 131072 bytes of 131072, pending 0, total 131334144
sent 131072 bytes of 131072, pending 0, total 131465216
sent 131072 bytes of 131072, pending 0, total 131596288
sent 131072 bytes of 131072, pending 0, total 131727360
sent 131072 bytes of 131072, pending 0, total 131858432
sent 131072 bytes of 131072, pending 0, total 131989504
sent 131072 bytes of 131072, pending 0, total 132120576
sent 131072 bytes of 131072, pending 0, total 132251648
sent 131072 bytes of 131072, pending 0, total 132382720
sent 131072 bytes of 131072, pending 0, total 132513792
sent 131072 bytes of 131072, pending 0, total 132644864
sent 131072 bytes of 131072, pending 0, total 132775936
sent 131072 bytes of 131072, pending 0, total 132907008
sent 131072 bytes of 131072, pending 0, total 133038080
sent 131072 bytes of 131072, pending 0, total 133169152
sent 131072 bytes of 131072, pending 0, total 133300224
sent 131072 bytes of 131072, pending 0, total 133431296
sent 131072 bytes of 131072, pending 0, total 133562368
sent 131072 bytes of 131072, pending 0, total 133693440
sent 131072 bytes of 131072, pending 0, total 133824512
sent 131072 bytes of 131072, pending 0, total 133955584
sent 131072 bytes of 131072, pending 0, total 134086656
sent 131072 bytes of 131072, pending 0, total 134217728
sent 131072 bytes of 131072, pending 0, total 134348800
sent 131072 bytes of 131072, pending 0, total 134479872
sent 131072 bytes of 131072, pending 0, total 134610944
sent 131072 bytes of 131072, pending 0, total 134742016
sent 131072 bytes of 131072, pending 0, total 134873088
sent 131072 bytes of 131072, pending 0, total 135004160
sent 131072 bytes of 131072, pending 0, total 135135232
sent 131072 bytes of 131072, pending 0, total 135266304
sent 131072 bytes of 131072, pending 0, total 135397376
sent 131072 bytes of 131072, pending 0, total 135528448
sent 131072 bytes of 131072, pending 0, total 135659520
sent 131072 bytes of 131072, pending 0, total 135790592
sent 131072 bytes of 131072, pending 0, total 135921664
sent 131072 bytes of 131072, pending 0, total 136052736
sent 131072 bytes of 131072, pending 0, total 136183808
sent 131072 bytes of 131072, pending 0, total 136314880
sent 131072 bytes of 131072, pending 0, total 136445952
sent 131072 bytes of 131072, pending 0, total 136577024
sent 131072 bytes of 131072, pending 0, total 136708096
sent 131072 bytes of 131072, pending 0, total 136839168
sent 131072 bytes of 131072, pending 0, total 136970240
sent 131072 bytes of 131072, pending 0, total 137101312
sent 131072 bytes of 131072, pending 0, total 137232384
sent 131072 bytes of 131072, pending 0, total 137363456
sent 131072 bytes of 131072, pending 0, total 137494528
sent 131072 bytes of 131072, pending 0, total 137625600
sent 131072 bytes of 131072, pending 0, total 137756672
sent 131072 bytes of 131072, pending 0, total 137887744
sent 131072 bytes of 131072, pending 0, total 138018816
sent 131072 bytes of 131072, pending 0, total 138149888
sent 131072 bytes of 131072, pending 0, total 138280960
sent 131072 bytes of 131072, pending 0, total 138412032
sent 131072 bytes of 131072, pending 0, total 138543104
sent 131072 bytes of 131072, pending 0, total 138674176
sent 131072 bytes of 131072, pending 0, total 138805248
sent 131072 bytes of 131072, pending 0, total 138936320
sent 131072 bytes of 131072, pending 0, total 139067392
sent 131072 bytes of 131072, pending 0, total 139198464
sent 131072 bytes of 131072, pending 0, total 139329536
sent 131072 bytes of 131072, pending 0, total 139460608
sent 131072 bytes of 131072, pending 0, total 139591680
sent 131072 bytes of 131072, pending 0, total 139722752
sent 131072 bytes of 131072, pending 0, total 139853824
sent 131072 bytes of 131072, pending 0, total 139984896
sent 131072 bytes of 131072, pending 0, total 140115968
sent 131072 bytes of 131072, pending 0, total 140247040
sent 131072 bytes of 131072, pending 0, total 140378112
sent 131072 bytes of 131072, pending 0, total 140509184
sent 131072 bytes of 131072, pending 0, total 140640256
sent 131072 bytes of 131072, pending 0, total 140771328
tcpi_snd_cwnd 958 tcpi_snd_mss 1368 tcpi_rtt 62499
interval_len 1.000007 bytes_transferred 19136512
interval forces keep
[  5]   7.00-8.00   sec  18.2 MBytes   153 Mbits/sec    0   1.25 MBytes       
sent 131072 bytes of 131072, pending 0, total 140902400
sent 131072 bytes of 131072, pending 0, total 141033472
sent 131072 bytes of 131072, pending 0, total 141164544
sent 131072 bytes of 131072, pending 0, total 141295616
sent 131072 bytes of 131072, pending 0, total 141426688
sent 131072 bytes of 131072, pending 0, total 141557760
sent 131072 bytes of 131072, pending 0, total 141688832
sent 131072 bytes of 131072, pending 0, total 141819904
sent 131072 bytes of 131072, pending 0, total 141950976
sent 131072 bytes of 131072, pending 0, total 142082048
sent 131072 bytes of 131072, pending 0, total 142213120
sent 131072 bytes of 131072, pending 0, total 142344192
sent 131072 bytes of 131072, pending 0, total 142475264
sent 131072 bytes of 131072, pending 0, total 142606336
sent 131072 bytes of 131072, pending 0, total 142737408
sent 131072 bytes of 131072, pending 0, total 142868480
sent 131072 bytes of 131072, pending 0, total 142999552
sent 131072 bytes of 131072, pending 0, total 143130624
sent 131072 bytes of 131072, pending 0, total 143261696
sent 131072 bytes of 131072, pending 0, total 143392768
sent 131072 bytes of 131072, pending 0, total 143523840
sent 131072 bytes of 131072, pending 0, total 143654912
sent 131072 bytes of 131072, pending 0, total 143785984
sent 131072 bytes of 131072, pending 0, total 143917056
sent 131072 bytes of 131072, pending 0, total 144048128
sent 131072 bytes of 131072, pending 0, total 144179200
sent 131072 bytes of 131072, pending 0, total 144310272
sent 131072 bytes of 131072, pending 0, total 144441344
sent 131072 bytes of 131072, pending 0, total 144572416
sent 131072 bytes of 131072, pending 0, total 144703488
sent 131072 bytes of 131072, pending 0, total 144834560
sent 131072 bytes of 131072, pending 0, total 144965632
sent 131072 bytes of 131072, pending 0, total 145096704
sent 131072 bytes of 131072, pending 0, total 145227776
sent 131072 bytes of 131072, pending 0, total 145358848
sent 131072 bytes of 131072, pending 0, total 145489920
sent 131072 bytes of 131072, pending 0, total 145620992
sent 131072 bytes of 131072, pending 0, total 145752064
sent 131072 bytes of 131072, pending 0, total 145883136
sent 131072 bytes of 131072, pending 0, total 146014208
sent 131072 bytes of 131072, pending 0, total 146145280
sent 131072 bytes of 131072, pending 0, total 146276352
sent 131072 bytes of 131072, pending 0, total 146407424
sent 131072 bytes of 131072, pending 0, total 146538496
sent 131072 bytes of 131072, pending 0, total 146669568
sent 131072 bytes of 131072, pending 0, total 146800640
sent 131072 bytes of 131072, pending 0, total 146931712
sent 131072 bytes of 131072, pending 0, total 147062784
sent 131072 bytes of 131072, pending 0, total 147193856
sent 131072 bytes of 131072, pending 0, total 147324928
sent 131072 bytes of 131072, pending 0, total 147456000
sent 131072 bytes of 131072, pending 0, total 147587072
sent 131072 bytes of 131072, pending 0, total 147718144
sent 131072 bytes of 131072, pending 0, total 147849216
sent 131072 bytes of 131072, pending 0, total 147980288
sent 131072 bytes of 131072, pending 0, total 148111360
sent 131072 bytes of 131072, pending 0, total 148242432
sent 131072 bytes of 131072, pending 0, total 148373504
sent 131072 bytes of 131072, pending 0, total 148504576
sent 131072 bytes of 131072, pending 0, total 148635648
sent 131072 bytes of 131072, pending 0, total 148766720
sent 131072 bytes of 131072, pending 0, total 148897792
sent 131072 bytes of 131072, pending 0, total 149028864
sent 131072 bytes of 131072, pending 0, total 149159936
sent 131072 bytes of 131072, pending 0, total 149291008
sent 131072 bytes of 131072, pending 0, total 149422080
sent 131072 bytes of 131072, pending 0, total 149553152
sent 131072 bytes of 131072, pending 0, total 149684224
sent 131072 bytes of 131072, pending 0, total 149815296
sent 131072 bytes of 131072, pending 0, total 149946368
sent 131072 bytes of 131072, pending 0, total 150077440
sent 131072 bytes of 131072, pending 0, total 150208512
sent 131072 bytes of 131072, pending 0, total 150339584
sent 131072 bytes of 131072, pending 0, total 150470656
sent 131072 bytes of 131072, pending 0, total 150601728
sent 131072 bytes of 131072, pending 0, total 150732800
sent 131072 bytes of 131072, pending 0, total 150863872
sent 131072 bytes of 131072, pending 0, total 150994944
sent 131072 bytes of 131072, pending 0, total 151126016
sent 131072 bytes of 131072, pending 0, total 151257088
sent 131072 bytes of 131072, pending 0, total 151388160
sent 131072 bytes of 131072, pending 0, total 151519232
sent 131072 bytes of 131072, pending 0, total 151650304
sent 131072 bytes of 131072, pending 0, total 151781376
sent 131072 bytes of 131072, pending 0, total 151912448
sent 131072 bytes of 131072, pending 0, total 152043520
sent 131072 bytes of 131072, pending 0, total 152174592
sent 131072 bytes of 131072, pending 0, total 152305664
sent 131072 bytes of 131072, pending 0, total 152436736
sent 131072 bytes of 131072, pending 0, total 152567808
sent 131072 bytes of 131072, pending 0, total 152698880
sent 131072 bytes of 131072, pending 0, total 152829952
sent 131072 bytes of 131072, pending 0, total 152961024
sent 131072 bytes of 131072, pending 0, total 153092096
sent 131072 bytes of 131072, pending 0, total 153223168
sent 131072 bytes of 131072, pending 0, total 153354240
sent 131072 bytes of 131072, pending 0, total 153485312
sent 131072 bytes of 131072, pending 0, total 153616384
sent 131072 bytes of 131072, pending 0, total 153747456
sent 131072 bytes of 131072, pending 0, total 153878528
sent 131072 bytes of 131072, pending 0, total 154009600
sent 131072 bytes of 131072, pending 0, total 154140672
sent 131072 bytes of 131072, pending 0, total 154271744
sent 131072 bytes of 131072, pending 0, total 154402816
sent 131072 bytes of 131072, pending 0, total 154533888
sent 131072 bytes of 131072, pending 0, total 154664960
sent 131072 bytes of 131072, pending 0, total 154796032
sent 131072 bytes of 131072, pending 0, total 154927104
sent 131072 bytes of 131072, pending 0, total 155058176
sent 131072 bytes of 131072, pending 0, total 155189248
sent 131072 bytes of 131072, pending 0, total 155320320
sent 131072 bytes of 131072, pending 0, total 155451392
sent 131072 bytes of 131072, pending 0, total 155582464
sent 131072 bytes of 131072, pending 0, total 155713536
sent 131072 bytes of 131072, pending 0, total 155844608
sent 131072 bytes of 131072, pending 0, total 155975680
sent 131072 bytes of 131072, pending 0, total 156106752
sent 131072 bytes of 131072, pending 0, total 156237824
sent 131072 bytes of 131072, pending 0, total 156368896
sent 131072 bytes of 131072, pending 0, total 156499968
sent 131072 bytes of 131072, pending 0, total 156631040
sent 131072 bytes of 131072, pending 0, total 156762112
sent 131072 bytes of 131072, pending 0, total 156893184
sent 131072 bytes of 131072, pending 0, total 157024256
sent 131072 bytes of 131072, pending 0, total 157155328
sent 131072 bytes of 131072, pending 0, total 157286400
sent 131072 bytes of 131072, pending 0, total 157417472
sent 131072 bytes of 131072, pending 0, total 157548544
sent 131072 bytes of 131072, pending 0, total 157679616
sent 131072 bytes of 131072, pending 0, total 157810688
sent 131072 bytes of 131072, pending 0, total 157941760
sent 131072 bytes of 131072, pending 0, total 158072832
sent 131072 bytes of 131072, pending 0, total 158203904
sent 131072 bytes of 131072, pending 0, total 158334976
sent 131072 bytes of 131072, pending 0, total 158466048
sent 131072 bytes of 131072, pending 0, total 158597120
sent 131072 bytes of 131072, pending 0, total 158728192
sent 131072 bytes of 131072, pending 0, total 158859264
sent 131072 bytes of 131072, pending 0, total 158990336
sent 131072 bytes of 131072, pending 0, total 159121408
sent 131072 bytes of 131072, pending 0, total 159252480
sent 131072 bytes of 131072, pending 0, total 159383552
sent 131072 bytes of 131072, pending 0, total 159514624
sent 131072 bytes of 131072, pending 0, total 159645696
sent 131072 bytes of 131072, pending 0, total 159776768
tcpi_snd_cwnd 958 tcpi_snd_mss 1368 tcpi_rtt 62106
interval_len 1.000039 bytes_transferred 19005440
interval forces keep
[  5]   8.00-9.00   sec  18.1 MBytes   152 Mbits/sec    0   1.25 MBytes       
sent 131072 bytes of 131072, pending 0, total 159907840
sent 131072 bytes of 131072, pending 0, total 160038912
sent 131072 bytes of 131072, pending 0, total 160169984
sent 131072 bytes of 131072, pending 0, total 160301056
sent 131072 bytes of 131072, pending 0, total 160432128
sent 131072 bytes of 131072, pending 0, total 160563200
sent 131072 bytes of 131072, pending 0, total 160694272
sent 131072 bytes of 131072, pending 0, total 160825344
sent 131072 bytes of 131072, pending 0, total 160956416
sent 131072 bytes of 131072, pending 0, total 161087488
sent 131072 bytes of 131072, pending 0, total 161218560
sent 131072 bytes of 131072, pending 0, total 161349632
sent 131072 bytes of 131072, pending 0, total 161480704
sent 131072 bytes of 131072, pending 0, total 161611776
sent 131072 bytes of 131072, pending 0, total 161742848
sent 131072 bytes of 131072, pending 0, total 161873920
sent 131072 bytes of 131072, pending 0, total 162004992
sent 131072 bytes of 131072, pending 0, total 162136064
sent 131072 bytes of 131072, pending 0, total 162267136
sent 131072 bytes of 131072, pending 0, total 162398208
sent 131072 bytes of 131072, pending 0, total 162529280
sent 131072 bytes of 131072, pending 0, total 162660352
sent 131072 bytes of 131072, pending 0, total 162791424
sent 131072 bytes of 131072, pending 0, total 162922496
sent 131072 bytes of 131072, pending 0, total 163053568
sent 131072 bytes of 131072, pending 0, total 163184640
sent 131072 bytes of 131072, pending 0, total 163315712
sent 131072 bytes of 131072, pending 0, total 163446784
sent 131072 bytes of 131072, pending 0, total 163577856
sent 131072 bytes of 131072, pending 0, total 163708928
sent 131072 bytes of 131072, pending 0, total 163840000
sent 131072 bytes of 131072, pending 0, total 163971072
sent 131072 bytes of 131072, pending 0, total 164102144
sent 131072 bytes of 131072, pending 0, total 164233216
sent 131072 bytes of 131072, pending 0, total 164364288
sent 131072 bytes of 131072, pending 0, total 164495360
sent 131072 bytes of 131072, pending 0, total 164626432
sent 131072 bytes of 131072, pending 0, total 164757504
sent 131072 bytes of 131072, pending 0, total 164888576
sent 131072 bytes of 131072, pending 0, total 165019648
sent 131072 bytes of 131072, pending 0, total 165150720
sent 131072 bytes of 131072, pending 0, total 165281792
sent 131072 bytes of 131072, pending 0, total 165412864
sent 131072 bytes of 131072, pending 0, total 165543936
sent 131072 bytes of 131072, pending 0, total 165675008
sent 131072 bytes of 131072, pending 0, total 165806080
sent 131072 bytes of 131072, pending 0, total 165937152
sent 131072 bytes of 131072, pending 0, total 166068224
sent 131072 bytes of 131072, pending 0, total 166199296
sent 131072 bytes of 131072, pending 0, total 166330368
sent 131072 bytes of 131072, pending 0, total 166461440
sent 131072 bytes of 131072, pending 0, total 166592512
sent 131072 bytes of 131072, pending 0, total 166723584
sent 131072 bytes of 131072, pending 0, total 166854656
sent 131072 bytes of 131072, pending 0, total 166985728
sent 131072 bytes of 131072, pending 0, total 167116800
sent 131072 bytes of 131072, pending 0, total 167247872
sent 131072 bytes of 131072, pending 0, total 167378944
sent 131072 bytes of 131072, pending 0, total 167510016
sent 131072 bytes of 131072, pending 0, total 167641088
sent 131072 bytes of 131072, pending 0, total 167772160
sent 131072 bytes of 131072, pending 0, total 167903232
sent 131072 bytes of 131072, pending 0, total 168034304
sent 131072 bytes of 131072, pending 0, total 168165376
sent 131072 bytes of 131072, pending 0, total 168296448
sent 131072 bytes of 131072, pending 0, total 168427520
sent 131072 bytes of 131072, pending 0, total 168558592
sent 131072 bytes of 131072, pending 0, total 168689664
sent 131072 bytes of 131072, pending 0, total 168820736
sent 131072 bytes of 131072, pending 0, total 168951808
sent 131072 bytes of 131072, pending 0, total 169082880
sent 131072 bytes of 131072, pending 0, total 169213952
sent 131072 bytes of 131072, pending 0, total 169345024
sent 131072 bytes of 131072, pending 0, total 169476096
sent 131072 bytes of 131072, pending 0, total 169607168
sent 131072 bytes of 131072, pending 0, total 169738240
sent 131072 bytes of 131072, pending 0, total 169869312
sent 131072 bytes of 131072, pending 0, total 170000384
sent 131072 bytes of 131072, pending 0, total 170131456
sent 131072 bytes of 131072, pending 0, total 170262528
sent 131072 bytes of 131072, pending 0, total 170393600
sent 131072 bytes of 131072, pending 0, total 170524672
sent 131072 bytes of 131072, pending 0, total 170655744
sent 131072 bytes of 131072, pending 0, total 170786816
sent 131072 bytes of 131072, pending 0, total 170917888
sent 131072 bytes of 131072, pending 0, total 171048960
sent 131072 bytes of 131072, pending 0, total 171180032
sent 131072 bytes of 131072, pending 0, total 171311104
sent 131072 bytes of 131072, pending 0, total 171442176
sent 131072 bytes of 131072, pending 0, total 171573248
sent 131072 bytes of 131072, pending 0, total 171704320
sent 131072 bytes of 131072, pending 0, total 171835392
sent 131072 bytes of 131072, pending 0, total 171966464
sent 131072 bytes of 131072, pending 0, total 172097536
sent 131072 bytes of 131072, pending 0, total 172228608
sent 131072 bytes of 131072, pending 0, total 172359680
sent 131072 bytes of 131072, pending 0, total 172490752
sent 131072 bytes of 131072, pending 0, total 172621824
sent 131072 bytes of 131072, pending 0, total 172752896
sent 131072 bytes of 131072, pending 0, total 172883968
sent 131072 bytes of 131072, pending 0, total 173015040
sent 131072 bytes of 131072, pending 0, total 173146112
sent 131072 bytes of 131072, pending 0, total 173277184
sent 131072 bytes of 131072, pending 0, total 173408256
sent 131072 bytes of 131072, pending 0, total 173539328
sent 131072 bytes of 131072, pending 0, total 173670400
sent 131072 bytes of 131072, pending 0, total 173801472
sent 131072 bytes of 131072, pending 0, total 173932544
sent 131072 bytes of 131072, pending 0, total 174063616
sent 131072 bytes of 131072, pending 0, total 174194688
sent 131072 bytes of 131072, pending 0, total 174325760
sent 131072 bytes of 131072, pending 0, total 174456832
sent 131072 bytes of 131072, pending 0, total 174587904
sent 131072 bytes of 131072, pending 0, total 174718976
sent 131072 bytes of 131072, pending 0, total 174850048
sent 131072 bytes of 131072, pending 0, total 174981120
sent 131072 bytes of 131072, pending 0, total 175112192
sent 131072 bytes of 131072, pending 0, total 175243264
sent 131072 bytes of 131072, pending 0, total 175374336
sent 131072 bytes of 131072, pending 0, total 175505408
sent 131072 bytes of 131072, pending 0, total 175636480
sent 131072 bytes of 131072, pending 0, total 175767552
sent 131072 bytes of 131072, pending 0, total 175898624
sent 131072 bytes of 131072, pending 0, total 176029696
sent 131072 bytes of 131072, pending 0, total 176160768
sent 131072 bytes of 131072, pending 0, total 176291840
sent 131072 bytes of 131072, pending 0, total 176422912
sent 131072 bytes of 131072, pending 0, total 176553984
sent 131072 bytes of 131072, pending 0, total 176685056
sent 131072 bytes of 131072, pending 0, total 176816128
sent 131072 bytes of 131072, pending 0, total 176947200
sent 131072 bytes of 131072, pending 0, total 177078272
sent 131072 bytes of 131072, pending 0, total 177209344
sent 131072 bytes of 131072, pending 0, total 177340416
sent 131072 bytes of 131072, pending 0, total 177471488
sent 131072 bytes of 131072, pending 0, total 177602560
sent 131072 bytes of 131072, pending 0, total 177733632
sent 131072 bytes of 131072, pending 0, total 177864704
sent 131072 bytes of 131072, pending 0, total 177995776
sent 131072 bytes of 131072, pending 0, total 178126848
sent 131072 bytes of 131072, pending 0, total 178257920
sent 131072 bytes of 131072, pending 0, total 178388992
sent 131072 bytes of 131072, pending 0, total 178520064
sent 131072 bytes of 131072, pending 0, total 178651136
sent 131072 bytes of 131072, pending 0, total 178782208
Thread FD 5 stopped
Sender threads stopped
tcpi_snd_cwnd 958 tcpi_snd_mss 1368 tcpi_rtt 73570
send_results
{
	"cpu_util_total":	70.839435210148835,
	"cpu_util_user":	0.88033758637641768,
	"cpu_util_system":	69.9590576878456,
	"sender_has_retransmits":	1,
	"congestion_used":	"cubic",
	"streams":	[{
			"id":	1,
			"bytes":	178782208,
			"retransmits":	0,
			"jitter":	0,
			"errors":	0,
			"omitted_errors":	0,
			"packets":	0,
			"omitted_packets":	0,
			"start_time":	0,
			"end_time":	10.002514
		}]
}
get_results
{
	"cpu_util_total":	72.424360002911556,
	"cpu_util_user":	2.9556646817386492,
	"cpu_util_system":	69.4687152089027,
	"sender_has_retransmits":	-1,
	"congestion_used":	"cubic",
	"streams":	[{
			"id":	1,
			"bytes":	178782208,
			"retransmits":	-1,
			"jitter":	0,
			"errors":	0,
			"omitted_errors":	0,
			"packets":	0,
			"omitted_packets":	0,
			"start_time":	0,
			"end_time":	10.056211
		}]
}
interval_len 1.001313 bytes_transferred 19005440
interval forces keep
[  5]   9.00-10.00  sec  18.1 MBytes   152 Mbits/sec    0   1.25 MBytes       
- - - - - - - - - - - - - - - - - - - - - - - - -
Test Complete. Summary Results:
[ ID] Interval           Transfer     Bitrate         Retr
[  5]   0.00-10.00  sec   170 MBytes   143 Mbits/sec    0             sender
[  5]   0.00-10.06  sec   170 MBytes   142 Mbits/sec                  receiver
CPU Utilization: local/sender 70.8% (0.9%u/70.0%s), remote/receiver 72.4% (3.0%u/69.5%s)
snd_tcp_congestion cubic
rcv_tcp_congestion cubic
Receiver threads stopped

iperf Done.
Test Completed at Wed Jun 18 15:43:48 UTC 2025
Batman/Batctl Report
====================
Batctl neighbors
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: lan/f4:4d:5c:fd:a2:fc (batman/2a:1b:08:b6:0e:40 BATMAN_IV)]
IF             Neighbor              last-seen
          lan	  20:97:27:52:6c:ab    3.520s
          lan	  f4:4d:5c:fd:9d:ef    4.290s
          lan	  f4:4d:5c:fe:51:64    4.770s
   phy0-mesh0	  d2:3d:f3:fe:f3:62  228.460s
   phy0-mesh0	  2a:97:27:52:6c:ad    1.510s
   phy0-mesh0	  f2:4d:5c:fd:9d:f0    3.150s
   phy0-mesh0	  d2:3d:f3:fe:f3:53    3.050s
   phy0-mesh0	  f2:4d:5c:fe:51:65    3.250s
   phy0-mesh0	  f2:4d:5c:fc:25:8d    1.060s
   phy1-mesh0	  2a:97:27:52:6c:ae    4.560s
   phy1-mesh0	  f2:4d:5c:fd:9d:f1    4.370s
   phy1-mesh0	  f2:4d:5c:fc:25:8e    2.650s
   phy1-mesh0	  f2:4d:5c:fe:51:66    3.570s
   phy1-mesh0	  d2:3d:f3:fe:f3:54    1.150s
Batctl originators
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: lan/f4:4d:5c:fd:a2:fc (batman/2a:1b:08:b6:0e:40 BATMAN_IV)]
   Originator        last-seen (#/255) Nexthop           [outgoingIF]
   f4:4d:5c:fd:9d:ef    4.060s   (166) 2a:97:27:52:6c:ad [phy0-mesh0]
   f4:4d:5c:fd:9d:ef    4.060s   (211) 2a:97:27:52:6c:ae [phy1-mesh0]
   f4:4d:5c:fd:9d:ef    4.060s   (245) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f4:4d:5c:fd:9d:ef    4.060s   (176) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f4:4d:5c:fd:9d:ef    4.060s   (181) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   f4:4d:5c:fd:9d:ef    4.060s   (220) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f4:4d:5c:fd:9d:ef    4.060s   (202) f2:4d:5c:fe:51:65 [phy0-mesh0]
   f4:4d:5c:fd:9d:ef    4.060s   (225) 20:97:27:52:6c:ab [       lan]
   f4:4d:5c:fd:9d:ef    4.060s   (225) f4:4d:5c:fe:51:64 [       lan]
 * f4:4d:5c:fd:9d:ef    4.060s   (255) f4:4d:5c:fd:9d:ef [       lan]
   d2:3d:f3:fe:f3:62  122.270s   (133) 2a:97:27:52:6c:ad [phy0-mesh0]
   d2:3d:f3:fe:f3:62  122.270s   (168) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   d2:3d:f3:fe:f3:62  122.270s   (154) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   d2:3d:f3:fe:f3:62  122.270s   (197) 2a:97:27:52:6c:ae [phy1-mesh0]
   d2:3d:f3:fe:f3:62  122.270s   (204) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   d2:3d:f3:fe:f3:62  122.270s   (208) 20:97:27:52:6c:ab [       lan]
 * d2:3d:f3:fe:f3:62  122.270s   (225) f4:4d:5c:fd:9d:ef [       lan]
   f2:4d:5c:fc:25:8e    1.420s   (147) 2a:97:27:52:6c:ae [phy1-mesh0]
   f2:4d:5c:fc:25:8e    1.420s   (176) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f2:4d:5c:fc:25:8e    1.420s   (166) d2:3d:f3:fe:f3:54 [phy1-mesh0]
 * f2:4d:5c:fc:25:8e    1.420s   (234) f2:4d:5c:fc:25:8e [phy1-mesh0]
   f2:4d:5c:fe:51:65    3.140s   (109) 2a:97:27:52:6c:ad [phy0-mesh0]
   f2:4d:5c:fe:51:65    3.140s   (126) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   f2:4d:5c:fe:51:65    3.140s   (171) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f2:4d:5c:fe:51:65    3.140s   (153) f2:4d:5c:fc:25:8d [phy0-mesh0]
 * f2:4d:5c:fe:51:65    3.140s   (230) f2:4d:5c:fe:51:65 [phy0-mesh0]
   2a:97:27:52:6c:ae    4.460s   (180) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   2a:97:27:52:6c:ae    4.460s   (171) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   2a:97:27:52:6c:ae    4.460s   (179) f2:4d:5c:fe:51:66 [phy1-mesh0]
 * 2a:97:27:52:6c:ae    4.460s   (240) 2a:97:27:52:6c:ae [phy1-mesh0]
   d2:3d:f3:fe:f3:63  119.490s   (  0) f2:4d:5c:fe:51:66 [phy1-mesh0]
 * d2:3d:f3:fe:f3:63  119.490s   (179) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   d2:3d:f3:fe:f3:63  119.490s   (172) 2a:97:27:52:6c:ae [phy1-mesh0]
   d2:3d:f3:fe:f3:53    2.940s   (  0) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   d2:3d:f3:fe:f3:53    2.940s   (  0) 2a:97:27:52:6c:ae [phy1-mesh0]
   d2:3d:f3:fe:f3:53    2.940s   (  0) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   d2:3d:f3:fe:f3:53    2.940s   (  0) 2a:97:27:52:6c:ad [phy0-mesh0]
   d2:3d:f3:fe:f3:53    2.940s   (185) f2:4d:5c:fc:25:8e [phy1-mesh0]
   d2:3d:f3:fe:f3:53    2.940s   (205) f2:4d:5c:fe:51:66 [phy1-mesh0]
 * d2:3d:f3:fe:f3:53    2.940s   (250) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   d2:3d:f3:fe:f3:53    2.940s   (234) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   d2:3d:f3:fe:f3:53    2.940s   (  0) f2:4d:5c:fe:51:65 [phy0-mesh0]
   d2:3d:f3:fe:f3:53    2.940s   (  0) f2:4d:5c:fc:25:8d [phy0-mesh0]
   d2:3d:f3:fe:f3:53    2.940s   (  0) 20:97:27:52:6c:ab [       lan]
   d2:3d:f3:fe:f3:53    2.940s   (  0) f4:4d:5c:fd:9d:ef [       lan]
   d2:3d:f3:fe:f3:53    2.940s   (210) f4:4d:5c:fe:51:64 [       lan]
   2a:97:27:52:6c:ad    1.400s   (  0) f2:4d:5c:fc:25:8d [phy0-mesh0]
   2a:97:27:52:6c:ad    1.400s   (157) f2:4d:5c:fe:51:65 [phy0-mesh0]
 * 2a:97:27:52:6c:ad    1.400s   (187) 2a:97:27:52:6c:ad [phy0-mesh0]
   2a:97:27:52:6c:ad    1.400s   (129) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   2a:97:27:52:6c:ad    1.400s   (137) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f2:4d:5c:fd:9d:f1    4.180s   (183) 2a:97:27:52:6c:ae [phy1-mesh0]
 * f2:4d:5c:fd:9d:f1    4.180s   (246) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f2:4d:5c:fd:9d:f1    4.180s   (174) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f2:4d:5c:fd:9d:f1    4.180s   (156) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   f2:4d:5c:fc:25:8d    0.800s   (136) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   f2:4d:5c:fc:25:8d    0.800s   (187) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f2:4d:5c:fc:25:8d    0.800s   (192) f4:4d:5c:fd:9d:ef [       lan]
   f2:4d:5c:fc:25:8d    0.800s   (140) 2a:97:27:52:6c:ad [phy0-mesh0]
   f2:4d:5c:fc:25:8d    0.800s   (180) 2a:97:27:52:6c:ae [phy1-mesh0]
   f2:4d:5c:fc:25:8d    0.800s   (192) 20:97:27:52:6c:ab [       lan]
   f2:4d:5c:fc:25:8d    0.800s   (173) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f2:4d:5c:fc:25:8d    0.800s   (234) f2:4d:5c:fc:25:8e [phy1-mesh0]
   f2:4d:5c:fc:25:8d    0.800s   (213) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f2:4d:5c:fc:25:8d    0.800s   (201) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   f2:4d:5c:fc:25:8d    0.800s   (184) f2:4d:5c:fe:51:65 [phy0-mesh0]
 * f2:4d:5c:fc:25:8d    0.800s   (242) f2:4d:5c:fc:25:8d [phy0-mesh0]
   f2:4d:5c:fc:25:8d    0.800s   (218) f4:4d:5c:fe:51:64 [       lan]
   f2:4d:5c:fe:51:66    3.460s   (165) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f2:4d:5c:fe:51:66    3.460s   (169) 2a:97:27:52:6c:ae [phy1-mesh0]
   f2:4d:5c:fe:51:66    3.460s   (162) f2:4d:5c:fc:25:8e [phy1-mesh0]
   f2:4d:5c:fe:51:66    3.460s   (188) d2:3d:f3:fe:f3:54 [phy1-mesh0]
 * f2:4d:5c:fe:51:66    3.460s   (251) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f2:4d:5c:fd:9d:f0    3.050s   (  0) d2:3d:f3:fe:f3:62 [phy0-mesh0]
   f2:4d:5c:fd:9d:f0    3.050s   (127) 2a:97:27:52:6c:ad [phy0-mesh0]
   f2:4d:5c:fd:9d:f0    3.050s   (128) d2:3d:f3:fe:f3:53 [phy0-mesh0]
 * f2:4d:5c:fd:9d:f0    3.050s   (182) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   f2:4d:5c:fd:9d:f0    3.050s   (135) f2:4d:5c:fe:51:65 [phy0-mesh0]
   20:97:27:52:6c:ab    3.410s   (189) 2a:97:27:52:6c:ad [phy0-mesh0]
   20:97:27:52:6c:ab    3.410s   (159) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   20:97:27:52:6c:ab    3.410s   (182) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   20:97:27:52:6c:ab    3.410s   (219) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   20:97:27:52:6c:ab    3.410s   (220) f2:4d:5c:fe:51:66 [phy1-mesh0]
   20:97:27:52:6c:ab    3.410s   (240) 2a:97:27:52:6c:ae [phy1-mesh0]
   20:97:27:52:6c:ab    3.410s   (202) f2:4d:5c:fe:51:65 [phy0-mesh0]
   20:97:27:52:6c:ab    3.410s   (225) f4:4d:5c:fe:51:64 [       lan]
   20:97:27:52:6c:ab    3.410s   (225) f4:4d:5c:fd:9d:ef [       lan]
 * 20:97:27:52:6c:ab    3.410s   (255) 20:97:27:52:6c:ab [       lan]
   f4:4d:5c:fe:51:64    4.630s   (166) 2a:97:27:52:6c:ad [phy0-mesh0]
   f4:4d:5c:fe:51:64    4.630s   (159) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   f4:4d:5c:fe:51:64    4.630s   (168) f2:4d:5c:fc:25:8e [phy1-mesh0]
   f4:4d:5c:fe:51:64    4.630s   (199) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f4:4d:5c:fe:51:64    4.630s   (219) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f4:4d:5c:fe:51:64    4.630s   (211) 2a:97:27:52:6c:ae [phy1-mesh0]
   f4:4d:5c:fe:51:64    4.630s   (250) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f4:4d:5c:fe:51:64    4.630s   (209) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   f4:4d:5c:fe:51:64    4.630s   (230) f2:4d:5c:fe:51:65 [phy0-mesh0]
   f4:4d:5c:fe:51:64    4.630s   (190) f2:4d:5c:fc:25:8d [phy0-mesh0]
   f4:4d:5c:fe:51:64    4.630s   (225) 20:97:27:52:6c:ab [       lan]
   f4:4d:5c:fe:51:64    4.630s   (225) f4:4d:5c:fd:9d:ef [       lan]
 * f4:4d:5c:fe:51:64    4.630s   (255) f4:4d:5c:fe:51:64 [       lan]
   d2:3d:f3:fe:f3:54    1.030s   (181) f2:4d:5c:fc:25:8e [phy1-mesh0]
   d2:3d:f3:fe:f3:54    1.030s   (166) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   d2:3d:f3:fe:f3:54    1.030s   (168) f2:4d:5c:fe:51:66 [phy1-mesh0]
   d2:3d:f3:fe:f3:54    1.030s   (168) 2a:97:27:52:6c:ae [phy1-mesh0]
 * d2:3d:f3:fe:f3:54    1.030s   (250) d2:3d:f3:fe:f3:54 [phy1-mesh0]
Batctl transglobal
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: lan/f4:4d:5c:fd:a2:fc (batman/2a:1b:08:b6:0e:40 BATMAN_IV)]
   Client             VID Flags Last ttvn     Via        ttvn  (CRC       )
 * 33:33:ff:99:79:f6   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
 * e6:b5:a1:87:27:54    0 [....] (  1) 20:97:27:52:6c:ab ( 16) (0x4edbbb86)
 * 16:87:5f:85:10:d4    0 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xff7b8a9d)
 * e6:b5:a1:87:27:54    3 [....] (  1) 20:97:27:52:6c:ab ( 16) (0xd70f86fe)
 * 0a:9f:f2:07:5b:66   -1 [....] ( 17) d2:3d:f3:fe:f3:62 ( 60) (0x31f39dc9)
 * 33:33:ff:29:ce:72   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
 * 06:3a:b0:85:82:c4   11 [.W..] ( 14) 20:97:27:52:6c:ab ( 16) (0xc02ff0c8)
   06:3a:b0:85:82:c4   11 [.W..] ( 58) d2:3d:f3:fe:f3:62 ( 60) (0x4e7ef6c6)
 * 16:87:5f:85:10:d4    3 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0x243f0df4)
 * 33:33:ff:85:10:d4   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
 * 20:97:27:52:6c:ad   12 [....] (  2) 20:97:27:52:6c:ab ( 16) (0x5c5d6f23)
 * 16:87:5f:85:10:d4   11 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0x6604092e)
 * 33:33:00:00:00:02   -1 [....] (  1) 20:97:27:52:6c:ab ( 16) (0xfaf54e6c)
   33:33:00:00:00:02   -1 [....] (  1) f4:4d:5c:fd:9d:ef ( 15) (0x6babf43b)
   33:33:00:00:00:02   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
   33:33:00:00:00:02   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
   33:33:00:00:00:02   -1 [....] ( 17) d2:3d:f3:fe:f3:62 ( 60) (0x31f39dc9)
   33:33:00:00:00:02   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
   33:33:00:00:00:02   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
 * e6:b5:a1:87:27:54   12 [....] (  1) 20:97:27:52:6c:ab ( 16) (0x5c5d6f23)
 * e6:b5:a1:87:27:54   11 [....] (  1) 20:97:27:52:6c:ab ( 16) (0xc02ff0c8)
 * 33:33:ff:87:27:54   -1 [....] (  1) 20:97:27:52:6c:ab ( 16) (0xfaf54e6c)
 * b6:1d:b2:47:cd:26   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
 * 9a:58:fd:e4:aa:99    3 [.W..] (  2) 20:97:27:52:6c:ab ( 16) (0xd70f86fe)
 * 3a:ed:be:29:ce:72    3 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x9e2e0cfa)
 * 20:97:27:52:6c:ad   11 [....] (  2) 20:97:27:52:6c:ab ( 16) (0xc02ff0c8)
 * 02:22:f3:35:3e:d3   -1 [....] (  1) f4:4d:5c:fd:9d:ef ( 15) (0x6babf43b)
 * b6:1d:b2:47:cd:26   12 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0xc531fab3)
 * 33:33:ff:07:5b:66   -1 [....] ( 17) d2:3d:f3:fe:f3:62 ( 60) (0x31f39dc9)
 * b6:1d:b2:47:cd:26   11 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x3f68ffb7)
 * e6:b5:a1:87:27:54   -1 [....] (  1) 20:97:27:52:6c:ab ( 16) (0xfaf54e6c)
 * 3a:ed:be:29:ce:72   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
 * b6:1d:b2:47:cd:26    0 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0xa6177c04)
 * 0a:9f:f2:07:5b:66    0 [....] ( 17) d2:3d:f3:fe:f3:62 ( 60) (0xb3e550c5)
 * b6:1d:b2:47:cd:26    3 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x7d53fb6d)
 * 0a:9f:f2:07:5b:66    3 [....] ( 17) d2:3d:f3:fe:f3:62 ( 60) (0x68a1d7ac)
 * 16:87:5f:85:10:d4   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
 * ca:4a:dc:99:79:f6   12 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xf16dbd8d)
 * ca:4a:dc:99:79:f6    0 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0x924b3b3a)
 * 01:00:5e:00:00:01   -1 [....] (  1) 20:97:27:52:6c:ab ( 16) (0xfaf54e6c)
   01:00:5e:00:00:01   -1 [....] (  1) f4:4d:5c:fd:9d:ef ( 15) (0x6babf43b)
   01:00:5e:00:00:01   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
   01:00:5e:00:00:01   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
   01:00:5e:00:00:01   -1 [....] ( 17) d2:3d:f3:fe:f3:62 ( 60) (0x31f39dc9)
   01:00:5e:00:00:01   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
   01:00:5e:00:00:01   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
 * 02:22:f3:35:3e:d3   12 [....] (  1) f4:4d:5c:fd:9d:ef ( 15) (0x0e42d16b)
 * 33:33:ff:00:00:00   -1 [....] (  1) 20:97:27:52:6c:ab ( 16) (0xfaf54e6c)
   33:33:ff:00:00:00   -1 [....] (  1) f4:4d:5c:fd:9d:ef ( 15) (0x6babf43b)
   33:33:ff:00:00:00   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
   33:33:ff:00:00:00   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
   33:33:ff:00:00:00   -1 [....] ( 17) d2:3d:f3:fe:f3:62 ( 60) (0x31f39dc9)
   33:33:ff:00:00:00   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
   33:33:ff:00:00:00   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
 * ca:4a:dc:99:79:f6   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
 * 02:22:f3:35:3e:d3    3 [....] (  1) f4:4d:5c:fd:9d:ef ( 15) (0xb620d0b5)
 * 33:33:ff:35:3e:d3   -1 [....] (  1) f4:4d:5c:fd:9d:ef ( 15) (0x6babf43b)
 * 0a:9f:f2:07:5b:66   12 [....] ( 17) d2:3d:f3:fe:f3:62 ( 60) (0xd0c3d672)
 * 3a:ed:be:29:ce:72   12 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x264c0d24)
 * 16:87:5f:85:10:d4   12 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0x9c5d0c2a)
 * 02:22:f3:35:3e:d3   11 [....] (  1) f4:4d:5c:fd:9d:ef ( 15) (0x7fcd4cba)
 * 0a:9f:f2:07:5b:66   11 [....] ( 17) d2:3d:f3:fe:f3:62 ( 60) (0x4e7ef6c6)
 * 3a:ed:be:29:ce:72    0 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x456a8b93)
 * 3a:ed:be:29:ce:72   11 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0xdc150820)
 * 33:33:ff:47:cd:26   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
 * 20:97:27:52:6c:ad    3 [....] (  2) 20:97:27:52:6c:ab ( 16) (0xd70f86fe)
 * a6:c5:67:2d:44:a5   11 [.W..] ( 16) 20:97:27:52:6c:ab ( 16) (0xc02ff0c8)
 * ca:4a:dc:99:79:f6   11 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0x0b34b889)
 * 02:22:f3:35:3e:d3    0 [....] (  1) f4:4d:5c:fd:9d:ef ( 15) (0x6d6457dc)
 * 06:88:e7:a1:63:64   11 [.W..] ( 15) f4:4d:5c:fd:9d:ef ( 15) (0x7fcd4cba)
   06:88:e7:a1:63:64   11 [.W..] ( 60) d2:3d:f3:fe:f3:62 ( 60) (0x4e7ef6c6)
 * ca:4a:dc:99:79:f6    3 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0x490fbc53)
 * 33:33:00:00:00:01   -1 [....] (  1) 20:97:27:52:6c:ab ( 16) (0xfaf54e6c)
   33:33:00:00:00:01   -1 [....] (  1) f4:4d:5c:fd:9d:ef ( 15) (0x6babf43b)
   33:33:00:00:00:01   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
   33:33:00:00:00:01   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
   33:33:00:00:00:01   -1 [....] ( 17) d2:3d:f3:fe:f3:62 ( 60) (0x31f39dc9)
   33:33:00:00:00:01   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
   33:33:00:00:00:01   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
Batctl translocal
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: lan/f4:4d:5c:fd:a2:fc (batman/2a:1b:08:b6:0e:40 BATMAN_IV), TTVN: 4]
Client             VID Flags    Last seen (CRC       )
2a:1b:08:b6:0e:40    3 [.P....]   0.000   (0xc9b01d7f)
33:33:00:00:00:02   -1 [.P....]   0.000   (0xb48493a1)
2a:1b:08:b6:0e:40   12 [.P....]   0.000   (0x71d21ca1)
2a:1b:08:b6:0e:40   -1 [.P....]   0.000   (0xb48493a1)
2a:1b:08:b6:0e:40    0 [.P....]   0.000   (0x12f49a16)
01:00:5e:00:00:01   -1 [.P....]   0.000   (0xb48493a1)
33:33:ff:00:00:00   -1 [.P....]   0.000   (0xb48493a1)
2a:1b:08:b6:0e:40   11 [.P....]   0.000   (0x8b8b19a5)
33:33:ff:b6:0e:40   -1 [.P....]   0.000   (0xb48493a1)
33:33:00:00:00:01   -1 [.P....]   0.000   (0xb48493a1)

```
### wap13
```shell
System Information
====================
NAME="OpenWrt"
VERSION="24.10-SNAPSHOT"
ID="openwrt"
ID_LIKE="lede openwrt"
PRETTY_NAME="OpenWrt 24.10-SNAPSHOT"
VERSION_ID="24.10-snapshot"
HOME_URL="https://openwrt.org/"
BUG_URL="https://bugs.openwrt.org/"
SUPPORT_URL="https://forum.openwrt.org/"
BUILD_ID="r0-e6677e14"
OPENWRT_BOARD="ramips/mt7621"
OPENWRT_ARCH="mipsel_24kc"
OPENWRT_TAINTS="no-all"
OPENWRT_DEVICE_MANUFACTURER="OpenWrt"
OPENWRT_DEVICE_MANUFACTURER_URL="https://openwrt.org/"
OPENWRT_DEVICE_PRODUCT="Generic"
OPENWRT_DEVICE_REVISION="v0"
OPENWRT_RELEASE="OpenWrt 24.10-SNAPSHOT r0-e6677e14"
OPENWRT_BUILD_DATE="1750175455"
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣀⣀⣤⣀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣀⣠⣀⣀⡀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣠⣾⣿⣿⣿⣿⣿⣿⣆⠀⢀⣀⣀⣤⣤⣤⣦⣦⣤⣤⣄⣀⣀⠀⢠⣾⣿⣿⣿⣿⣿⣷⣦⡀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣰⣿⣿⣿⣿⣿⣿⣿⣿⡿⠟⠛⠉⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠙⠛⠿⣿⣿⣿⣿⣿⣿⣿⣿⣷⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣿⣿⣿⣿⣿⣿⣿⠟⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠙⢿⣿⣿⣿⣿⣿⣿⡇⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⢻⣿⣿⣿⣿⡟⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠙⣿⣿⣿⣿⣿⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠻⢿⣿⠟⠀⠀⠀⠀⠀⣀⣤⣤⣤⡀⠀⠀⠀⠀⠀⢀⣤⣤⣤⣄⡀⠀⠀⠀⠀⠘⣿⡿⠿⠃⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⢠⡟⠀⠀⠀⠀⣠⣾⣿⣿⣟⣿⡇⠀⠀⠀⠀⠀⢸⣿⣿⣻⣿⣿⣦⠀⠀⠀⠀⠸⣧⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣼⠁⠀⠀⠀⠀⣿⣿⣿⣿⣿⡟⢠⣶⣾⣿⣿⣷⣤⢽⣿⣿⣿⣿⣿⡇⠀⠀⣀⣤⣿⣷⣴⣶⣦⣀⡀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⢀⣠⣤⣤⣠⣇⠀⠀⠀⠀⠀⣿⣿⣿⣿⣿⠀⠘⠻⣿⣿⣿⡿⠋⠀⢹⣿⣿⣿⣿⡇⠀⣿⣿⣿⡏⢹⣿⠉⣿⣿⣿⣷⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⢠⣾⣿⣿⣿⣿⣿⣿⣿⣶⣄⠀⠀⠹⣿⣿⠿⠋⠀⢤⣀⢀⣼⡄⠀⣠⠀⠈⠻⣿⣿⠟⠀⢸⣿⣇⣽⣿⠿⠿⠿⣿⣅⣽⣿⡇⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣆⠀⠀⠀⠀⠀⠀⠀⠀⠈⠉⠁⠉⠉⠀⠀⠀⠀⠀⠀⠀⠀⠈⣿⣿⣟⠁⠀⠀⠀⠈⣿⣿⣿⡇⠀⠀⠀⠀⢀
⠛⠛⠛⠛⠛⠛⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛
⠀⠀⠀⠀⠀⠀⠘⠛⠻⢿⣿⣿⣿⣿⣿⠟⠛⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠀⠈⠉⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀

UB-EDGE - 2025-06-17 - 6a5e2b7
Linux f44d5cfe5164 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips GNU/Linux
Network Configuration
======================
1: lo: <LOOPBACK,UP,LOWER_UP> mtu 65536 state UNKNOWN qlen 1000
    inet6 ::1/128 scope host proto kernel_lo 
       valid_lft forever preferred_lft forever
2: eth0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1540 state UP qlen 1000
    inet6 fe80::f64d:5cff:fefe:5164/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
3: lan@eth0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1536 state UP qlen 1000
    inet6 fe80::f64d:5cff:fefe:5164/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
9: up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::1487:5fff:fe85:10d4/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
10: up0v11@up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::1487:5fff:fe85:10d4/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
11: up1v12@up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::1487:5fff:fe85:10d4/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
12: up2v3@up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fd42:dead:c0de:1337:0:f44d:5cfe:5164/64 scope global 
       valid_lft forever preferred_lft forever
    inet6 fe80::1487:5fff:fe85:10d4/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
13: batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UNKNOWN qlen 1000
    inet6 fe80::1487:5fff:fe85:10d4/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
14: batman.11@batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::1487:5fff:fe85:10d4/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
15: batman.12@batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::1487:5fff:fe85:10d4/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
16: batman.3@batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::1487:5fff:fe85:10d4/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
18: phy0-mesh0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1532 state UP qlen 1000
    inet6 fe80::f04d:5cff:fefe:5165/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
21: phy1-mesh0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1532 state UP qlen 1000
    inet6 fe80::f04d:5cff:fefe:5166/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
fd42:dead:c0de:1337::/64 dev up2v3 proto static metric 5 pref medium
unreachable fd8f:c0e4:d8d4::/48 dev lo proto static metric 2147483647 pref medium
fe80::/64 dev eth0 proto kernel metric 256 pref medium
fe80::/64 dev batman proto kernel metric 256 pref medium
fe80::/64 dev batman.11 proto kernel metric 256 pref medium
fe80::/64 dev up proto kernel metric 256 pref medium
fe80::/64 dev up0v11 proto kernel metric 256 pref medium
fe80::/64 dev up1v12 proto kernel metric 256 pref medium
fe80::/64 dev up2v3 proto kernel metric 256 pref medium
fe80::/64 dev batman.12 proto kernel metric 256 pref medium
fe80::/64 dev batman.3 proto kernel metric 256 pref medium
fe80::/64 dev lan proto kernel metric 256 pref medium
fe80::/64 dev phy0-mesh0 proto kernel metric 256 pref medium
fe80::/64 dev phy1-mesh0 proto kernel metric 256 pref medium
Speed Test Report
==================
Test Started at Wed Jun 18 15:45:07 UTC 2025
Running iperf3 (Upload) test to fd42:dead:c0de:1337::1
iperf 3.17.1
Linux f44d5cfe5164 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips
Control connection MSS 1368
Time: Wed, 18 Jun 2025 15:45:07 UTC
Connecting to host fd42:dead:c0de:1337::1, port 5201
      Cookie: 3y66molkcwox7dey2c35tkdnsmgulacutnmi
      TCP MSS: 1368 (default)
[  5] local fd42:dead:c0de:1337:0:f44d:5cfe:5164 port 34206 connected to fd42:dead:c0de:1337::1 port 5201
Starting Test: protocol: TCP, 1 streams, 131072 byte blocks, omitting 0 seconds, 10 second test, tos 0
[ ID] Interval           Transfer     Bitrate         Retr  Cwnd
[  5]   0.00-1.00   sec  18.2 MBytes   153 Mbits/sec    0    898 KBytes       
[  5]   1.00-2.00   sec  17.2 MBytes   145 Mbits/sec    0   1.25 MBytes       
[  5]   2.00-3.00   sec  17.9 MBytes   150 Mbits/sec    0   1.25 MBytes       
[  5]   3.00-4.00   sec  18.0 MBytes   151 Mbits/sec    0   1.25 MBytes       
[  5]   4.00-5.00   sec  15.9 MBytes   133 Mbits/sec    0   1.25 MBytes       
[  5]   5.00-6.00   sec  17.8 MBytes   149 Mbits/sec    0   1.25 MBytes       
[  5]   6.00-7.00   sec  17.6 MBytes   148 Mbits/sec    0   1.25 MBytes       
[  5]   7.00-8.00   sec  17.2 MBytes   145 Mbits/sec    0   1.25 MBytes       
[  5]   8.00-9.00   sec  16.2 MBytes   136 Mbits/sec    0   1.25 MBytes       
[  5]   9.00-10.00  sec  16.1 MBytes   135 Mbits/sec    0   1.25 MBytes       
- - - - - - - - - - - - - - - - - - - - - - - - -
Test Complete. Summary Results:
[ ID] Interval           Transfer     Bitrate         Retr
[  5]   0.00-10.00  sec   175 MBytes   146 Mbits/sec    0             sender
[  5]   0.00-10.04  sec   175 MBytes   146 Mbits/sec                  receiver
CPU Utilization: local/sender 76.4% (0.2%u/76.2%s), remote/receiver 72.3% (2.8%u/69.5%s)
snd_tcp_congestion cubic
rcv_tcp_congestion cubic

iperf Done.
Test Completed at Wed Jun 18 15:45:18 UTC 2025
Test iperf3 (Download) to fd42:dead:c0de:1337::1
iperf 3.17.1
Linux f44d5cfe5164 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips
Control connection MSS 1368
Time: Wed, 18 Jun 2025 15:45:18 UTC
Connecting to host fd42:dead:c0de:1337::1, port 5201
Reverse mode, remote host fd42:dead:c0de:1337::1 is sending
      Cookie: bemtu2m5aqmx32vd4bkchktyxixrse73bbzq
      TCP MSS: 1368 (default)
[  5] local fd42:dead:c0de:1337:0:f44d:5cfe:5164 port 40166 connected to fd42:dead:c0de:1337::1 port 5201
Starting Test: protocol: TCP, 1 streams, 131072 byte blocks, omitting 0 seconds, 10 second test, tos 0
[ ID] Interval           Transfer     Bitrate
[  5]   0.00-1.00   sec  16.9 MBytes   141 Mbits/sec                  
[  5]   1.00-2.00   sec  19.1 MBytes   161 Mbits/sec                  
[  5]   2.00-3.00   sec  16.9 MBytes   142 Mbits/sec                  
[  5]   3.00-4.00   sec  17.2 MBytes   145 Mbits/sec                  
[  5]   4.00-5.00   sec  15.5 MBytes   130 Mbits/sec                  
[  5]   5.00-6.00   sec  16.2 MBytes   136 Mbits/sec                  
[  5]   6.00-7.00   sec  16.6 MBytes   139 Mbits/sec                  
[  5]   7.00-8.00   sec  17.0 MBytes   143 Mbits/sec                  
[  5]   8.00-9.00   sec  18.8 MBytes   157 Mbits/sec                  
[  5]   9.00-10.00  sec  17.1 MBytes   144 Mbits/sec                  
- - - - - - - - - - - - - - - - - - - - - - - - -
Test Complete. Summary Results:
[ ID] Interval           Transfer     Bitrate         Retr
[  5]   0.00-10.01  sec   174 MBytes   146 Mbits/sec    0             sender
[  5]   0.00-10.00  sec   172 MBytes   144 Mbits/sec                  receiver
snd_tcp_congestion cubic
rcv_tcp_congestion cubic

iperf Done.
Test Completed at Wed Jun 18 15:45:28 UTC 2025
Test iperf3 (Bidirectional) to fd42:dead:c0de:1337::1
iperf 3.17.1
Linux f44d5cfe5164 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips
Control connection MSS 1368
send_parameters:
{
	"tcp":	true,
	"omit":	0,
	"time":	10,
	"num":	0,
	"blockcount":	0,
	"parallel":	1,
	"len":	131072,
	"pacing_timer":	1000,
	"client_version":	"3.17.1"
}
Time: Wed, 18 Jun 2025 15:45:28 UTC
Connecting to host fd42:dead:c0de:1337::1, port 5201
      Cookie: dx3zmfovomq5sdvz5xx6slokent57wvbjbks
      TCP MSS: 1368 (default)
SNDBUF is 16384, expecting 0
RCVBUF is 131072, expecting 0
Congestion algorithm is cubic
[  5] local fd42:dead:c0de:1337:0:f44d:5cfe:5164 port 57452 connected to fd42:dead:c0de:1337::1 port 5201
Starting Test: protocol: TCP, 1 streams, 131072 byte blocks, omitting 0 seconds, 10 second test, tos 0
Thread FD 5 created
All threads created
sent 131072 bytes of 131072, pending 0, total 131072
sent 131072 bytes of 131072, pending 0, total 262144
sent 131072 bytes of 131072, pending 0, total 393216
sent 131072 bytes of 131072, pending 0, total 524288
sent 131072 bytes of 131072, pending 0, total 655360
sent 131072 bytes of 131072, pending 0, total 786432
sent 131072 bytes of 131072, pending 0, total 917504
sent 131072 bytes of 131072, pending 0, total 1048576
sent 131072 bytes of 131072, pending 0, total 1179648
sent 131072 bytes of 131072, pending 0, total 1310720
sent 131072 bytes of 131072, pending 0, total 1441792
sent 131072 bytes of 131072, pending 0, total 1572864
sent 131072 bytes of 131072, pending 0, total 1703936
sent 131072 bytes of 131072, pending 0, total 1835008
sent 131072 bytes of 131072, pending 0, total 1966080
sent 131072 bytes of 131072, pending 0, total 2097152
sent 131072 bytes of 131072, pending 0, total 2228224
sent 131072 bytes of 131072, pending 0, total 2359296
sent 131072 bytes of 131072, pending 0, total 2490368
sent 131072 bytes of 131072, pending 0, total 2621440
sent 131072 bytes of 131072, pending 0, total 2752512
sent 131072 bytes of 131072, pending 0, total 2883584
sent 131072 bytes of 131072, pending 0, total 3014656
sent 131072 bytes of 131072, pending 0, total 3145728
sent 131072 bytes of 131072, pending 0, total 3276800
sent 131072 bytes of 131072, pending 0, total 3407872
sent 131072 bytes of 131072, pending 0, total 3538944
sent 131072 bytes of 131072, pending 0, total 3670016
sent 131072 bytes of 131072, pending 0, total 3801088
sent 131072 bytes of 131072, pending 0, total 3932160
sent 131072 bytes of 131072, pending 0, total 4063232
sent 131072 bytes of 131072, pending 0, total 4194304
sent 131072 bytes of 131072, pending 0, total 4325376
sent 131072 bytes of 131072, pending 0, total 4456448
sent 131072 bytes of 131072, pending 0, total 4587520
sent 131072 bytes of 131072, pending 0, total 4718592
sent 131072 bytes of 131072, pending 0, total 4849664
sent 131072 bytes of 131072, pending 0, total 4980736
sent 131072 bytes of 131072, pending 0, total 5111808
sent 131072 bytes of 131072, pending 0, total 5242880
sent 131072 bytes of 131072, pending 0, total 5373952
sent 131072 bytes of 131072, pending 0, total 5505024
sent 131072 bytes of 131072, pending 0, total 5636096
sent 131072 bytes of 131072, pending 0, total 5767168
sent 131072 bytes of 131072, pending 0, total 5898240
sent 131072 bytes of 131072, pending 0, total 6029312
sent 131072 bytes of 131072, pending 0, total 6160384
sent 131072 bytes of 131072, pending 0, total 6291456
sent 131072 bytes of 131072, pending 0, total 6422528
sent 131072 bytes of 131072, pending 0, total 6553600
sent 131072 bytes of 131072, pending 0, total 6684672
sent 131072 bytes of 131072, pending 0, total 6815744
sent 131072 bytes of 131072, pending 0, total 6946816
sent 131072 bytes of 131072, pending 0, total 7077888
sent 131072 bytes of 131072, pending 0, total 7208960
sent 131072 bytes of 131072, pending 0, total 7340032
sent 131072 bytes of 131072, pending 0, total 7471104
sent 131072 bytes of 131072, pending 0, total 7602176
sent 131072 bytes of 131072, pending 0, total 7733248
sent 131072 bytes of 131072, pending 0, total 7864320
sent 131072 bytes of 131072, pending 0, total 7995392
sent 131072 bytes of 131072, pending 0, total 8126464
sent 131072 bytes of 131072, pending 0, total 8257536
sent 131072 bytes of 131072, pending 0, total 8388608
sent 131072 bytes of 131072, pending 0, total 8519680
sent 131072 bytes of 131072, pending 0, total 8650752
sent 131072 bytes of 131072, pending 0, total 8781824
sent 131072 bytes of 131072, pending 0, total 8912896
sent 131072 bytes of 131072, pending 0, total 9043968
sent 131072 bytes of 131072, pending 0, total 9175040
sent 131072 bytes of 131072, pending 0, total 9306112
sent 131072 bytes of 131072, pending 0, total 9437184
sent 131072 bytes of 131072, pending 0, total 9568256
sent 131072 bytes of 131072, pending 0, total 9699328
sent 131072 bytes of 131072, pending 0, total 9830400
sent 131072 bytes of 131072, pending 0, total 9961472
sent 131072 bytes of 131072, pending 0, total 10092544
sent 131072 bytes of 131072, pending 0, total 10223616
sent 131072 bytes of 131072, pending 0, total 10354688
sent 131072 bytes of 131072, pending 0, total 10485760
sent 131072 bytes of 131072, pending 0, total 10616832
sent 131072 bytes of 131072, pending 0, total 10747904
sent 131072 bytes of 131072, pending 0, total 10878976
sent 131072 bytes of 131072, pending 0, total 11010048
sent 131072 bytes of 131072, pending 0, total 11141120
sent 131072 bytes of 131072, pending 0, total 11272192
sent 131072 bytes of 131072, pending 0, total 11403264
sent 131072 bytes of 131072, pending 0, total 11534336
sent 131072 bytes of 131072, pending 0, total 11665408
sent 131072 bytes of 131072, pending 0, total 11796480
sent 131072 bytes of 131072, pending 0, total 11927552
sent 131072 bytes of 131072, pending 0, total 12058624
sent 131072 bytes of 131072, pending 0, total 12189696
sent 131072 bytes of 131072, pending 0, total 12320768
sent 131072 bytes of 131072, pending 0, total 12451840
sent 131072 bytes of 131072, pending 0, total 12582912
sent 131072 bytes of 131072, pending 0, total 12713984
sent 131072 bytes of 131072, pending 0, total 12845056
sent 131072 bytes of 131072, pending 0, total 12976128
sent 131072 bytes of 131072, pending 0, total 13107200
sent 131072 bytes of 131072, pending 0, total 13238272
sent 131072 bytes of 131072, pending 0, total 13369344
sent 131072 bytes of 131072, pending 0, total 13500416
sent 131072 bytes of 131072, pending 0, total 13631488
sent 131072 bytes of 131072, pending 0, total 13762560
sent 131072 bytes of 131072, pending 0, total 13893632
sent 131072 bytes of 131072, pending 0, total 14024704
sent 131072 bytes of 131072, pending 0, total 14155776
sent 131072 bytes of 131072, pending 0, total 14286848
sent 131072 bytes of 131072, pending 0, total 14417920
sent 131072 bytes of 131072, pending 0, total 14548992
sent 131072 bytes of 131072, pending 0, total 14680064
sent 131072 bytes of 131072, pending 0, total 14811136
sent 131072 bytes of 131072, pending 0, total 14942208
sent 131072 bytes of 131072, pending 0, total 15073280
sent 131072 bytes of 131072, pending 0, total 15204352
sent 131072 bytes of 131072, pending 0, total 15335424
sent 131072 bytes of 131072, pending 0, total 15466496
sent 131072 bytes of 131072, pending 0, total 15597568
sent 131072 bytes of 131072, pending 0, total 15728640
sent 131072 bytes of 131072, pending 0, total 15859712
sent 131072 bytes of 131072, pending 0, total 15990784
sent 131072 bytes of 131072, pending 0, total 16121856
sent 131072 bytes of 131072, pending 0, total 16252928
sent 131072 bytes of 131072, pending 0, total 16384000
sent 131072 bytes of 131072, pending 0, total 16515072
sent 131072 bytes of 131072, pending 0, total 16646144
sent 131072 bytes of 131072, pending 0, total 16777216
sent 131072 bytes of 131072, pending 0, total 16908288
sent 131072 bytes of 131072, pending 0, total 17039360
sent 131072 bytes of 131072, pending 0, total 17170432
sent 131072 bytes of 131072, pending 0, total 17301504
sent 131072 bytes of 131072, pending 0, total 17432576
sent 131072 bytes of 131072, pending 0, total 17563648
sent 131072 bytes of 131072, pending 0, total 17694720
sent 131072 bytes of 131072, pending 0, total 17825792
sent 131072 bytes of 131072, pending 0, total 17956864
sent 131072 bytes of 131072, pending 0, total 18087936
sent 131072 bytes of 131072, pending 0, total 18219008
sent 131072 bytes of 131072, pending 0, total 18350080
sent 131072 bytes of 131072, pending 0, total 18481152
sent 131072 bytes of 131072, pending 0, total 18612224
sent 131072 bytes of 131072, pending 0, total 18743296
sent 131072 bytes of 131072, pending 0, total 18874368
sent 131072 bytes of 131072, pending 0, total 19005440
sent 131072 bytes of 131072, pending 0, total 19136512
tcpi_snd_cwnd 655 tcpi_snd_mss 1368 tcpi_rtt 48537
interval_len 1.001607 bytes_transferred 19136512
interval forces keep
[ ID] Interval           Transfer     Bitrate         Retr  Cwnd
[  5]   0.00-1.00   sec  18.2 MBytes   153 Mbits/sec    0    875 KBytes       
sent 131072 bytes of 131072, pending 0, total 19267584
sent 131072 bytes of 131072, pending 0, total 19398656
sent 131072 bytes of 131072, pending 0, total 19529728
sent 131072 bytes of 131072, pending 0, total 19660800
sent 131072 bytes of 131072, pending 0, total 19791872
sent 131072 bytes of 131072, pending 0, total 19922944
sent 131072 bytes of 131072, pending 0, total 20054016
sent 131072 bytes of 131072, pending 0, total 20185088
sent 131072 bytes of 131072, pending 0, total 20316160
sent 131072 bytes of 131072, pending 0, total 20447232
sent 131072 bytes of 131072, pending 0, total 20578304
sent 131072 bytes of 131072, pending 0, total 20709376
sent 131072 bytes of 131072, pending 0, total 20840448
sent 131072 bytes of 131072, pending 0, total 20971520
sent 131072 bytes of 131072, pending 0, total 21102592
sent 131072 bytes of 131072, pending 0, total 21233664
sent 131072 bytes of 131072, pending 0, total 21364736
sent 131072 bytes of 131072, pending 0, total 21495808
sent 131072 bytes of 131072, pending 0, total 21626880
sent 131072 bytes of 131072, pending 0, total 21757952
sent 131072 bytes of 131072, pending 0, total 21889024
sent 131072 bytes of 131072, pending 0, total 22020096
sent 131072 bytes of 131072, pending 0, total 22151168
sent 131072 bytes of 131072, pending 0, total 22282240
sent 131072 bytes of 131072, pending 0, total 22413312
sent 131072 bytes of 131072, pending 0, total 22544384
sent 131072 bytes of 131072, pending 0, total 22675456
sent 131072 bytes of 131072, pending 0, total 22806528
sent 131072 bytes of 131072, pending 0, total 22937600
sent 131072 bytes of 131072, pending 0, total 23068672
sent 131072 bytes of 131072, pending 0, total 23199744
sent 131072 bytes of 131072, pending 0, total 23330816
sent 131072 bytes of 131072, pending 0, total 23461888
sent 131072 bytes of 131072, pending 0, total 23592960
sent 131072 bytes of 131072, pending 0, total 23724032
sent 131072 bytes of 131072, pending 0, total 23855104
sent 131072 bytes of 131072, pending 0, total 23986176
sent 131072 bytes of 131072, pending 0, total 24117248
sent 131072 bytes of 131072, pending 0, total 24248320
sent 131072 bytes of 131072, pending 0, total 24379392
sent 131072 bytes of 131072, pending 0, total 24510464
sent 131072 bytes of 131072, pending 0, total 24641536
sent 131072 bytes of 131072, pending 0, total 24772608
sent 131072 bytes of 131072, pending 0, total 24903680
sent 131072 bytes of 131072, pending 0, total 25034752
sent 131072 bytes of 131072, pending 0, total 25165824
sent 131072 bytes of 131072, pending 0, total 25296896
sent 131072 bytes of 131072, pending 0, total 25427968
sent 131072 bytes of 131072, pending 0, total 25559040
sent 131072 bytes of 131072, pending 0, total 25690112
sent 131072 bytes of 131072, pending 0, total 25821184
sent 131072 bytes of 131072, pending 0, total 25952256
sent 131072 bytes of 131072, pending 0, total 26083328
sent 131072 bytes of 131072, pending 0, total 26214400
sent 131072 bytes of 131072, pending 0, total 26345472
sent 131072 bytes of 131072, pending 0, total 26476544
sent 131072 bytes of 131072, pending 0, total 26607616
sent 131072 bytes of 131072, pending 0, total 26738688
sent 131072 bytes of 131072, pending 0, total 26869760
sent 131072 bytes of 131072, pending 0, total 27000832
sent 131072 bytes of 131072, pending 0, total 27131904
sent 131072 bytes of 131072, pending 0, total 27262976
sent 131072 bytes of 131072, pending 0, total 27394048
sent 131072 bytes of 131072, pending 0, total 27525120
sent 131072 bytes of 131072, pending 0, total 27656192
sent 131072 bytes of 131072, pending 0, total 27787264
sent 131072 bytes of 131072, pending 0, total 27918336
sent 131072 bytes of 131072, pending 0, total 28049408
sent 131072 bytes of 131072, pending 0, total 28180480
sent 131072 bytes of 131072, pending 0, total 28311552
sent 131072 bytes of 131072, pending 0, total 28442624
sent 131072 bytes of 131072, pending 0, total 28573696
sent 131072 bytes of 131072, pending 0, total 28704768
sent 131072 bytes of 131072, pending 0, total 28835840
sent 131072 bytes of 131072, pending 0, total 28966912
sent 131072 bytes of 131072, pending 0, total 29097984
sent 131072 bytes of 131072, pending 0, total 29229056
sent 131072 bytes of 131072, pending 0, total 29360128
sent 131072 bytes of 131072, pending 0, total 29491200
sent 131072 bytes of 131072, pending 0, total 29622272
sent 131072 bytes of 131072, pending 0, total 29753344
sent 131072 bytes of 131072, pending 0, total 29884416
sent 131072 bytes of 131072, pending 0, total 30015488
sent 131072 bytes of 131072, pending 0, total 30146560
sent 131072 bytes of 131072, pending 0, total 30277632
sent 131072 bytes of 131072, pending 0, total 30408704
sent 131072 bytes of 131072, pending 0, total 30539776
sent 131072 bytes of 131072, pending 0, total 30670848
sent 131072 bytes of 131072, pending 0, total 30801920
sent 131072 bytes of 131072, pending 0, total 30932992
sent 131072 bytes of 131072, pending 0, total 31064064
sent 131072 bytes of 131072, pending 0, total 31195136
sent 131072 bytes of 131072, pending 0, total 31326208
sent 131072 bytes of 131072, pending 0, total 31457280
sent 131072 bytes of 131072, pending 0, total 31588352
sent 131072 bytes of 131072, pending 0, total 31719424
sent 131072 bytes of 131072, pending 0, total 31850496
sent 131072 bytes of 131072, pending 0, total 31981568
sent 131072 bytes of 131072, pending 0, total 32112640
sent 131072 bytes of 131072, pending 0, total 32243712
sent 131072 bytes of 131072, pending 0, total 32374784
sent 131072 bytes of 131072, pending 0, total 32505856
sent 131072 bytes of 131072, pending 0, total 32636928
sent 131072 bytes of 131072, pending 0, total 32768000
sent 131072 bytes of 131072, pending 0, total 32899072
sent 131072 bytes of 131072, pending 0, total 33030144
sent 131072 bytes of 131072, pending 0, total 33161216
sent 131072 bytes of 131072, pending 0, total 33292288
sent 131072 bytes of 131072, pending 0, total 33423360
sent 131072 bytes of 131072, pending 0, total 33554432
sent 131072 bytes of 131072, pending 0, total 33685504
sent 131072 bytes of 131072, pending 0, total 33816576
sent 131072 bytes of 131072, pending 0, total 33947648
sent 131072 bytes of 131072, pending 0, total 34078720
sent 131072 bytes of 131072, pending 0, total 34209792
sent 131072 bytes of 131072, pending 0, total 34340864
sent 131072 bytes of 131072, pending 0, total 34471936
sent 131072 bytes of 131072, pending 0, total 34603008
sent 131072 bytes of 131072, pending 0, total 34734080
sent 131072 bytes of 131072, pending 0, total 34865152
sent 131072 bytes of 131072, pending 0, total 34996224
sent 131072 bytes of 131072, pending 0, total 35127296
sent 131072 bytes of 131072, pending 0, total 35258368
sent 131072 bytes of 131072, pending 0, total 35389440
sent 131072 bytes of 131072, pending 0, total 35520512
sent 131072 bytes of 131072, pending 0, total 35651584
sent 131072 bytes of 131072, pending 0, total 35782656
sent 131072 bytes of 131072, pending 0, total 35913728
sent 131072 bytes of 131072, pending 0, total 36044800
sent 131072 bytes of 131072, pending 0, total 36175872
sent 131072 bytes of 131072, pending 0, total 36306944
sent 131072 bytes of 131072, pending 0, total 36438016
sent 131072 bytes of 131072, pending 0, total 36569088
sent 131072 bytes of 131072, pending 0, total 36700160
sent 131072 bytes of 131072, pending 0, total 36831232
sent 131072 bytes of 131072, pending 0, total 36962304
sent 131072 bytes of 131072, pending 0, total 37093376
tcpi_snd_cwnd 958 tcpi_snd_mss 1368 tcpi_rtt 66982
interval_len 0.999915 bytes_transferred 17694720
interval forces keep
[  5]   1.00-2.00   sec  16.9 MBytes   142 Mbits/sec    0   1.25 MBytes       
sent 131072 bytes of 131072, pending 0, total 37224448
sent 131072 bytes of 131072, pending 0, total 37355520
sent 131072 bytes of 131072, pending 0, total 37486592
sent 131072 bytes of 131072, pending 0, total 37617664
sent 131072 bytes of 131072, pending 0, total 37748736
sent 131072 bytes of 131072, pending 0, total 37879808
sent 131072 bytes of 131072, pending 0, total 38010880
sent 131072 bytes of 131072, pending 0, total 38141952
sent 131072 bytes of 131072, pending 0, total 38273024
sent 131072 bytes of 131072, pending 0, total 38404096
sent 131072 bytes of 131072, pending 0, total 38535168
sent 131072 bytes of 131072, pending 0, total 38666240
sent 131072 bytes of 131072, pending 0, total 38797312
sent 131072 bytes of 131072, pending 0, total 38928384
sent 131072 bytes of 131072, pending 0, total 39059456
sent 131072 bytes of 131072, pending 0, total 39190528
sent 131072 bytes of 131072, pending 0, total 39321600
sent 131072 bytes of 131072, pending 0, total 39452672
sent 131072 bytes of 131072, pending 0, total 39583744
sent 131072 bytes of 131072, pending 0, total 39714816
sent 131072 bytes of 131072, pending 0, total 39845888
sent 131072 bytes of 131072, pending 0, total 39976960
sent 131072 bytes of 131072, pending 0, total 40108032
sent 131072 bytes of 131072, pending 0, total 40239104
sent 131072 bytes of 131072, pending 0, total 40370176
sent 131072 bytes of 131072, pending 0, total 40501248
sent 131072 bytes of 131072, pending 0, total 40632320
sent 131072 bytes of 131072, pending 0, total 40763392
sent 131072 bytes of 131072, pending 0, total 40894464
sent 131072 bytes of 131072, pending 0, total 41025536
sent 131072 bytes of 131072, pending 0, total 41156608
sent 131072 bytes of 131072, pending 0, total 41287680
sent 131072 bytes of 131072, pending 0, total 41418752
sent 131072 bytes of 131072, pending 0, total 41549824
sent 131072 bytes of 131072, pending 0, total 41680896
sent 131072 bytes of 131072, pending 0, total 41811968
sent 131072 bytes of 131072, pending 0, total 41943040
sent 131072 bytes of 131072, pending 0, total 42074112
sent 131072 bytes of 131072, pending 0, total 42205184
sent 131072 bytes of 131072, pending 0, total 42336256
sent 131072 bytes of 131072, pending 0, total 42467328
sent 131072 bytes of 131072, pending 0, total 42598400
sent 131072 bytes of 131072, pending 0, total 42729472
sent 131072 bytes of 131072, pending 0, total 42860544
sent 131072 bytes of 131072, pending 0, total 42991616
sent 131072 bytes of 131072, pending 0, total 43122688
sent 131072 bytes of 131072, pending 0, total 43253760
sent 131072 bytes of 131072, pending 0, total 43384832
sent 131072 bytes of 131072, pending 0, total 43515904
sent 131072 bytes of 131072, pending 0, total 43646976
sent 131072 bytes of 131072, pending 0, total 43778048
sent 131072 bytes of 131072, pending 0, total 43909120
sent 131072 bytes of 131072, pending 0, total 44040192
sent 131072 bytes of 131072, pending 0, total 44171264
sent 131072 bytes of 131072, pending 0, total 44302336
sent 131072 bytes of 131072, pending 0, total 44433408
sent 131072 bytes of 131072, pending 0, total 44564480
sent 131072 bytes of 131072, pending 0, total 44695552
sent 131072 bytes of 131072, pending 0, total 44826624
sent 131072 bytes of 131072, pending 0, total 44957696
sent 131072 bytes of 131072, pending 0, total 45088768
sent 131072 bytes of 131072, pending 0, total 45219840
sent 131072 bytes of 131072, pending 0, total 45350912
sent 131072 bytes of 131072, pending 0, total 45481984
sent 131072 bytes of 131072, pending 0, total 45613056
sent 131072 bytes of 131072, pending 0, total 45744128
sent 131072 bytes of 131072, pending 0, total 45875200
sent 131072 bytes of 131072, pending 0, total 46006272
sent 131072 bytes of 131072, pending 0, total 46137344
sent 131072 bytes of 131072, pending 0, total 46268416
sent 131072 bytes of 131072, pending 0, total 46399488
sent 131072 bytes of 131072, pending 0, total 46530560
sent 131072 bytes of 131072, pending 0, total 46661632
sent 131072 bytes of 131072, pending 0, total 46792704
sent 131072 bytes of 131072, pending 0, total 46923776
sent 131072 bytes of 131072, pending 0, total 47054848
sent 131072 bytes of 131072, pending 0, total 47185920
sent 131072 bytes of 131072, pending 0, total 47316992
sent 131072 bytes of 131072, pending 0, total 47448064
sent 131072 bytes of 131072, pending 0, total 47579136
sent 131072 bytes of 131072, pending 0, total 47710208
sent 131072 bytes of 131072, pending 0, total 47841280
sent 131072 bytes of 131072, pending 0, total 47972352
sent 131072 bytes of 131072, pending 0, total 48103424
sent 131072 bytes of 131072, pending 0, total 48234496
sent 131072 bytes of 131072, pending 0, total 48365568
sent 131072 bytes of 131072, pending 0, total 48496640
sent 131072 bytes of 131072, pending 0, total 48627712
sent 131072 bytes of 131072, pending 0, total 48758784
sent 131072 bytes of 131072, pending 0, total 48889856
sent 131072 bytes of 131072, pending 0, total 49020928
sent 131072 bytes of 131072, pending 0, total 49152000
sent 131072 bytes of 131072, pending 0, total 49283072
sent 131072 bytes of 131072, pending 0, total 49414144
sent 131072 bytes of 131072, pending 0, total 49545216
sent 131072 bytes of 131072, pending 0, total 49676288
sent 131072 bytes of 131072, pending 0, total 49807360
sent 131072 bytes of 131072, pending 0, total 49938432
sent 131072 bytes of 131072, pending 0, total 50069504
sent 131072 bytes of 131072, pending 0, total 50200576
sent 131072 bytes of 131072, pending 0, total 50331648
sent 131072 bytes of 131072, pending 0, total 50462720
sent 131072 bytes of 131072, pending 0, total 50593792
sent 131072 bytes of 131072, pending 0, total 50724864
sent 131072 bytes of 131072, pending 0, total 50855936
sent 131072 bytes of 131072, pending 0, total 50987008
sent 131072 bytes of 131072, pending 0, total 51118080
sent 131072 bytes of 131072, pending 0, total 51249152
sent 131072 bytes of 131072, pending 0, total 51380224
sent 131072 bytes of 131072, pending 0, total 51511296
sent 131072 bytes of 131072, pending 0, total 51642368
sent 131072 bytes of 131072, pending 0, total 51773440
sent 131072 bytes of 131072, pending 0, total 51904512
sent 131072 bytes of 131072, pending 0, total 52035584
sent 131072 bytes of 131072, pending 0, total 52166656
sent 131072 bytes of 131072, pending 0, total 52297728
sent 131072 bytes of 131072, pending 0, total 52428800
sent 131072 bytes of 131072, pending 0, total 52559872
sent 131072 bytes of 131072, pending 0, total 52690944
sent 131072 bytes of 131072, pending 0, total 52822016
sent 131072 bytes of 131072, pending 0, total 52953088
sent 131072 bytes of 131072, pending 0, total 53084160
sent 131072 bytes of 131072, pending 0, total 53215232
sent 131072 bytes of 131072, pending 0, total 53346304
sent 131072 bytes of 131072, pending 0, total 53477376
sent 131072 bytes of 131072, pending 0, total 53608448
sent 131072 bytes of 131072, pending 0, total 53739520
sent 131072 bytes of 131072, pending 0, total 53870592
sent 131072 bytes of 131072, pending 0, total 54001664
tcpi_snd_cwnd 958 tcpi_snd_mss 1368 tcpi_rtt 65700
interval_len 0.999598 bytes_transferred 16777216
interval forces keep
[  5]   2.00-3.00   sec  16.0 MBytes   134 Mbits/sec    0   1.25 MBytes       
sent 131072 bytes of 131072, pending 0, total 54132736
sent 131072 bytes of 131072, pending 0, total 54263808
sent 131072 bytes of 131072, pending 0, total 54394880
sent 131072 bytes of 131072, pending 0, total 54525952
sent 131072 bytes of 131072, pending 0, total 54657024
sent 131072 bytes of 131072, pending 0, total 54788096
sent 131072 bytes of 131072, pending 0, total 54919168
sent 131072 bytes of 131072, pending 0, total 55050240
sent 131072 bytes of 131072, pending 0, total 55181312
sent 131072 bytes of 131072, pending 0, total 55312384
sent 131072 bytes of 131072, pending 0, total 55443456
sent 131072 bytes of 131072, pending 0, total 55574528
sent 131072 bytes of 131072, pending 0, total 55705600
sent 131072 bytes of 131072, pending 0, total 55836672
sent 131072 bytes of 131072, pending 0, total 55967744
sent 131072 bytes of 131072, pending 0, total 56098816
sent 131072 bytes of 131072, pending 0, total 56229888
sent 131072 bytes of 131072, pending 0, total 56360960
sent 131072 bytes of 131072, pending 0, total 56492032
sent 131072 bytes of 131072, pending 0, total 56623104
sent 131072 bytes of 131072, pending 0, total 56754176
sent 131072 bytes of 131072, pending 0, total 56885248
sent 131072 bytes of 131072, pending 0, total 57016320
sent 131072 bytes of 131072, pending 0, total 57147392
sent 131072 bytes of 131072, pending 0, total 57278464
sent 131072 bytes of 131072, pending 0, total 57409536
sent 131072 bytes of 131072, pending 0, total 57540608
sent 131072 bytes of 131072, pending 0, total 57671680
sent 131072 bytes of 131072, pending 0, total 57802752
sent 131072 bytes of 131072, pending 0, total 57933824
sent 131072 bytes of 131072, pending 0, total 58064896
sent 131072 bytes of 131072, pending 0, total 58195968
sent 131072 bytes of 131072, pending 0, total 58327040
sent 131072 bytes of 131072, pending 0, total 58458112
sent 131072 bytes of 131072, pending 0, total 58589184
sent 131072 bytes of 131072, pending 0, total 58720256
sent 131072 bytes of 131072, pending 0, total 58851328
sent 131072 bytes of 131072, pending 0, total 58982400
sent 131072 bytes of 131072, pending 0, total 59113472
sent 131072 bytes of 131072, pending 0, total 59244544
sent 131072 bytes of 131072, pending 0, total 59375616
sent 131072 bytes of 131072, pending 0, total 59506688
sent 131072 bytes of 131072, pending 0, total 59637760
sent 131072 bytes of 131072, pending 0, total 59768832
sent 131072 bytes of 131072, pending 0, total 59899904
sent 131072 bytes of 131072, pending 0, total 60030976
sent 131072 bytes of 131072, pending 0, total 60162048
sent 131072 bytes of 131072, pending 0, total 60293120
sent 131072 bytes of 131072, pending 0, total 60424192
sent 131072 bytes of 131072, pending 0, total 60555264
sent 131072 bytes of 131072, pending 0, total 60686336
sent 131072 bytes of 131072, pending 0, total 60817408
sent 131072 bytes of 131072, pending 0, total 60948480
sent 131072 bytes of 131072, pending 0, total 61079552
sent 131072 bytes of 131072, pending 0, total 61210624
sent 131072 bytes of 131072, pending 0, total 61341696
sent 131072 bytes of 131072, pending 0, total 61472768
sent 131072 bytes of 131072, pending 0, total 61603840
sent 131072 bytes of 131072, pending 0, total 61734912
sent 131072 bytes of 131072, pending 0, total 61865984
sent 131072 bytes of 131072, pending 0, total 61997056
sent 131072 bytes of 131072, pending 0, total 62128128
sent 131072 bytes of 131072, pending 0, total 62259200
sent 131072 bytes of 131072, pending 0, total 62390272
sent 131072 bytes of 131072, pending 0, total 62521344
sent 131072 bytes of 131072, pending 0, total 62652416
sent 131072 bytes of 131072, pending 0, total 62783488
sent 131072 bytes of 131072, pending 0, total 62914560
sent 131072 bytes of 131072, pending 0, total 63045632
sent 131072 bytes of 131072, pending 0, total 63176704
sent 131072 bytes of 131072, pending 0, total 63307776
sent 131072 bytes of 131072, pending 0, total 63438848
sent 131072 bytes of 131072, pending 0, total 63569920
sent 131072 bytes of 131072, pending 0, total 63700992
sent 131072 bytes of 131072, pending 0, total 63832064
sent 131072 bytes of 131072, pending 0, total 63963136
sent 131072 bytes of 131072, pending 0, total 64094208
sent 131072 bytes of 131072, pending 0, total 64225280
sent 131072 bytes of 131072, pending 0, total 64356352
sent 131072 bytes of 131072, pending 0, total 64487424
sent 131072 bytes of 131072, pending 0, total 64618496
sent 131072 bytes of 131072, pending 0, total 64749568
sent 131072 bytes of 131072, pending 0, total 64880640
sent 131072 bytes of 131072, pending 0, total 65011712
sent 131072 bytes of 131072, pending 0, total 65142784
sent 131072 bytes of 131072, pending 0, total 65273856
sent 131072 bytes of 131072, pending 0, total 65404928
sent 131072 bytes of 131072, pending 0, total 65536000
sent 131072 bytes of 131072, pending 0, total 65667072
sent 131072 bytes of 131072, pending 0, total 65798144
sent 131072 bytes of 131072, pending 0, total 65929216
sent 131072 bytes of 131072, pending 0, total 66060288
sent 131072 bytes of 131072, pending 0, total 66191360
sent 131072 bytes of 131072, pending 0, total 66322432
sent 131072 bytes of 131072, pending 0, total 66453504
sent 131072 bytes of 131072, pending 0, total 66584576
sent 131072 bytes of 131072, pending 0, total 66715648
sent 131072 bytes of 131072, pending 0, total 66846720
sent 131072 bytes of 131072, pending 0, total 66977792
sent 131072 bytes of 131072, pending 0, total 67108864
sent 131072 bytes of 131072, pending 0, total 67239936
sent 131072 bytes of 131072, pending 0, total 67371008
sent 131072 bytes of 131072, pending 0, total 67502080
sent 131072 bytes of 131072, pending 0, total 67633152
sent 131072 bytes of 131072, pending 0, total 67764224
sent 131072 bytes of 131072, pending 0, total 67895296
sent 131072 bytes of 131072, pending 0, total 68026368
sent 131072 bytes of 131072, pending 0, total 68157440
sent 131072 bytes of 131072, pending 0, total 68288512
sent 131072 bytes of 131072, pending 0, total 68419584
sent 131072 bytes of 131072, pending 0, total 68550656
sent 131072 bytes of 131072, pending 0, total 68681728
sent 131072 bytes of 131072, pending 0, total 68812800
sent 131072 bytes of 131072, pending 0, total 68943872
sent 131072 bytes of 131072, pending 0, total 69074944
sent 131072 bytes of 131072, pending 0, total 69206016
sent 131072 bytes of 131072, pending 0, total 69337088
sent 131072 bytes of 131072, pending 0, total 69468160
sent 131072 bytes of 131072, pending 0, total 69599232
sent 131072 bytes of 131072, pending 0, total 69730304
sent 131072 bytes of 131072, pending 0, total 69861376
sent 131072 bytes of 131072, pending 0, total 69992448
sent 131072 bytes of 131072, pending 0, total 70123520
sent 131072 bytes of 131072, pending 0, total 70254592
sent 131072 bytes of 131072, pending 0, total 70385664
sent 131072 bytes of 131072, pending 0, total 70516736
sent 131072 bytes of 131072, pending 0, total 70647808
sent 131072 bytes of 131072, pending 0, total 70778880
sent 131072 bytes of 131072, pending 0, total 70909952
sent 131072 bytes of 131072, pending 0, total 71041024
sent 131072 bytes of 131072, pending 0, total 71172096
sent 131072 bytes of 131072, pending 0, total 71303168
sent 131072 bytes of 131072, pending 0, total 71434240
sent 131072 bytes of 131072, pending 0, total 71565312
tcpi_snd_cwnd 958 tcpi_snd_mss 1368 tcpi_rtt 76899
interval_len 1.000023 bytes_transferred 17563648
interval forces keep
[  5]   3.00-4.00   sec  16.8 MBytes   141 Mbits/sec    0   1.25 MBytes       
sent 131072 bytes of 131072, pending 0, total 71696384
sent 131072 bytes of 131072, pending 0, total 71827456
sent 131072 bytes of 131072, pending 0, total 71958528
sent 131072 bytes of 131072, pending 0, total 72089600
sent 131072 bytes of 131072, pending 0, total 72220672
sent 131072 bytes of 131072, pending 0, total 72351744
sent 131072 bytes of 131072, pending 0, total 72482816
sent 131072 bytes of 131072, pending 0, total 72613888
sent 131072 bytes of 131072, pending 0, total 72744960
sent 131072 bytes of 131072, pending 0, total 72876032
sent 131072 bytes of 131072, pending 0, total 73007104
sent 131072 bytes of 131072, pending 0, total 73138176
sent 131072 bytes of 131072, pending 0, total 73269248
sent 131072 bytes of 131072, pending 0, total 73400320
sent 131072 bytes of 131072, pending 0, total 73531392
sent 131072 bytes of 131072, pending 0, total 73662464
sent 131072 bytes of 131072, pending 0, total 73793536
sent 131072 bytes of 131072, pending 0, total 73924608
sent 131072 bytes of 131072, pending 0, total 74055680
sent 131072 bytes of 131072, pending 0, total 74186752
sent 131072 bytes of 131072, pending 0, total 74317824
sent 131072 bytes of 131072, pending 0, total 74448896
sent 131072 bytes of 131072, pending 0, total 74579968
sent 131072 bytes of 131072, pending 0, total 74711040
sent 131072 bytes of 131072, pending 0, total 74842112
sent 131072 bytes of 131072, pending 0, total 74973184
sent 131072 bytes of 131072, pending 0, total 75104256
sent 131072 bytes of 131072, pending 0, total 75235328
sent 131072 bytes of 131072, pending 0, total 75366400
sent 131072 bytes of 131072, pending 0, total 75497472
sent 131072 bytes of 131072, pending 0, total 75628544
sent 131072 bytes of 131072, pending 0, total 75759616
sent 131072 bytes of 131072, pending 0, total 75890688
sent 131072 bytes of 131072, pending 0, total 76021760
sent 131072 bytes of 131072, pending 0, total 76152832
sent 131072 bytes of 131072, pending 0, total 76283904
sent 131072 bytes of 131072, pending 0, total 76414976
sent 131072 bytes of 131072, pending 0, total 76546048
sent 131072 bytes of 131072, pending 0, total 76677120
sent 131072 bytes of 131072, pending 0, total 76808192
sent 131072 bytes of 131072, pending 0, total 76939264
sent 131072 bytes of 131072, pending 0, total 77070336
sent 131072 bytes of 131072, pending 0, total 77201408
sent 131072 bytes of 131072, pending 0, total 77332480
sent 131072 bytes of 131072, pending 0, total 77463552
sent 131072 bytes of 131072, pending 0, total 77594624
sent 131072 bytes of 131072, pending 0, total 77725696
sent 131072 bytes of 131072, pending 0, total 77856768
sent 131072 bytes of 131072, pending 0, total 77987840
sent 131072 bytes of 131072, pending 0, total 78118912
sent 131072 bytes of 131072, pending 0, total 78249984
sent 131072 bytes of 131072, pending 0, total 78381056
sent 131072 bytes of 131072, pending 0, total 78512128
sent 131072 bytes of 131072, pending 0, total 78643200
sent 131072 bytes of 131072, pending 0, total 78774272
sent 131072 bytes of 131072, pending 0, total 78905344
sent 131072 bytes of 131072, pending 0, total 79036416
sent 131072 bytes of 131072, pending 0, total 79167488
sent 131072 bytes of 131072, pending 0, total 79298560
sent 131072 bytes of 131072, pending 0, total 79429632
sent 131072 bytes of 131072, pending 0, total 79560704
sent 131072 bytes of 131072, pending 0, total 79691776
sent 131072 bytes of 131072, pending 0, total 79822848
sent 131072 bytes of 131072, pending 0, total 79953920
sent 131072 bytes of 131072, pending 0, total 80084992
sent 131072 bytes of 131072, pending 0, total 80216064
sent 131072 bytes of 131072, pending 0, total 80347136
sent 131072 bytes of 131072, pending 0, total 80478208
sent 131072 bytes of 131072, pending 0, total 80609280
sent 131072 bytes of 131072, pending 0, total 80740352
sent 131072 bytes of 131072, pending 0, total 80871424
sent 131072 bytes of 131072, pending 0, total 81002496
sent 131072 bytes of 131072, pending 0, total 81133568
sent 131072 bytes of 131072, pending 0, total 81264640
sent 131072 bytes of 131072, pending 0, total 81395712
sent 131072 bytes of 131072, pending 0, total 81526784
sent 131072 bytes of 131072, pending 0, total 81657856
sent 131072 bytes of 131072, pending 0, total 81788928
sent 131072 bytes of 131072, pending 0, total 81920000
sent 131072 bytes of 131072, pending 0, total 82051072
sent 131072 bytes of 131072, pending 0, total 82182144
sent 131072 bytes of 131072, pending 0, total 82313216
sent 131072 bytes of 131072, pending 0, total 82444288
sent 131072 bytes of 131072, pending 0, total 82575360
sent 131072 bytes of 131072, pending 0, total 82706432
sent 131072 bytes of 131072, pending 0, total 82837504
sent 131072 bytes of 131072, pending 0, total 82968576
sent 131072 bytes of 131072, pending 0, total 83099648
sent 131072 bytes of 131072, pending 0, total 83230720
sent 131072 bytes of 131072, pending 0, total 83361792
sent 131072 bytes of 131072, pending 0, total 83492864
sent 131072 bytes of 131072, pending 0, total 83623936
sent 131072 bytes of 131072, pending 0, total 83755008
sent 131072 bytes of 131072, pending 0, total 83886080
sent 131072 bytes of 131072, pending 0, total 84017152
sent 131072 bytes of 131072, pending 0, total 84148224
sent 131072 bytes of 131072, pending 0, total 84279296
sent 131072 bytes of 131072, pending 0, total 84410368
sent 131072 bytes of 131072, pending 0, total 84541440
sent 131072 bytes of 131072, pending 0, total 84672512
sent 131072 bytes of 131072, pending 0, total 84803584
sent 131072 bytes of 131072, pending 0, total 84934656
sent 131072 bytes of 131072, pending 0, total 85065728
sent 131072 bytes of 131072, pending 0, total 85196800
sent 131072 bytes of 131072, pending 0, total 85327872
sent 131072 bytes of 131072, pending 0, total 85458944
sent 131072 bytes of 131072, pending 0, total 85590016
sent 131072 bytes of 131072, pending 0, total 85721088
sent 131072 bytes of 131072, pending 0, total 85852160
sent 131072 bytes of 131072, pending 0, total 85983232
sent 131072 bytes of 131072, pending 0, total 86114304
sent 131072 bytes of 131072, pending 0, total 86245376
sent 131072 bytes of 131072, pending 0, total 86376448
tcpi_snd_cwnd 958 tcpi_snd_mss 1368 tcpi_rtt 72326
interval_len 1.000083 bytes_transferred 14417920
interval forces keep
[  5]   4.00-5.00   sec  13.8 MBytes   115 Mbits/sec    0   1.25 MBytes       
sent 131072 bytes of 131072, pending 0, total 86507520
sent 131072 bytes of 131072, pending 0, total 86638592
sent 131072 bytes of 131072, pending 0, total 86769664
sent 131072 bytes of 131072, pending 0, total 86900736
sent 131072 bytes of 131072, pending 0, total 87031808
sent 131072 bytes of 131072, pending 0, total 87162880
sent 131072 bytes of 131072, pending 0, total 87293952
sent 131072 bytes of 131072, pending 0, total 87425024
sent 131072 bytes of 131072, pending 0, total 87556096
sent 131072 bytes of 131072, pending 0, total 87687168
sent 131072 bytes of 131072, pending 0, total 87818240
sent 131072 bytes of 131072, pending 0, total 87949312
sent 131072 bytes of 131072, pending 0, total 88080384
sent 131072 bytes of 131072, pending 0, total 88211456
sent 131072 bytes of 131072, pending 0, total 88342528
sent 131072 bytes of 131072, pending 0, total 88473600
sent 131072 bytes of 131072, pending 0, total 88604672
sent 131072 bytes of 131072, pending 0, total 88735744
sent 131072 bytes of 131072, pending 0, total 88866816
sent 131072 bytes of 131072, pending 0, total 88997888
sent 131072 bytes of 131072, pending 0, total 89128960
sent 131072 bytes of 131072, pending 0, total 89260032
sent 131072 bytes of 131072, pending 0, total 89391104
sent 131072 bytes of 131072, pending 0, total 89522176
sent 131072 bytes of 131072, pending 0, total 89653248
sent 131072 bytes of 131072, pending 0, total 89784320
sent 131072 bytes of 131072, pending 0, total 89915392
sent 131072 bytes of 131072, pending 0, total 90046464
sent 131072 bytes of 131072, pending 0, total 90177536
sent 131072 bytes of 131072, pending 0, total 90308608
sent 131072 bytes of 131072, pending 0, total 90439680
sent 131072 bytes of 131072, pending 0, total 90570752
sent 131072 bytes of 131072, pending 0, total 90701824
sent 131072 bytes of 131072, pending 0, total 90832896
sent 131072 bytes of 131072, pending 0, total 90963968
sent 131072 bytes of 131072, pending 0, total 91095040
sent 131072 bytes of 131072, pending 0, total 91226112
sent 131072 bytes of 131072, pending 0, total 91357184
sent 131072 bytes of 131072, pending 0, total 91488256
sent 131072 bytes of 131072, pending 0, total 91619328
sent 131072 bytes of 131072, pending 0, total 91750400
sent 131072 bytes of 131072, pending 0, total 91881472
sent 131072 bytes of 131072, pending 0, total 92012544
sent 131072 bytes of 131072, pending 0, total 92143616
sent 131072 bytes of 131072, pending 0, total 92274688
sent 131072 bytes of 131072, pending 0, total 92405760
sent 131072 bytes of 131072, pending 0, total 92536832
sent 131072 bytes of 131072, pending 0, total 92667904
sent 131072 bytes of 131072, pending 0, total 92798976
sent 131072 bytes of 131072, pending 0, total 92930048
sent 131072 bytes of 131072, pending 0, total 93061120
sent 131072 bytes of 131072, pending 0, total 93192192
sent 131072 bytes of 131072, pending 0, total 93323264
sent 131072 bytes of 131072, pending 0, total 93454336
sent 131072 bytes of 131072, pending 0, total 93585408
sent 131072 bytes of 131072, pending 0, total 93716480
sent 131072 bytes of 131072, pending 0, total 93847552
sent 131072 bytes of 131072, pending 0, total 93978624
sent 131072 bytes of 131072, pending 0, total 94109696
sent 131072 bytes of 131072, pending 0, total 94240768
sent 131072 bytes of 131072, pending 0, total 94371840
sent 131072 bytes of 131072, pending 0, total 94502912
sent 131072 bytes of 131072, pending 0, total 94633984
sent 131072 bytes of 131072, pending 0, total 94765056
sent 131072 bytes of 131072, pending 0, total 94896128
sent 131072 bytes of 131072, pending 0, total 95027200
sent 131072 bytes of 131072, pending 0, total 95158272
sent 131072 bytes of 131072, pending 0, total 95289344
sent 131072 bytes of 131072, pending 0, total 95420416
sent 131072 bytes of 131072, pending 0, total 95551488
sent 131072 bytes of 131072, pending 0, total 95682560
sent 131072 bytes of 131072, pending 0, total 95813632
sent 131072 bytes of 131072, pending 0, total 95944704
sent 131072 bytes of 131072, pending 0, total 96075776
sent 131072 bytes of 131072, pending 0, total 96206848
sent 131072 bytes of 131072, pending 0, total 96337920
sent 131072 bytes of 131072, pending 0, total 96468992
sent 131072 bytes of 131072, pending 0, total 96600064
sent 131072 bytes of 131072, pending 0, total 96731136
sent 131072 bytes of 131072, pending 0, total 96862208
sent 131072 bytes of 131072, pending 0, total 96993280
sent 131072 bytes of 131072, pending 0, total 97124352
sent 131072 bytes of 131072, pending 0, total 97255424
sent 131072 bytes of 131072, pending 0, total 97386496
sent 131072 bytes of 131072, pending 0, total 97517568
sent 131072 bytes of 131072, pending 0, total 97648640
sent 131072 bytes of 131072, pending 0, total 97779712
sent 131072 bytes of 131072, pending 0, total 97910784
sent 131072 bytes of 131072, pending 0, total 98041856
sent 131072 bytes of 131072, pending 0, total 98172928
sent 131072 bytes of 131072, pending 0, total 98304000
sent 131072 bytes of 131072, pending 0, total 98435072
sent 131072 bytes of 131072, pending 0, total 98566144
sent 131072 bytes of 131072, pending 0, total 98697216
sent 131072 bytes of 131072, pending 0, total 98828288
sent 131072 bytes of 131072, pending 0, total 98959360
sent 131072 bytes of 131072, pending 0, total 99090432
sent 131072 bytes of 131072, pending 0, total 99221504
sent 131072 bytes of 131072, pending 0, total 99352576
sent 131072 bytes of 131072, pending 0, total 99483648
sent 131072 bytes of 131072, pending 0, total 99614720
sent 131072 bytes of 131072, pending 0, total 99745792
sent 131072 bytes of 131072, pending 0, total 99876864
sent 131072 bytes of 131072, pending 0, total 100007936
sent 131072 bytes of 131072, pending 0, total 100139008
sent 131072 bytes of 131072, pending 0, total 100270080
sent 131072 bytes of 131072, pending 0, total 100401152
sent 131072 bytes of 131072, pending 0, total 100532224
sent 131072 bytes of 131072, pending 0, total 100663296
sent 131072 bytes of 131072, pending 0, total 100794368
sent 131072 bytes of 131072, pending 0, total 100925440
sent 131072 bytes of 131072, pending 0, total 101056512
sent 131072 bytes of 131072, pending 0, total 101187584
sent 131072 bytes of 131072, pending 0, total 101318656
sent 131072 bytes of 131072, pending 0, total 101449728
sent 131072 bytes of 131072, pending 0, total 101580800
sent 131072 bytes of 131072, pending 0, total 101711872
sent 131072 bytes of 131072, pending 0, total 101842944
sent 131072 bytes of 131072, pending 0, total 101974016
sent 131072 bytes of 131072, pending 0, total 102105088
sent 131072 bytes of 131072, pending 0, total 102236160
sent 131072 bytes of 131072, pending 0, total 102367232
sent 131072 bytes of 131072, pending 0, total 102498304
sent 131072 bytes of 131072, pending 0, total 102629376
sent 131072 bytes of 131072, pending 0, total 102760448
sent 131072 bytes of 131072, pending 0, total 102891520
sent 131072 bytes of 131072, pending 0, total 103022592
sent 131072 bytes of 131072, pending 0, total 103153664
sent 131072 bytes of 131072, pending 0, total 103284736
sent 131072 bytes of 131072, pending 0, total 103415808
sent 131072 bytes of 131072, pending 0, total 103546880
sent 131072 bytes of 131072, pending 0, total 103677952
sent 131072 bytes of 131072, pending 0, total 103809024
sent 131072 bytes of 131072, pending 0, total 103940096
tcpi_snd_cwnd 958 tcpi_snd_mss 1368 tcpi_rtt 71499
interval_len 0.999931 bytes_transferred 17563648
interval forces keep
[  5]   5.00-6.00   sec  16.8 MBytes   141 Mbits/sec    0   1.25 MBytes       
sent 131072 bytes of 131072, pending 0, total 104071168
sent 131072 bytes of 131072, pending 0, total 104202240
sent 131072 bytes of 131072, pending 0, total 104333312
sent 131072 bytes of 131072, pending 0, total 104464384
sent 131072 bytes of 131072, pending 0, total 104595456
sent 131072 bytes of 131072, pending 0, total 104726528
sent 131072 bytes of 131072, pending 0, total 104857600
sent 131072 bytes of 131072, pending 0, total 104988672
sent 131072 bytes of 131072, pending 0, total 105119744
sent 131072 bytes of 131072, pending 0, total 105250816
sent 131072 bytes of 131072, pending 0, total 105381888
sent 131072 bytes of 131072, pending 0, total 105512960
sent 131072 bytes of 131072, pending 0, total 105644032
sent 131072 bytes of 131072, pending 0, total 105775104
sent 131072 bytes of 131072, pending 0, total 105906176
sent 131072 bytes of 131072, pending 0, total 106037248
sent 131072 bytes of 131072, pending 0, total 106168320
sent 131072 bytes of 131072, pending 0, total 106299392
sent 131072 bytes of 131072, pending 0, total 106430464
sent 131072 bytes of 131072, pending 0, total 106561536
sent 131072 bytes of 131072, pending 0, total 106692608
sent 131072 bytes of 131072, pending 0, total 106823680
sent 131072 bytes of 131072, pending 0, total 106954752
sent 131072 bytes of 131072, pending 0, total 107085824
sent 131072 bytes of 131072, pending 0, total 107216896
sent 131072 bytes of 131072, pending 0, total 107347968
sent 131072 bytes of 131072, pending 0, total 107479040
sent 131072 bytes of 131072, pending 0, total 107610112
sent 131072 bytes of 131072, pending 0, total 107741184
sent 131072 bytes of 131072, pending 0, total 107872256
sent 131072 bytes of 131072, pending 0, total 108003328
sent 131072 bytes of 131072, pending 0, total 108134400
sent 131072 bytes of 131072, pending 0, total 108265472
sent 131072 bytes of 131072, pending 0, total 108396544
sent 131072 bytes of 131072, pending 0, total 108527616
sent 131072 bytes of 131072, pending 0, total 108658688
sent 131072 bytes of 131072, pending 0, total 108789760
sent 131072 bytes of 131072, pending 0, total 108920832
sent 131072 bytes of 131072, pending 0, total 109051904
sent 131072 bytes of 131072, pending 0, total 109182976
sent 131072 bytes of 131072, pending 0, total 109314048
sent 131072 bytes of 131072, pending 0, total 109445120
sent 131072 bytes of 131072, pending 0, total 109576192
sent 131072 bytes of 131072, pending 0, total 109707264
sent 131072 bytes of 131072, pending 0, total 109838336
sent 131072 bytes of 131072, pending 0, total 109969408
sent 131072 bytes of 131072, pending 0, total 110100480
sent 131072 bytes of 131072, pending 0, total 110231552
sent 131072 bytes of 131072, pending 0, total 110362624
sent 131072 bytes of 131072, pending 0, total 110493696
sent 131072 bytes of 131072, pending 0, total 110624768
sent 131072 bytes of 131072, pending 0, total 110755840
sent 131072 bytes of 131072, pending 0, total 110886912
sent 131072 bytes of 131072, pending 0, total 111017984
sent 131072 bytes of 131072, pending 0, total 111149056
sent 131072 bytes of 131072, pending 0, total 111280128
sent 131072 bytes of 131072, pending 0, total 111411200
sent 131072 bytes of 131072, pending 0, total 111542272
sent 131072 bytes of 131072, pending 0, total 111673344
sent 131072 bytes of 131072, pending 0, total 111804416
sent 131072 bytes of 131072, pending 0, total 111935488
sent 131072 bytes of 131072, pending 0, total 112066560
sent 131072 bytes of 131072, pending 0, total 112197632
sent 131072 bytes of 131072, pending 0, total 112328704
sent 131072 bytes of 131072, pending 0, total 112459776
sent 131072 bytes of 131072, pending 0, total 112590848
sent 131072 bytes of 131072, pending 0, total 112721920
sent 131072 bytes of 131072, pending 0, total 112852992
sent 131072 bytes of 131072, pending 0, total 112984064
sent 131072 bytes of 131072, pending 0, total 113115136
sent 131072 bytes of 131072, pending 0, total 113246208
sent 131072 bytes of 131072, pending 0, total 113377280
sent 131072 bytes of 131072, pending 0, total 113508352
sent 131072 bytes of 131072, pending 0, total 113639424
sent 131072 bytes of 131072, pending 0, total 113770496
sent 131072 bytes of 131072, pending 0, total 113901568
sent 131072 bytes of 131072, pending 0, total 114032640
sent 131072 bytes of 131072, pending 0, total 114163712
sent 131072 bytes of 131072, pending 0, total 114294784
sent 131072 bytes of 131072, pending 0, total 114425856
sent 131072 bytes of 131072, pending 0, total 114556928
sent 131072 bytes of 131072, pending 0, total 114688000
sent 131072 bytes of 131072, pending 0, total 114819072
sent 131072 bytes of 131072, pending 0, total 114950144
sent 131072 bytes of 131072, pending 0, total 115081216
sent 131072 bytes of 131072, pending 0, total 115212288
sent 131072 bytes of 131072, pending 0, total 115343360
sent 131072 bytes of 131072, pending 0, total 115474432
sent 131072 bytes of 131072, pending 0, total 115605504
sent 131072 bytes of 131072, pending 0, total 115736576
sent 131072 bytes of 131072, pending 0, total 115867648
sent 131072 bytes of 131072, pending 0, total 115998720
sent 131072 bytes of 131072, pending 0, total 116129792
sent 131072 bytes of 131072, pending 0, total 116260864
sent 131072 bytes of 131072, pending 0, total 116391936
sent 131072 bytes of 131072, pending 0, total 116523008
sent 131072 bytes of 131072, pending 0, total 116654080
sent 131072 bytes of 131072, pending 0, total 116785152
sent 131072 bytes of 131072, pending 0, total 116916224
sent 131072 bytes of 131072, pending 0, total 117047296
sent 131072 bytes of 131072, pending 0, total 117178368
sent 131072 bytes of 131072, pending 0, total 117309440
sent 131072 bytes of 131072, pending 0, total 117440512
sent 131072 bytes of 131072, pending 0, total 117571584
sent 131072 bytes of 131072, pending 0, total 117702656
sent 131072 bytes of 131072, pending 0, total 117833728
sent 131072 bytes of 131072, pending 0, total 117964800
sent 131072 bytes of 131072, pending 0, total 118095872
sent 131072 bytes of 131072, pending 0, total 118226944
sent 131072 bytes of 131072, pending 0, total 118358016
sent 131072 bytes of 131072, pending 0, total 118489088
sent 131072 bytes of 131072, pending 0, total 118620160
sent 131072 bytes of 131072, pending 0, total 118751232
sent 131072 bytes of 131072, pending 0, total 118882304
sent 131072 bytes of 131072, pending 0, total 119013376
sent 131072 bytes of 131072, pending 0, total 119144448
sent 131072 bytes of 131072, pending 0, total 119275520
sent 131072 bytes of 131072, pending 0, total 119406592
sent 131072 bytes of 131072, pending 0, total 119537664
sent 131072 bytes of 131072, pending 0, total 119668736
sent 131072 bytes of 131072, pending 0, total 119799808
sent 131072 bytes of 131072, pending 0, total 119930880
sent 131072 bytes of 131072, pending 0, total 120061952
sent 131072 bytes of 131072, pending 0, total 120193024
sent 131072 bytes of 131072, pending 0, total 120324096
sent 131072 bytes of 131072, pending 0, total 120455168
sent 131072 bytes of 131072, pending 0, total 120586240
sent 131072 bytes of 131072, pending 0, total 120717312
sent 131072 bytes of 131072, pending 0, total 120848384
sent 131072 bytes of 131072, pending 0, total 120979456
sent 131072 bytes of 131072, pending 0, total 121110528
sent 131072 bytes of 131072, pending 0, total 121241600
sent 131072 bytes of 131072, pending 0, total 121372672
sent 131072 bytes of 131072, pending 0, total 121503744
sent 131072 bytes of 131072, pending 0, total 121634816
tcpi_snd_cwnd 958 tcpi_snd_mss 1368 tcpi_rtt 71682
interval_len 0.999998 bytes_transferred 17694720
interval forces keep
[  5]   6.00-7.00   sec  16.9 MBytes   142 Mbits/sec    0   1.25 MBytes       
sent 131072 bytes of 131072, pending 0, total 121765888
sent 131072 bytes of 131072, pending 0, total 121896960
sent 131072 bytes of 131072, pending 0, total 122028032
sent 131072 bytes of 131072, pending 0, total 122159104
sent 131072 bytes of 131072, pending 0, total 122290176
sent 131072 bytes of 131072, pending 0, total 122421248
sent 131072 bytes of 131072, pending 0, total 122552320
sent 131072 bytes of 131072, pending 0, total 122683392
sent 131072 bytes of 131072, pending 0, total 122814464
sent 131072 bytes of 131072, pending 0, total 122945536
sent 131072 bytes of 131072, pending 0, total 123076608
sent 131072 bytes of 131072, pending 0, total 123207680
sent 131072 bytes of 131072, pending 0, total 123338752
sent 131072 bytes of 131072, pending 0, total 123469824
sent 131072 bytes of 131072, pending 0, total 123600896
sent 131072 bytes of 131072, pending 0, total 123731968
sent 131072 bytes of 131072, pending 0, total 123863040
sent 131072 bytes of 131072, pending 0, total 123994112
sent 131072 bytes of 131072, pending 0, total 124125184
sent 131072 bytes of 131072, pending 0, total 124256256
sent 131072 bytes of 131072, pending 0, total 124387328
sent 131072 bytes of 131072, pending 0, total 124518400
sent 131072 bytes of 131072, pending 0, total 124649472
sent 131072 bytes of 131072, pending 0, total 124780544
sent 131072 bytes of 131072, pending 0, total 124911616
sent 131072 bytes of 131072, pending 0, total 125042688
sent 131072 bytes of 131072, pending 0, total 125173760
sent 131072 bytes of 131072, pending 0, total 125304832
sent 131072 bytes of 131072, pending 0, total 125435904
sent 131072 bytes of 131072, pending 0, total 125566976
sent 131072 bytes of 131072, pending 0, total 125698048
sent 131072 bytes of 131072, pending 0, total 125829120
sent 131072 bytes of 131072, pending 0, total 125960192
sent 131072 bytes of 131072, pending 0, total 126091264
sent 131072 bytes of 131072, pending 0, total 126222336
sent 131072 bytes of 131072, pending 0, total 126353408
sent 131072 bytes of 131072, pending 0, total 126484480
sent 131072 bytes of 131072, pending 0, total 126615552
sent 131072 bytes of 131072, pending 0, total 126746624
sent 131072 bytes of 131072, pending 0, total 126877696
sent 131072 bytes of 131072, pending 0, total 127008768
sent 131072 bytes of 131072, pending 0, total 127139840
sent 131072 bytes of 131072, pending 0, total 127270912
sent 131072 bytes of 131072, pending 0, total 127401984
sent 131072 bytes of 131072, pending 0, total 127533056
sent 131072 bytes of 131072, pending 0, total 127664128
sent 131072 bytes of 131072, pending 0, total 127795200
sent 131072 bytes of 131072, pending 0, total 127926272
sent 131072 bytes of 131072, pending 0, total 128057344
sent 131072 bytes of 131072, pending 0, total 128188416
sent 131072 bytes of 131072, pending 0, total 128319488
sent 131072 bytes of 131072, pending 0, total 128450560
sent 131072 bytes of 131072, pending 0, total 128581632
sent 131072 bytes of 131072, pending 0, total 128712704
sent 131072 bytes of 131072, pending 0, total 128843776
sent 131072 bytes of 131072, pending 0, total 128974848
sent 131072 bytes of 131072, pending 0, total 129105920
sent 131072 bytes of 131072, pending 0, total 129236992
sent 131072 bytes of 131072, pending 0, total 129368064
sent 131072 bytes of 131072, pending 0, total 129499136
sent 131072 bytes of 131072, pending 0, total 129630208
sent 131072 bytes of 131072, pending 0, total 129761280
sent 131072 bytes of 131072, pending 0, total 129892352
sent 131072 bytes of 131072, pending 0, total 130023424
sent 131072 bytes of 131072, pending 0, total 130154496
sent 131072 bytes of 131072, pending 0, total 130285568
sent 131072 bytes of 131072, pending 0, total 130416640
sent 131072 bytes of 131072, pending 0, total 130547712
sent 131072 bytes of 131072, pending 0, total 130678784
sent 131072 bytes of 131072, pending 0, total 130809856
sent 131072 bytes of 131072, pending 0, total 130940928
sent 131072 bytes of 131072, pending 0, total 131072000
sent 131072 bytes of 131072, pending 0, total 131203072
sent 131072 bytes of 131072, pending 0, total 131334144
sent 131072 bytes of 131072, pending 0, total 131465216
sent 131072 bytes of 131072, pending 0, total 131596288
sent 131072 bytes of 131072, pending 0, total 131727360
sent 131072 bytes of 131072, pending 0, total 131858432
sent 131072 bytes of 131072, pending 0, total 131989504
sent 131072 bytes of 131072, pending 0, total 132120576
sent 131072 bytes of 131072, pending 0, total 132251648
sent 131072 bytes of 131072, pending 0, total 132382720
sent 131072 bytes of 131072, pending 0, total 132513792
sent 131072 bytes of 131072, pending 0, total 132644864
sent 131072 bytes of 131072, pending 0, total 132775936
sent 131072 bytes of 131072, pending 0, total 132907008
sent 131072 bytes of 131072, pending 0, total 133038080
sent 131072 bytes of 131072, pending 0, total 133169152
sent 131072 bytes of 131072, pending 0, total 133300224
sent 131072 bytes of 131072, pending 0, total 133431296
sent 131072 bytes of 131072, pending 0, total 133562368
sent 131072 bytes of 131072, pending 0, total 133693440
sent 131072 bytes of 131072, pending 0, total 133824512
sent 131072 bytes of 131072, pending 0, total 133955584
sent 131072 bytes of 131072, pending 0, total 134086656
sent 131072 bytes of 131072, pending 0, total 134217728
sent 131072 bytes of 131072, pending 0, total 134348800
sent 131072 bytes of 131072, pending 0, total 134479872
sent 131072 bytes of 131072, pending 0, total 134610944
sent 131072 bytes of 131072, pending 0, total 134742016
sent 131072 bytes of 131072, pending 0, total 134873088
sent 131072 bytes of 131072, pending 0, total 135004160
sent 131072 bytes of 131072, pending 0, total 135135232
sent 131072 bytes of 131072, pending 0, total 135266304
sent 131072 bytes of 131072, pending 0, total 135397376
sent 131072 bytes of 131072, pending 0, total 135528448
sent 131072 bytes of 131072, pending 0, total 135659520
sent 131072 bytes of 131072, pending 0, total 135790592
sent 131072 bytes of 131072, pending 0, total 135921664
sent 131072 bytes of 131072, pending 0, total 136052736
sent 131072 bytes of 131072, pending 0, total 136183808
sent 131072 bytes of 131072, pending 0, total 136314880
sent 131072 bytes of 131072, pending 0, total 136445952
sent 131072 bytes of 131072, pending 0, total 136577024
sent 131072 bytes of 131072, pending 0, total 136708096
sent 131072 bytes of 131072, pending 0, total 136839168
sent 131072 bytes of 131072, pending 0, total 136970240
sent 131072 bytes of 131072, pending 0, total 137101312
sent 131072 bytes of 131072, pending 0, total 137232384
sent 131072 bytes of 131072, pending 0, total 137363456
sent 131072 bytes of 131072, pending 0, total 137494528
sent 131072 bytes of 131072, pending 0, total 137625600
sent 131072 bytes of 131072, pending 0, total 137756672
sent 131072 bytes of 131072, pending 0, total 137887744
sent 131072 bytes of 131072, pending 0, total 138018816
sent 131072 bytes of 131072, pending 0, total 138149888
sent 131072 bytes of 131072, pending 0, total 138280960
sent 131072 bytes of 131072, pending 0, total 138412032
sent 131072 bytes of 131072, pending 0, total 138543104
sent 131072 bytes of 131072, pending 0, total 138674176
sent 131072 bytes of 131072, pending 0, total 138805248
sent 131072 bytes of 131072, pending 0, total 138936320
sent 131072 bytes of 131072, pending 0, total 139067392
sent 131072 bytes of 131072, pending 0, total 139198464
sent 131072 bytes of 131072, pending 0, total 139329536
sent 131072 bytes of 131072, pending 0, total 139460608
sent 131072 bytes of 131072, pending 0, total 139591680
sent 131072 bytes of 131072, pending 0, total 139722752
sent 131072 bytes of 131072, pending 0, total 139853824
sent 131072 bytes of 131072, pending 0, total 139984896
sent 131072 bytes of 131072, pending 0, total 140115968
sent 131072 bytes of 131072, pending 0, total 140247040
sent 131072 bytes of 131072, pending 0, total 140378112
tcpi_snd_cwnd 958 tcpi_snd_mss 1368 tcpi_rtt 61412
interval_len 0.999988 bytes_transferred 18743296
interval forces keep
[  5]   7.00-8.00   sec  17.9 MBytes   150 Mbits/sec    0   1.25 MBytes       
sent 131072 bytes of 131072, pending 0, total 140509184
sent 131072 bytes of 131072, pending 0, total 140640256
sent 131072 bytes of 131072, pending 0, total 140771328
sent 131072 bytes of 131072, pending 0, total 140902400
sent 131072 bytes of 131072, pending 0, total 141033472
sent 131072 bytes of 131072, pending 0, total 141164544
sent 131072 bytes of 131072, pending 0, total 141295616
sent 131072 bytes of 131072, pending 0, total 141426688
sent 131072 bytes of 131072, pending 0, total 141557760
sent 131072 bytes of 131072, pending 0, total 141688832
sent 131072 bytes of 131072, pending 0, total 141819904
sent 131072 bytes of 131072, pending 0, total 141950976
sent 131072 bytes of 131072, pending 0, total 142082048
sent 131072 bytes of 131072, pending 0, total 142213120
sent 131072 bytes of 131072, pending 0, total 142344192
sent 131072 bytes of 131072, pending 0, total 142475264
sent 131072 bytes of 131072, pending 0, total 142606336
sent 131072 bytes of 131072, pending 0, total 142737408
sent 131072 bytes of 131072, pending 0, total 142868480
sent 131072 bytes of 131072, pending 0, total 142999552
sent 131072 bytes of 131072, pending 0, total 143130624
sent 131072 bytes of 131072, pending 0, total 143261696
sent 131072 bytes of 131072, pending 0, total 143392768
sent 131072 bytes of 131072, pending 0, total 143523840
sent 131072 bytes of 131072, pending 0, total 143654912
sent 131072 bytes of 131072, pending 0, total 143785984
sent 131072 bytes of 131072, pending 0, total 143917056
sent 131072 bytes of 131072, pending 0, total 144048128
sent 131072 bytes of 131072, pending 0, total 144179200
sent 131072 bytes of 131072, pending 0, total 144310272
sent 131072 bytes of 131072, pending 0, total 144441344
sent 131072 bytes of 131072, pending 0, total 144572416
sent 131072 bytes of 131072, pending 0, total 144703488
sent 131072 bytes of 131072, pending 0, total 144834560
sent 131072 bytes of 131072, pending 0, total 144965632
sent 131072 bytes of 131072, pending 0, total 145096704
sent 131072 bytes of 131072, pending 0, total 145227776
sent 131072 bytes of 131072, pending 0, total 145358848
sent 131072 bytes of 131072, pending 0, total 145489920
sent 131072 bytes of 131072, pending 0, total 145620992
sent 131072 bytes of 131072, pending 0, total 145752064
sent 131072 bytes of 131072, pending 0, total 145883136
sent 131072 bytes of 131072, pending 0, total 146014208
sent 131072 bytes of 131072, pending 0, total 146145280
sent 131072 bytes of 131072, pending 0, total 146276352
sent 131072 bytes of 131072, pending 0, total 146407424
sent 131072 bytes of 131072, pending 0, total 146538496
sent 131072 bytes of 131072, pending 0, total 146669568
sent 131072 bytes of 131072, pending 0, total 146800640
sent 131072 bytes of 131072, pending 0, total 146931712
sent 131072 bytes of 131072, pending 0, total 147062784
sent 131072 bytes of 131072, pending 0, total 147193856
sent 131072 bytes of 131072, pending 0, total 147324928
sent 131072 bytes of 131072, pending 0, total 147456000
sent 131072 bytes of 131072, pending 0, total 147587072
sent 131072 bytes of 131072, pending 0, total 147718144
sent 131072 bytes of 131072, pending 0, total 147849216
sent 131072 bytes of 131072, pending 0, total 147980288
sent 131072 bytes of 131072, pending 0, total 148111360
sent 131072 bytes of 131072, pending 0, total 148242432
sent 131072 bytes of 131072, pending 0, total 148373504
sent 131072 bytes of 131072, pending 0, total 148504576
sent 131072 bytes of 131072, pending 0, total 148635648
sent 131072 bytes of 131072, pending 0, total 148766720
sent 131072 bytes of 131072, pending 0, total 148897792
sent 131072 bytes of 131072, pending 0, total 149028864
sent 131072 bytes of 131072, pending 0, total 149159936
sent 131072 bytes of 131072, pending 0, total 149291008
sent 131072 bytes of 131072, pending 0, total 149422080
sent 131072 bytes of 131072, pending 0, total 149553152
sent 131072 bytes of 131072, pending 0, total 149684224
sent 131072 bytes of 131072, pending 0, total 149815296
sent 131072 bytes of 131072, pending 0, total 149946368
sent 131072 bytes of 131072, pending 0, total 150077440
sent 131072 bytes of 131072, pending 0, total 150208512
sent 131072 bytes of 131072, pending 0, total 150339584
sent 131072 bytes of 131072, pending 0, total 150470656
sent 131072 bytes of 131072, pending 0, total 150601728
sent 131072 bytes of 131072, pending 0, total 150732800
sent 131072 bytes of 131072, pending 0, total 150863872
sent 131072 bytes of 131072, pending 0, total 150994944
sent 131072 bytes of 131072, pending 0, total 151126016
sent 131072 bytes of 131072, pending 0, total 151257088
sent 131072 bytes of 131072, pending 0, total 151388160
sent 131072 bytes of 131072, pending 0, total 151519232
sent 131072 bytes of 131072, pending 0, total 151650304
sent 131072 bytes of 131072, pending 0, total 151781376
sent 131072 bytes of 131072, pending 0, total 151912448
sent 131072 bytes of 131072, pending 0, total 152043520
sent 131072 bytes of 131072, pending 0, total 152174592
sent 131072 bytes of 131072, pending 0, total 152305664
sent 131072 bytes of 131072, pending 0, total 152436736
sent 131072 bytes of 131072, pending 0, total 152567808
sent 131072 bytes of 131072, pending 0, total 152698880
sent 131072 bytes of 131072, pending 0, total 152829952
sent 131072 bytes of 131072, pending 0, total 152961024
sent 131072 bytes of 131072, pending 0, total 153092096
sent 131072 bytes of 131072, pending 0, total 153223168
sent 131072 bytes of 131072, pending 0, total 153354240
sent 131072 bytes of 131072, pending 0, total 153485312
sent 131072 bytes of 131072, pending 0, total 153616384
sent 131072 bytes of 131072, pending 0, total 153747456
sent 131072 bytes of 131072, pending 0, total 153878528
sent 131072 bytes of 131072, pending 0, total 154009600
sent 131072 bytes of 131072, pending 0, total 154140672
sent 131072 bytes of 131072, pending 0, total 154271744
sent 131072 bytes of 131072, pending 0, total 154402816
sent 131072 bytes of 131072, pending 0, total 154533888
sent 131072 bytes of 131072, pending 0, total 154664960
sent 131072 bytes of 131072, pending 0, total 154796032
sent 131072 bytes of 131072, pending 0, total 154927104
sent 131072 bytes of 131072, pending 0, total 155058176
sent 131072 bytes of 131072, pending 0, total 155189248
sent 131072 bytes of 131072, pending 0, total 155320320
sent 131072 bytes of 131072, pending 0, total 155451392
sent 131072 bytes of 131072, pending 0, total 155582464
sent 131072 bytes of 131072, pending 0, total 155713536
sent 131072 bytes of 131072, pending 0, total 155844608
sent 131072 bytes of 131072, pending 0, total 155975680
sent 131072 bytes of 131072, pending 0, total 156106752
sent 131072 bytes of 131072, pending 0, total 156237824
sent 131072 bytes of 131072, pending 0, total 156368896
sent 131072 bytes of 131072, pending 0, total 156499968
sent 131072 bytes of 131072, pending 0, total 156631040
sent 131072 bytes of 131072, pending 0, total 156762112
sent 131072 bytes of 131072, pending 0, total 156893184
sent 131072 bytes of 131072, pending 0, total 157024256
sent 131072 bytes of 131072, pending 0, total 157155328
sent 131072 bytes of 131072, pending 0, total 157286400
sent 131072 bytes of 131072, pending 0, total 157417472
sent 131072 bytes of 131072, pending 0, total 157548544
sent 131072 bytes of 131072, pending 0, total 157679616
sent 131072 bytes of 131072, pending 0, total 157810688
sent 131072 bytes of 131072, pending 0, total 157941760
sent 131072 bytes of 131072, pending 0, total 158072832
sent 131072 bytes of 131072, pending 0, total 158203904
sent 131072 bytes of 131072, pending 0, total 158334976
sent 131072 bytes of 131072, pending 0, total 158466048
sent 131072 bytes of 131072, pending 0, total 158597120
sent 131072 bytes of 131072, pending 0, total 158728192
sent 131072 bytes of 131072, pending 0, total 158859264
sent 131072 bytes of 131072, pending 0, total 158990336
sent 131072 bytes of 131072, pending 0, total 159121408
sent 131072 bytes of 131072, pending 0, total 159252480
sent 131072 bytes of 131072, pending 0, total 159383552
sent 131072 bytes of 131072, pending 0, total 159514624
sent 131072 bytes of 131072, pending 0, total 159645696
tcpi_snd_cwnd 958 tcpi_snd_mss 1368 tcpi_rtt 55385
sent 131072 bytes of 131072, pending 0, total 159776768
interval_len 1.000015 bytes_transferred 19005440
interval forces keep
[  5]   8.00-9.00   sec  18.1 MBytes   152 Mbits/sec    0   1.25 MBytes       
sent 131072 bytes of 131072, pending 0, total 159907840
sent 131072 bytes of 131072, pending 0, total 160038912
sent 131072 bytes of 131072, pending 0, total 160169984
sent 131072 bytes of 131072, pending 0, total 160301056
sent 131072 bytes of 131072, pending 0, total 160432128
sent 131072 bytes of 131072, pending 0, total 160563200
sent 131072 bytes of 131072, pending 0, total 160694272
sent 131072 bytes of 131072, pending 0, total 160825344
sent 131072 bytes of 131072, pending 0, total 160956416
sent 131072 bytes of 131072, pending 0, total 161087488
sent 131072 bytes of 131072, pending 0, total 161218560
sent 131072 bytes of 131072, pending 0, total 161349632
sent 131072 bytes of 131072, pending 0, total 161480704
sent 131072 bytes of 131072, pending 0, total 161611776
sent 131072 bytes of 131072, pending 0, total 161742848
sent 131072 bytes of 131072, pending 0, total 161873920
sent 131072 bytes of 131072, pending 0, total 162004992
sent 131072 bytes of 131072, pending 0, total 162136064
sent 131072 bytes of 131072, pending 0, total 162267136
sent 131072 bytes of 131072, pending 0, total 162398208
sent 131072 bytes of 131072, pending 0, total 162529280
sent 131072 bytes of 131072, pending 0, total 162660352
sent 131072 bytes of 131072, pending 0, total 162791424
sent 131072 bytes of 131072, pending 0, total 162922496
sent 131072 bytes of 131072, pending 0, total 163053568
sent 131072 bytes of 131072, pending 0, total 163184640
sent 131072 bytes of 131072, pending 0, total 163315712
sent 131072 bytes of 131072, pending 0, total 163446784
sent 131072 bytes of 131072, pending 0, total 163577856
sent 131072 bytes of 131072, pending 0, total 163708928
sent 131072 bytes of 131072, pending 0, total 163840000
sent 131072 bytes of 131072, pending 0, total 163971072
sent 131072 bytes of 131072, pending 0, total 164102144
sent 131072 bytes of 131072, pending 0, total 164233216
sent 131072 bytes of 131072, pending 0, total 164364288
sent 131072 bytes of 131072, pending 0, total 164495360
sent 131072 bytes of 131072, pending 0, total 164626432
sent 131072 bytes of 131072, pending 0, total 164757504
sent 131072 bytes of 131072, pending 0, total 164888576
sent 131072 bytes of 131072, pending 0, total 165019648
sent 131072 bytes of 131072, pending 0, total 165150720
sent 131072 bytes of 131072, pending 0, total 165281792
sent 131072 bytes of 131072, pending 0, total 165412864
sent 131072 bytes of 131072, pending 0, total 165543936
sent 131072 bytes of 131072, pending 0, total 165675008
sent 131072 bytes of 131072, pending 0, total 165806080
sent 131072 bytes of 131072, pending 0, total 165937152
sent 131072 bytes of 131072, pending 0, total 166068224
sent 131072 bytes of 131072, pending 0, total 166199296
sent 131072 bytes of 131072, pending 0, total 166330368
sent 131072 bytes of 131072, pending 0, total 166461440
sent 131072 bytes of 131072, pending 0, total 166592512
sent 131072 bytes of 131072, pending 0, total 166723584
sent 131072 bytes of 131072, pending 0, total 166854656
sent 131072 bytes of 131072, pending 0, total 166985728
sent 131072 bytes of 131072, pending 0, total 167116800
sent 131072 bytes of 131072, pending 0, total 167247872
sent 131072 bytes of 131072, pending 0, total 167378944
sent 131072 bytes of 131072, pending 0, total 167510016
sent 131072 bytes of 131072, pending 0, total 167641088
sent 131072 bytes of 131072, pending 0, total 167772160
sent 131072 bytes of 131072, pending 0, total 167903232
sent 131072 bytes of 131072, pending 0, total 168034304
sent 131072 bytes of 131072, pending 0, total 168165376
sent 131072 bytes of 131072, pending 0, total 168296448
sent 131072 bytes of 131072, pending 0, total 168427520
sent 131072 bytes of 131072, pending 0, total 168558592
sent 131072 bytes of 131072, pending 0, total 168689664
sent 131072 bytes of 131072, pending 0, total 168820736
sent 131072 bytes of 131072, pending 0, total 168951808
sent 131072 bytes of 131072, pending 0, total 169082880
sent 131072 bytes of 131072, pending 0, total 169213952
sent 131072 bytes of 131072, pending 0, total 169345024
sent 131072 bytes of 131072, pending 0, total 169476096
sent 131072 bytes of 131072, pending 0, total 169607168
sent 131072 bytes of 131072, pending 0, total 169738240
sent 131072 bytes of 131072, pending 0, total 169869312
sent 131072 bytes of 131072, pending 0, total 170000384
sent 131072 bytes of 131072, pending 0, total 170131456
sent 131072 bytes of 131072, pending 0, total 170262528
sent 131072 bytes of 131072, pending 0, total 170393600
sent 131072 bytes of 131072, pending 0, total 170524672
sent 131072 bytes of 131072, pending 0, total 170655744
sent 131072 bytes of 131072, pending 0, total 170786816
sent 131072 bytes of 131072, pending 0, total 170917888
sent 131072 bytes of 131072, pending 0, total 171048960
sent 131072 bytes of 131072, pending 0, total 171180032
sent 131072 bytes of 131072, pending 0, total 171311104
sent 131072 bytes of 131072, pending 0, total 171442176
sent 131072 bytes of 131072, pending 0, total 171573248
sent 131072 bytes of 131072, pending 0, total 171704320
sent 131072 bytes of 131072, pending 0, total 171835392
sent 131072 bytes of 131072, pending 0, total 171966464
sent 131072 bytes of 131072, pending 0, total 172097536
sent 131072 bytes of 131072, pending 0, total 172228608
sent 131072 bytes of 131072, pending 0, total 172359680
sent 131072 bytes of 131072, pending 0, total 172490752
sent 131072 bytes of 131072, pending 0, total 172621824
sent 131072 bytes of 131072, pending 0, total 172752896
sent 131072 bytes of 131072, pending 0, total 172883968
sent 131072 bytes of 131072, pending 0, total 173015040
sent 131072 bytes of 131072, pending 0, total 173146112
sent 131072 bytes of 131072, pending 0, total 173277184
sent 131072 bytes of 131072, pending 0, total 173408256
sent 131072 bytes of 131072, pending 0, total 173539328
sent 131072 bytes of 131072, pending 0, total 173670400
sent 131072 bytes of 131072, pending 0, total 173801472
sent 131072 bytes of 131072, pending 0, total 173932544
sent 131072 bytes of 131072, pending 0, total 174063616
sent 131072 bytes of 131072, pending 0, total 174194688
sent 131072 bytes of 131072, pending 0, total 174325760
sent 131072 bytes of 131072, pending 0, total 174456832
sent 131072 bytes of 131072, pending 0, total 174587904
sent 131072 bytes of 131072, pending 0, total 174718976
sent 131072 bytes of 131072, pending 0, total 174850048
sent 131072 bytes of 131072, pending 0, total 174981120
sent 131072 bytes of 131072, pending 0, total 175112192
sent 131072 bytes of 131072, pending 0, total 175243264
sent 131072 bytes of 131072, pending 0, total 175374336
sent 131072 bytes of 131072, pending 0, total 175505408
sent 131072 bytes of 131072, pending 0, total 175636480
sent 131072 bytes of 131072, pending 0, total 175767552
sent 131072 bytes of 131072, pending 0, total 175898624
sent 131072 bytes of 131072, pending 0, total 176029696
sent 131072 bytes of 131072, pending 0, total 176160768
sent 131072 bytes of 131072, pending 0, total 176291840
sent 131072 bytes of 131072, pending 0, total 176422912
sent 131072 bytes of 131072, pending 0, total 176553984
sent 131072 bytes of 131072, pending 0, total 176685056
sent 131072 bytes of 131072, pending 0, total 176816128
sent 131072 bytes of 131072, pending 0, total 176947200
sent 131072 bytes of 131072, pending 0, total 177078272
sent 131072 bytes of 131072, pending 0, total 177209344
sent 131072 bytes of 131072, pending 0, total 177340416
sent 131072 bytes of 131072, pending 0, total 177471488
sent 131072 bytes of 131072, pending 0, total 177602560
sent 131072 bytes of 131072, pending 0, total 177733632
sent 131072 bytes of 131072, pending 0, total 177864704
sent 131072 bytes of 131072, pending 0, total 177995776
sent 131072 bytes of 131072, pending 0, total 178126848
Thread FD 5 stopped
Sender threads stopped
tcpi_snd_cwnd 958 tcpi_snd_mss 1368 tcpi_rtt 66941
send_results
{
	"cpu_util_total":	61.033610566401173,
	"cpu_util_user":	0.622736226092491,
	"cpu_util_system":	60.4108344104415,
	"sender_has_retransmits":	1,
	"congestion_used":	"cubic",
	"streams":	[{
			"id":	1,
			"bytes":	178126848,
			"retransmits":	0,
			"jitter":	0,
			"errors":	0,
			"omitted_errors":	0,
			"packets":	0,
			"omitted_packets":	0,
			"start_time":	0,
			"end_time":	10.002141
		}]
}
get_results
{
	"cpu_util_total":	70.672719679503842,
	"cpu_util_user":	2.7729995017082585,
	"cpu_util_system":	67.899720177795572,
	"sender_has_retransmits":	-1,
	"congestion_used":	"cubic",
	"streams":	[{
			"id":	1,
			"bytes":	177995776,
			"retransmits":	-1,
			"jitter":	0,
			"errors":	0,
			"omitted_errors":	0,
			"packets":	0,
			"omitted_packets":	0,
			"start_time":	0,
			"end_time":	10.066117
		}]
}
interval_len 1.000983 bytes_transferred 18350080
interval forces keep
[  5]   9.00-10.00  sec  17.5 MBytes   147 Mbits/sec    0   1.25 MBytes       
- - - - - - - - - - - - - - - - - - - - - - - - -
Test Complete. Summary Results:
[ ID] Interval           Transfer     Bitrate         Retr
[  5]   0.00-10.00  sec   170 MBytes   142 Mbits/sec    0             sender
[  5]   0.00-10.07  sec   170 MBytes   141 Mbits/sec                  receiver
CPU Utilization: local/sender 61.0% (0.6%u/60.4%s), remote/receiver 70.7% (2.8%u/67.9%s)
snd_tcp_congestion cubic
rcv_tcp_congestion cubic
Receiver threads stopped

iperf Done.
Test Completed at Wed Jun 18 15:45:38 UTC 2025
Batman/Batctl Report
====================
Batctl neighbors
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: lan/f4:4d:5c:fe:51:64 (batman/16:87:5f:85:10:d4 BATMAN_IV)]
IF             Neighbor              last-seen
          lan	  f4:4d:5c:fd:a2:fc    4.280s
          lan	  20:97:27:52:6c:ab    2.830s
          lan	  f4:4d:5c:fd:9d:ef    3.580s
   phy0-mesh0	  2a:97:27:52:6c:ad    0.820s
   phy0-mesh0	  f2:4d:5c:fd:a2:fd    3.070s
   phy0-mesh0	  f2:4d:5c:fd:9d:f0    7.510s
   phy0-mesh0	  f2:4d:5c:fc:25:8d    0.360s
   phy0-mesh0	  d2:3d:f3:fe:f3:53    2.360s
   phy1-mesh0	  f2:4d:5c:fd:a2:fe    3.620s
   phy1-mesh0	  d2:3d:f3:fe:f3:54    0.450s
   phy1-mesh0	  2a:97:27:52:6c:ae    3.860s
   phy1-mesh0	  f2:4d:5c:fc:25:8e    1.960s
   phy1-mesh0	  f2:4d:5c:fd:9d:f1    3.670s
Batctl originators
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: lan/f4:4d:5c:fe:51:64 (batman/16:87:5f:85:10:d4 BATMAN_IV)]
   Originator        last-seen (#/255) Nexthop           [outgoingIF]
   f4:4d:5c:fd:9d:ef    3.360s   (204) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f4:4d:5c:fd:9d:ef    3.360s   (171) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   f4:4d:5c:fd:9d:ef    3.360s   (201) 2a:97:27:52:6c:ad [phy0-mesh0]
   f4:4d:5c:fd:9d:ef    3.360s   (198) f2:4d:5c:fc:25:8d [phy0-mesh0]
   f4:4d:5c:fd:9d:ef    3.360s   (213) 2a:97:27:52:6c:ae [phy1-mesh0]
   f4:4d:5c:fd:9d:ef    3.360s   (175) f2:4d:5c:fc:25:8e [phy1-mesh0]
   f4:4d:5c:fd:9d:ef    3.360s   (241) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f4:4d:5c:fd:9d:ef    3.360s   (194) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   f4:4d:5c:fd:9d:ef    3.360s   (225) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f4:4d:5c:fd:9d:ef    3.360s   (214) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   f4:4d:5c:fd:9d:ef    3.360s   (225) f4:4d:5c:fd:a2:fc [       lan]
   f4:4d:5c:fd:9d:ef    3.360s   (225) 20:97:27:52:6c:ab [       lan]
 * f4:4d:5c:fd:9d:ef    3.360s   (255) f4:4d:5c:fd:9d:ef [       lan]
   f4:4d:5c:fd:a2:fc    4.130s   (201) 2a:97:27:52:6c:ad [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    4.130s   (225) f2:4d:5c:fc:25:8d [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    4.130s   (194) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   f4:4d:5c:fd:a2:fc    4.130s   (199) f2:4d:5c:fc:25:8e [phy1-mesh0]
   f4:4d:5c:fd:a2:fc    4.130s   (208) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    4.130s   (243) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   f4:4d:5c:fd:a2:fc    4.130s   (172) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    4.130s   (214) 2a:97:27:52:6c:ae [phy1-mesh0]
   f4:4d:5c:fd:a2:fc    4.130s   (255) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    4.130s   (225) 20:97:27:52:6c:ab [       lan]
   f4:4d:5c:fd:a2:fc    4.130s   (213) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f4:4d:5c:fd:a2:fc    4.130s   (225) f4:4d:5c:fd:9d:ef [       lan]
 * f4:4d:5c:fd:a2:fc    4.130s   (255) f4:4d:5c:fd:a2:fc [       lan]
   f2:4d:5c:fc:25:8e    1.840s   (164) 2a:97:27:52:6c:ae [phy1-mesh0]
   f2:4d:5c:fc:25:8e    1.840s   (179) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   f2:4d:5c:fc:25:8e    1.840s   (166) d2:3d:f3:fe:f3:54 [phy1-mesh0]
 * f2:4d:5c:fc:25:8e    1.840s   (238) f2:4d:5c:fc:25:8e [phy1-mesh0]
   f2:4d:5c:fd:a2:fe    3.520s   (146) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f2:4d:5c:fd:a2:fe    3.520s   (165) 2a:97:27:52:6c:ae [phy1-mesh0]
   f2:4d:5c:fd:a2:fe    3.520s   (185) f2:4d:5c:fc:25:8e [phy1-mesh0]
   f2:4d:5c:fd:a2:fe    3.520s   (168) d2:3d:f3:fe:f3:54 [phy1-mesh0]
 * f2:4d:5c:fd:a2:fe    3.520s   (243) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   2a:97:27:52:6c:ae    3.750s   (176) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   2a:97:27:52:6c:ae    3.750s   (165) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   2a:97:27:52:6c:ae    3.750s   (173) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
 * 2a:97:27:52:6c:ae    3.750s   (240) 2a:97:27:52:6c:ae [phy1-mesh0]
   d2:3d:f3:fe:f3:53    2.110s   (194) 2a:97:27:52:6c:ad [phy0-mesh0]
   d2:3d:f3:fe:f3:53    2.110s   (149) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   d2:3d:f3:fe:f3:53    2.110s   (202) f4:4d:5c:fd:9d:ef [       lan]
   d2:3d:f3:fe:f3:53    2.110s   (189) 2a:97:27:52:6c:ae [phy1-mesh0]
   d2:3d:f3:fe:f3:53    2.110s   (198) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   d2:3d:f3:fe:f3:53    2.110s   (225) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   d2:3d:f3:fe:f3:53    2.110s   (225) f4:4d:5c:fd:a2:fc [       lan]
   d2:3d:f3:fe:f3:53    2.110s   (225) f2:4d:5c:fc:25:8d [phy0-mesh0]
   d2:3d:f3:fe:f3:53    2.110s   (200) f2:4d:5c:fc:25:8e [phy1-mesh0]
   d2:3d:f3:fe:f3:53    2.110s   (228) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   d2:3d:f3:fe:f3:53    2.110s   (192) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
 * d2:3d:f3:fe:f3:53    2.110s   (249) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   d2:3d:f3:fe:f3:53    2.110s   (215) 20:97:27:52:6c:ab [       lan]
   2a:97:27:52:6c:ad    0.710s   (142) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   2a:97:27:52:6c:ad    0.710s   (  0) f2:4d:5c:fc:25:8d [phy0-mesh0]
 * 2a:97:27:52:6c:ad    0.710s   (229) 2a:97:27:52:6c:ad [phy0-mesh0]
   2a:97:27:52:6c:ad    0.710s   (134) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   2a:97:27:52:6c:ad    0.710s   (146) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f2:4d:5c:fd:9d:f1    3.550s   (188) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   f2:4d:5c:fd:9d:f1    3.550s   (166) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   f2:4d:5c:fd:9d:f1    3.550s   (187) 2a:97:27:52:6c:ae [phy1-mesh0]
 * f2:4d:5c:fd:9d:f1    3.550s   (243) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   f2:4d:5c:fc:25:8d    0.250s   (205) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   f2:4d:5c:fc:25:8d    0.250s   (215) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f2:4d:5c:fc:25:8d    0.250s   (217) f4:4d:5c:fd:a2:fc [       lan]
   f2:4d:5c:fc:25:8d    0.250s   (184) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   f2:4d:5c:fc:25:8d    0.250s   (238) f2:4d:5c:fc:25:8e [phy1-mesh0]
 * f2:4d:5c:fc:25:8d    0.250s   (255) f2:4d:5c:fc:25:8d [phy0-mesh0]
   f2:4d:5c:fc:25:8d    0.250s   (206) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f2:4d:5c:fd:a2:fd    2.960s   (148) 2a:97:27:52:6c:ad [phy0-mesh0]
   f2:4d:5c:fd:a2:fd    2.960s   (117) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   f2:4d:5c:fd:a2:fd    2.960s   (186) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f2:4d:5c:fd:a2:fd    2.960s   (187) f2:4d:5c:fc:25:8d [phy0-mesh0]
 * f2:4d:5c:fd:a2:fd    2.960s   (254) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f2:4d:5c:fd:9d:f0    2.430s   (155) 2a:97:27:52:6c:ad [phy0-mesh0]
   f2:4d:5c:fd:9d:f0    2.430s   (140) f2:4d:5c:fd:a2:fd [phy0-mesh0]
 * f2:4d:5c:fd:9d:f0    2.430s   (191) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   f2:4d:5c:fd:9d:f0    2.430s   (136) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   20:97:27:52:6c:ab    2.610s   (171) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   20:97:27:52:6c:ab    2.610s   (176) f2:4d:5c:fc:25:8e [phy1-mesh0]
   20:97:27:52:6c:ab    2.610s   (228) 2a:97:27:52:6c:ad [phy0-mesh0]
   20:97:27:52:6c:ab    2.610s   (198) f2:4d:5c:fc:25:8d [phy0-mesh0]
   20:97:27:52:6c:ab    2.610s   (212) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   20:97:27:52:6c:ab    2.610s   (225) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   20:97:27:52:6c:ab    2.610s   (225) f4:4d:5c:fd:a2:fc [       lan]
   20:97:27:52:6c:ab    2.610s   (170) f2:4d:5c:fd:9d:f0 [phy0-mesh0]
   20:97:27:52:6c:ab    2.610s   (240) 2a:97:27:52:6c:ae [phy1-mesh0]
   20:97:27:52:6c:ab    2.610s   (212) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
   20:97:27:52:6c:ab    2.610s   (204) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   20:97:27:52:6c:ab    2.610s   (225) f4:4d:5c:fd:9d:ef [       lan]
 * 20:97:27:52:6c:ab    2.610s   (255) 20:97:27:52:6c:ab [       lan]
   d2:3d:f3:fe:f3:54    0.330s   (187) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   d2:3d:f3:fe:f3:54    0.330s   (182) 2a:97:27:52:6c:ae [phy1-mesh0]
   d2:3d:f3:fe:f3:54    0.330s   (184) f2:4d:5c:fc:25:8e [phy1-mesh0]
   d2:3d:f3:fe:f3:54    0.330s   (154) f2:4d:5c:fd:9d:f1 [phy1-mesh0]
 * d2:3d:f3:fe:f3:54    0.330s   (227) d2:3d:f3:fe:f3:54 [phy1-mesh0]
Batctl transglobal
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: lan/f4:4d:5c:fe:51:64 (batman/16:87:5f:85:10:d4 BATMAN_IV)]
   Client             VID Flags Last ttvn     Via        ttvn  (CRC       )
 * 33:33:ff:99:79:f6   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
 * e6:b5:a1:87:27:54    0 [....] (  1) 20:97:27:52:6c:ab ( 16) (0x4edbbb86)
 * e6:b5:a1:87:27:54    3 [....] (  1) 20:97:27:52:6c:ab ( 16) (0xd70f86fe)
 * 2a:1b:08:b6:0e:40    3 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xc9b01d7f)
 * 33:33:ff:29:ce:72   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
 * 06:3a:b0:85:82:c4   11 [.W..] ( 14) 20:97:27:52:6c:ab ( 16) (0xc02ff0c8)
 * 20:97:27:52:6c:ad   12 [....] (  2) 20:97:27:52:6c:ab ( 16) (0x5c5d6f23)
 * 33:33:00:00:00:02   -1 [....] (  1) 20:97:27:52:6c:ab ( 16) (0xfaf54e6c)
   33:33:00:00:00:02   -1 [....] (  1) f4:4d:5c:fd:9d:ef ( 19) (0x6babf43b)
   33:33:00:00:00:02   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
   33:33:00:00:00:02   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
   33:33:00:00:00:02   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
   33:33:00:00:00:02   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
 * e6:b5:a1:87:27:54   12 [....] (  1) 20:97:27:52:6c:ab ( 16) (0x5c5d6f23)
 * e6:b5:a1:87:27:54   11 [....] (  1) 20:97:27:52:6c:ab ( 16) (0xc02ff0c8)
 * 33:33:ff:87:27:54   -1 [....] (  1) 20:97:27:52:6c:ab ( 16) (0xfaf54e6c)
 * b6:1d:b2:47:cd:26   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
 * 9a:58:fd:e4:aa:99    3 [.W..] (  2) 20:97:27:52:6c:ab ( 16) (0xd70f86fe)
 * 3a:ed:be:29:ce:72    3 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x9e2e0cfa)
 * 20:97:27:52:6c:ad   11 [....] (  2) 20:97:27:52:6c:ab ( 16) (0xc02ff0c8)
 * 02:22:f3:35:3e:d3   -1 [....] (  1) f4:4d:5c:fd:9d:ef ( 19) (0x6babf43b)
 * 2a:1b:08:b6:0e:40   12 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0x71d21ca1)
 * b6:1d:b2:47:cd:26   12 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0xc531fab3)
 * 2a:1b:08:b6:0e:40   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
 * b6:1d:b2:47:cd:26   11 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x3f68ffb7)
 * e6:b5:a1:87:27:54   -1 [....] (  1) 20:97:27:52:6c:ab ( 16) (0xfaf54e6c)
 * 3a:ed:be:29:ce:72   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
 * 2a:1b:08:b6:0e:40    0 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0x12f49a16)
 * b6:1d:b2:47:cd:26    0 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0xa6177c04)
 * b6:1d:b2:47:cd:26    3 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x7d53fb6d)
 * ca:4a:dc:99:79:f6   12 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xf16dbd8d)
 * ca:4a:dc:99:79:f6    0 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0x924b3b3a)
 * 01:00:5e:00:00:01   -1 [....] (  1) 20:97:27:52:6c:ab ( 16) (0xfaf54e6c)
   01:00:5e:00:00:01   -1 [....] (  1) f4:4d:5c:fd:9d:ef ( 19) (0x6babf43b)
   01:00:5e:00:00:01   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
   01:00:5e:00:00:01   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
   01:00:5e:00:00:01   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
   01:00:5e:00:00:01   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
 * 02:22:f3:35:3e:d3   12 [....] (  1) f4:4d:5c:fd:9d:ef ( 19) (0x0e42d16b)
 * 33:33:ff:00:00:00   -1 [....] (  1) 20:97:27:52:6c:ab ( 16) (0xfaf54e6c)
   33:33:ff:00:00:00   -1 [....] (  1) f4:4d:5c:fd:9d:ef ( 19) (0x6babf43b)
   33:33:ff:00:00:00   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
   33:33:ff:00:00:00   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
   33:33:ff:00:00:00   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
   33:33:ff:00:00:00   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
 * ca:4a:dc:99:79:f6   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
 * 02:22:f3:35:3e:d3    3 [....] (  1) f4:4d:5c:fd:9d:ef ( 19) (0xb620d0b5)
 * 33:33:ff:35:3e:d3   -1 [....] (  1) f4:4d:5c:fd:9d:ef ( 19) (0x6babf43b)
 * 3a:ed:be:29:ce:72   12 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x264c0d24)
 * 02:22:f3:35:3e:d3   11 [....] (  1) f4:4d:5c:fd:9d:ef ( 19) (0x7fcd4cba)
 * 3a:ed:be:29:ce:72    0 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x456a8b93)
 * 2a:1b:08:b6:0e:40   11 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0x8b8b19a5)
 * 3a:ed:be:29:ce:72   11 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0xdc150820)
 * 33:33:ff:b6:0e:40   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
 * 33:33:ff:47:cd:26   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
 * 20:97:27:52:6c:ad    3 [....] (  2) 20:97:27:52:6c:ab ( 16) (0xd70f86fe)
 * a6:c5:67:2d:44:a5   11 [.W..] ( 16) 20:97:27:52:6c:ab ( 16) (0xc02ff0c8)
 * ca:4a:dc:99:79:f6   11 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0x0b34b889)
 * 02:22:f3:35:3e:d3    0 [....] (  1) f4:4d:5c:fd:9d:ef ( 19) (0x6d6457dc)
 * 06:88:e7:a1:63:64   11 [.W..] ( 19) f4:4d:5c:fd:9d:ef ( 19) (0x7fcd4cba)
 * ca:4a:dc:99:79:f6    3 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0x490fbc53)
 * 33:33:00:00:00:01   -1 [....] (  1) 20:97:27:52:6c:ab ( 16) (0xfaf54e6c)
   33:33:00:00:00:01   -1 [....] (  1) f4:4d:5c:fd:9d:ef ( 19) (0x6babf43b)
   33:33:00:00:00:01   -1 [....] (  1) f2:4d:5c:fd:9d:f0 (  1) (0x8132d7fa)
   33:33:00:00:00:01   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
   33:33:00:00:00:01   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
   33:33:00:00:00:01   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
Batctl translocal
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: lan/f4:4d:5c:fe:51:64 (batman/16:87:5f:85:10:d4 BATMAN_IV), TTVN: 3]
Client             VID Flags    Last seen (CRC       )
16:87:5f:85:10:d4    0 [.P....]   0.000   (0xff7b8a9d)
16:87:5f:85:10:d4    3 [.P....]   0.000   (0x243f0df4)
33:33:ff:85:10:d4   -1 [.P....]   0.000   (0xbcefcdc4)
16:87:5f:85:10:d4   11 [.P....]   0.000   (0x6604092e)
33:33:00:00:00:02   -1 [.P....]   0.000   (0xbcefcdc4)
16:87:5f:85:10:d4   -1 [.P....]   0.000   (0xbcefcdc4)
01:00:5e:00:00:01   -1 [.P....]   0.000   (0xbcefcdc4)
33:33:ff:00:00:00   -1 [.P....]   0.000   (0xbcefcdc4)
16:87:5f:85:10:d4   12 [.P....]   0.000   (0x9c5d0c2a)
33:33:00:00:00:01   -1 [.P....]   0.000   (0xbcefcdc4)

```
### wap14
```shell
System Information
====================
NAME="OpenWrt"
VERSION="24.10-SNAPSHOT"
ID="openwrt"
ID_LIKE="lede openwrt"
PRETTY_NAME="OpenWrt 24.10-SNAPSHOT"
VERSION_ID="24.10-snapshot"
HOME_URL="https://openwrt.org/"
BUG_URL="https://bugs.openwrt.org/"
SUPPORT_URL="https://forum.openwrt.org/"
BUILD_ID="r0-e6677e14"
OPENWRT_BOARD="ramips/mt7621"
OPENWRT_ARCH="mipsel_24kc"
OPENWRT_TAINTS="no-all"
OPENWRT_DEVICE_MANUFACTURER="OpenWrt"
OPENWRT_DEVICE_MANUFACTURER_URL="https://openwrt.org/"
OPENWRT_DEVICE_PRODUCT="Generic"
OPENWRT_DEVICE_REVISION="v0"
OPENWRT_RELEASE="OpenWrt 24.10-SNAPSHOT r0-e6677e14"
OPENWRT_BUILD_DATE="1750175455"
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣀⣀⣤⣀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣀⣠⣀⣀⡀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣠⣾⣿⣿⣿⣿⣿⣿⣆⠀⢀⣀⣀⣤⣤⣤⣦⣦⣤⣤⣄⣀⣀⠀⢠⣾⣿⣿⣿⣿⣿⣷⣦⡀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣰⣿⣿⣿⣿⣿⣿⣿⣿⡿⠟⠛⠉⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠙⠛⠿⣿⣿⣿⣿⣿⣿⣿⣿⣷⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣿⣿⣿⣿⣿⣿⣿⠟⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠙⢿⣿⣿⣿⣿⣿⣿⡇⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⢻⣿⣿⣿⣿⡟⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠙⣿⣿⣿⣿⣿⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠻⢿⣿⠟⠀⠀⠀⠀⠀⣀⣤⣤⣤⡀⠀⠀⠀⠀⠀⢀⣤⣤⣤⣄⡀⠀⠀⠀⠀⠘⣿⡿⠿⠃⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⢠⡟⠀⠀⠀⠀⣠⣾⣿⣿⣟⣿⡇⠀⠀⠀⠀⠀⢸⣿⣿⣻⣿⣿⣦⠀⠀⠀⠀⠸⣧⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⣼⠁⠀⠀⠀⠀⣿⣿⣿⣿⣿⡟⢠⣶⣾⣿⣿⣷⣤⢽⣿⣿⣿⣿⣿⡇⠀⠀⣀⣤⣿⣷⣴⣶⣦⣀⡀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⢀⣠⣤⣤⣠⣇⠀⠀⠀⠀⠀⣿⣿⣿⣿⣿⠀⠘⠻⣿⣿⣿⡿⠋⠀⢹⣿⣿⣿⣿⡇⠀⣿⣿⣿⡏⢹⣿⠉⣿⣿⣿⣷⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⢠⣾⣿⣿⣿⣿⣿⣿⣿⣶⣄⠀⠀⠹⣿⣿⠿⠋⠀⢤⣀⢀⣼⡄⠀⣠⠀⠈⠻⣿⣿⠟⠀⢸⣿⣇⣽⣿⠿⠿⠿⣿⣅⣽⣿⡇⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣆⠀⠀⠀⠀⠀⠀⠀⠀⠈⠉⠁⠉⠉⠀⠀⠀⠀⠀⠀⠀⠀⠈⣿⣿⣟⠁⠀⠀⠀⠈⣿⣿⣿⡇⠀⠀⠀⠀⢀
⠛⠛⠛⠛⠛⠛⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛⠛
⠀⠀⠀⠀⠀⠀⠘⠛⠻⢿⣿⣿⣿⣿⣿⠟⠛⠁⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀
⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠈⠀⠈⠉⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀⠀

UB-EDGE - 2025-06-17 - 6a5e2b7
Linux f44d5cfd9def 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips GNU/Linux
Network Configuration
======================
1: lo: <LOOPBACK,UP,LOWER_UP> mtu 65536 state UNKNOWN qlen 1000
    inet6 ::1/128 scope host proto kernel_lo 
       valid_lft forever preferred_lft forever
2: eth0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1540 state UP qlen 1000
    inet6 fe80::f64d:5cff:fefd:9def/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
3: lan@eth0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1536 state UP qlen 1000
    inet6 fe80::f64d:5cff:fefd:9def/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
9: up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::22:f3ff:fe35:3ed3/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
10: up0v11@up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::22:f3ff:fe35:3ed3/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
11: up1v12@up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::22:f3ff:fe35:3ed3/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
12: up2v3@up: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fd42:dead:c0de:1337:0:f44d:5cfd:9def/64 scope global 
       valid_lft forever preferred_lft forever
    inet6 fe80::22:f3ff:fe35:3ed3/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
13: batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UNKNOWN qlen 1000
    inet6 fe80::22:f3ff:fe35:3ed3/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
14: batman.11@batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::22:f3ff:fe35:3ed3/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
15: batman.12@batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::22:f3ff:fe35:3ed3/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
16: batman.3@batman: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 state UP qlen 1000
    inet6 fe80::22:f3ff:fe35:3ed3/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
18: phy0-mesh0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1532 state UP qlen 1000
    inet6 fe80::f04d:5cff:fefd:9df0/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
21: phy1-mesh0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1532 state UP qlen 1000
    inet6 fe80::f04d:5cff:fefd:9df1/64 scope link proto kernel_ll 
       valid_lft forever preferred_lft forever
fd42:dead:c0de:1337::/64 dev up2v3 proto static metric 5 pref medium
unreachable fd71:6e08:45ed::/48 dev lo proto static metric 2147483647 pref medium
fe80::/64 dev eth0 proto kernel metric 256 pref medium
fe80::/64 dev batman proto kernel metric 256 pref medium
fe80::/64 dev batman.11 proto kernel metric 256 pref medium
fe80::/64 dev up proto kernel metric 256 pref medium
fe80::/64 dev up0v11 proto kernel metric 256 pref medium
fe80::/64 dev up1v12 proto kernel metric 256 pref medium
fe80::/64 dev up2v3 proto kernel metric 256 pref medium
fe80::/64 dev batman.12 proto kernel metric 256 pref medium
fe80::/64 dev batman.3 proto kernel metric 256 pref medium
fe80::/64 dev lan proto kernel metric 256 pref medium
fe80::/64 dev phy0-mesh0 proto kernel metric 256 pref medium
fe80::/64 dev phy1-mesh0 proto kernel metric 256 pref medium
Speed Test Report
==================
Test Started at Wed Jun 18 15:45:39 UTC 2025
Running iperf3 (Upload) test to fd42:dead:c0de:1337::1
iperf 3.17.1
Linux f44d5cfd9def 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips
Control connection MSS 1368
Time: Wed, 18 Jun 2025 15:45:39 UTC
Connecting to host fd42:dead:c0de:1337::1, port 5201
      Cookie: nn7tpaozvi64hbjx43nrjh6r7spe23gruo4f
      TCP MSS: 1368 (default)
[  5] local fd42:dead:c0de:1337:0:f44d:5cfd:9def port 49222 connected to fd42:dead:c0de:1337::1 port 5201
Starting Test: protocol: TCP, 1 streams, 131072 byte blocks, omitting 0 seconds, 10 second test, tos 0
[ ID] Interval           Transfer     Bitrate         Retr  Cwnd
[  5]   0.00-1.00   sec  16.2 MBytes   136 Mbits/sec    0    624 KBytes       
[  5]   1.00-2.00   sec  18.2 MBytes   153 Mbits/sec    0   1.09 MBytes       
[  5]   2.00-3.00   sec  15.6 MBytes   131 Mbits/sec    0   1.21 MBytes       
[  5]   3.00-4.00   sec  16.5 MBytes   138 Mbits/sec    0   1.21 MBytes       
[  5]   4.00-5.00   sec  16.6 MBytes   139 Mbits/sec    0   1.21 MBytes       
[  5]   5.00-6.00   sec  19.5 MBytes   164 Mbits/sec    0   1.21 MBytes       
[  5]   6.00-7.00   sec  18.5 MBytes   155 Mbits/sec    0   1.21 MBytes       
[  5]   7.00-8.00   sec  18.8 MBytes   157 Mbits/sec    0   1.21 MBytes       
[  5]   8.00-9.00   sec  18.4 MBytes   154 Mbits/sec    0   1.21 MBytes       
[  5]   9.00-10.00  sec  18.4 MBytes   154 Mbits/sec    0   1.21 MBytes       
- - - - - - - - - - - - - - - - - - - - - - - - -
Test Complete. Summary Results:
[ ID] Interval           Transfer     Bitrate         Retr
[  5]   0.00-10.00  sec   179 MBytes   150 Mbits/sec    0             sender
[  5]   0.00-10.05  sec   179 MBytes   149 Mbits/sec                  receiver
CPU Utilization: local/sender 64.0% (0.5%u/63.5%s), remote/receiver 70.9% (2.7%u/68.2%s)
snd_tcp_congestion cubic
rcv_tcp_congestion cubic

iperf Done.
Test Completed at Wed Jun 18 15:45:49 UTC 2025
Test iperf3 (Download) to fd42:dead:c0de:1337::1
iperf 3.17.1
Linux f44d5cfd9def 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips
Control connection MSS 1368
Time: Wed, 18 Jun 2025 15:45:49 UTC
Connecting to host fd42:dead:c0de:1337::1, port 5201
Reverse mode, remote host fd42:dead:c0de:1337::1 is sending
      Cookie: 36grfscpvyxhp2bteld63vgsyuxy53kcyjab
      TCP MSS: 1368 (default)
[  5] local fd42:dead:c0de:1337:0:f44d:5cfd:9def port 51202 connected to fd42:dead:c0de:1337::1 port 5201
Starting Test: protocol: TCP, 1 streams, 131072 byte blocks, omitting 0 seconds, 10 second test, tos 0
[ ID] Interval           Transfer     Bitrate
[  5]   0.00-1.00   sec  4.50 MBytes  37.7 Mbits/sec                  
[  5]   1.00-2.00   sec  9.88 MBytes  82.9 Mbits/sec                  
[  5]   2.00-3.00   sec  11.1 MBytes  93.4 Mbits/sec                  
[  5]   3.00-4.00   sec  9.25 MBytes  77.6 Mbits/sec                  
[  5]   4.00-5.00   sec  9.62 MBytes  80.7 Mbits/sec                  
[  5]   5.00-6.00   sec  8.75 MBytes  73.4 Mbits/sec                  
[  5]   6.00-7.00   sec  8.88 MBytes  74.4 Mbits/sec                  
[  5]   7.00-8.00   sec  9.00 MBytes  75.5 Mbits/sec                  
[  5]   8.00-9.00   sec  9.62 MBytes  80.7 Mbits/sec                  
[  5]   9.00-10.00  sec  9.12 MBytes  76.5 Mbits/sec                  
- - - - - - - - - - - - - - - - - - - - - - - - -
Test Complete. Summary Results:
[ ID] Interval           Transfer     Bitrate         Retr
[  5]   0.00-10.00  sec  91.6 MBytes  76.8 Mbits/sec    0             sender
[  5]   0.00-10.00  sec  89.8 MBytes  75.3 Mbits/sec                  receiver
snd_tcp_congestion cubic
rcv_tcp_congestion cubic

iperf Done.
Test Completed at Wed Jun 18 15:46:00 UTC 2025
Test iperf3 (Bidirectional) to fd42:dead:c0de:1337::1
iperf 3.17.1
Linux f44d5cfd9def 6.6.58 #0 SMP Tue Jun 17 15:50:55 2025 mips
Control connection MSS 1368
send_parameters:
{
	"tcp":	true,
	"omit":	0,
	"time":	10,
	"num":	0,
	"blockcount":	0,
	"parallel":	1,
	"len":	131072,
	"pacing_timer":	1000,
	"client_version":	"3.17.1"
}
Time: Wed, 18 Jun 2025 15:46:00 UTC
Connecting to host fd42:dead:c0de:1337::1, port 5201
      Cookie: pkjotbft4dryft7aiyo54boxcmv3azfhdrac
      TCP MSS: 1368 (default)
SNDBUF is 16384, expecting 0
RCVBUF is 131072, expecting 0
Congestion algorithm is cubic
[  5] local fd42:dead:c0de:1337:0:f44d:5cfd:9def port 59528 connected to fd42:dead:c0de:1337::1 port 5201
Starting Test: protocol: TCP, 1 streams, 131072 byte blocks, omitting 0 seconds, 10 second test, tos 0
Thread FD 5 created
All threads created
sent 131072 bytes of 131072, pending 0, total 131072
sent 131072 bytes of 131072, pending 0, total 262144
sent 131072 bytes of 131072, pending 0, total 393216
sent 131072 bytes of 131072, pending 0, total 524288
sent 131072 bytes of 131072, pending 0, total 655360
sent 131072 bytes of 131072, pending 0, total 786432
sent 131072 bytes of 131072, pending 0, total 917504
sent 131072 bytes of 131072, pending 0, total 1048576
sent 131072 bytes of 131072, pending 0, total 1179648
sent 131072 bytes of 131072, pending 0, total 1310720
sent 131072 bytes of 131072, pending 0, total 1441792
sent 131072 bytes of 131072, pending 0, total 1572864
sent 131072 bytes of 131072, pending 0, total 1703936
sent 131072 bytes of 131072, pending 0, total 1835008
sent 131072 bytes of 131072, pending 0, total 1966080
sent 131072 bytes of 131072, pending 0, total 2097152
sent 131072 bytes of 131072, pending 0, total 2228224
sent 131072 bytes of 131072, pending 0, total 2359296
sent 131072 bytes of 131072, pending 0, total 2490368
sent 131072 bytes of 131072, pending 0, total 2621440
sent 131072 bytes of 131072, pending 0, total 2752512
sent 131072 bytes of 131072, pending 0, total 2883584
sent 131072 bytes of 131072, pending 0, total 3014656
sent 131072 bytes of 131072, pending 0, total 3145728
sent 131072 bytes of 131072, pending 0, total 3276800
sent 131072 bytes of 131072, pending 0, total 3407872
sent 131072 bytes of 131072, pending 0, total 3538944
sent 131072 bytes of 131072, pending 0, total 3670016
sent 131072 bytes of 131072, pending 0, total 3801088
sent 131072 bytes of 131072, pending 0, total 3932160
sent 131072 bytes of 131072, pending 0, total 4063232
sent 131072 bytes of 131072, pending 0, total 4194304
sent 131072 bytes of 131072, pending 0, total 4325376
sent 131072 bytes of 131072, pending 0, total 4456448
sent 131072 bytes of 131072, pending 0, total 4587520
sent 131072 bytes of 131072, pending 0, total 4718592
sent 131072 bytes of 131072, pending 0, total 4849664
sent 131072 bytes of 131072, pending 0, total 4980736
sent 131072 bytes of 131072, pending 0, total 5111808
sent 131072 bytes of 131072, pending 0, total 5242880
sent 131072 bytes of 131072, pending 0, total 5373952
sent 131072 bytes of 131072, pending 0, total 5505024
sent 131072 bytes of 131072, pending 0, total 5636096
sent 131072 bytes of 131072, pending 0, total 5767168
sent 131072 bytes of 131072, pending 0, total 5898240
sent 131072 bytes of 131072, pending 0, total 6029312
sent 131072 bytes of 131072, pending 0, total 6160384
sent 131072 bytes of 131072, pending 0, total 6291456
sent 131072 bytes of 131072, pending 0, total 6422528
sent 131072 bytes of 131072, pending 0, total 6553600
sent 131072 bytes of 131072, pending 0, total 6684672
sent 131072 bytes of 131072, pending 0, total 6815744
sent 131072 bytes of 131072, pending 0, total 6946816
sent 131072 bytes of 131072, pending 0, total 7077888
sent 131072 bytes of 131072, pending 0, total 7208960
sent 131072 bytes of 131072, pending 0, total 7340032
sent 131072 bytes of 131072, pending 0, total 7471104
sent 131072 bytes of 131072, pending 0, total 7602176
sent 131072 bytes of 131072, pending 0, total 7733248
sent 131072 bytes of 131072, pending 0, total 7864320
sent 131072 bytes of 131072, pending 0, total 7995392
sent 131072 bytes of 131072, pending 0, total 8126464
sent 131072 bytes of 131072, pending 0, total 8257536
sent 131072 bytes of 131072, pending 0, total 8388608
sent 131072 bytes of 131072, pending 0, total 8519680
sent 131072 bytes of 131072, pending 0, total 8650752
sent 131072 bytes of 131072, pending 0, total 8781824
sent 131072 bytes of 131072, pending 0, total 8912896
sent 131072 bytes of 131072, pending 0, total 9043968
sent 131072 bytes of 131072, pending 0, total 9175040
sent 131072 bytes of 131072, pending 0, total 9306112
sent 131072 bytes of 131072, pending 0, total 9437184
sent 131072 bytes of 131072, pending 0, total 9568256
sent 131072 bytes of 131072, pending 0, total 9699328
sent 131072 bytes of 131072, pending 0, total 9830400
sent 131072 bytes of 131072, pending 0, total 9961472
sent 131072 bytes of 131072, pending 0, total 10092544
sent 131072 bytes of 131072, pending 0, total 10223616
sent 131072 bytes of 131072, pending 0, total 10354688
sent 131072 bytes of 131072, pending 0, total 10485760
sent 131072 bytes of 131072, pending 0, total 10616832
sent 131072 bytes of 131072, pending 0, total 10747904
sent 131072 bytes of 131072, pending 0, total 10878976
sent 131072 bytes of 131072, pending 0, total 11010048
sent 131072 bytes of 131072, pending 0, total 11141120
sent 131072 bytes of 131072, pending 0, total 11272192
sent 131072 bytes of 131072, pending 0, total 11403264
sent 131072 bytes of 131072, pending 0, total 11534336
sent 131072 bytes of 131072, pending 0, total 11665408
sent 131072 bytes of 131072, pending 0, total 11796480
sent 131072 bytes of 131072, pending 0, total 11927552
sent 131072 bytes of 131072, pending 0, total 12058624
sent 131072 bytes of 131072, pending 0, total 12189696
sent 131072 bytes of 131072, pending 0, total 12320768
sent 131072 bytes of 131072, pending 0, total 12451840
sent 131072 bytes of 131072, pending 0, total 12582912
sent 131072 bytes of 131072, pending 0, total 12713984
sent 131072 bytes of 131072, pending 0, total 12845056
sent 131072 bytes of 131072, pending 0, total 12976128
sent 131072 bytes of 131072, pending 0, total 13107200
sent 131072 bytes of 131072, pending 0, total 13238272
sent 131072 bytes of 131072, pending 0, total 13369344
sent 131072 bytes of 131072, pending 0, total 13500416
sent 131072 bytes of 131072, pending 0, total 13631488
sent 131072 bytes of 131072, pending 0, total 13762560
sent 131072 bytes of 131072, pending 0, total 13893632
sent 131072 bytes of 131072, pending 0, total 14024704
sent 131072 bytes of 131072, pending 0, total 14155776
sent 131072 bytes of 131072, pending 0, total 14286848
sent 131072 bytes of 131072, pending 0, total 14417920
sent 131072 bytes of 131072, pending 0, total 14548992
sent 131072 bytes of 131072, pending 0, total 14680064
sent 131072 bytes of 131072, pending 0, total 14811136
sent 131072 bytes of 131072, pending 0, total 14942208
sent 131072 bytes of 131072, pending 0, total 15073280
sent 131072 bytes of 131072, pending 0, total 15204352
sent 131072 bytes of 131072, pending 0, total 15335424
sent 131072 bytes of 131072, pending 0, total 15466496
sent 131072 bytes of 131072, pending 0, total 15597568
sent 131072 bytes of 131072, pending 0, total 15728640
sent 131072 bytes of 131072, pending 0, total 15859712
sent 131072 bytes of 131072, pending 0, total 15990784
sent 131072 bytes of 131072, pending 0, total 16121856
sent 131072 bytes of 131072, pending 0, total 16252928
sent 131072 bytes of 131072, pending 0, total 16384000
sent 131072 bytes of 131072, pending 0, total 16515072
sent 131072 bytes of 131072, pending 0, total 16646144
sent 131072 bytes of 131072, pending 0, total 16777216
sent 131072 bytes of 131072, pending 0, total 16908288
sent 131072 bytes of 131072, pending 0, total 17039360
sent 131072 bytes of 131072, pending 0, total 17170432
sent 131072 bytes of 131072, pending 0, total 17301504
sent 131072 bytes of 131072, pending 0, total 17432576
sent 131072 bytes of 131072, pending 0, total 17563648
sent 131072 bytes of 131072, pending 0, total 17694720
sent 131072 bytes of 131072, pending 0, total 17825792
sent 131072 bytes of 131072, pending 0, total 17956864
sent 131072 bytes of 131072, pending 0, total 18087936
sent 131072 bytes of 131072, pending 0, total 18219008
sent 131072 bytes of 131072, pending 0, total 18350080
sent 131072 bytes of 131072, pending 0, total 18481152
sent 131072 bytes of 131072, pending 0, total 18612224
sent 131072 bytes of 131072, pending 0, total 18743296
sent 131072 bytes of 131072, pending 0, total 18874368
sent 131072 bytes of 131072, pending 0, total 19005440
sent 131072 bytes of 131072, pending 0, total 19136512
sent 131072 bytes of 131072, pending 0, total 19267584
tcpi_snd_cwnd 355 tcpi_snd_mss 1368 tcpi_rtt 19258
interval_len 1.001169 bytes_transferred 19136512
interval forces keep
[ ID] Interval           Transfer     Bitrate         Retr  Cwnd
[  5]   0.00-1.00   sec  18.2 MBytes   153 Mbits/sec    0    474 KBytes       
sent 131072 bytes of 131072, pending 0, total 19398656
sent 131072 bytes of 131072, pending 0, total 19529728
sent 131072 bytes of 131072, pending 0, total 19660800
sent 131072 bytes of 131072, pending 0, total 19791872
sent 131072 bytes of 131072, pending 0, total 19922944
sent 131072 bytes of 131072, pending 0, total 20054016
sent 131072 bytes of 131072, pending 0, total 20185088
sent 131072 bytes of 131072, pending 0, total 20316160
sent 131072 bytes of 131072, pending 0, total 20447232
sent 131072 bytes of 131072, pending 0, total 20578304
sent 131072 bytes of 131072, pending 0, total 20709376
sent 131072 bytes of 131072, pending 0, total 20840448
sent 131072 bytes of 131072, pending 0, total 20971520
sent 131072 bytes of 131072, pending 0, total 21102592
sent 131072 bytes of 131072, pending 0, total 21233664
sent 131072 bytes of 131072, pending 0, total 21364736
sent 131072 bytes of 131072, pending 0, total 21495808
sent 131072 bytes of 131072, pending 0, total 21626880
sent 131072 bytes of 131072, pending 0, total 21757952
sent 131072 bytes of 131072, pending 0, total 21889024
sent 131072 bytes of 131072, pending 0, total 22020096
sent 131072 bytes of 131072, pending 0, total 22151168
sent 131072 bytes of 131072, pending 0, total 22282240
sent 131072 bytes of 131072, pending 0, total 22413312
sent 131072 bytes of 131072, pending 0, total 22544384
sent 131072 bytes of 131072, pending 0, total 22675456
sent 131072 bytes of 131072, pending 0, total 22806528
sent 131072 bytes of 131072, pending 0, total 22937600
sent 131072 bytes of 131072, pending 0, total 23068672
sent 131072 bytes of 131072, pending 0, total 23199744
sent 131072 bytes of 131072, pending 0, total 23330816
sent 131072 bytes of 131072, pending 0, total 23461888
sent 131072 bytes of 131072, pending 0, total 23592960
sent 131072 bytes of 131072, pending 0, total 23724032
sent 131072 bytes of 131072, pending 0, total 23855104
sent 131072 bytes of 131072, pending 0, total 23986176
sent 131072 bytes of 131072, pending 0, total 24117248
sent 131072 bytes of 131072, pending 0, total 24248320
sent 131072 bytes of 131072, pending 0, total 24379392
sent 131072 bytes of 131072, pending 0, total 24510464
sent 131072 bytes of 131072, pending 0, total 24641536
sent 131072 bytes of 131072, pending 0, total 24772608
sent 131072 bytes of 131072, pending 0, total 24903680
sent 131072 bytes of 131072, pending 0, total 25034752
sent 131072 bytes of 131072, pending 0, total 25165824
sent 131072 bytes of 131072, pending 0, total 25296896
sent 131072 bytes of 131072, pending 0, total 25427968
sent 131072 bytes of 131072, pending 0, total 25559040
sent 131072 bytes of 131072, pending 0, total 25690112
sent 131072 bytes of 131072, pending 0, total 25821184
sent 131072 bytes of 131072, pending 0, total 25952256
sent 131072 bytes of 131072, pending 0, total 26083328
sent 131072 bytes of 131072, pending 0, total 26214400
sent 131072 bytes of 131072, pending 0, total 26345472
sent 131072 bytes of 131072, pending 0, total 26476544
sent 131072 bytes of 131072, pending 0, total 26607616
sent 131072 bytes of 131072, pending 0, total 26738688
sent 131072 bytes of 131072, pending 0, total 26869760
sent 131072 bytes of 131072, pending 0, total 27000832
sent 131072 bytes of 131072, pending 0, total 27131904
sent 131072 bytes of 131072, pending 0, total 27262976
sent 131072 bytes of 131072, pending 0, total 27394048
sent 131072 bytes of 131072, pending 0, total 27525120
sent 131072 bytes of 131072, pending 0, total 27656192
sent 131072 bytes of 131072, pending 0, total 27787264
sent 131072 bytes of 131072, pending 0, total 27918336
sent 131072 bytes of 131072, pending 0, total 28049408
sent 131072 bytes of 131072, pending 0, total 28180480
sent 131072 bytes of 131072, pending 0, total 28311552
sent 131072 bytes of 131072, pending 0, total 28442624
sent 131072 bytes of 131072, pending 0, total 28573696
sent 131072 bytes of 131072, pending 0, total 28704768
sent 131072 bytes of 131072, pending 0, total 28835840
sent 131072 bytes of 131072, pending 0, total 28966912
sent 131072 bytes of 131072, pending 0, total 29097984
sent 131072 bytes of 131072, pending 0, total 29229056
sent 131072 bytes of 131072, pending 0, total 29360128
sent 131072 bytes of 131072, pending 0, total 29491200
sent 131072 bytes of 131072, pending 0, total 29622272
sent 131072 bytes of 131072, pending 0, total 29753344
sent 131072 bytes of 131072, pending 0, total 29884416
sent 131072 bytes of 131072, pending 0, total 30015488
sent 131072 bytes of 131072, pending 0, total 30146560
sent 131072 bytes of 131072, pending 0, total 30277632
sent 131072 bytes of 131072, pending 0, total 30408704
sent 131072 bytes of 131072, pending 0, total 30539776
sent 131072 bytes of 131072, pending 0, total 30670848
sent 131072 bytes of 131072, pending 0, total 30801920
sent 131072 bytes of 131072, pending 0, total 30932992
sent 131072 bytes of 131072, pending 0, total 31064064
sent 131072 bytes of 131072, pending 0, total 31195136
sent 131072 bytes of 131072, pending 0, total 31326208
sent 131072 bytes of 131072, pending 0, total 31457280
sent 131072 bytes of 131072, pending 0, total 31588352
sent 131072 bytes of 131072, pending 0, total 31719424
sent 131072 bytes of 131072, pending 0, total 31850496
sent 131072 bytes of 131072, pending 0, total 31981568
sent 131072 bytes of 131072, pending 0, total 32112640
sent 131072 bytes of 131072, pending 0, total 32243712
sent 131072 bytes of 131072, pending 0, total 32374784
sent 131072 bytes of 131072, pending 0, total 32505856
sent 131072 bytes of 131072, pending 0, total 32636928
sent 131072 bytes of 131072, pending 0, total 32768000
sent 131072 bytes of 131072, pending 0, total 32899072
sent 131072 bytes of 131072, pending 0, total 33030144
sent 131072 bytes of 131072, pending 0, total 33161216
sent 131072 bytes of 131072, pending 0, total 33292288
sent 131072 bytes of 131072, pending 0, total 33423360
sent 131072 bytes of 131072, pending 0, total 33554432
sent 131072 bytes of 131072, pending 0, total 33685504
sent 131072 bytes of 131072, pending 0, total 33816576
sent 131072 bytes of 131072, pending 0, total 33947648
sent 131072 bytes of 131072, pending 0, total 34078720
sent 131072 bytes of 131072, pending 0, total 34209792
sent 131072 bytes of 131072, pending 0, total 34340864
sent 131072 bytes of 131072, pending 0, total 34471936
sent 131072 bytes of 131072, pending 0, total 34603008
sent 131072 bytes of 131072, pending 0, total 34734080
sent 131072 bytes of 131072, pending 0, total 34865152
sent 131072 bytes of 131072, pending 0, total 34996224
sent 131072 bytes of 131072, pending 0, total 35127296
sent 131072 bytes of 131072, pending 0, total 35258368
sent 131072 bytes of 131072, pending 0, total 35389440
sent 131072 bytes of 131072, pending 0, total 35520512
sent 131072 bytes of 131072, pending 0, total 35651584
sent 131072 bytes of 131072, pending 0, total 35782656
sent 131072 bytes of 131072, pending 0, total 35913728
sent 131072 bytes of 131072, pending 0, total 36044800
sent 131072 bytes of 131072, pending 0, total 36175872
sent 131072 bytes of 131072, pending 0, total 36306944
sent 131072 bytes of 131072, pending 0, total 36438016
sent 131072 bytes of 131072, pending 0, total 36569088
sent 131072 bytes of 131072, pending 0, total 36700160
sent 131072 bytes of 131072, pending 0, total 36831232
sent 131072 bytes of 131072, pending 0, total 36962304
sent 131072 bytes of 131072, pending 0, total 37093376
sent 131072 bytes of 131072, pending 0, total 37224448
sent 131072 bytes of 131072, pending 0, total 37355520
sent 131072 bytes of 131072, pending 0, total 37486592
sent 131072 bytes of 131072, pending 0, total 37617664
sent 131072 bytes of 131072, pending 0, total 37748736
sent 131072 bytes of 131072, pending 0, total 37879808
sent 131072 bytes of 131072, pending 0, total 38010880
sent 131072 bytes of 131072, pending 0, total 38141952
sent 131072 bytes of 131072, pending 0, total 38273024
sent 131072 bytes of 131072, pending 0, total 38404096
sent 131072 bytes of 131072, pending 0, total 38535168
sent 131072 bytes of 131072, pending 0, total 38666240
sent 131072 bytes of 131072, pending 0, total 38797312
sent 131072 bytes of 131072, pending 0, total 38928384
sent 131072 bytes of 131072, pending 0, total 39059456
sent 131072 bytes of 131072, pending 0, total 39190528
sent 131072 bytes of 131072, pending 0, total 39321600
sent 131072 bytes of 131072, pending 0, total 39452672
sent 131072 bytes of 131072, pending 0, total 39583744
sent 131072 bytes of 131072, pending 0, total 39714816
sent 131072 bytes of 131072, pending 0, total 39845888
sent 131072 bytes of 131072, pending 0, total 39976960
sent 131072 bytes of 131072, pending 0, total 40108032
sent 131072 bytes of 131072, pending 0, total 40239104
sent 131072 bytes of 131072, pending 0, total 40370176
sent 131072 bytes of 131072, pending 0, total 40501248
sent 131072 bytes of 131072, pending 0, total 40632320
tcpi_snd_cwnd 627 tcpi_snd_mss 1368 tcpi_rtt 25678
interval_len 0.999999 bytes_transferred 21233664
interval forces keep
[  5]   1.00-2.00   sec  20.2 MBytes   170 Mbits/sec    0    838 KBytes       
sent 131072 bytes of 131072, pending 0, total 40763392
sent 131072 bytes of 131072, pending 0, total 40894464
sent 131072 bytes of 131072, pending 0, total 41025536
sent 131072 bytes of 131072, pending 0, total 41156608
sent 131072 bytes of 131072, pending 0, total 41287680
sent 131072 bytes of 131072, pending 0, total 41418752
sent 131072 bytes of 131072, pending 0, total 41549824
sent 131072 bytes of 131072, pending 0, total 41680896
sent 131072 bytes of 131072, pending 0, total 41811968
sent 131072 bytes of 131072, pending 0, total 41943040
sent 131072 bytes of 131072, pending 0, total 42074112
sent 131072 bytes of 131072, pending 0, total 42205184
sent 131072 bytes of 131072, pending 0, total 42336256
sent 131072 bytes of 131072, pending 0, total 42467328
sent 131072 bytes of 131072, pending 0, total 42598400
sent 131072 bytes of 131072, pending 0, total 42729472
sent 131072 bytes of 131072, pending 0, total 42860544
sent 131072 bytes of 131072, pending 0, total 42991616
sent 131072 bytes of 131072, pending 0, total 43122688
sent 131072 bytes of 131072, pending 0, total 43253760
sent 131072 bytes of 131072, pending 0, total 43384832
sent 131072 bytes of 131072, pending 0, total 43515904
sent 131072 bytes of 131072, pending 0, total 43646976
sent 131072 bytes of 131072, pending 0, total 43778048
sent 131072 bytes of 131072, pending 0, total 43909120
sent 131072 bytes of 131072, pending 0, total 44040192
sent 131072 bytes of 131072, pending 0, total 44171264
sent 131072 bytes of 131072, pending 0, total 44302336
sent 131072 bytes of 131072, pending 0, total 44433408
sent 131072 bytes of 131072, pending 0, total 44564480
sent 131072 bytes of 131072, pending 0, total 44695552
sent 131072 bytes of 131072, pending 0, total 44826624
sent 131072 bytes of 131072, pending 0, total 44957696
sent 131072 bytes of 131072, pending 0, total 45088768
sent 131072 bytes of 131072, pending 0, total 45219840
sent 131072 bytes of 131072, pending 0, total 45350912
sent 131072 bytes of 131072, pending 0, total 45481984
sent 131072 bytes of 131072, pending 0, total 45613056
sent 131072 bytes of 131072, pending 0, total 45744128
sent 131072 bytes of 131072, pending 0, total 45875200
sent 131072 bytes of 131072, pending 0, total 46006272
sent 131072 bytes of 131072, pending 0, total 46137344
sent 131072 bytes of 131072, pending 0, total 46268416
sent 131072 bytes of 131072, pending 0, total 46399488
sent 131072 bytes of 131072, pending 0, total 46530560
sent 131072 bytes of 131072, pending 0, total 46661632
sent 131072 bytes of 131072, pending 0, total 46792704
sent 131072 bytes of 131072, pending 0, total 46923776
sent 131072 bytes of 131072, pending 0, total 47054848
sent 131072 bytes of 131072, pending 0, total 47185920
sent 131072 bytes of 131072, pending 0, total 47316992
sent 131072 bytes of 131072, pending 0, total 47448064
sent 131072 bytes of 131072, pending 0, total 47579136
sent 131072 bytes of 131072, pending 0, total 47710208
sent 131072 bytes of 131072, pending 0, total 47841280
sent 131072 bytes of 131072, pending 0, total 47972352
sent 131072 bytes of 131072, pending 0, total 48103424
sent 131072 bytes of 131072, pending 0, total 48234496
sent 131072 bytes of 131072, pending 0, total 48365568
sent 131072 bytes of 131072, pending 0, total 48496640
sent 131072 bytes of 131072, pending 0, total 48627712
sent 131072 bytes of 131072, pending 0, total 48758784
sent 131072 bytes of 131072, pending 0, total 48889856
sent 131072 bytes of 131072, pending 0, total 49020928
sent 131072 bytes of 131072, pending 0, total 49152000
sent 131072 bytes of 131072, pending 0, total 49283072
sent 131072 bytes of 131072, pending 0, total 49414144
sent 131072 bytes of 131072, pending 0, total 49545216
sent 131072 bytes of 131072, pending 0, total 49676288
sent 131072 bytes of 131072, pending 0, total 49807360
sent 131072 bytes of 131072, pending 0, total 49938432
sent 131072 bytes of 131072, pending 0, total 50069504
sent 131072 bytes of 131072, pending 0, total 50200576
sent 131072 bytes of 131072, pending 0, total 50331648
sent 131072 bytes of 131072, pending 0, total 50462720
sent 131072 bytes of 131072, pending 0, total 50593792
sent 131072 bytes of 131072, pending 0, total 50724864
sent 131072 bytes of 131072, pending 0, total 50855936
sent 131072 bytes of 131072, pending 0, total 50987008
sent 131072 bytes of 131072, pending 0, total 51118080
sent 131072 bytes of 131072, pending 0, total 51249152
sent 131072 bytes of 131072, pending 0, total 51380224
sent 131072 bytes of 131072, pending 0, total 51511296
sent 131072 bytes of 131072, pending 0, total 51642368
sent 131072 bytes of 131072, pending 0, total 51773440
sent 131072 bytes of 131072, pending 0, total 51904512
sent 131072 bytes of 131072, pending 0, total 52035584
sent 131072 bytes of 131072, pending 0, total 52166656
sent 131072 bytes of 131072, pending 0, total 52297728
sent 131072 bytes of 131072, pending 0, total 52428800
sent 131072 bytes of 131072, pending 0, total 52559872
sent 131072 bytes of 131072, pending 0, total 52690944
sent 131072 bytes of 131072, pending 0, total 52822016
sent 131072 bytes of 131072, pending 0, total 52953088
sent 131072 bytes of 131072, pending 0, total 53084160
sent 131072 bytes of 131072, pending 0, total 53215232
sent 131072 bytes of 131072, pending 0, total 53346304
sent 131072 bytes of 131072, pending 0, total 53477376
sent 131072 bytes of 131072, pending 0, total 53608448
sent 131072 bytes of 131072, pending 0, total 53739520
sent 131072 bytes of 131072, pending 0, total 53870592
sent 131072 bytes of 131072, pending 0, total 54001664
sent 131072 bytes of 131072, pending 0, total 54132736
sent 131072 bytes of 131072, pending 0, total 54263808
sent 131072 bytes of 131072, pending 0, total 54394880
sent 131072 bytes of 131072, pending 0, total 54525952
sent 131072 bytes of 131072, pending 0, total 54657024
sent 131072 bytes of 131072, pending 0, total 54788096
sent 131072 bytes of 131072, pending 0, total 54919168
sent 131072 bytes of 131072, pending 0, total 55050240
sent 131072 bytes of 131072, pending 0, total 55181312
sent 131072 bytes of 131072, pending 0, total 55312384
sent 131072 bytes of 131072, pending 0, total 55443456
sent 131072 bytes of 131072, pending 0, total 55574528
sent 131072 bytes of 131072, pending 0, total 55705600
sent 131072 bytes of 131072, pending 0, total 55836672
sent 131072 bytes of 131072, pending 0, total 55967744
sent 131072 bytes of 131072, pending 0, total 56098816
sent 131072 bytes of 131072, pending 0, total 56229888
sent 131072 bytes of 131072, pending 0, total 56360960
sent 131072 bytes of 131072, pending 0, total 56492032
sent 131072 bytes of 131072, pending 0, total 56623104
sent 131072 bytes of 131072, pending 0, total 56754176
sent 131072 bytes of 131072, pending 0, total 56885248
sent 131072 bytes of 131072, pending 0, total 57016320
sent 131072 bytes of 131072, pending 0, total 57147392
sent 131072 bytes of 131072, pending 0, total 57278464
sent 131072 bytes of 131072, pending 0, total 57409536
sent 131072 bytes of 131072, pending 0, total 57540608
sent 131072 bytes of 131072, pending 0, total 57671680
sent 131072 bytes of 131072, pending 0, total 57802752
sent 131072 bytes of 131072, pending 0, total 57933824
sent 131072 bytes of 131072, pending 0, total 58064896
sent 131072 bytes of 131072, pending 0, total 58195968
tcpi_snd_cwnd 627 tcpi_snd_mss 1368 tcpi_rtt 25974
interval_len 1.000045 bytes_transferred 17563648
interval forces keep
[  5]   2.00-3.00   sec  16.8 MBytes   141 Mbits/sec    0    838 KBytes       
sent 131072 bytes of 131072, pending 0, total 58327040
sent 131072 bytes of 131072, pending 0, total 58458112
sent 131072 bytes of 131072, pending 0, total 58589184
sent 131072 bytes of 131072, pending 0, total 58720256
sent 131072 bytes of 131072, pending 0, total 58851328
sent 131072 bytes of 131072, pending 0, total 58982400
sent 131072 bytes of 131072, pending 0, total 59113472
sent 131072 bytes of 131072, pending 0, total 59244544
sent 131072 bytes of 131072, pending 0, total 59375616
sent 131072 bytes of 131072, pending 0, total 59506688
sent 131072 bytes of 131072, pending 0, total 59637760
sent 131072 bytes of 131072, pending 0, total 59768832
sent 131072 bytes of 131072, pending 0, total 59899904
sent 131072 bytes of 131072, pending 0, total 60030976
sent 131072 bytes of 131072, pending 0, total 60162048
sent 131072 bytes of 131072, pending 0, total 60293120
sent 131072 bytes of 131072, pending 0, total 60424192
sent 131072 bytes of 131072, pending 0, total 60555264
sent 131072 bytes of 131072, pending 0, total 60686336
sent 131072 bytes of 131072, pending 0, total 60817408
sent 131072 bytes of 131072, pending 0, total 60948480
sent 131072 bytes of 131072, pending 0, total 61079552
sent 131072 bytes of 131072, pending 0, total 61210624
sent 131072 bytes of 131072, pending 0, total 61341696
sent 131072 bytes of 131072, pending 0, total 61472768
sent 131072 bytes of 131072, pending 0, total 61603840
sent 131072 bytes of 131072, pending 0, total 61734912
sent 131072 bytes of 131072, pending 0, total 61865984
sent 131072 bytes of 131072, pending 0, total 61997056
sent 131072 bytes of 131072, pending 0, total 62128128
sent 131072 bytes of 131072, pending 0, total 62259200
sent 131072 bytes of 131072, pending 0, total 62390272
sent 131072 bytes of 131072, pending 0, total 62521344
sent 131072 bytes of 131072, pending 0, total 62652416
sent 131072 bytes of 131072, pending 0, total 62783488
sent 131072 bytes of 131072, pending 0, total 62914560
sent 131072 bytes of 131072, pending 0, total 63045632
sent 131072 bytes of 131072, pending 0, total 63176704
sent 131072 bytes of 131072, pending 0, total 63307776
sent 131072 bytes of 131072, pending 0, total 63438848
sent 131072 bytes of 131072, pending 0, total 63569920
sent 131072 bytes of 131072, pending 0, total 63700992
sent 131072 bytes of 131072, pending 0, total 63832064
sent 131072 bytes of 131072, pending 0, total 63963136
sent 131072 bytes of 131072, pending 0, total 64094208
sent 131072 bytes of 131072, pending 0, total 64225280
sent 131072 bytes of 131072, pending 0, total 64356352
sent 131072 bytes of 131072, pending 0, total 64487424
sent 131072 bytes of 131072, pending 0, total 64618496
sent 131072 bytes of 131072, pending 0, total 64749568
sent 131072 bytes of 131072, pending 0, total 64880640
sent 131072 bytes of 131072, pending 0, total 65011712
sent 131072 bytes of 131072, pending 0, total 65142784
sent 131072 bytes of 131072, pending 0, total 65273856
sent 131072 bytes of 131072, pending 0, total 65404928
sent 131072 bytes of 131072, pending 0, total 65536000
sent 131072 bytes of 131072, pending 0, total 65667072
sent 131072 bytes of 131072, pending 0, total 65798144
sent 131072 bytes of 131072, pending 0, total 65929216
sent 131072 bytes of 131072, pending 0, total 66060288
sent 131072 bytes of 131072, pending 0, total 66191360
sent 131072 bytes of 131072, pending 0, total 66322432
sent 131072 bytes of 131072, pending 0, total 66453504
sent 131072 bytes of 131072, pending 0, total 66584576
sent 131072 bytes of 131072, pending 0, total 66715648
sent 131072 bytes of 131072, pending 0, total 66846720
sent 131072 bytes of 131072, pending 0, total 66977792
sent 131072 bytes of 131072, pending 0, total 67108864
sent 131072 bytes of 131072, pending 0, total 67239936
sent 131072 bytes of 131072, pending 0, total 67371008
sent 131072 bytes of 131072, pending 0, total 67502080
sent 131072 bytes of 131072, pending 0, total 67633152
sent 131072 bytes of 131072, pending 0, total 67764224
sent 131072 bytes of 131072, pending 0, total 67895296
sent 131072 bytes of 131072, pending 0, total 68026368
sent 131072 bytes of 131072, pending 0, total 68157440
sent 131072 bytes of 131072, pending 0, total 68288512
sent 131072 bytes of 131072, pending 0, total 68419584
sent 131072 bytes of 131072, pending 0, total 68550656
sent 131072 bytes of 131072, pending 0, total 68681728
sent 131072 bytes of 131072, pending 0, total 68812800
sent 131072 bytes of 131072, pending 0, total 68943872
sent 131072 bytes of 131072, pending 0, total 69074944
sent 131072 bytes of 131072, pending 0, total 69206016
sent 131072 bytes of 131072, pending 0, total 69337088
sent 131072 bytes of 131072, pending 0, total 69468160
sent 131072 bytes of 131072, pending 0, total 69599232
sent 131072 bytes of 131072, pending 0, total 69730304
sent 131072 bytes of 131072, pending 0, total 69861376
sent 131072 bytes of 131072, pending 0, total 69992448
sent 131072 bytes of 131072, pending 0, total 70123520
sent 131072 bytes of 131072, pending 0, total 70254592
sent 131072 bytes of 131072, pending 0, total 70385664
sent 131072 bytes of 131072, pending 0, total 70516736
sent 131072 bytes of 131072, pending 0, total 70647808
sent 131072 bytes of 131072, pending 0, total 70778880
sent 131072 bytes of 131072, pending 0, total 70909952
sent 131072 bytes of 131072, pending 0, total 71041024
sent 131072 bytes of 131072, pending 0, total 71172096
sent 131072 bytes of 131072, pending 0, total 71303168
sent 131072 bytes of 131072, pending 0, total 71434240
sent 131072 bytes of 131072, pending 0, total 71565312
sent 131072 bytes of 131072, pending 0, total 71696384
sent 131072 bytes of 131072, pending 0, total 71827456
sent 131072 bytes of 131072, pending 0, total 71958528
sent 131072 bytes of 131072, pending 0, total 72089600
sent 131072 bytes of 131072, pending 0, total 72220672
sent 131072 bytes of 131072, pending 0, total 72351744
sent 131072 bytes of 131072, pending 0, total 72482816
sent 131072 bytes of 131072, pending 0, total 72613888
sent 131072 bytes of 131072, pending 0, total 72744960
sent 131072 bytes of 131072, pending 0, total 72876032
sent 131072 bytes of 131072, pending 0, total 73007104
sent 131072 bytes of 131072, pending 0, total 73138176
sent 131072 bytes of 131072, pending 0, total 73269248
sent 131072 bytes of 131072, pending 0, total 73400320
sent 131072 bytes of 131072, pending 0, total 73531392
sent 131072 bytes of 131072, pending 0, total 73662464
sent 131072 bytes of 131072, pending 0, total 73793536
sent 131072 bytes of 131072, pending 0, total 73924608
sent 131072 bytes of 131072, pending 0, total 74055680
sent 131072 bytes of 131072, pending 0, total 74186752
sent 131072 bytes of 131072, pending 0, total 74317824
sent 131072 bytes of 131072, pending 0, total 74448896
sent 131072 bytes of 131072, pending 0, total 74579968
sent 131072 bytes of 131072, pending 0, total 74711040
sent 131072 bytes of 131072, pending 0, total 74842112
sent 131072 bytes of 131072, pending 0, total 74973184
sent 131072 bytes of 131072, pending 0, total 75104256
sent 131072 bytes of 131072, pending 0, total 75235328
sent 131072 bytes of 131072, pending 0, total 75366400
sent 131072 bytes of 131072, pending 0, total 75497472
sent 131072 bytes of 131072, pending 0, total 75628544
sent 131072 bytes of 131072, pending 0, total 75759616
sent 131072 bytes of 131072, pending 0, total 75890688
sent 131072 bytes of 131072, pending 0, total 76021760
sent 131072 bytes of 131072, pending 0, total 76152832
sent 131072 bytes of 131072, pending 0, total 76283904
sent 131072 bytes of 131072, pending 0, total 76414976
tcpi_snd_cwnd 864 tcpi_snd_mss 1368 tcpi_rtt 61437
interval_len 0.999952 bytes_transferred 18219008
interval forces keep
[  5]   3.00-4.00   sec  17.4 MBytes   146 Mbits/sec    0   1.13 MBytes       
sent 131072 bytes of 131072, pending 0, total 76546048
sent 131072 bytes of 131072, pending 0, total 76677120
sent 131072 bytes of 131072, pending 0, total 76808192
sent 131072 bytes of 131072, pending 0, total 76939264
sent 131072 bytes of 131072, pending 0, total 77070336
sent 131072 bytes of 131072, pending 0, total 77201408
sent 131072 bytes of 131072, pending 0, total 77332480
sent 131072 bytes of 131072, pending 0, total 77463552
sent 131072 bytes of 131072, pending 0, total 77594624
sent 131072 bytes of 131072, pending 0, total 77725696
sent 131072 bytes of 131072, pending 0, total 77856768
sent 131072 bytes of 131072, pending 0, total 77987840
sent 131072 bytes of 131072, pending 0, total 78118912
sent 131072 bytes of 131072, pending 0, total 78249984
sent 131072 bytes of 131072, pending 0, total 78381056
sent 131072 bytes of 131072, pending 0, total 78512128
sent 131072 bytes of 131072, pending 0, total 78643200
sent 131072 bytes of 131072, pending 0, total 78774272
sent 131072 bytes of 131072, pending 0, total 78905344
sent 131072 bytes of 131072, pending 0, total 79036416
sent 131072 bytes of 131072, pending 0, total 79167488
sent 131072 bytes of 131072, pending 0, total 79298560
sent 131072 bytes of 131072, pending 0, total 79429632
sent 131072 bytes of 131072, pending 0, total 79560704
sent 131072 bytes of 131072, pending 0, total 79691776
sent 131072 bytes of 131072, pending 0, total 79822848
sent 131072 bytes of 131072, pending 0, total 79953920
sent 131072 bytes of 131072, pending 0, total 80084992
sent 131072 bytes of 131072, pending 0, total 80216064
sent 131072 bytes of 131072, pending 0, total 80347136
sent 131072 bytes of 131072, pending 0, total 80478208
sent 131072 bytes of 131072, pending 0, total 80609280
sent 131072 bytes of 131072, pending 0, total 80740352
sent 131072 bytes of 131072, pending 0, total 80871424
sent 131072 bytes of 131072, pending 0, total 81002496
sent 131072 bytes of 131072, pending 0, total 81133568
sent 131072 bytes of 131072, pending 0, total 81264640
sent 131072 bytes of 131072, pending 0, total 81395712
sent 131072 bytes of 131072, pending 0, total 81526784
sent 131072 bytes of 131072, pending 0, total 81657856
sent 131072 bytes of 131072, pending 0, total 81788928
sent 131072 bytes of 131072, pending 0, total 81920000
sent 131072 bytes of 131072, pending 0, total 82051072
sent 131072 bytes of 131072, pending 0, total 82182144
sent 131072 bytes of 131072, pending 0, total 82313216
sent 131072 bytes of 131072, pending 0, total 82444288
sent 131072 bytes of 131072, pending 0, total 82575360
sent 131072 bytes of 131072, pending 0, total 82706432
sent 131072 bytes of 131072, pending 0, total 82837504
sent 131072 bytes of 131072, pending 0, total 82968576
sent 131072 bytes of 131072, pending 0, total 83099648
sent 131072 bytes of 131072, pending 0, total 83230720
sent 131072 bytes of 131072, pending 0, total 83361792
sent 131072 bytes of 131072, pending 0, total 83492864
sent 131072 bytes of 131072, pending 0, total 83623936
sent 131072 bytes of 131072, pending 0, total 83755008
sent 131072 bytes of 131072, pending 0, total 83886080
sent 131072 bytes of 131072, pending 0, total 84017152
sent 131072 bytes of 131072, pending 0, total 84148224
sent 131072 bytes of 131072, pending 0, total 84279296
sent 131072 bytes of 131072, pending 0, total 84410368
sent 131072 bytes of 131072, pending 0, total 84541440
sent 131072 bytes of 131072, pending 0, total 84672512
sent 131072 bytes of 131072, pending 0, total 84803584
sent 131072 bytes of 131072, pending 0, total 84934656
sent 131072 bytes of 131072, pending 0, total 85065728
sent 131072 bytes of 131072, pending 0, total 85196800
sent 131072 bytes of 131072, pending 0, total 85327872
sent 131072 bytes of 131072, pending 0, total 85458944
sent 131072 bytes of 131072, pending 0, total 85590016
sent 131072 bytes of 131072, pending 0, total 85721088
sent 131072 bytes of 131072, pending 0, total 85852160
sent 131072 bytes of 131072, pending 0, total 85983232
sent 131072 bytes of 131072, pending 0, total 86114304
sent 131072 bytes of 131072, pending 0, total 86245376
sent 131072 bytes of 131072, pending 0, total 86376448
sent 131072 bytes of 131072, pending 0, total 86507520
sent 131072 bytes of 131072, pending 0, total 86638592
sent 131072 bytes of 131072, pending 0, total 86769664
sent 131072 bytes of 131072, pending 0, total 86900736
sent 131072 bytes of 131072, pending 0, total 87031808
sent 131072 bytes of 131072, pending 0, total 87162880
sent 131072 bytes of 131072, pending 0, total 87293952
sent 131072 bytes of 131072, pending 0, total 87425024
sent 131072 bytes of 131072, pending 0, total 87556096
sent 131072 bytes of 131072, pending 0, total 87687168
sent 131072 bytes of 131072, pending 0, total 87818240
sent 131072 bytes of 131072, pending 0, total 87949312
sent 131072 bytes of 131072, pending 0, total 88080384
sent 131072 bytes of 131072, pending 0, total 88211456
sent 131072 bytes of 131072, pending 0, total 88342528
sent 131072 bytes of 131072, pending 0, total 88473600
sent 131072 bytes of 131072, pending 0, total 88604672
sent 131072 bytes of 131072, pending 0, total 88735744
sent 131072 bytes of 131072, pending 0, total 88866816
sent 131072 bytes of 131072, pending 0, total 88997888
sent 131072 bytes of 131072, pending 0, total 89128960
sent 131072 bytes of 131072, pending 0, total 89260032
sent 131072 bytes of 131072, pending 0, total 89391104
sent 131072 bytes of 131072, pending 0, total 89522176
sent 131072 bytes of 131072, pending 0, total 89653248
sent 131072 bytes of 131072, pending 0, total 89784320
sent 131072 bytes of 131072, pending 0, total 89915392
sent 131072 bytes of 131072, pending 0, total 90046464
sent 131072 bytes of 131072, pending 0, total 90177536
sent 131072 bytes of 131072, pending 0, total 90308608
sent 131072 bytes of 131072, pending 0, total 90439680
sent 131072 bytes of 131072, pending 0, total 90570752
sent 131072 bytes of 131072, pending 0, total 90701824
sent 131072 bytes of 131072, pending 0, total 90832896
sent 131072 bytes of 131072, pending 0, total 90963968
sent 131072 bytes of 131072, pending 0, total 91095040
sent 131072 bytes of 131072, pending 0, total 91226112
sent 131072 bytes of 131072, pending 0, total 91357184
sent 131072 bytes of 131072, pending 0, total 91488256
sent 131072 bytes of 131072, pending 0, total 91619328
sent 131072 bytes of 131072, pending 0, total 91750400
sent 131072 bytes of 131072, pending 0, total 91881472
sent 131072 bytes of 131072, pending 0, total 92012544
sent 131072 bytes of 131072, pending 0, total 92143616
sent 131072 bytes of 131072, pending 0, total 92274688
sent 131072 bytes of 131072, pending 0, total 92405760
sent 131072 bytes of 131072, pending 0, total 92536832
sent 131072 bytes of 131072, pending 0, total 92667904
sent 131072 bytes of 131072, pending 0, total 92798976
sent 131072 bytes of 131072, pending 0, total 92930048
sent 131072 bytes of 131072, pending 0, total 93061120
sent 131072 bytes of 131072, pending 0, total 93192192
sent 131072 bytes of 131072, pending 0, total 93323264
sent 131072 bytes of 131072, pending 0, total 93454336
sent 131072 bytes of 131072, pending 0, total 93585408
sent 131072 bytes of 131072, pending 0, total 93716480
tcpi_snd_cwnd 955 tcpi_snd_mss 1368 tcpi_rtt 14402
interval_len 0.999986 bytes_transferred 17170432
interval forces keep
[  5]   4.00-5.00   sec  16.4 MBytes   137 Mbits/sec    0   1.25 MBytes       
sent 131072 bytes of 131072, pending 0, total 93847552
sent 131072 bytes of 131072, pending 0, total 93978624
sent 131072 bytes of 131072, pending 0, total 94109696
sent 131072 bytes of 131072, pending 0, total 94240768
sent 131072 bytes of 131072, pending 0, total 94371840
sent 131072 bytes of 131072, pending 0, total 94502912
sent 131072 bytes of 131072, pending 0, total 94633984
sent 131072 bytes of 131072, pending 0, total 94765056
sent 131072 bytes of 131072, pending 0, total 94896128
sent 131072 bytes of 131072, pending 0, total 95027200
sent 131072 bytes of 131072, pending 0, total 95158272
sent 131072 bytes of 131072, pending 0, total 95289344
sent 131072 bytes of 131072, pending 0, total 95420416
sent 131072 bytes of 131072, pending 0, total 95551488
sent 131072 bytes of 131072, pending 0, total 95682560
sent 131072 bytes of 131072, pending 0, total 95813632
sent 131072 bytes of 131072, pending 0, total 95944704
sent 131072 bytes of 131072, pending 0, total 96075776
sent 131072 bytes of 131072, pending 0, total 96206848
sent 131072 bytes of 131072, pending 0, total 96337920
sent 131072 bytes of 131072, pending 0, total 96468992
sent 131072 bytes of 131072, pending 0, total 96600064
sent 131072 bytes of 131072, pending 0, total 96731136
sent 131072 bytes of 131072, pending 0, total 96862208
sent 131072 bytes of 131072, pending 0, total 96993280
sent 131072 bytes of 131072, pending 0, total 97124352
sent 131072 bytes of 131072, pending 0, total 97255424
sent 131072 bytes of 131072, pending 0, total 97386496
sent 131072 bytes of 131072, pending 0, total 97517568
sent 131072 bytes of 131072, pending 0, total 97648640
sent 131072 bytes of 131072, pending 0, total 97779712
sent 131072 bytes of 131072, pending 0, total 97910784
sent 131072 bytes of 131072, pending 0, total 98041856
sent 131072 bytes of 131072, pending 0, total 98172928
sent 131072 bytes of 131072, pending 0, total 98304000
sent 131072 bytes of 131072, pending 0, total 98435072
sent 131072 bytes of 131072, pending 0, total 98566144
sent 131072 bytes of 131072, pending 0, total 98697216
sent 131072 bytes of 131072, pending 0, total 98828288
sent 131072 bytes of 131072, pending 0, total 98959360
sent 131072 bytes of 131072, pending 0, total 99090432
sent 131072 bytes of 131072, pending 0, total 99221504
sent 131072 bytes of 131072, pending 0, total 99352576
sent 131072 bytes of 131072, pending 0, total 99483648
sent 131072 bytes of 131072, pending 0, total 99614720
sent 131072 bytes of 131072, pending 0, total 99745792
sent 131072 bytes of 131072, pending 0, total 99876864
sent 131072 bytes of 131072, pending 0, total 100007936
sent 131072 bytes of 131072, pending 0, total 100139008
sent 131072 bytes of 131072, pending 0, total 100270080
sent 131072 bytes of 131072, pending 0, total 100401152
sent 131072 bytes of 131072, pending 0, total 100532224
sent 131072 bytes of 131072, pending 0, total 100663296
sent 131072 bytes of 131072, pending 0, total 100794368
sent 131072 bytes of 131072, pending 0, total 100925440
sent 131072 bytes of 131072, pending 0, total 101056512
sent 131072 bytes of 131072, pending 0, total 101187584
sent 131072 bytes of 131072, pending 0, total 101318656
sent 131072 bytes of 131072, pending 0, total 101449728
sent 131072 bytes of 131072, pending 0, total 101580800
sent 131072 bytes of 131072, pending 0, total 101711872
sent 131072 bytes of 131072, pending 0, total 101842944
sent 131072 bytes of 131072, pending 0, total 101974016
sent 131072 bytes of 131072, pending 0, total 102105088
sent 131072 bytes of 131072, pending 0, total 102236160
sent 131072 bytes of 131072, pending 0, total 102367232
sent 131072 bytes of 131072, pending 0, total 102498304
sent 131072 bytes of 131072, pending 0, total 102629376
sent 131072 bytes of 131072, pending 0, total 102760448
sent 131072 bytes of 131072, pending 0, total 102891520
sent 131072 bytes of 131072, pending 0, total 103022592
sent 131072 bytes of 131072, pending 0, total 103153664
sent 131072 bytes of 131072, pending 0, total 103284736
sent 131072 bytes of 131072, pending 0, total 103415808
sent 131072 bytes of 131072, pending 0, total 103546880
sent 131072 bytes of 131072, pending 0, total 103677952
sent 131072 bytes of 131072, pending 0, total 103809024
sent 131072 bytes of 131072, pending 0, total 103940096
sent 131072 bytes of 131072, pending 0, total 104071168
sent 131072 bytes of 131072, pending 0, total 104202240
sent 131072 bytes of 131072, pending 0, total 104333312
sent 131072 bytes of 131072, pending 0, total 104464384
sent 131072 bytes of 131072, pending 0, total 104595456
sent 131072 bytes of 131072, pending 0, total 104726528
sent 131072 bytes of 131072, pending 0, total 104857600
sent 131072 bytes of 131072, pending 0, total 104988672
sent 131072 bytes of 131072, pending 0, total 105119744
sent 131072 bytes of 131072, pending 0, total 105250816
sent 131072 bytes of 131072, pending 0, total 105381888
sent 131072 bytes of 131072, pending 0, total 105512960
sent 131072 bytes of 131072, pending 0, total 105644032
sent 131072 bytes of 131072, pending 0, total 105775104
sent 131072 bytes of 131072, pending 0, total 105906176
sent 131072 bytes of 131072, pending 0, total 106037248
sent 131072 bytes of 131072, pending 0, total 106168320
sent 131072 bytes of 131072, pending 0, total 106299392
sent 131072 bytes of 131072, pending 0, total 106430464
sent 131072 bytes of 131072, pending 0, total 106561536
sent 131072 bytes of 131072, pending 0, total 106692608
sent 131072 bytes of 131072, pending 0, total 106823680
sent 131072 bytes of 131072, pending 0, total 106954752
sent 131072 bytes of 131072, pending 0, total 107085824
sent 131072 bytes of 131072, pending 0, total 107216896
sent 131072 bytes of 131072, pending 0, total 107347968
sent 131072 bytes of 131072, pending 0, total 107479040
sent 131072 bytes of 131072, pending 0, total 107610112
sent 131072 bytes of 131072, pending 0, total 107741184
sent 131072 bytes of 131072, pending 0, total 107872256
sent 131072 bytes of 131072, pending 0, total 108003328
sent 131072 bytes of 131072, pending 0, total 108134400
sent 131072 bytes of 131072, pending 0, total 108265472
sent 131072 bytes of 131072, pending 0, total 108396544
sent 131072 bytes of 131072, pending 0, total 108527616
sent 131072 bytes of 131072, pending 0, total 108658688
sent 131072 bytes of 131072, pending 0, total 108789760
sent 131072 bytes of 131072, pending 0, total 108920832
sent 131072 bytes of 131072, pending 0, total 109051904
sent 131072 bytes of 131072, pending 0, total 109182976
sent 131072 bytes of 131072, pending 0, total 109314048
sent 131072 bytes of 131072, pending 0, total 109445120
sent 131072 bytes of 131072, pending 0, total 109576192
sent 131072 bytes of 131072, pending 0, total 109707264
sent 131072 bytes of 131072, pending 0, total 109838336
sent 131072 bytes of 131072, pending 0, total 109969408
sent 131072 bytes of 131072, pending 0, total 110100480
sent 131072 bytes of 131072, pending 0, total 110231552
sent 131072 bytes of 131072, pending 0, total 110362624
sent 131072 bytes of 131072, pending 0, total 110493696
sent 131072 bytes of 131072, pending 0, total 110624768
sent 131072 bytes of 131072, pending 0, total 110755840
sent 131072 bytes of 131072, pending 0, total 110886912
sent 131072 bytes of 131072, pending 0, total 111017984
sent 131072 bytes of 131072, pending 0, total 111149056
sent 131072 bytes of 131072, pending 0, total 111280128
sent 131072 bytes of 131072, pending 0, total 111411200
sent 131072 bytes of 131072, pending 0, total 111542272
sent 131072 bytes of 131072, pending 0, total 111673344
sent 131072 bytes of 131072, pending 0, total 111804416
sent 131072 bytes of 131072, pending 0, total 111935488
sent 131072 bytes of 131072, pending 0, total 112066560
sent 131072 bytes of 131072, pending 0, total 112197632
sent 131072 bytes of 131072, pending 0, total 112328704
sent 131072 bytes of 131072, pending 0, total 112459776
sent 131072 bytes of 131072, pending 0, total 112590848
sent 131072 bytes of 131072, pending 0, total 112721920
tcpi_snd_cwnd 955 tcpi_snd_mss 1368 tcpi_rtt 58189
interval_len 1.000161 bytes_transferred 18874368
interval forces keep
[  5]   5.00-6.00   sec  18.0 MBytes   151 Mbits/sec    0   1.25 MBytes       
sent 131072 bytes of 131072, pending 0, total 112852992
sent 131072 bytes of 131072, pending 0, total 112984064
sent 131072 bytes of 131072, pending 0, total 113115136
sent 131072 bytes of 131072, pending 0, total 113246208
sent 131072 bytes of 131072, pending 0, total 113377280
sent 131072 bytes of 131072, pending 0, total 113508352
sent 131072 bytes of 131072, pending 0, total 113639424
sent 131072 bytes of 131072, pending 0, total 113770496
sent 131072 bytes of 131072, pending 0, total 113901568
sent 131072 bytes of 131072, pending 0, total 114032640
sent 131072 bytes of 131072, pending 0, total 114163712
sent 131072 bytes of 131072, pending 0, total 114294784
sent 131072 bytes of 131072, pending 0, total 114425856
sent 131072 bytes of 131072, pending 0, total 114556928
sent 131072 bytes of 131072, pending 0, total 114688000
sent 131072 bytes of 131072, pending 0, total 114819072
sent 131072 bytes of 131072, pending 0, total 114950144
sent 131072 bytes of 131072, pending 0, total 115081216
sent 131072 bytes of 131072, pending 0, total 115212288
sent 131072 bytes of 131072, pending 0, total 115343360
sent 131072 bytes of 131072, pending 0, total 115474432
sent 131072 bytes of 131072, pending 0, total 115605504
sent 131072 bytes of 131072, pending 0, total 115736576
sent 131072 bytes of 131072, pending 0, total 115867648
sent 131072 bytes of 131072, pending 0, total 115998720
sent 131072 bytes of 131072, pending 0, total 116129792
sent 131072 bytes of 131072, pending 0, total 116260864
sent 131072 bytes of 131072, pending 0, total 116391936
sent 131072 bytes of 131072, pending 0, total 116523008
sent 131072 bytes of 131072, pending 0, total 116654080
sent 131072 bytes of 131072, pending 0, total 116785152
sent 131072 bytes of 131072, pending 0, total 116916224
sent 131072 bytes of 131072, pending 0, total 117047296
sent 131072 bytes of 131072, pending 0, total 117178368
sent 131072 bytes of 131072, pending 0, total 117309440
sent 131072 bytes of 131072, pending 0, total 117440512
sent 131072 bytes of 131072, pending 0, total 117571584
sent 131072 bytes of 131072, pending 0, total 117702656
sent 131072 bytes of 131072, pending 0, total 117833728
sent 131072 bytes of 131072, pending 0, total 117964800
sent 131072 bytes of 131072, pending 0, total 118095872
sent 131072 bytes of 131072, pending 0, total 118226944
sent 131072 bytes of 131072, pending 0, total 118358016
sent 131072 bytes of 131072, pending 0, total 118489088
sent 131072 bytes of 131072, pending 0, total 118620160
sent 131072 bytes of 131072, pending 0, total 118751232
sent 131072 bytes of 131072, pending 0, total 118882304
sent 131072 bytes of 131072, pending 0, total 119013376
sent 131072 bytes of 131072, pending 0, total 119144448
sent 131072 bytes of 131072, pending 0, total 119275520
sent 131072 bytes of 131072, pending 0, total 119406592
sent 131072 bytes of 131072, pending 0, total 119537664
sent 131072 bytes of 131072, pending 0, total 119668736
sent 131072 bytes of 131072, pending 0, total 119799808
sent 131072 bytes of 131072, pending 0, total 119930880
sent 131072 bytes of 131072, pending 0, total 120061952
sent 131072 bytes of 131072, pending 0, total 120193024
sent 131072 bytes of 131072, pending 0, total 120324096
sent 131072 bytes of 131072, pending 0, total 120455168
sent 131072 bytes of 131072, pending 0, total 120586240
sent 131072 bytes of 131072, pending 0, total 120717312
sent 131072 bytes of 131072, pending 0, total 120848384
sent 131072 bytes of 131072, pending 0, total 120979456
sent 131072 bytes of 131072, pending 0, total 121110528
sent 131072 bytes of 131072, pending 0, total 121241600
sent 131072 bytes of 131072, pending 0, total 121372672
sent 131072 bytes of 131072, pending 0, total 121503744
sent 131072 bytes of 131072, pending 0, total 121634816
sent 131072 bytes of 131072, pending 0, total 121765888
sent 131072 bytes of 131072, pending 0, total 121896960
sent 131072 bytes of 131072, pending 0, total 122028032
sent 131072 bytes of 131072, pending 0, total 122159104
sent 131072 bytes of 131072, pending 0, total 122290176
sent 131072 bytes of 131072, pending 0, total 122421248
sent 131072 bytes of 131072, pending 0, total 122552320
sent 131072 bytes of 131072, pending 0, total 122683392
sent 131072 bytes of 131072, pending 0, total 122814464
sent 131072 bytes of 131072, pending 0, total 122945536
sent 131072 bytes of 131072, pending 0, total 123076608
sent 131072 bytes of 131072, pending 0, total 123207680
sent 131072 bytes of 131072, pending 0, total 123338752
sent 131072 bytes of 131072, pending 0, total 123469824
sent 131072 bytes of 131072, pending 0, total 123600896
sent 131072 bytes of 131072, pending 0, total 123731968
sent 131072 bytes of 131072, pending 0, total 123863040
sent 131072 bytes of 131072, pending 0, total 123994112
sent 131072 bytes of 131072, pending 0, total 124125184
sent 131072 bytes of 131072, pending 0, total 124256256
sent 131072 bytes of 131072, pending 0, total 124387328
sent 131072 bytes of 131072, pending 0, total 124518400
sent 131072 bytes of 131072, pending 0, total 124649472
sent 131072 bytes of 131072, pending 0, total 124780544
sent 131072 bytes of 131072, pending 0, total 124911616
sent 131072 bytes of 131072, pending 0, total 125042688
sent 131072 bytes of 131072, pending 0, total 125173760
sent 131072 bytes of 131072, pending 0, total 125304832
sent 131072 bytes of 131072, pending 0, total 125435904
sent 131072 bytes of 131072, pending 0, total 125566976
sent 131072 bytes of 131072, pending 0, total 125698048
sent 131072 bytes of 131072, pending 0, total 125829120
sent 131072 bytes of 131072, pending 0, total 125960192
sent 131072 bytes of 131072, pending 0, total 126091264
sent 131072 bytes of 131072, pending 0, total 126222336
sent 131072 bytes of 131072, pending 0, total 126353408
sent 131072 bytes of 131072, pending 0, total 126484480
sent 131072 bytes of 131072, pending 0, total 126615552
sent 131072 bytes of 131072, pending 0, total 126746624
sent 131072 bytes of 131072, pending 0, total 126877696
sent 131072 bytes of 131072, pending 0, total 127008768
sent 131072 bytes of 131072, pending 0, total 127139840
sent 131072 bytes of 131072, pending 0, total 127270912
sent 131072 bytes of 131072, pending 0, total 127401984
sent 131072 bytes of 131072, pending 0, total 127533056
sent 131072 bytes of 131072, pending 0, total 127664128
sent 131072 bytes of 131072, pending 0, total 127795200
sent 131072 bytes of 131072, pending 0, total 127926272
sent 131072 bytes of 131072, pending 0, total 128057344
sent 131072 bytes of 131072, pending 0, total 128188416
sent 131072 bytes of 131072, pending 0, total 128319488
sent 131072 bytes of 131072, pending 0, total 128450560
sent 131072 bytes of 131072, pending 0, total 128581632
sent 131072 bytes of 131072, pending 0, total 128712704
sent 131072 bytes of 131072, pending 0, total 128843776
sent 131072 bytes of 131072, pending 0, total 128974848
sent 131072 bytes of 131072, pending 0, total 129105920
sent 131072 bytes of 131072, pending 0, total 129236992
sent 131072 bytes of 131072, pending 0, total 129368064
sent 131072 bytes of 131072, pending 0, total 129499136
sent 131072 bytes of 131072, pending 0, total 129630208
sent 131072 bytes of 131072, pending 0, total 129761280
sent 131072 bytes of 131072, pending 0, total 129892352
sent 131072 bytes of 131072, pending 0, total 130023424
sent 131072 bytes of 131072, pending 0, total 130154496
sent 131072 bytes of 131072, pending 0, total 130285568
sent 131072 bytes of 131072, pending 0, total 130416640
sent 131072 bytes of 131072, pending 0, total 130547712
sent 131072 bytes of 131072, pending 0, total 130678784
tcpi_snd_cwnd 955 tcpi_snd_mss 1368 tcpi_rtt 43502
interval_len 0.999846 bytes_transferred 17825792
interval forces keep
[  5]   6.00-7.00   sec  17.0 MBytes   143 Mbits/sec    0   1.25 MBytes       
sent 131072 bytes of 131072, pending 0, total 130809856
sent 131072 bytes of 131072, pending 0, total 130940928
sent 131072 bytes of 131072, pending 0, total 131072000
sent 131072 bytes of 131072, pending 0, total 131203072
sent 131072 bytes of 131072, pending 0, total 131334144
sent 131072 bytes of 131072, pending 0, total 131465216
sent 131072 bytes of 131072, pending 0, total 131596288
sent 131072 bytes of 131072, pending 0, total 131727360
sent 131072 bytes of 131072, pending 0, total 131858432
sent 131072 bytes of 131072, pending 0, total 131989504
sent 131072 bytes of 131072, pending 0, total 132120576
sent 131072 bytes of 131072, pending 0, total 132251648
sent 131072 bytes of 131072, pending 0, total 132382720
sent 131072 bytes of 131072, pending 0, total 132513792
sent 131072 bytes of 131072, pending 0, total 132644864
sent 131072 bytes of 131072, pending 0, total 132775936
sent 131072 bytes of 131072, pending 0, total 132907008
sent 131072 bytes of 131072, pending 0, total 133038080
sent 131072 bytes of 131072, pending 0, total 133169152
sent 131072 bytes of 131072, pending 0, total 133300224
sent 131072 bytes of 131072, pending 0, total 133431296
sent 131072 bytes of 131072, pending 0, total 133562368
sent 131072 bytes of 131072, pending 0, total 133693440
sent 131072 bytes of 131072, pending 0, total 133824512
sent 131072 bytes of 131072, pending 0, total 133955584
sent 131072 bytes of 131072, pending 0, total 134086656
sent 131072 bytes of 131072, pending 0, total 134217728
sent 131072 bytes of 131072, pending 0, total 134348800
sent 131072 bytes of 131072, pending 0, total 134479872
sent 131072 bytes of 131072, pending 0, total 134610944
sent 131072 bytes of 131072, pending 0, total 134742016
sent 131072 bytes of 131072, pending 0, total 134873088
sent 131072 bytes of 131072, pending 0, total 135004160
sent 131072 bytes of 131072, pending 0, total 135135232
sent 131072 bytes of 131072, pending 0, total 135266304
sent 131072 bytes of 131072, pending 0, total 135397376
sent 131072 bytes of 131072, pending 0, total 135528448
sent 131072 bytes of 131072, pending 0, total 135659520
sent 131072 bytes of 131072, pending 0, total 135790592
sent 131072 bytes of 131072, pending 0, total 135921664
sent 131072 bytes of 131072, pending 0, total 136052736
sent 131072 bytes of 131072, pending 0, total 136183808
sent 131072 bytes of 131072, pending 0, total 136314880
sent 131072 bytes of 131072, pending 0, total 136445952
sent 131072 bytes of 131072, pending 0, total 136577024
sent 131072 bytes of 131072, pending 0, total 136708096
sent 131072 bytes of 131072, pending 0, total 136839168
sent 131072 bytes of 131072, pending 0, total 136970240
sent 131072 bytes of 131072, pending 0, total 137101312
sent 131072 bytes of 131072, pending 0, total 137232384
sent 131072 bytes of 131072, pending 0, total 137363456
sent 131072 bytes of 131072, pending 0, total 137494528
sent 131072 bytes of 131072, pending 0, total 137625600
sent 131072 bytes of 131072, pending 0, total 137756672
sent 131072 bytes of 131072, pending 0, total 137887744
sent 131072 bytes of 131072, pending 0, total 138018816
sent 131072 bytes of 131072, pending 0, total 138149888
sent 131072 bytes of 131072, pending 0, total 138280960
sent 131072 bytes of 131072, pending 0, total 138412032
sent 131072 bytes of 131072, pending 0, total 138543104
sent 131072 bytes of 131072, pending 0, total 138674176
sent 131072 bytes of 131072, pending 0, total 138805248
sent 131072 bytes of 131072, pending 0, total 138936320
sent 131072 bytes of 131072, pending 0, total 139067392
sent 131072 bytes of 131072, pending 0, total 139198464
sent 131072 bytes of 131072, pending 0, total 139329536
sent 131072 bytes of 131072, pending 0, total 139460608
sent 131072 bytes of 131072, pending 0, total 139591680
sent 131072 bytes of 131072, pending 0, total 139722752
sent 131072 bytes of 131072, pending 0, total 139853824
sent 131072 bytes of 131072, pending 0, total 139984896
sent 131072 bytes of 131072, pending 0, total 140115968
sent 131072 bytes of 131072, pending 0, total 140247040
sent 131072 bytes of 131072, pending 0, total 140378112
sent 131072 bytes of 131072, pending 0, total 140509184
sent 131072 bytes of 131072, pending 0, total 140640256
sent 131072 bytes of 131072, pending 0, total 140771328
sent 131072 bytes of 131072, pending 0, total 140902400
sent 131072 bytes of 131072, pending 0, total 141033472
sent 131072 bytes of 131072, pending 0, total 141164544
sent 131072 bytes of 131072, pending 0, total 141295616
sent 131072 bytes of 131072, pending 0, total 141426688
sent 131072 bytes of 131072, pending 0, total 141557760
sent 131072 bytes of 131072, pending 0, total 141688832
sent 131072 bytes of 131072, pending 0, total 141819904
sent 131072 bytes of 131072, pending 0, total 141950976
sent 131072 bytes of 131072, pending 0, total 142082048
sent 131072 bytes of 131072, pending 0, total 142213120
sent 131072 bytes of 131072, pending 0, total 142344192
sent 131072 bytes of 131072, pending 0, total 142475264
sent 131072 bytes of 131072, pending 0, total 142606336
sent 131072 bytes of 131072, pending 0, total 142737408
sent 131072 bytes of 131072, pending 0, total 142868480
sent 131072 bytes of 131072, pending 0, total 142999552
sent 131072 bytes of 131072, pending 0, total 143130624
sent 131072 bytes of 131072, pending 0, total 143261696
sent 131072 bytes of 131072, pending 0, total 143392768
sent 131072 bytes of 131072, pending 0, total 143523840
sent 131072 bytes of 131072, pending 0, total 143654912
sent 131072 bytes of 131072, pending 0, total 143785984
sent 131072 bytes of 131072, pending 0, total 143917056
sent 131072 bytes of 131072, pending 0, total 144048128
sent 131072 bytes of 131072, pending 0, total 144179200
sent 131072 bytes of 131072, pending 0, total 144310272
sent 131072 bytes of 131072, pending 0, total 144441344
sent 131072 bytes of 131072, pending 0, total 144572416
sent 131072 bytes of 131072, pending 0, total 144703488
sent 131072 bytes of 131072, pending 0, total 144834560
sent 131072 bytes of 131072, pending 0, total 144965632
sent 131072 bytes of 131072, pending 0, total 145096704
sent 131072 bytes of 131072, pending 0, total 145227776
sent 131072 bytes of 131072, pending 0, total 145358848
sent 131072 bytes of 131072, pending 0, total 145489920
sent 131072 bytes of 131072, pending 0, total 145620992
sent 131072 bytes of 131072, pending 0, total 145752064
sent 131072 bytes of 131072, pending 0, total 145883136
sent 131072 bytes of 131072, pending 0, total 146014208
sent 131072 bytes of 131072, pending 0, total 146145280
sent 131072 bytes of 131072, pending 0, total 146276352
sent 131072 bytes of 131072, pending 0, total 146407424
sent 131072 bytes of 131072, pending 0, total 146538496
sent 131072 bytes of 131072, pending 0, total 146669568
sent 131072 bytes of 131072, pending 0, total 146800640
sent 131072 bytes of 131072, pending 0, total 146931712
sent 131072 bytes of 131072, pending 0, total 147062784
sent 131072 bytes of 131072, pending 0, total 147193856
sent 131072 bytes of 131072, pending 0, total 147324928
sent 131072 bytes of 131072, pending 0, total 147456000
sent 131072 bytes of 131072, pending 0, total 147587072
sent 131072 bytes of 131072, pending 0, total 147718144
sent 131072 bytes of 131072, pending 0, total 147849216
sent 131072 bytes of 131072, pending 0, total 147980288
sent 131072 bytes of 131072, pending 0, total 148111360
sent 131072 bytes of 131072, pending 0, total 148242432
sent 131072 bytes of 131072, pending 0, total 148373504
sent 131072 bytes of 131072, pending 0, total 148504576
sent 131072 bytes of 131072, pending 0, total 148635648
sent 131072 bytes of 131072, pending 0, total 148766720
sent 131072 bytes of 131072, pending 0, total 148897792
tcpi_snd_cwnd 955 tcpi_snd_mss 1368 tcpi_rtt 73302
interval_len 1.000084 bytes_transferred 18087936
interval forces keep
[  5]   7.00-8.00   sec  17.2 MBytes   145 Mbits/sec    0   1.25 MBytes       
sent 131072 bytes of 131072, pending 0, total 149028864
sent 131072 bytes of 131072, pending 0, total 149159936
sent 131072 bytes of 131072, pending 0, total 149291008
sent 131072 bytes of 131072, pending 0, total 149422080
sent 131072 bytes of 131072, pending 0, total 149553152
sent 131072 bytes of 131072, pending 0, total 149684224
sent 131072 bytes of 131072, pending 0, total 149815296
sent 131072 bytes of 131072, pending 0, total 149946368
sent 131072 bytes of 131072, pending 0, total 150077440
sent 131072 bytes of 131072, pending 0, total 150208512
sent 131072 bytes of 131072, pending 0, total 150339584
sent 131072 bytes of 131072, pending 0, total 150470656
sent 131072 bytes of 131072, pending 0, total 150601728
sent 131072 bytes of 131072, pending 0, total 150732800
sent 131072 bytes of 131072, pending 0, total 150863872
sent 131072 bytes of 131072, pending 0, total 150994944
sent 131072 bytes of 131072, pending 0, total 151126016
sent 131072 bytes of 131072, pending 0, total 151257088
sent 131072 bytes of 131072, pending 0, total 151388160
sent 131072 bytes of 131072, pending 0, total 151519232
sent 131072 bytes of 131072, pending 0, total 151650304
sent 131072 bytes of 131072, pending 0, total 151781376
sent 131072 bytes of 131072, pending 0, total 151912448
sent 131072 bytes of 131072, pending 0, total 152043520
sent 131072 bytes of 131072, pending 0, total 152174592
sent 131072 bytes of 131072, pending 0, total 152305664
sent 131072 bytes of 131072, pending 0, total 152436736
sent 131072 bytes of 131072, pending 0, total 152567808
sent 131072 bytes of 131072, pending 0, total 152698880
sent 131072 bytes of 131072, pending 0, total 152829952
sent 131072 bytes of 131072, pending 0, total 152961024
sent 131072 bytes of 131072, pending 0, total 153092096
sent 131072 bytes of 131072, pending 0, total 153223168
sent 131072 bytes of 131072, pending 0, total 153354240
sent 131072 bytes of 131072, pending 0, total 153485312
sent 131072 bytes of 131072, pending 0, total 153616384
sent 131072 bytes of 131072, pending 0, total 153747456
sent 131072 bytes of 131072, pending 0, total 153878528
sent 131072 bytes of 131072, pending 0, total 154009600
sent 131072 bytes of 131072, pending 0, total 154140672
sent 131072 bytes of 131072, pending 0, total 154271744
sent 131072 bytes of 131072, pending 0, total 154402816
sent 131072 bytes of 131072, pending 0, total 154533888
sent 131072 bytes of 131072, pending 0, total 154664960
sent 131072 bytes of 131072, pending 0, total 154796032
sent 131072 bytes of 131072, pending 0, total 154927104
sent 131072 bytes of 131072, pending 0, total 155058176
sent 131072 bytes of 131072, pending 0, total 155189248
sent 131072 bytes of 131072, pending 0, total 155320320
sent 131072 bytes of 131072, pending 0, total 155451392
sent 131072 bytes of 131072, pending 0, total 155582464
sent 131072 bytes of 131072, pending 0, total 155713536
sent 131072 bytes of 131072, pending 0, total 155844608
sent 131072 bytes of 131072, pending 0, total 155975680
sent 131072 bytes of 131072, pending 0, total 156106752
sent 131072 bytes of 131072, pending 0, total 156237824
sent 131072 bytes of 131072, pending 0, total 156368896
sent 131072 bytes of 131072, pending 0, total 156499968
sent 131072 bytes of 131072, pending 0, total 156631040
sent 131072 bytes of 131072, pending 0, total 156762112
sent 131072 bytes of 131072, pending 0, total 156893184
sent 131072 bytes of 131072, pending 0, total 157024256
sent 131072 bytes of 131072, pending 0, total 157155328
sent 131072 bytes of 131072, pending 0, total 157286400
sent 131072 bytes of 131072, pending 0, total 157417472
sent 131072 bytes of 131072, pending 0, total 157548544
sent 131072 bytes of 131072, pending 0, total 157679616
sent 131072 bytes of 131072, pending 0, total 157810688
sent 131072 bytes of 131072, pending 0, total 157941760
sent 131072 bytes of 131072, pending 0, total 158072832
sent 131072 bytes of 131072, pending 0, total 158203904
sent 131072 bytes of 131072, pending 0, total 158334976
sent 131072 bytes of 131072, pending 0, total 158466048
sent 131072 bytes of 131072, pending 0, total 158597120
sent 131072 bytes of 131072, pending 0, total 158728192
sent 131072 bytes of 131072, pending 0, total 158859264
sent 131072 bytes of 131072, pending 0, total 158990336
sent 131072 bytes of 131072, pending 0, total 159121408
sent 131072 bytes of 131072, pending 0, total 159252480
sent 131072 bytes of 131072, pending 0, total 159383552
sent 131072 bytes of 131072, pending 0, total 159514624
sent 131072 bytes of 131072, pending 0, total 159645696
sent 131072 bytes of 131072, pending 0, total 159776768
sent 131072 bytes of 131072, pending 0, total 159907840
sent 131072 bytes of 131072, pending 0, total 160038912
sent 131072 bytes of 131072, pending 0, total 160169984
sent 131072 bytes of 131072, pending 0, total 160301056
sent 131072 bytes of 131072, pending 0, total 160432128
sent 131072 bytes of 131072, pending 0, total 160563200
sent 131072 bytes of 131072, pending 0, total 160694272
sent 131072 bytes of 131072, pending 0, total 160825344
sent 131072 bytes of 131072, pending 0, total 160956416
sent 131072 bytes of 131072, pending 0, total 161087488
sent 131072 bytes of 131072, pending 0, total 161218560
sent 131072 bytes of 131072, pending 0, total 161349632
sent 131072 bytes of 131072, pending 0, total 161480704
sent 131072 bytes of 131072, pending 0, total 161611776
sent 131072 bytes of 131072, pending 0, total 161742848
sent 131072 bytes of 131072, pending 0, total 161873920
sent 131072 bytes of 131072, pending 0, total 162004992
sent 131072 bytes of 131072, pending 0, total 162136064
sent 131072 bytes of 131072, pending 0, total 162267136
sent 131072 bytes of 131072, pending 0, total 162398208
sent 131072 bytes of 131072, pending 0, total 162529280
sent 131072 bytes of 131072, pending 0, total 162660352
sent 131072 bytes of 131072, pending 0, total 162791424
sent 131072 bytes of 131072, pending 0, total 162922496
sent 131072 bytes of 131072, pending 0, total 163053568
sent 131072 bytes of 131072, pending 0, total 163184640
sent 131072 bytes of 131072, pending 0, total 163315712
sent 131072 bytes of 131072, pending 0, total 163446784
sent 131072 bytes of 131072, pending 0, total 163577856
sent 131072 bytes of 131072, pending 0, total 163708928
sent 131072 bytes of 131072, pending 0, total 163840000
sent 131072 bytes of 131072, pending 0, total 163971072
sent 131072 bytes of 131072, pending 0, total 164102144
sent 131072 bytes of 131072, pending 0, total 164233216
sent 131072 bytes of 131072, pending 0, total 164364288
sent 131072 bytes of 131072, pending 0, total 164495360
sent 131072 bytes of 131072, pending 0, total 164626432
sent 131072 bytes of 131072, pending 0, total 164757504
sent 131072 bytes of 131072, pending 0, total 164888576
sent 131072 bytes of 131072, pending 0, total 165019648
sent 131072 bytes of 131072, pending 0, total 165150720
sent 131072 bytes of 131072, pending 0, total 165281792
sent 131072 bytes of 131072, pending 0, total 165412864
sent 131072 bytes of 131072, pending 0, total 165543936
sent 131072 bytes of 131072, pending 0, total 165675008
sent 131072 bytes of 131072, pending 0, total 165806080
sent 131072 bytes of 131072, pending 0, total 165937152
sent 131072 bytes of 131072, pending 0, total 166068224
sent 131072 bytes of 131072, pending 0, total 166199296
sent 131072 bytes of 131072, pending 0, total 166330368
sent 131072 bytes of 131072, pending 0, total 166461440
sent 131072 bytes of 131072, pending 0, total 166592512
tcpi_snd_cwnd 955 tcpi_snd_mss 1368 tcpi_rtt 63899
interval_len 0.999931 bytes_transferred 17563648
interval forces keep
[  5]   8.00-9.00   sec  16.8 MBytes   141 Mbits/sec    0   1.25 MBytes       
sent 131072 bytes of 131072, pending 0, total 166723584
sent 131072 bytes of 131072, pending 0, total 166854656
sent 131072 bytes of 131072, pending 0, total 166985728
sent 131072 bytes of 131072, pending 0, total 167116800
sent 131072 bytes of 131072, pending 0, total 167247872
sent 131072 bytes of 131072, pending 0, total 167378944
sent 131072 bytes of 131072, pending 0, total 167510016
sent 131072 bytes of 131072, pending 0, total 167641088
sent 131072 bytes of 131072, pending 0, total 167772160
sent 131072 bytes of 131072, pending 0, total 167903232
sent 131072 bytes of 131072, pending 0, total 168034304
sent 131072 bytes of 131072, pending 0, total 168165376
sent 131072 bytes of 131072, pending 0, total 168296448
sent 131072 bytes of 131072, pending 0, total 168427520
sent 131072 bytes of 131072, pending 0, total 168558592
sent 131072 bytes of 131072, pending 0, total 168689664
sent 131072 bytes of 131072, pending 0, total 168820736
sent 131072 bytes of 131072, pending 0, total 168951808
sent 131072 bytes of 131072, pending 0, total 169082880
sent 131072 bytes of 131072, pending 0, total 169213952
sent 131072 bytes of 131072, pending 0, total 169345024
sent 131072 bytes of 131072, pending 0, total 169476096
sent 131072 bytes of 131072, pending 0, total 169607168
sent 131072 bytes of 131072, pending 0, total 169738240
sent 131072 bytes of 131072, pending 0, total 169869312
sent 131072 bytes of 131072, pending 0, total 170000384
sent 131072 bytes of 131072, pending 0, total 170131456
sent 131072 bytes of 131072, pending 0, total 170262528
sent 131072 bytes of 131072, pending 0, total 170393600
sent 131072 bytes of 131072, pending 0, total 170524672
sent 131072 bytes of 131072, pending 0, total 170655744
sent 131072 bytes of 131072, pending 0, total 170786816
sent 131072 bytes of 131072, pending 0, total 170917888
sent 131072 bytes of 131072, pending 0, total 171048960
sent 131072 bytes of 131072, pending 0, total 171180032
sent 131072 bytes of 131072, pending 0, total 171311104
sent 131072 bytes of 131072, pending 0, total 171442176
sent 131072 bytes of 131072, pending 0, total 171573248
sent 131072 bytes of 131072, pending 0, total 171704320
sent 131072 bytes of 131072, pending 0, total 171835392
sent 131072 bytes of 131072, pending 0, total 171966464
sent 131072 bytes of 131072, pending 0, total 172097536
sent 131072 bytes of 131072, pending 0, total 172228608
sent 131072 bytes of 131072, pending 0, total 172359680
sent 131072 bytes of 131072, pending 0, total 172490752
sent 131072 bytes of 131072, pending 0, total 172621824
sent 131072 bytes of 131072, pending 0, total 172752896
sent 131072 bytes of 131072, pending 0, total 172883968
sent 131072 bytes of 131072, pending 0, total 173015040
sent 131072 bytes of 131072, pending 0, total 173146112
sent 131072 bytes of 131072, pending 0, total 173277184
sent 131072 bytes of 131072, pending 0, total 173408256
sent 131072 bytes of 131072, pending 0, total 173539328
sent 131072 bytes of 131072, pending 0, total 173670400
sent 131072 bytes of 131072, pending 0, total 173801472
sent 131072 bytes of 131072, pending 0, total 173932544
sent 131072 bytes of 131072, pending 0, total 174063616
sent 131072 bytes of 131072, pending 0, total 174194688
sent 131072 bytes of 131072, pending 0, total 174325760
sent 131072 bytes of 131072, pending 0, total 174456832
sent 131072 bytes of 131072, pending 0, total 174587904
sent 131072 bytes of 131072, pending 0, total 174718976
sent 131072 bytes of 131072, pending 0, total 174850048
sent 131072 bytes of 131072, pending 0, total 174981120
sent 131072 bytes of 131072, pending 0, total 175112192
sent 131072 bytes of 131072, pending 0, total 175243264
sent 131072 bytes of 131072, pending 0, total 175374336
sent 131072 bytes of 131072, pending 0, total 175505408
sent 131072 bytes of 131072, pending 0, total 175636480
sent 131072 bytes of 131072, pending 0, total 175767552
sent 131072 bytes of 131072, pending 0, total 175898624
sent 131072 bytes of 131072, pending 0, total 176029696
sent 131072 bytes of 131072, pending 0, total 176160768
sent 131072 bytes of 131072, pending 0, total 176291840
sent 131072 bytes of 131072, pending 0, total 176422912
sent 131072 bytes of 131072, pending 0, total 176553984
sent 131072 bytes of 131072, pending 0, total 176685056
sent 131072 bytes of 131072, pending 0, total 176816128
sent 131072 bytes of 131072, pending 0, total 176947200
sent 131072 bytes of 131072, pending 0, total 177078272
sent 131072 bytes of 131072, pending 0, total 177209344
sent 131072 bytes of 131072, pending 0, total 177340416
sent 131072 bytes of 131072, pending 0, total 177471488
sent 131072 bytes of 131072, pending 0, total 177602560
sent 131072 bytes of 131072, pending 0, total 177733632
sent 131072 bytes of 131072, pending 0, total 177864704
sent 131072 bytes of 131072, pending 0, total 177995776
sent 131072 bytes of 131072, pending 0, total 178126848
sent 131072 bytes of 131072, pending 0, total 178257920
sent 131072 bytes of 131072, pending 0, total 178388992
sent 131072 bytes of 131072, pending 0, total 178520064
sent 131072 bytes of 131072, pending 0, total 178651136
sent 131072 bytes of 131072, pending 0, total 178782208
sent 131072 bytes of 131072, pending 0, total 178913280
sent 131072 bytes of 131072, pending 0, total 179044352
sent 131072 bytes of 131072, pending 0, total 179175424
sent 131072 bytes of 131072, pending 0, total 179306496
sent 131072 bytes of 131072, pending 0, total 179437568
sent 131072 bytes of 131072, pending 0, total 179568640
sent 131072 bytes of 131072, pending 0, total 179699712
sent 131072 bytes of 131072, pending 0, total 179830784
sent 131072 bytes of 131072, pending 0, total 179961856
sent 131072 bytes of 131072, pending 0, total 180092928
sent 131072 bytes of 131072, pending 0, total 180224000
sent 131072 bytes of 131072, pending 0, total 180355072
sent 131072 bytes of 131072, pending 0, total 180486144
sent 131072 bytes of 131072, pending 0, total 180617216
sent 131072 bytes of 131072, pending 0, total 180748288
sent 131072 bytes of 131072, pending 0, total 180879360
sent 131072 bytes of 131072, pending 0, total 181010432
sent 131072 bytes of 131072, pending 0, total 181141504
sent 131072 bytes of 131072, pending 0, total 181272576
sent 131072 bytes of 131072, pending 0, total 181403648
sent 131072 bytes of 131072, pending 0, total 181534720
sent 131072 bytes of 131072, pending 0, total 181665792
sent 131072 bytes of 131072, pending 0, total 181796864
sent 131072 bytes of 131072, pending 0, total 181927936
sent 131072 bytes of 131072, pending 0, total 182059008
sent 131072 bytes of 131072, pending 0, total 182190080
sent 131072 bytes of 131072, pending 0, total 182321152
sent 131072 bytes of 131072, pending 0, total 182452224
sent 131072 bytes of 131072, pending 0, total 182583296
sent 131072 bytes of 131072, pending 0, total 182714368
sent 131072 bytes of 131072, pending 0, total 182845440
sent 131072 bytes of 131072, pending 0, total 182976512
sent 131072 bytes of 131072, pending 0, total 183107584
sent 131072 bytes of 131072, pending 0, total 183238656
sent 131072 bytes of 131072, pending 0, total 183369728
sent 131072 bytes of 131072, pending 0, total 183500800
sent 131072 bytes of 131072, pending 0, total 183631872
sent 131072 bytes of 131072, pending 0, total 183762944
sent 131072 bytes of 131072, pending 0, total 183894016
sent 131072 bytes of 131072, pending 0, total 184025088
sent 131072 bytes of 131072, pending 0, total 184156160
Thread FD 5 stopped
Sender threads stopped
tcpi_snd_cwnd 955 tcpi_snd_mss 1368 tcpi_rtt 66276
send_results
{
	"cpu_util_total":	83.907392814685835,
	"cpu_util_user":	0.786599809824459,
	"cpu_util_system":	83.1207730452118,
	"sender_has_retransmits":	1,
	"congestion_used":	"cubic",
	"streams":	[{
			"id":	1,
			"bytes":	184156160,
			"retransmits":	0,
			"jitter":	0,
			"errors":	0,
			"omitted_errors":	0,
			"packets":	0,
			"omitted_packets":	0,
			"start_time":	0,
			"end_time":	10.007778
		}]
}
get_results
{
	"cpu_util_total":	68.748793080440549,
	"cpu_util_user":	2.8826857283887568,
	"cpu_util_system":	65.86612723950077,
	"sender_has_retransmits":	-1,
	"congestion_used":	"cubic",
	"streams":	[{
			"id":	1,
			"bytes":	184156160,
			"retransmits":	-1,
			"jitter":	0,
			"errors":	0,
			"omitted_errors":	0,
			"packets":	0,
			"omitted_packets":	0,
			"start_time":	0,
			"end_time":	10.056353
		}]
}
interval_len 1.006605 bytes_transferred 17563648
interval forces keep
[  5]   9.00-10.01  sec  16.8 MBytes   140 Mbits/sec    0   1.25 MBytes       
- - - - - - - - - - - - - - - - - - - - - - - - -
Test Complete. Summary Results:
[ ID] Interval           Transfer     Bitrate         Retr
[  5]   0.00-10.01  sec   176 MBytes   147 Mbits/sec    0             sender
[  5]   0.00-10.06  sec   176 MBytes   146 Mbits/sec                  receiver
CPU Utilization: local/sender 83.9% (0.8%u/83.1%s), remote/receiver 68.7% (2.9%u/65.9%s)
snd_tcp_congestion cubic
rcv_tcp_congestion cubic
Receiver threads stopped

iperf Done.
Test Completed at Wed Jun 18 15:46:10 UTC 2025
Batman/Batctl Report
====================
Batctl neighbors
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: lan/f4:4d:5c:fd:9d:ef (batman/02:22:f3:35:3e:d3 BATMAN_IV)]
IF             Neighbor              last-seen
          lan	  20:97:27:52:6c:ab    4.460s
          lan	  f4:4d:5c:fe:51:64    0.670s
          lan	  f4:4d:5c:fd:a2:fc    0.870s
   phy0-mesh0	  2a:97:27:52:6c:ad    2.460s
   phy0-mesh0	  f2:4d:5c:fc:25:8d    2.000s
   phy0-mesh0	  f2:4d:5c:fe:51:65    4.190s
   phy0-mesh0	  f2:4d:5c:fd:a2:fd    4.710s
   phy0-mesh0	  d2:3d:f3:fe:f3:53    9.040s
   phy1-mesh0	  f2:4d:5c:fc:25:8e   43.920s
   phy1-mesh0	  2a:97:27:52:6c:ae    0.460s
   phy1-mesh0	  f2:4d:5c:fd:a2:fe    0.230s
   phy1-mesh0	  d2:3d:f3:fe:f3:54    2.080s
   phy1-mesh0	  f2:4d:5c:fe:51:66    4.350s
Batctl originators
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: lan/f4:4d:5c:fd:9d:ef (batman/02:22:f3:35:3e:d3 BATMAN_IV)]
   Originator        last-seen (#/255) Nexthop           [outgoingIF]
   f4:4d:5c:fd:a2:fc    0.720s   (  8) f2:4d:5c:fc:25:8e [phy1-mesh0]
   f4:4d:5c:fd:a2:fc    0.720s   (225) 20:97:27:52:6c:ab [       lan]
   f4:4d:5c:fd:a2:fc    0.720s   (139) f2:4d:5c:fc:25:8d [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    0.720s   (212) 2a:97:27:52:6c:ae [phy1-mesh0]
   f4:4d:5c:fd:a2:fc    0.720s   (206) 2a:97:27:52:6c:ad [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    0.720s   (213) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   f4:4d:5c:fd:a2:fc    0.720s   (182) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   f4:4d:5c:fd:a2:fc    0.720s   (194) f2:4d:5c:fe:51:65 [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    0.720s   (209) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f4:4d:5c:fd:a2:fc    0.720s   (196) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    0.720s   (198) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f4:4d:5c:fd:a2:fc    0.720s   (225) f4:4d:5c:fe:51:64 [       lan]
 * f4:4d:5c:fd:a2:fc    0.720s   (255) f4:4d:5c:fd:a2:fc [       lan]
   f2:4d:5c:fc:25:8e    3.300s   (  0) f2:4d:5c:fc:25:8e [phy1-mesh0]
   f2:4d:5c:fc:25:8e    3.300s   (163) 2a:97:27:52:6c:ae [phy1-mesh0]
   f2:4d:5c:fc:25:8e    3.300s   (164) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   f2:4d:5c:fc:25:8e    3.300s   (157) f2:4d:5c:fd:a2:fe [phy1-mesh0]
 * f2:4d:5c:fc:25:8e    3.300s   (168) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f2:4d:5c:fe:51:65    4.070s   (144) 2a:97:27:52:6c:ad [phy0-mesh0]
   f2:4d:5c:fe:51:65    4.070s   ( 93) f2:4d:5c:fc:25:8d [phy0-mesh0]
   f2:4d:5c:fe:51:65    4.070s   (133) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f2:4d:5c:fe:51:65    4.070s   (164) d2:3d:f3:fe:f3:53 [phy0-mesh0]
 * f2:4d:5c:fe:51:65    4.070s   (217) f2:4d:5c:fe:51:65 [phy0-mesh0]
   f2:4d:5c:fd:a2:fe    0.150s   (  0) f2:4d:5c:fc:25:8e [phy1-mesh0]
   f2:4d:5c:fd:a2:fe    0.150s   (165) 2a:97:27:52:6c:ae [phy1-mesh0]
   f2:4d:5c:fd:a2:fe    0.150s   (164) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   f2:4d:5c:fd:a2:fe    0.150s   (171) f2:4d:5c:fe:51:66 [phy1-mesh0]
 * f2:4d:5c:fd:a2:fe    0.150s   (209) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   2a:97:27:52:6c:ae    0.350s   (152) d2:3d:f3:fe:f3:54 [phy1-mesh0]
 * 2a:97:27:52:6c:ae    0.350s   (240) 2a:97:27:52:6c:ae [phy1-mesh0]
   2a:97:27:52:6c:ae    0.350s   (160) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   2a:97:27:52:6c:ae    0.350s   (175) f2:4d:5c:fe:51:66 [phy1-mesh0]
   d2:3d:f3:fe:f3:53    3.760s   (  0) f2:4d:5c:fc:25:8e [phy1-mesh0]
   d2:3d:f3:fe:f3:53    3.760s   (  0) f2:4d:5c:fc:25:8d [phy0-mesh0]
   d2:3d:f3:fe:f3:53    3.760s   (186) 2a:97:27:52:6c:ae [phy1-mesh0]
   d2:3d:f3:fe:f3:53    3.760s   (206) 2a:97:27:52:6c:ad [phy0-mesh0]
   d2:3d:f3:fe:f3:53    3.760s   (225) 20:97:27:52:6c:ab [       lan]
   d2:3d:f3:fe:f3:53    3.760s   (174) f2:4d:5c:fe:51:65 [phy0-mesh0]
   d2:3d:f3:fe:f3:53    3.760s   (174) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   d2:3d:f3:fe:f3:53    3.760s   (215) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   d2:3d:f3:fe:f3:53    3.760s   (173) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   d2:3d:f3:fe:f3:53    3.760s   (205) f2:4d:5c:fe:51:66 [phy1-mesh0]
 * d2:3d:f3:fe:f3:53    3.760s   (227) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   d2:3d:f3:fe:f3:53    3.760s   (225) f4:4d:5c:fd:a2:fc [       lan]
   d2:3d:f3:fe:f3:53    3.760s   (221) f4:4d:5c:fe:51:64 [       lan]
   2a:97:27:52:6c:ad    2.350s   (112) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   2a:97:27:52:6c:ad    2.350s   (  0) f2:4d:5c:fc:25:8d [phy0-mesh0]
   2a:97:27:52:6c:ad    2.350s   (156) f2:4d:5c:fe:51:65 [phy0-mesh0]
   2a:97:27:52:6c:ad    2.350s   (139) d2:3d:f3:fe:f3:53 [phy0-mesh0]
 * 2a:97:27:52:6c:ad    2.350s   (234) 2a:97:27:52:6c:ad [phy0-mesh0]
   f2:4d:5c:fc:25:8d    1.890s   (  0) f2:4d:5c:fc:25:8e [phy1-mesh0]
   f2:4d:5c:fc:25:8d    1.890s   (181) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   f2:4d:5c:fc:25:8d    1.890s   (173) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   f2:4d:5c:fc:25:8d    1.890s   (209) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f2:4d:5c:fc:25:8d    1.890s   (178) f2:4d:5c:fe:51:65 [phy0-mesh0]
   f2:4d:5c:fc:25:8d    1.890s   (165) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f2:4d:5c:fc:25:8d    1.890s   (149) f2:4d:5c:fc:25:8d [phy0-mesh0]
   f2:4d:5c:fc:25:8d    1.890s   (195) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f2:4d:5c:fc:25:8d    1.890s   (217) f4:4d:5c:fd:a2:fc [       lan]
 * f2:4d:5c:fc:25:8d    1.890s   (225) f4:4d:5c:fe:51:64 [       lan]
   f2:4d:5c:fd:a2:fd    4.600s   (146) 2a:97:27:52:6c:ad [phy0-mesh0]
   f2:4d:5c:fd:a2:fd    4.600s   (115) f2:4d:5c:fc:25:8d [phy0-mesh0]
   f2:4d:5c:fd:a2:fd    4.600s   (168) f2:4d:5c:fe:51:65 [phy0-mesh0]
   f2:4d:5c:fd:a2:fd    4.600s   (170) d2:3d:f3:fe:f3:53 [phy0-mesh0]
 * f2:4d:5c:fd:a2:fd    4.600s   (195) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f2:4d:5c:fe:51:66    4.240s   (  8) f2:4d:5c:fc:25:8e [phy1-mesh0]
   f2:4d:5c:fe:51:66    4.240s   (183) 2a:97:27:52:6c:ae [phy1-mesh0]
   f2:4d:5c:fe:51:66    4.240s   (165) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   f2:4d:5c:fe:51:66    4.240s   (166) d2:3d:f3:fe:f3:54 [phy1-mesh0]
 * f2:4d:5c:fe:51:66    4.240s   (238) f2:4d:5c:fe:51:66 [phy1-mesh0]
   20:97:27:52:6c:ab    4.230s   (  0) f2:4d:5c:fc:25:8e [phy1-mesh0]
   20:97:27:52:6c:ab    4.230s   (  0) f2:4d:5c:fc:25:8d [phy0-mesh0]
   20:97:27:52:6c:ab    4.230s   (173) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   20:97:27:52:6c:ab    4.230s   (234) 2a:97:27:52:6c:ad [phy0-mesh0]
   20:97:27:52:6c:ab    4.230s   (240) 2a:97:27:52:6c:ae [phy1-mesh0]
   20:97:27:52:6c:ab    4.230s   (161) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   20:97:27:52:6c:ab    4.230s   (183) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   20:97:27:52:6c:ab    4.230s   (187) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   20:97:27:52:6c:ab    4.230s   (191) f2:4d:5c:fe:51:65 [phy0-mesh0]
   20:97:27:52:6c:ab    4.230s   (209) f2:4d:5c:fe:51:66 [phy1-mesh0]
   20:97:27:52:6c:ab    4.230s   (225) f4:4d:5c:fe:51:64 [       lan]
   20:97:27:52:6c:ab    4.230s   (225) f4:4d:5c:fd:a2:fc [       lan]
 * 20:97:27:52:6c:ab    4.230s   (255) 20:97:27:52:6c:ab [       lan]
   f4:4d:5c:fe:51:64    0.520s   (  0) f2:4d:5c:fc:25:8e [phy1-mesh0]
   f4:4d:5c:fe:51:64    0.520s   (134) f2:4d:5c:fc:25:8d [phy0-mesh0]
   f4:4d:5c:fe:51:64    0.520s   (206) 2a:97:27:52:6c:ad [phy0-mesh0]
   f4:4d:5c:fe:51:64    0.520s   (212) 2a:97:27:52:6c:ae [phy1-mesh0]
   f4:4d:5c:fe:51:64    0.520s   (225) 20:97:27:52:6c:ab [       lan]
   f4:4d:5c:fe:51:64    0.520s   (187) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   f4:4d:5c:fe:51:64    0.520s   (179) d2:3d:f3:fe:f3:54 [phy1-mesh0]
   f4:4d:5c:fe:51:64    0.520s   (173) f2:4d:5c:fd:a2:fd [phy0-mesh0]
   f4:4d:5c:fe:51:64    0.520s   (220) f2:4d:5c:fe:51:65 [phy0-mesh0]
   f4:4d:5c:fe:51:64    0.520s   (237) f2:4d:5c:fe:51:66 [phy1-mesh0]
   f4:4d:5c:fe:51:64    0.520s   (199) d2:3d:f3:fe:f3:53 [phy0-mesh0]
   f4:4d:5c:fe:51:64    0.520s   (225) f4:4d:5c:fd:a2:fc [       lan]
 * f4:4d:5c:fe:51:64    0.520s   (255) f4:4d:5c:fe:51:64 [       lan]
   d2:3d:f3:fe:f3:54    1.890s   (  8) f2:4d:5c:fc:25:8e [phy1-mesh0]
   d2:3d:f3:fe:f3:54    1.890s   (187) 2a:97:27:52:6c:ae [phy1-mesh0]
   d2:3d:f3:fe:f3:54    1.890s   (165) f2:4d:5c:fd:a2:fe [phy1-mesh0]
   d2:3d:f3:fe:f3:54    1.890s   (165) f2:4d:5c:fe:51:66 [phy1-mesh0]
 * d2:3d:f3:fe:f3:54    1.890s   (215) d2:3d:f3:fe:f3:54 [phy1-mesh0]
Batctl transglobal
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: lan/f4:4d:5c:fd:9d:ef (batman/02:22:f3:35:3e:d3 BATMAN_IV)]
   Client             VID Flags Last ttvn     Via        ttvn  (CRC       )
 * 33:33:ff:99:79:f6   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
 * e6:b5:a1:87:27:54    0 [....] (  1) 20:97:27:52:6c:ab ( 17) (0x4edbbb86)
 * 16:87:5f:85:10:d4    0 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xff7b8a9d)
 * e6:b5:a1:87:27:54    3 [....] (  1) 20:97:27:52:6c:ab ( 17) (0xd70f86fe)
 * 2a:1b:08:b6:0e:40    3 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xc9b01d7f)
 * 06:3a:b0:85:82:c4   11 [.W..] ( 14) 20:97:27:52:6c:ab ( 17) (0xb36fd246)
 * 16:87:5f:85:10:d4    3 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0x243f0df4)
 * 33:33:ff:85:10:d4   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
 * 20:97:27:52:6c:ad   12 [....] (  2) 20:97:27:52:6c:ab ( 17) (0x5c5d6f23)
 * 16:87:5f:85:10:d4   11 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0x6604092e)
 * 33:33:00:00:00:02   -1 [....] (  1) 20:97:27:52:6c:ab ( 17) (0xfaf54e6c)
   33:33:00:00:00:02   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
   33:33:00:00:00:02   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
   33:33:00:00:00:02   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
   33:33:00:00:00:02   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
 * e6:b5:a1:87:27:54   12 [....] (  1) 20:97:27:52:6c:ab ( 17) (0x5c5d6f23)
 * 33:33:ff:87:27:54   -1 [....] (  1) 20:97:27:52:6c:ab ( 17) (0xfaf54e6c)
 * e6:b5:a1:87:27:54   11 [....] (  1) 20:97:27:52:6c:ab ( 17) (0xb36fd246)
 * b6:1d:b2:47:cd:26   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
 * 9a:58:fd:e4:aa:99    3 [.W..] (  2) 20:97:27:52:6c:ab ( 17) (0xd70f86fe)
 * 20:97:27:52:6c:ad   11 [....] (  2) 20:97:27:52:6c:ab ( 17) (0xb36fd246)
 * 2a:1b:08:b6:0e:40   12 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0x71d21ca1)
 * b6:1d:b2:47:cd:26   12 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0xc531fab3)
 * 2a:1b:08:b6:0e:40   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
 * b6:1d:b2:47:cd:26   11 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x3f68ffb7)
 * e6:b5:a1:87:27:54   -1 [....] (  1) 20:97:27:52:6c:ab ( 17) (0xfaf54e6c)
 * 2a:1b:08:b6:0e:40    0 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0x12f49a16)
 * b6:1d:b2:47:cd:26    0 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0xa6177c04)
 * b6:1d:b2:47:cd:26    3 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x7d53fb6d)
 * 16:87:5f:85:10:d4   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
 * ca:4a:dc:99:79:f6   12 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xf16dbd8d)
 * ca:4a:dc:99:79:f6    0 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0x924b3b3a)
 * 01:00:5e:00:00:01   -1 [....] (  1) 20:97:27:52:6c:ab ( 17) (0xfaf54e6c)
   01:00:5e:00:00:01   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
   01:00:5e:00:00:01   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
   01:00:5e:00:00:01   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
   01:00:5e:00:00:01   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
 * 33:33:ff:00:00:00   -1 [....] (  1) 20:97:27:52:6c:ab ( 17) (0xfaf54e6c)
   33:33:ff:00:00:00   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
   33:33:ff:00:00:00   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
   33:33:ff:00:00:00   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
   33:33:ff:00:00:00   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
 * ca:4a:dc:99:79:f6   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
 * 16:87:5f:85:10:d4   12 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0x9c5d0c2a)
 * 2a:1b:08:b6:0e:40   11 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0x8b8b19a5)
 * 33:33:ff:b6:0e:40   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
 * 33:33:ff:47:cd:26   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
 * 20:97:27:52:6c:ad    3 [....] (  2) 20:97:27:52:6c:ab ( 17) (0xd70f86fe)
 * a6:c5:67:2d:44:a5   11 [R...] ( 18) 20:97:27:52:6c:ab ( 17) (0xb36fd246)
 * ca:4a:dc:99:79:f6   11 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0x0b34b889)
 * ca:4a:dc:99:79:f6    3 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0x490fbc53)
 * 33:33:00:00:00:01   -1 [....] (  1) 20:97:27:52:6c:ab ( 17) (0xfaf54e6c)
   33:33:00:00:00:01   -1 [....] (  1) f2:4d:5c:fc:25:8d (  1) (0x0fd67627)
   33:33:00:00:00:01   -1 [....] (  1) d2:3d:f3:fe:f3:53 (  5) (0xc85e1bd6)
   33:33:00:00:00:01   -1 [....] (  1) f4:4d:5c:fe:51:64 (  3) (0xbcefcdc4)
   33:33:00:00:00:01   -1 [....] (  1) f4:4d:5c:fd:a2:fc (  4) (0xb48493a1)
Batctl translocal
[B.A.T.M.A.N. adv 2024.3-openwrt-2, MainIF/MAC: lan/f4:4d:5c:fd:9d:ef (batman/02:22:f3:35:3e:d3 BATMAN_IV), TTVN: 23]
Client             VID Flags    Last seen (CRC       )
33:33:00:00:00:02   -1 [.P....]   0.000   (0x6babf43b)
02:22:f3:35:3e:d3   -1 [.P....]   0.000   (0x6babf43b)
01:00:5e:00:00:01   -1 [.P....]   0.000   (0x6babf43b)
02:22:f3:35:3e:d3   12 [.P....]   0.000   (0x0e42d16b)
33:33:ff:00:00:00   -1 [.P....]   0.000   (0x6babf43b)
02:22:f3:35:3e:d3    3 [.P....]   0.000   (0xb620d0b5)
33:33:ff:35:3e:d3   -1 [.P....]   0.000   (0x6babf43b)
02:22:f3:35:3e:d3   11 [.P....]   0.000   (0x7fcd4cba)
02:22:f3:35:3e:d3    0 [.P....]   0.000   (0x6d6457dc)
06:88:e7:a1:63:64   11 [....W.]   0.030   (0x7fcd4cba)
33:33:00:00:00:01   -1 [.P....]   0.000   (0x6babf43b)

```

