# Lab Setup

## Index

- [Index](#index)
- [IP List](#ip-list)
- [Schematic](#schematic)
- [Components](#components)
  - [Test Client](#test-client)
  - [Switch](#switch)
  - [USB Hub](#usb-hub)
  - [USB UART adapter](#usb-uart-adapter)
  - [Connections](#connections)
  - [Reboot PoE Device](#reboot-poe-device)

## IP List

- labbook: 10.42.3.39
- current default controller ip: 192.168.133.1
- current IPv6 controller ip: fd42:dead:c0de:1337::1
- aws ip: 35.157.207.77
- server with 64cores and 1tb memory (lab-edge-da): 10.42.3.42
- our proxxe in se case: 10.42.3.34 / 10.42.3.35 "iLo"

## Accessing the Lab

The Lab is using [labgrid](https://labgrid.readthedocs.io/en/v24.0.2/) to orchestrate the testing resources in a way they are accessible to humas as well as automatic CI testing.

This comes with some advantages.

 - Instead of interfacing with a PoE Switch to toggle a device, a serial console on a Notebook to access console, a Server to download images, the devices are handled as a entity instead of components
 - Queueing enables conflict-free working even with multiple CI jobs.
 - Labgrid uses a distributed architecture which enables to have a central coordinator orchestrating multiple machines controlling the actual test equipment
 
 
> In our case the Coordinator and executer are both running on the machine in the Darmstadt Lab
{.is-info}

### Places

Labgrid organizes devices in "Places". The following list depicts all places defined in our lab

| Name | Device |
| ---- | ------ |
| teltonika | Teltonika Gateway |
| ap1 | ZyXEL 1 |
| ap2 | ZyXEL 2 |


### Installation

You will require labgrid to be installed on your local machine in order to facilitate local-running deployments.

[Refer to the Installation the CI is performing in the Git repository.](https://git.uniberg.com/ub-edge/uconfig/uconfigd/-/blob/labgrid-integration/labgrid/labgrid-ci-setup.sh)

> The addition to the hosts file is necessary, as Labgrid does not use IP addresses for the connection to the coordinator.
{.is-info}

### Connecting

> You will require to export the address of the labgrid coordinator in your environment.
{.is-warning}
```
export LG_CROSSBAR="ws://10.42.3.39:20408/ws"
```

Ensure the Virtual Environment is enabled
```
source "/tmp/labgrid-venv/bin/activate"
```

### Acquiring a place

In order to work with a device on your local machine, you will need to acquire the device before using it.


```
labgrid-client -p <place> acquire
```


### Releasing a place

 After working with a place, ensure you release it in order for CI jobs (or your lovely coworker) to work with it
 
 ```
 labgrid-client -p <place> release
 ```
 
#### Releasing a locked place

In case you receive a warning indicating the device is in use, you can force-release the place.

```
labgrid-client -p <place> release --kick
```

> Don't forget to check who blocked the resource. Ask first before you force release!
{.is-success}


```
labgrid-client -p <place> show
```


### Command reference

Here are soem commands which allow you to work with the labgrid CLI

#### Power

Get the device Power state

```
labgrid-client -p <place> power get
```

Power-Cycle the device

```
labgrid-client -p <place> power cycle
```

Power-Down the device

```
labgrid-client -p <place> power off
```

Power-On the device

```
labgrid-client -p <place> power on
```

#### Console

Access the device console (R/W)

```
labgrid-client -p <place> con
```

Exiting this console uses the same keybindings as telnet for escape characters.

On MacOS, this is `CTRL`+`5`.


## Schematic

![labdiagram](labdiagram.png)

## Components

### Test Client

2x HP MSM460

#### Package list

https://firmware-selector.openwrt.org/?version=24.10.0-rc6&target=mpc85xx%2Fp1020&id=hpe_msm460

```
base-files ca-bundle dropbear fstools kmod-ath9k kmod-button-hotplug kmod-crypto-hw-talitos kmod-input-core kmod-input-gpio-keys kmod-leds-gpio libc libgcc libustream-openssl logd mtd netifd odhcp6c opkg procd-ujail uboot-envtools uci uclient-fetch urandom-seed urngd wpad-openssl luci tcpdump iw-full iperf3 wpa-cli tmux
```

### Switch

| Port | Device        | IP-Address   | Misc              | VLAN  |
|------|---------------|--------------|-------------------|-------|
| 1    | Uplink        | 10.42.3.1/24 |                   | 423   |
| 2    | Labbook       | 10.42.3.39   |                   | 423   |
| 3    | Teltonik WAN  | 10.42.3.121  |                   | 423   |
| 4    | Test AP1      |              |                   | 423   |
| 5    | TEST AP2      |              |                   | 423   |
| 6    |               |              |                   |       |
| 19   | Zyxel 1       |              | D4:3D:F3:FE:DE:76 | ???   |
| 21   | Zyxel 2       |              | D4:3D:F3:FE:DE:82 | ???   |
| 23   | Teltonika LAN |              |                   | ???   |
| 48   | Labbook Trunk |              |                   | TRUNK |


### Connections

All use baudrate 115200

Close Session with STRG+A and STRG+X

```
picocom -b115200 /dev/ttyUSBx
```

| Port | Device |
| ------ | ------ |
| /dev/ttyUSB0 | HP Switch |
| /dev/ttyUSB1 | Teltonika |
| /dev/ttyUSB2 | ZyXEL |
| /dev/ttyUSB3 | ZyXEL |


### Reboot PoE Device

Connect to HP switch

```
enable
configure
no interface <port> power-over-ethernet
interface <port> power-over-ethernet
```

## Allow Traffic from VPN to teltonika WAN

Connect to Teltonika via Labbook serial.

```
ip a add 10.42.3.121/24 dev up3v0; ip r add 10.41.0.0/16 via 10.42.3.1 dev up3v0; /etc/init.d/firewall stop
```
