# Remote Access

- [Remote Access](#remote-access)
  - [TL;DR](#tldr)
    - [How do i clear all settings on a device](#how-do-i-clear-all-settings-on-a-device)
    - [How do i access the Serial Port of a Device?](#how-do-i-access-the-serial-port-of-a-device)
    - [How do i Reboot a device?](#how-do-i-reboot-a-device)
    - [I fucked up and need to reflash?](#i-fucked-up-and-need-to-reflash)
      - [Reflash using OpenWrt failsafe](#reflash-using-openwrt-failsafe)
      - [Reflash using Bootloader.](#reflash-using-bootloader)
        - [Teltonika](#teltonika)
        - [ZyXEL](#zyxel)
  - [ssh config](#ssh-config)
  - [jumphost](#jumphost)
  - [local access](#local-access)
  - [remote access](#remote-access-1)
  - [serial console access](#serial-console-access)

## TL;DR

### How do i clear all settings on a device

To reset the device to the original state you have two ways.

1. Long press the reset button when the device is powered on.

2. Enter `firstboot` on the OpenWrt shell.

### How do i access the Serial Port of a Device?

All Devices are conencted to TTL UART adapters with the Labbook. A list of mapping between Device and Serial port can be found [here](#serial-console-access).

To Exit the Session when picocom is opened, Press `CTRL`+ `A` followed by `CTRL` + `X`.

```
$ ssh uniberg@10.42.3.39
uniberg@labbook:~$ picocom -b 115200 /dev/ttyUSB2
picocom v3.1

port is        : /dev/ttyUSB2
flowcontrol    : none
baudrate is    : 115200
parity is      : none
databits are   : 8
stopbits are   : 1
escape is      : C-a
local echo is  : no
noinit is      : no
noreset is     : no
hangup is      : no
nolock is      : no
send_cmd is    : sz -vv
receive_cmd is : rz -vv -E
imap is        :
omap is        :
emap is        : crcrlf,delbs,
logfile is     : none
initstring     : none
exit_after is  : not set
exit is        : no

Type [C-a] [C-h] to see available commands
Terminal ready

root@d43df3fede82:~#
```

### How do i Reboot a device?

Access the HP Switch at `/dev/ttyUSB0`. You will find yourself on the CLI.

Press Enter until you are prompted to login.

```
User: uniberg
PW: uniberg123
```

Afterwards enable the configure context:

```
enable
configure
```

To reboot, you need the interface ID of the port the device is connected to. This matches the label on the frotn side of the switch.

```
no interface <port> power-over-ethernet
interface <port> power-over-ethernet
```

A list of Port - Device mapping can be found here: TODO.

### I fucked up and need to reflash?

You should not feel bad! This can happen to anyone! I got you covered, follow me!

First, you need to reboot the device. This can be done using the PoE switch.

You have two methods at your disposal now.

#### Reflash using OpenWrt failsafe

If the device still boots, but you did introduce configuration changes which rendered it unreachable, the OpenWrt failsafe mode can be used to reflash a firmware image. For this, copy the `sysupgrade` image to the labbook.

Wait until you see this prompt:

```
Press the [f] key and hit [enter] to enter failsafe mode
Press the [1], [2], [3] or [4] key and hit [enter] to select the debug level
```

When the device reboots, press the `F` key followed by `Enter`  on the serial console. This can be spammed, but be advised that you need to do the whole `F`+`Enter` sequence.

You can check if this was successfull once you are greeted with the Failsafe screen:

```
================= FAILSAFE MODE active ================
special commands:
* firstboot	     reset settings to factory defaults
* mount_root	 mount root-partition with config files

after mount_root:
* passwd			 change root's password
* /etc/config		    directory with config files

for more help see:
https://openwrt.org/docs/guide-user/troubleshooting/
- failsafe_and_factory_reset
- root_password_reset
=======================================================

root@OpenWrt-failsafe:/#
```

You can now copy over the `sysupgrade` File to the device from the lapbook using `scp` on the labbook.

```
scp -oUserKnownHostsFile=/dev/null -O openwrt-sysupgrade.bin root@192.168.1.1:/tmp/image.bin
```

Install the image by executing `sysupgrade` on the target device.

```
sysupgrade -n /tmp/image.bin
```

#### Reflash using Bootloader.

This process differs depending on the device. Make sure to pick the right instructions.

Recovery images are already on the labbook. They are initramfs images for the device and reside in `/srv/tftp`.

All instructions have in common that this process will boot a OpenWrt release image. You can afterwards copy over the image using `scp` and flash using `sysupgrade` described in the previous section.

##### Teltonika

Press `Enter` once the prompt appears.

```
U-Boot 2.3 [ ,r16279-5cc0535800] (Nov 22 2024 - 12:58:23)

smem ram ptable found: ver: 1 len: 3
DRAM:  256 MiB
machid : 0x8010100
NAND:  spi_nand: spi_nand_flash_probe SF NAND ID 0:ef:aa:22
SF: Detected W25N02KV with page size 2 KiB, total 256 MiB
SF: Detected W25Q128 with page size 64 KiB, total 16 MiB
ipq_spi: page_size: 0x100, sector_size: 0x10000, size: 0x1000000
272 MiB
MMC:
*** Warning - bad CRC, using default environment

In:    serial
Out:   serial
Err:   serial
machid: 8010100
flash_type: 0
Hit any key to stop autoboot:  0
```

Enter the following command:

```
setenv ipaddr 192.168.1.94; setenv serverip 192.168.1.39; tftpboot 0x85000000 recovery-rutx50.bin; bootm
```

Wait for OpenWrt to boot. It will become reachable at `192.168.1.1`.

##### ZyXEL

Press `Enter` when prompted.

```
U-Boot 2018.09 (May 17 2022 - 01:17:57 +0000)

CPU:   MediaTek MT7621AT ver 1, eco 3
Clocks: CPU: 880MHz, DDR: 600MHz (1200MT/s), Bus: 220MHz, XTAL: 40MHz
Model: MediaTek MT7621 reference board (NAND)
DRAM:  256 MiB
NAND:  128 MiB

Initializing NMBM ...
Signature found at block 1023 [0x07fe0000]
First info table with writecount 0 found in block 960
Second info table with writecount 0 found in block 963
NMBM has been successfully attached

Loading Environment from NMBM... *** Warning - bad CRC, using default environment

In:    uartlite0@1e000c00
Out:   uartlite0@1e000c00
Err:   uartlite0@1e000c00
Net:
Warning: eth@1e100000 (eth0) using random MAC address - 36:28:78:08:40:24
eth0: eth@1e100000
Reading from 0x7700000, size 0x20000
Succeeded
Zyxel version:V1.05
gpio: pin 24 (gpio 24) value is 0
gpio: pin 24 (gpio 24) value is 1
Hit any key to stop autoboot:  0
=>
```

Enter the following commands

```
=> atna 192.168.1.90
=> atnf recovery-nwa50ax.bin
=> atns "192.168.1.39; tftpboot; bootm"
```

Wait for OpenWrt to boot. It will become reachable at `192.168.1.1`.

## ssh config
this is not mandatory but will make your life easier.

populate .ssh/config with the following content

```
Host labbook
        HostName 10.42.3.39
        User uniberg
        ServerAliveInterval 60

Host compalio
	HostName 10.42.3.42
	User uniberg

Host lab_teltonika
        HostName 192.168.133.1
        User root
        StrictHostKeyChecking no
        UserKnownHostsFile /dev/null
        ProxyJump labbook

Host aws
	User admin
	HostName 35.157.207.77

Host aws_teltonika1
        User root
        ProxyJump aws
        StrictHostKeyChecking no
        UserKnownHostsFile /dev/null
        HostName 192.168.201.21
        ServerAliveInterval 20

Host core
       Hostname 10.42.3.13
       User uniberg
		
```
## jumphost

we are currently using the labbook as a jumphost.

```shell
ssh uniberg@10.42.3.39
```

from there you can connect to every device on the hp switch.

default controller ip: 
```
192.168.133.1
fd42:dead:c0de:1337::1
```

## local access 
access is always possible via the fd42 address on the wan port. currently configured via labbook.

```
ssh uniberg@10.42.3.39

uniberg@labbook:~$ cat .ssh/config
Host teltonika
	User root
	HostName fd42:dead:c0de:1337::1
uniberg@labbook:~$ grep teltonika /etc/hosts
fd42:dead:c0de:1337::1 teltonika
```

## remote access
via aws e.g. cellular jump host: ssh teltonika
```
$ cat .ssh/config
Host aws
	User admin
	HostName 35.157.207.77
Host teltonika
        ProxyJump aws
        HostName 92.168.201.21

$ ssh aws grep teltonika /etc/hosts
192.168.201.21	teltonika teltonika1 teltonika21
```


## serial console access

you can access the serial console via the [labbok](#jumphost)

to open a session use picocom like this:

```shell
# /dev/ttyUSB0 - HP Switch
# /dev/ttyUSB1 - Teltonika
# /dev/ttyUSB2 - ZyXEL
# /dev/ttyUSB3 - ZyXEL
picocom -b 115200 /dev/ttyUSB1
```

to exit a session press strg + a, x

