# Access Points

## Zyxel NWA50AX / NWA55AXE Overview
- **CPU:** MediaTek MT7621
- **RAM:** 256 MB DDR3
- **Flash:** 128 MB NAND
- **Ethernet:** 1× Gigabit (PoE-in on NWA55AXE)
- **WiFi:** MediaTek MT7915 (2.4 / 5 GHz 802.11ax 2×2 DBDC)
- **Buttons:** Reset button only on NWA50AX
- **LEDs:** Multi-colour system LED only on NWA50AX
- Placeholder: Add environmental specifications (IP rating, operating temperature) and mounting accessories.

## Installing OpenWrt via Web UI
1. Log into the Zyxel management UI and upload the OpenWrt factory image.
2. Ensure the device is currently booted from **Slot B**. OpenWrt can only be flashed to Slot A; if Slot A is active, first install any official Zyxel firmware so the unit reboots into Slot B.
3. Wait for the device to reboot into OpenWrt. If it reboots back to Zyxel firmware, repeat step 1 to switch the active slot before re-flashing.
- Placeholder: Record the exact OpenWrt build/version we validated in production.

## Installing via TFTP/Serial Recovery
Use this path when the device password is unknown (NWA55AXE has no reset button) or the unit is bricked.

1. Connect to the UART console and interrupt boot by pressing **Enter**.
2. Place the OpenWrt initramfs image (`owrt.bin`) on a TFTP server reachable at `192.168.1.66`.
3. In the bootloader, run:
   ```
   atnf owrt.bin
   atna 192.168.1.88
   atns "192.168.1.66; tftpboot; bootm"
   ```
4. Once OpenWrt initramfs is running, set Slot A as active and valid:
   ```
   zyxel-bootconfig /dev/mtd10 get-status
   zyxel-bootconfig /dev/mtd10 set-image-status 0 valid
   zyxel-bootconfig /dev/mtd10 set-active-image 0
   ```
5. Copy the `ramboot-factory` image to the device and write it to NAND:
   ```
   scp ramboot-factory.bin root@192.168.1.1:/tmp/
   mtd write /tmp/ramboot-factory.bin firmware
   reboot
   ```

## UART Console Access
- **Baud rate:** 115200 8N1 (3.3 V logic level – never connect VCC from your USB-UART adapter).
- **NWA50AX:** Header sits under the rubber cover next to the Ethernet port; pinout (from 12 V barrel jack towards Ethernet): `GND – RX – TX – VCC`.
- **NWA55AXE:** Test pads on the PCB; remove the enclosure to access the same pin order.
- Placeholder: Add board photos highlighting the header for quick reference.