# Setup Guide

Step-by-step notes for setting up a UB-EDGE kit on site. We expand this guide as we validate each stage in the field.

## 1. Kit Contents
| Component | Details | Notes |
|-----------|---------|-------|
| QuWireless QuMax enclosure | Teltonika router pre-mounted; integrated PoE switch | Check whether the 4-port PoE variant is supplied |
| Teltonika router | 5G backhaul (RUTX series) | Label shows firmware/build version |
| Power cable | AC lead for the enclosure and switch | Inspect insulation for transport damage |
| Zyxel NWA55AXE (x3) | Outdoor WiFi 6 access points | Each box includes the mounting kit |
| Ethernet cables | Pre-cut runs for APs and backhaul | Length labels expected (AP1/2/3) |
| Sysmocom SIM card | Preconfigured profile | ICCID + PIN printed on card holder |

Add serial numbers and missing components here as soon as they are known.

---

## 2. Unpacking & Bench Setup
2.1 Unpack the enclosure and verify all components above are present.  
2.2 Insert the Sysmocom SIM:  
 • If the enclosure exposes the external SIM slot, push the SIM in until it locks.  
 • Otherwise open the enclosure and insert the SIM directly into the Teltonika router before resealing it.  
2.3 Power up the enclosure with the supplied AC cable.  
2.4 Connect a Mac or PC to one of the PoE Ethernet ports on the enclosure to access the router UI for initial checks.  

---

## 3. Bench Network Configuration (macOS example)
3.1 Connect your MacBook using a USB Ethernet adapter to LAN1 of the Teltonika and wait for link.  
3.2 In **System Settings → Network**, select the adapter and assign a manual IPv4 address.  

> This step needs to be done for every Ethernet adapter. Changing adapters will reset the manual IP.  
{.is-info}

![screenshot_2025-09-03_at_14.24.38.png](screenshot_2025-09-03_at_14.24.38.png)
![screenshot_2025-09-03_at_14.24.42.png](screenshot_2025-09-03_at_14.24.42.png)

3.3 Click `Details`, open the `TCP/IP` tab, and set IP `192.168.1.69` with subnet mask `255.255.255.0`.  

![screenshot_2025-09-03_at_14.24.51.png](screenshot_2025-09-03_at_14.24.51.png)

3.4 Complete the Teltonika setup wizard (keep the device in router mode) and set the admin password to `Uniberg123!`.  
3.5 Enable SSH in the web UI (`System → Administration → Access Control`).  

![screenshot_2025-09-03_at_14.49.31.png](screenshot_2025-09-03_at_14.49.31.png)

3.6 Open an SSH session for the remaining steps:  

```bash
ssh -o UserKnownHostsFile=/dev/null root@192.168.1.1
```

---

## 4. Flash the UB-EDGE Factory Image (Teltonika RUTX50)

Before flashing, download the required artifacts to your laptop:  
- Latest Teltonika stock firmware (only needed if the router still boots from partition set `0`):  
  https://wiki.teltonika-networks.com/view/RUTX50_Firmware_Downloads   
- Latest UB-EDGE factory image (from build artifacts) 
   - pipelines from uconfigd - main - build-image / build-firmware, browse - target
  https://git.uniberg.com/ub-edge/uconfig/uconfigd/-/pipelines  
  - choose ipq40xx for Teltonika

4.1 Check which partition set is active:  
```bash
cat /proc/boot_info/rootfs/primaryboot
```
 • If the command returns `0`, upload an official Teltonika firmware first, let it reboot, and re-run the command until it shows `1`.  

4.2 Copy the UB-EDGE factory image to the router:  
```bash
scp -oUserKnownHostsFile=/dev/null -O ~/Downloads/openwrt-ipq40xx-generic-teltonika_rutx50-squashfs-factory.ubi \
  root@192.168.1.1:/tmp/ubedge-factory.ubi
```

4.3 Flash the factory image:  
```bash
ubiformat /dev/mtd16 -y -f /tmp/openwrt-ipq40xx-generic-teltonika_rutx50-squashfs-factory.ubi
```

4.4 Rewrite the boot configuration so the device boots from the freshly flashed partition:  
```bash
echo 0 > /proc/boot_info/rootfs/primaryboot
cat /proc/boot_info/getbinary_bootconfig > /tmp/bootconfig.bin
cat /proc/boot_info/getbinary_bootconfig1 > /tmp/bootconfig1.bin
mtd write /tmp/bootconfig.bin /dev/mtd2
mtd write /tmp/bootconfig1.bin /dev/mtd3
```

one liner

```shell
echo 0 > /proc/boot_info/rootfs/primaryboot; cat /proc/boot_info/getbinary_bootconfig > /tmp/bootconfig.bin; cat /proc/boot_info/getbinary_bootconfig1 > /tmp/bootconfig1.bin; mtd write /tmp/bootconfig.bin /dev/mtd2; mtd write /tmp/bootconfig1.bin /dev/mtd3
```

4.5 Reboot the router by executing `reboot` and make sure your laptop is connected to LAN1. You should get an IP address via DHCP in the 192.168.133.0/24 network and be able to reach 192.168.133.1, if not check that your IP is dynamic and not stuck on manual IP mode.

4.6 Confirm you can ping `192.168.133.1`.  

4.7 Done — the router now runs the UB-EDGE factory image.  

---

## 5. Post-Flash Controller Checklist
- Downstream interfaces (LAN ports) serve DHCP from `192.168.133.1`. Do **not** connect them to other Uniberg infrastructure to avoid accidental DHCP leaks.  
- The upstream Ethernet interface is intentionally unconfigured after flashing. Plan the uplink assignment during on-site deployment.  
- The cellular modem (wwan0) ships powered off. Enable it when required:  
  ```bash
  echo 1 > /sys/class/gpio/modem_power/value
  ```  
- Confirm WireGuard connectivity, collect the running configuration snapshot, and store photos or console logs with the deployment record.  

---

## 6. Deployment Overview
- The automated build pipeline publishes artifacts here:  
  https://git.uniberg.com/ub-edge/uconfig/uconfigd/-/pipelines  
- For subsequent upgrades in the field, copy the new `sysupgrade` image to `/tmp/` on the target device and run:  
  ```bash
  sysupgrade /tmp/<image>.bin
  ```  
- Keep a changelog of which image was deployed to which site to support rollback and incident response.  

---

## 7. Prepare Zyxel Access Points
- choose ramips-mt for Zyxel - see:
   - Hardware specs, serial console access, and flashing methods (web UI + TFTP recovery) live in `Products/UB-EDGE-One/Access-Points.md`.  
- Confirm the APs are flashed to the validated OpenWrt build before travelling onsite; switching slots incorrectly will boot back to Zyxel firmware.  
- Record MAC addresses, mounting hardware provided, and PoE injector details in the site inventory.  

---

## 8. On-Site Installation (Placeholder)
- Placeholder: Add detailed checklist for mounting, weatherproofing, and cabling.  
- Placeholder: Document acceptance tests (signal measurements, client onboarding) required before handover.  

# recovery procedures for bricked devices 

0. download new firmware: https://wiki.teltonika-networks.com/view/RUTX50_Firmware_Downloads


1. turn off device
2. press the reset button next to the lan 1 port with something long and thin (it's not a piemel)
3. turn on device while holding the reset button
4. when every led flashes (on .. off .. on .. off) all the time you can stop pressing
5. insert cable into computer and teltonika eth1
6. set your computer ip to 192.168.1.69/24 (255.255.255.0)
7. go on http://192.168.1.1 and uploade firmware and press button
8. isso

official docs: https://wiki.teltonika-networks.com/view/Bootloader_menu