# UB-EDGE Pro Hardware & Software Options

There are two major approaches we can follow which have both advantages and disadvantages.

## Integrated gnB

Fully integrated outdoor gnB that only needs to be connected the hardware running applications and the 5G Core (UB-EDGE Pro).

- Advantages: Cost effective and low integration effort
- Disadvantages: Less features (older 3GPP releases), less control / config

In the following, a collection of options that we have quotes for is listed - sorted by manufacturer:

### Baicells

- **Aurora249 n78**
  - **Type:** Integrated outdoor TDD gNB (2×40 W) with external antennas
  - **Specs:** 3300–3800 MHz, 1×SFP (1.25 G) + 2×10 Gb SFP, GPS/GLONASS/BDS, IP66, −48 V DC
  - **Commercials (USD, EXW, QUO36342):** 6850 Dollars per unit; antenna 385 Dollars; accessory kit 280 Dollars; BaiOMC software 5000 Dollars (waived for current testing); device licences $50 each (waived); 100 % upfront within 7 days; lead time 50 days; 12‑month warranty
- **Aurora243 n78**
  - **Type:** Integrated outdoor TDD gNB (2×10 W)
  - **Specs:** 3300–3800 MHz, 1×RJ45 GE + 1×SFP (1.25 G), −48 V DC, IP66
  - **Commercials (USD):** 5950 Dollars per unit; antenna 
  385 Dollars; accessory kit 235 Dollars (same payment/lead-time terms)
- **Open Items:** Confirm updated pricing/discounts, BaiOMC costs for production use, 5GC interoperability validation, shipping/RMA process

### BTI Wireless

- **nCELL-M4370 Integrated gNB**
  - **Type:** All-in-one 5G gNB (BBU+RU), TDD FR1
  - **Specs:** 3GPP Rel 16, 1×4T4R cell, 4×5 W RF, bands n38/n40/n41/n48/n77/n78 (custom options), up to 100 MHz BW, GPS/IEEE 1588 sync, IP67, −48 V DC (<230 W), weight <17 kg
  - **Commercials:** Pricing not provided—quote required
- **nCELL-M4460 Integrated gNB**
  - **Type:** Higher-power (separate BBU/RRU) outdoor system
  - **Specs:** 4×40 W RF, same band coverage, BBU 6.3 kg, RRU 27.9 kg, total power <700 W, IP65, −48 V DC
  - **Commercials:** Pricing pending


### Polaris Networks / CloudRAN.AI

- **Polaris10 Outdoor gNB**
  - **Type:** Integrated outdoor 5G gNB (2×10 W) with optional embedded core
  - **Specs:** FR1 bands n41/n48/n77/n78/n79, 2×2 MIMO, up to 100 MHz, peak DL 850 Mbps / UL 660 Mbps, SA support, F1 (planned), 1×SFP (optical) + 1×GE RJ45 backhaul, −48 V DC or AC input, IP65, max 150 W, 7.2 kg, 333×240×109 mm, GPS/1588 sync, external or integrated antennas, CE/FCC depending on band

- **Polaris440 Outdoor gNB**
  - **Type:** High-power integrated gNB (4×40 W) based on Qualcomm 5G SoC
  - **Specs:** Band n78 (3300–3800 MHz), 4×4 MIMO, 100 MHz BW, peak DL 1.5 Gbps, −48 V DC, 3×10 Gb SFP+ + 2.5 GbE RJ45, IP60, max 650 W, 18 kg, 527×308×120 mm, GNSS/1588 sync, external high-gain antennas (N-type), SA mode

### Lopcomm

- **Kommt noch**
  - **Type:** asdf



## ORAN Split 7.2/8.X

ORAN Setup consisting of Remote Radio Unit (RRU), Network Interface Card (NIC) and Software based CU/DU.

- Advantages: High flexibility for upgrades / features, more configuration control
- Disadvantages: More costly, more complicated to integrate

In the following, a collection of options that we have quotes for is listed - sorted by manufacturer:

## Benetel

- **Device:** RAN650 Outdoor RU (n78)
- **Type:** O-RAN Split 7.2 radio unit (requires external DU/CU and core)
- **Key Specs:** 4T4R, IP66, external antennas (not included), 10 Gb SFP+ optics, CE certified, lead time 6 weeks (FCA Dublin)
- **Commercials (EUR):**
  - RAN650 RU €9950
  - Mandatory remote technical & integration support (40 h) €5000
  - Annual Software Maintenance (2 years up front, 22 % of radio price) €2189
  - Optional M-plane licence €398/year
  - 10 Gb SFP+ optics €130 each (×2) and shipping €300
  - 100 % payment in advance, 12‑month warranty, cancellation fee 100 %

## AW2S

- **Panther 4×4 MIMO RRH (n78)**
  - **Type:** Outdoor RU, CPRI Split 8 today, ORAN roadmap
  - **Specs:** 4T4R, 36 dBm (4 W) per chain, bandwidth 5–100 MHz, IP66, −40…−58 V isolated DC, ~300 W typical, dual SFP+ CPRI ports, GPS/sync SMA
  - **Status:** Need commercial quote (pricing, lead time), certification details, support terms

- **5G Neo RU (n78)**
  - **Type:** Compact RU with CPRI rate 9 (split 8) and planned ORAN 7.2 support
  - **Specs:** 4T4R, IP65, <7 kg, −40…−56 V DC, ~90 W typical, dual SFP28 high-speed ports, 4.3/10 RF connectors
  - **Status:** Await pricing, ORAN availability date, warranty/support wording

## SRS (srsRAN Enterprise 5G)

- **Type:** Commercial CU/DU/gNB and 5GC software stack (3GPP Rel 17) with modular deployment (embedded, vRAN, cloudRAN)
- **Key Features:** 100 % in-house L1/2/3, O-RAN splits 7.2/8, up to 100 MHz FR1, 4-layer DL/2-layer UL, optional HW acceleration (ACC100/vRAN Boost), portable across Intel/AMD/ARM, support for O1/O-RAN interfaces
- **Licensing:** Negotiated commercial licence (modifiable source), includes warranty/indemnity and maintenance updates during paid term
- **Commercials:** Pricing not disclosed—need quote covering licence, support, and professional services


## Amarisoft

- **Type:** Commercial 5G core and CU/DU (O-RAN) software
- **Key Info:** CU/DU licence for O-RAN deployments quoted at €2500 (pricing basis and scope to confirm)

