# git
we use git to synchronize our development efforts.
there are many benefits here: 
1) `git log`: history of all changes made by everybody, with date, name, and reason (title/description), per repo, per file, per whatever (you go learn the man page to check all possible arguments if you need more or nobody tells you any cool magic tricks in person: type man git-log)
2) `git blame`: another view of the history, where you can check per-line who is responsible, who touched something last. this is very important bec. you can use this to avoid stepping on each other's toes ;)
3) `git merge`: multiple commits can be collected in branches and worked on in peace by groups of people, without disturbing others, until it's merged to master. This has to happen often to force us to stay in sync. Getting out of sync too much is VERY undesireable (it creates huge complications and generally it makes merging very difficult). Please note, we do not always merge, see below: #upstream
4) communication: working together is complicated. 
git allows for many opportunities to attach meaningful messages to objects like commits, both in the title and in the longer-form description. 

with gitlab+merge-requests there are even more opportunities for extra descriptions, abstractions, coalesquing of commits(into branch+MR instead of squashing), etc.

# code-review / approval
We always want everybody to have a high level understanding about what's happening in the repos and branches, and what other team members are doing (struggling with, succeeded in, wisdom achieved,...).
We can use processes like merge requests and code review to increase opportunities for such kind of knowledge transfer. 
We often want to share also more detailed understandings, hopefully not always escalating into nitpicking: relevant outcome/conclusions/synthesis could be shared back to the team, maybe even to the bigger company.
The end goal is always to efficiently communicate the relevant and valuable information.

# we use submodules.
the reason is bec. we reference also external repos, or forks of other projects that have an upstream repo that we want to regularly fetch and then reintegrate back into our repo, where our commits are the minority.
to handle such repos we use submodule, which is just references to a commit in another repo.

the biggest cost of submodules now is how to keep our own changes cleanly separated from upstream, to track changes that aren't upstreamed, help communicate with upstream, resolve conflicts when we merge upstream in, and end-to-end test our system in case the many upstream changes broke anything.

the easiest way to get going with all submodules is to git clone recursively:

```sh
git clone --recurse-submodules git@git.uniberg.com:ub-edge/uconfig/uconfigd.git
```

to get submodules after git clone

```sh
git submodule update --init
```

afterwards, git pull will not update the suubmodules automatically unless you use the correct --arguments, if you dont want to type them every time use the following global git settings instead:

```sh
git config --global submodule.recurse true
```

beware, recursive submodule updates dont care what branch you had checked out in a given submodule, so you might easily oversee an unpushed change.

# upstream
i have not seen good evidence what is the most feasible way to manage our patches to upstream: right now it's a giant multi-repo spaghetti mess where we sometimes commit and rebase or merge, or use patch files instead which might in turn get committed and rebased/merged again. Open to suggestions.

some repos have upstream not controlled by us, thus branch names might not follow our usual pattern.

one thing that might be unusual to you in the openwrt package repo is their system where patches (as generated by `git format-patch`) will be picked up automatically in the build process if they are placed in certain subdirectories (grep for file ending .patch). when our patches are eventually included in upstream we have to remove the patch files in the repo so they dont get applied twice any more. on the plus side: this also relieves us from the responsibility over the patch.


many packages are actually a reference to yet another git repo (which we might not mirror).