# Edge-API

The Edge-API is responsible for interfacing with the Edge-Wi-Fi-Controller to allow for
config functionality and status reports over an HTTP REST API.
The Edge-API enforces authorization and permissions for these operations.

## API Documentation
The REST API documentation is specified in the OpenAPI format [here](). \
You can also find a rendered HTML version [here]().

## Getting Started for Development

### Prerequisites
- go v1.23.2
- make

### Installation

Clone this repository:
```shell
git clone git@git.uniberg.com:ub-edge/edge-api.git

cd edge-api
```

In the project root directory run:
```shell
go get .
```

To start the application, run:
```shell
go run cmd/edge-api/main.go
```

To understand the project structure and what each directory is used for you will find a `README.md` in each directory.

For the development of go, IntelliJ GoLand is recommended.

## Building the Applications

To build all applications you can use the following command:
```shell
make
```

To clean the builds you can run:
```shell
make clean
```

To build a specific application (specified in the cmd directory) you can run:
```shell
# make [application-name]
# e.g.:
make edge-api
```

## cross-arch and cross-os compilation is trivial with go as we avoid the ulrich drepper sabotage framework (glibc):

```shell
GOOS=linux GOARCH=arm go build -o edge-api ./cmd/edge-api/main.go
```
🍓🍓
