FROM --platform=linux/amd64 golang:1.23.2-bookworm AS build

# Install required packages, including MUSL cross-compiler for ARMv7
RUN apt-get update && \
    apt-get install -y \
    musl-tools \
    gcc \
    gcc-arm-linux-gnueabihf \
    musl-dev && \
    apt-get clean

# Download musl cross-compiler for ARMv7
RUN wget https://musl.cc/armv7l-linux-musleabihf-cross.tgz && \
    tar -xzf armv7l-linux-musleabihf-cross.tgz && \
    mv armv7l-linux-musleabihf-cross /opt/cross && \
    ln -s /opt/cross/bin/armv7l-linux-musleabihf-gcc /usr/bin/armv7l-linux-musleabihf-gcc

WORKDIR /usr/src/app

# pre-copy/cache go.mod for pre-downloading dependencies and only redownloading them in subsequent builds if they change
COPY go.mod go.sum ./
RUN go mod download && go mod verify

COPY . .
RUN env CC=armv7l-linux-musleabihf-gcc GOOS=linux GOARCH=arm GOARM=7 CGO_ENABLED=1 go build -v -o /usr/local/bin/edge-api --ldflags '-linkmode external -extldflags "-static"' cmd/edge-api/main.go

FROM scratch
COPY --from=build /usr/local/bin/edge-api /
ENTRYPOINT ["/"]

# docker build -f TeltonikaBuild.Dockerfile --output=bin .
