#!/bin/bash
set -x

TELTONIKA_IP=192.168.201.21
BINARY_PATH=/usr/bin/edge-api
SSH="ssh -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null root@$TELTONIKA_IP"

# compile for teltonika
env GOOS=linux env GOARCH=arm go build -o edge-api ./cmd/edge-api/main.go

# copy to teltonika
rsync edge-api root@$TELTONIKA_IP:$BINARY_PATH

# restart service
$SSH /etc/init.d/uniberg-ub-edge-api restart
