package database

import (
	"github.com/jmoiron/sqlx"
	_ "modernc.org/sqlite"
)

var DB *sqlx.DB

func InitDB(dsn string) error {
	var err error
	DB, err = sqlx.Connect("sqlite", dsn)
	if err != nil {
		return err
	}

	DB.MustExec("PRAGMA foreign_keys = ON;")
	DB.MustExec("PRAGMA journal_mode=WAL;")
	return DB.Ping()
}
