package handlers

import (
	"edge-api/internal/database"
	"edge-api/internal/models"
	"edge-api/internal/services"
	"net/http"
	"time"

	"github.com/gin-gonic/gin"
)

func Login(jwtSecret string, jwtExpiration time.Duration) gin.HandlerFunc {
	return func(c *gin.Context) {

		var loginDetails models.LoginDetails

		if err := c.ShouldBindJSON(&loginDetails); err != nil {
			c.JSON(http.StatusBadRequest, gin.H{"error": "Invalid request"})
			return
		}

		user := models.User{}
		err := database.DB.Get(&user, "select * from users where email = $1", loginDetails.Email)
		if err != nil || !services.CheckPasswordHash(loginDetails.Password, user.PasswordHash) {
			c.JSON(http.StatusUnauthorized, gin.H{"error": "Invalid credentials"})
			return
		}

		apiKey, err := services.GenerateJWT(jwtSecret, jwtExpiration, user)
		if err != nil {
			c.JSON(http.StatusInternalServerError, gin.H{"error": "Could not generate API key"})
			return
		}

		c.SetCookie("apiKey", apiKey, int(jwtExpiration.Seconds()), "/", "", false, false)
		c.JSON(http.StatusOK, gin.H{"apiKey": apiKey})
	}
}
