package handlers

import (
	"edge-api/internal/database"
	"edge-api/internal/models"
	"net/http"

	"github.com/gin-gonic/gin"
)

func UserList(c *gin.Context) {
	users := []models.User{}

	err := database.DB.Select(&users, "SELECT * FROM users")
	if err != nil {
		c.JSON(http.StatusInternalServerError, gin.H{"error": "Failed to fetch users"})
		return
	}

	c.JSON(http.StatusOK, users)
}
