package models

import (
	"encoding/json"
)

type Config struct {
	UUID             int64             `json:"uuid"`
	Networks         []ConfigNetwork   `json:"networks"`
	WirelessNetworks []WirelessNetwork `json:"wireless_networks"`
}

type ConfigNetwork struct {
	UUID   string `json:"uuid"`
	Name   string `json:"name"`
	VLANID int    `json:"vlan_id"`
}

type WirelessNetwork struct {
	SSID        string           `json:"ssid"`
	NetworkUUID string           `json:"network_uuid"`
	Encryption  EncryptionConfig `json:"encryption"`
}

type EncryptionConfig struct {
	Method     string          `json:"method"`
	Passkeys   []PasskeyConfig `json:"passkeys,omitempty"`
	Passphrase string          `json:"passphrase,omitempty"`
}

type PasskeyConfig struct {
	Passkey     string `json:"passkey"`
	NetworkUUID string `json:"network_uuid"`
	MACAddress  string `json:"mac_address,omitempty"`
}

func (c *Config) JSON() ([]byte, error) {
	configJSON, err := json.MarshalIndent(c, "", "  ")
	return configJSON, err
}
