import React from 'react';
import {
    EuiFlexGroup,
    EuiFlexItem,
    EuiPanel,
    EuiStat,
    EuiHealth,
    EuiIcon,
    EuiText,
    EuiSpacer,
    EuiTitle,
    EuiBadge,
    EuiHorizontalRule,
} from '@elastic/eui';
import Device from './types/Device';

export default function CardsDashboard({ devices, dict }) {
    const onlineDevices = devices.filter((d) => d.online).length;
    const authDevices = devices.filter((d) => d.authorized).length;
    const sumKb = devices.reduce((acc: number, obj: Device) => acc + (obj.bytes_rx ?? 0) + (obj.bytes_tx ?? 0), 0)/1024;
    const sumUp = devices.reduce((acc: number, obj: Device) => acc + (obj.bytes_tx ?? 0), 0)/1024;
    const sumDown = devices.reduce((acc: number, obj: Device) => acc + (obj.bytes_rx ?? 0), 0)/1024;
    return (
        <div style={{ padding: '24px', background: '#f5f7fa' }}>
            <EuiFlexGroup gutterSize="l" responsive={true}>
                {/* Internet Status Card */}
                <EuiFlexItem>
                    <EuiPanel paddingSize="l" hasShadow={false} hasBorder>
                        <EuiFlexGroup gutterSize="s" alignItems="center" responsive={false}>
                            <EuiFlexItem grow={false}>
                                <EuiIcon type="globe" size="xl" color="success" />
                            </EuiFlexItem>
                            <EuiFlexItem>
                                <EuiTitle size="xs">
                                    <h3>{dict.dashboardInternetStatus}</h3>
                                </EuiTitle>
                            </EuiFlexItem>
                        </EuiFlexGroup>

                        <EuiSpacer size="m" />

                        <EuiHealth color="success" style={{ fontSize: '16px', fontWeight: 600 }}>
                            Guter Empfang
                        </EuiHealth>

                        <EuiSpacer size="s" />

                        <EuiText size="s" color="subdued">
                            <p>Verbindung stabil</p>
                        </EuiText>

                        <EuiSpacer size="m" />

                        <EuiFlexGroup gutterSize="s" responsive={false}>
                            <EuiFlexItem>
                                <EuiText size="xs" color="subdued">
                                    <strong>Signal:</strong>
                                </EuiText>
                            </EuiFlexItem>
                            <EuiFlexItem grow={false}>
                                <EuiBadge color="success">Stark</EuiBadge>
                            </EuiFlexItem>
                        </EuiFlexGroup>
                    </EuiPanel>
                </EuiFlexItem>

                {/* Device Info Card */}
                <EuiFlexItem>
                    <EuiPanel paddingSize="l" hasShadow={false} hasBorder>
                        <EuiFlexGroup gutterSize="s" alignItems="center" responsive={false}>
                            <EuiFlexItem grow={false}>
                                <EuiIcon type="gear" size="xl" color="primary" />
                            </EuiFlexItem>
                            <EuiFlexItem>
                                <EuiTitle size="xs">
                                    <h3>{dict.dashboardDevicesStatus}</h3>
                                </EuiTitle>
                            </EuiFlexItem>
                        </EuiFlexGroup>

                        <EuiSpacer size="m" />

                        <EuiFlexGroup gutterSize="l">
                            <EuiFlexItem>
                                <EuiStat
                                    title={onlineDevices}
                                    description={dict.online}
                                    titleColor="success"
                                    titleSize="l"
                                    textAlign="left"
                                >
                                    <EuiIcon type="dot" color="success" />
                                </EuiStat>
                            </EuiFlexItem>

                            <EuiFlexItem>
                                <EuiStat
                                    title={authDevices}
                                    description={dict.registered}
                                    titleColor="primary"
                                    titleSize="l"
                                    textAlign="left"
                                >
                                    <EuiIcon type="checkInCircleFilled" color="primary" />
                                </EuiStat>
                            </EuiFlexItem>
                        </EuiFlexGroup>
                    </EuiPanel>
                </EuiFlexItem>

                {/* Data Usage Card */}
                <EuiFlexItem>
                    <EuiPanel paddingSize="l" hasShadow={false} hasBorder>
                        <EuiFlexGroup gutterSize="s" alignItems="center" responsive={false}>
                            <EuiFlexItem grow={false}>
                                <EuiIcon type="visGauge" size="xl" color="warning" />
                            </EuiFlexItem>
                            <EuiFlexItem>
                                <EuiTitle size="xs">
                                    <h3>{dict.dashboardTrafficStatus}</h3>
                                </EuiTitle>
                            </EuiFlexItem>
                        </EuiFlexGroup>

                        <EuiSpacer size="m" />

                        <EuiText size="xs" color="subdued">
                            <p>{dict.inTheLast} 24h</p>
                        </EuiText>

                        <EuiSpacer size="s" />

                        <EuiFlexGroup direction="column" gutterSize="s">
                            <EuiFlexItem>
                                <EuiFlexGroup justifyContent="spaceBetween" alignItems="center" gutterSize="s">
                                    <EuiFlexItem grow={false}>
                                        <EuiFlexGroup gutterSize="xs" alignItems="center" responsive={false}>
                                            <EuiFlexItem grow={false}>
                                                <EuiIcon type="arrowDown" color="success" />
                                            </EuiFlexItem>
                                            <EuiFlexItem>
                                                <EuiText size="s">Download</EuiText>
                                            </EuiFlexItem>
                                        </EuiFlexGroup>
                                    </EuiFlexItem>
                                    <EuiFlexItem grow={false}>
                                        <EuiText size="s">
                                            <strong>{(sumUp).toFixed(1) + 'Mb'}</strong>
                                        </EuiText>
                                    </EuiFlexItem>
                                </EuiFlexGroup>
                            </EuiFlexItem>

                            <EuiFlexItem>
                                <EuiHorizontalRule margin="xs" />
                            </EuiFlexItem>

                            <EuiFlexItem>
                                <EuiFlexGroup justifyContent="spaceBetween" alignItems="center" gutterSize="s">
                                    <EuiFlexItem grow={false}>
                                        <EuiFlexGroup gutterSize="xs" alignItems="center" responsive={false}>
                                            <EuiFlexItem grow={false}>
                                                <EuiIcon type="arrowUp" color="primary" />
                                            </EuiFlexItem>
                                            <EuiFlexItem>
                                                <EuiText size="s">Upload</EuiText>
                                            </EuiFlexItem>
                                        </EuiFlexGroup>
                                    </EuiFlexItem>
                                    <EuiFlexItem grow={false}>
                                        <EuiText size="s">
                                            <strong>{(sumDown).toFixed(1) + 'Mb'}</strong>
                                        </EuiText>
                                    </EuiFlexItem>
                                </EuiFlexGroup>
                            </EuiFlexItem>
                        </EuiFlexGroup>
                    </EuiPanel>
                </EuiFlexItem>
            </EuiFlexGroup>
        </div>
    );
}
