import {
    EuiOverlayMask, EuiModal, EuiModalHeader,
    EuiModalHeaderTitle, EuiFlexGroup, EuiFlexItem,
    EuiDescriptionListTitle, EuiModalFooter, EuiModalBody,
    EuiButton, EuiSpacer, EuiText, EuiHealth, EuiPanel,
    EuiDescriptionList, EuiTitle, EuiDescriptionListDescription,
    EuiProgress, EuiEmptyPrompt, EuiCode, EuiIcon
} from '@elastic/eui';
import getDict from '@/lib/dict';
const dict = getDict("de");

export const NodeDetails = ({setShowNodeDetailsModal, accessPointTypes, selectedNodeDetails, globalAps, startEditingNode}) => {
    // Get status color
    const getStatusColor = (status: string) => {
        switch (status) {
            case 'online':
                return 'success';
            case 'offline':
                return 'danger';
            case 'warning':
                return 'warning';
            default:
                return 'subdued';
        }
    };
    if (!selectedNodeDetails) return null;
    const currentAccessPoint = globalAps?.find(ap => ap.id === selectedNodeDetails.type);
    return currentAccessPoint && (
        <EuiOverlayMask>
        <EuiModal onClose={() => setShowNodeDetailsModal(false)} maxWidth={700}>
            <EuiModalHeader>
                <EuiModalHeaderTitle>
                    <EuiFlexGroup alignItems="center" gutterSize="s">
                        <EuiFlexItem grow={false}>
                            <div
                                style={{
                                    width: '32px',
                                    height: '32px',
                                    borderRadius: '50%',
                                    backgroundColor: accessPointTypes.find(t => t.id === selectedNodeDetails.type)?.color,
                                    display: 'flex',
                                    alignItems: 'center',
                                    justifyContent: 'center',
                                    color: 'white',
                                    fontSize: '14px',
                                    fontWeight: 'bold'
                                }}
                            >
                                {accessPointTypes.find((t: { id: string }) => t.id === selectedNodeDetails.type)?.name?.charAt(0)}
                            </div>
                        </EuiFlexItem>
                        <EuiFlexItem>
                            <div>
                                <div>{accessPointTypes.find((t: { id: string }) => t.id === selectedNodeDetails.type)?.name}</div>
                                <EuiText size="s" color="subdued">
                                    {selectedNodeDetails.floor || '0'} {dict.floor}
                                </EuiText>
                            </div>
                        </EuiFlexItem>
                        <EuiFlexItem grow={false}>
                            <EuiHealth
                                color={getStatusColor(currentAccessPoint.online ? 'online' : 'offline')}
                            >
                                {(currentAccessPoint.online ? dict.online : dict.offline).toUpperCase()}
                            </EuiHealth>
                        </EuiFlexItem>
                    </EuiFlexGroup>
                </EuiModalHeaderTitle>
            </EuiModalHeader>

            <EuiModalBody>
                {selectedNodeDetails.deviceDetails ? (
                    <>
                        {/* Device Information */}
                        <EuiTitle size="s">
                            <h3>{dict.device} {dict.info}</h3>
                        </EuiTitle>
                        <EuiSpacer size="m" />

                        <EuiDescriptionList type="column" compressed>
                            <EuiDescriptionListTitle>{dict.macAddress}</EuiDescriptionListTitle>
                            <EuiDescriptionListDescription>
                                <EuiCode>{currentAccessPoint?.mac}</EuiCode>
                            </EuiDescriptionListDescription>

                            <EuiDescriptionListTitle>{dict.lastConnectedAt}</EuiDescriptionListTitle>
                            <EuiDescriptionListDescription>
                                {new Date(currentAccessPoint?.lastConnectedAt).toLocaleString()}
                            </EuiDescriptionListDescription>
                        </EuiDescriptionList>

                        <EuiSpacer size="l" />

                        {/* Network Performance */}
                        <EuiTitle size="s">
                            <h3>{dict.accessPoint} {dict.clientStats}</h3>
                        </EuiTitle>
                        <EuiSpacer size="m" />

                        <EuiFlexGroup>
                            <EuiFlexItem>
                                <EuiPanel paddingSize="m" color="subdued">
                                    <EuiFlexGroup direction="column" gutterSize="s">
                                        <EuiFlexItem>
                                            <EuiText size="s" color="subdued">{dict.signal}</EuiText>
                                        </EuiFlexItem>
                                        <EuiFlexItem>
                                            <EuiFlexGroup alignItems="center" gutterSize="s">
                                                <EuiFlexItem>
                                                    <EuiProgress
                                                        value={currentAccessPoint?.signal}
                                                        max={100}
                                                        color={currentAccessPoint.signal > 70 ? 'success' :
                                                            currentAccessPoint?.signal > 40 ? 'warning' : 'danger'}
                                                        size="m"
                                                    />
                                                </EuiFlexItem>
                                                <EuiFlexItem grow={false}>
                                                    <EuiText size="s">
                                                        <strong>{currentAccessPoint?.signal}%</strong>
                                                    </EuiText>
                                                </EuiFlexItem>
                                            </EuiFlexGroup>
                                        </EuiFlexItem>
                                    </EuiFlexGroup>
                                </EuiPanel>
                            </EuiFlexItem>

                            <EuiFlexItem>
                                <EuiPanel paddingSize="m" color="subdued">
                                    <EuiFlexGroup direction="column" gutterSize="s">
                                        <EuiFlexItem>
                                            <EuiText size="s" color="subdued">{dict.connectedDevices}</EuiText>
                                        </EuiFlexItem>
                                        <EuiFlexItem>
                                            <EuiText size="l">
                                                <strong>{currentAccessPoint.connectedDevices.length || 0}</strong>
                                            </EuiText>
                                        </EuiFlexItem>
                                    </EuiFlexGroup>
                                </EuiPanel>
                            </EuiFlexItem>
                        </EuiFlexGroup>

                        <EuiSpacer size="l" />

                    </>
                ) : (
                    <EuiEmptyPrompt
                        icon={<EuiIcon type="alert" size="l" />}
                        title={<h3>No Device Details</h3>}
                        body={<p>This access point doesn't have detailed device information available.</p>}
                    />
                )}
            </EuiModalBody>

            <EuiModalFooter>
                <EuiFlexGroup justifyContent="spaceBetween">
                    <EuiFlexItem grow={false}>
                        <EuiButton
                            onClick={() => {
                                setShowNodeDetailsModal(false);
                                startEditingNode(selectedNodeDetails);
                            }}
                            iconType="pencil"
                        >
                            {dict.floor}  {dict.update}
                        </EuiButton>
                    </EuiFlexItem>
                    <EuiFlexItem grow={false}>
                        <EuiButton onClick={() => setShowNodeDetailsModal(false)} fill>
                            {dict.close}
                        </EuiButton>
                    </EuiFlexItem>
                </EuiFlexGroup>
            </EuiModalFooter>
        </EuiModal>
    </EuiOverlayMask>)
}
