import React from 'react';
import {
  EuiPanel,
  EuiTitle,
  EuiSpacer,
  EuiFlexGroup,
  EuiFlexItem,
  EuiCard,
  EuiIcon,
    EuiToolTip,
    EuiHealth,
  EuiText,
  EuiBadge,
} from '@elastic/eui';

import getDict from '@/lib/dict';
const dict = getDict("de");

export const AccessPointTypes = ({
  accessPointTypes,
  isTypeAtLimit,
  getTypeCount,
  handleDragStart,
  handleTouchStartType,
  accessPoints,
}) => {
  return (
      <div style={{ background: '#f5f7fa',padding: '24px', }}>
          <EuiPanel paddingSize="m" hasShadow={false} hasBorder>
              <EuiFlexGroup alignItems="center" gutterSize="s" responsive={false}>
                  <EuiFlexItem grow={false}>
                      <EuiIcon type="bullseye" size="m" color="primary" />
                  </EuiFlexItem>
                  <EuiFlexItem>
                      <EuiTitle size="xs">
                          <h3>{dict.available + ' ' + dict.accessPoint}</h3>
                      </EuiTitle>
                  </EuiFlexItem>
              </EuiFlexGroup>

              <EuiSpacer size="s" />

              <EuiFlexGroup direction="column" gutterSize="s">
                  {accessPointTypes.map((type) => {
                      const isAtLimit = isTypeAtLimit(type.id, accessPoints);
                      const currentCount = getTypeCount(type.id, accessPoints);

                      return (
                          <EuiFlexItem key={type.id}>
                              <EuiToolTip
                                  content={isAtLimit ? dict.limit : dict.drag}
                                  position="left"
                              >
                                  <EuiPanel
                                      paddingSize="s"
                                      hasShadow={false}
                                      hasBorder
                                      style={{
                                          cursor: isAtLimit ? 'not-allowed' : 'grab',
                                          opacity: isAtLimit ? 0.6 : 1,
                                          backgroundColor: isAtLimit ? '#f7f8fc' : 'white',
                                          transition: 'all 0.2s ease',
                                          borderWidth: '2px',
                                          borderStyle: 'solid',
                                          borderColor: type.online ? '#00BFB3' : '#ef4444',
                                      }}
                                      onDragStart={(e) => handleDragStart(e, type.id)}
                                      onTouchStart={(e) => handleTouchStartType(e, type.id)}
                                      onMouseEnter={(e) => {
                                          if (!isAtLimit) {
                                              e.currentTarget.style.boxShadow = '0 2px 8px rgba(0, 191, 179, 0.15)';
                                          }
                                      }}
                                      onMouseLeave={(e) => {
                                          if (!isAtLimit) {
                                              e.currentTarget.style.boxShadow = 'none';
                                          }
                                      }}
                                  >
                                      <EuiFlexGroup alignItems="center" gutterSize="s" responsive={false}>
                                          <EuiFlexItem grow={false}>
                                              <div style={{ position: 'relative', display: 'inline-block' }} draggable={!isAtLimit}>

                                                  <EuiIcon
                                                      type={'bullseye'}
                                                      size="l"
                                                      color={isAtLimit ? 'subdued' : 'primary'}
                                                  />
                                                  <div
                                                      style={{
                                                          position: 'absolute',
                                                          bottom: '-2px',
                                                          right: '-2px',
                                                          width: '10px',
                                                          height: '10px',
                                                          borderRadius: '50%',
                                                          backgroundColor: type.online ? '#10b981' : '#ef4444',
                                                          border: '2px solid white',
                                                          opacity: isAtLimit ? 0.6 : 1
                                                      }}
                                                  />
                                              </div>
                                          </EuiFlexItem>

                                          <EuiFlexItem>
                                              <EuiText size="s">
                                                  <strong style={{ color: isAtLimit ? '#69707D' : '#343741' }}>
                                                      {type.name}
                                                  </strong>
                                              </EuiText>
                                              <EuiText size="xs" color="subdued" style={{ marginTop: '2px' }}>
                                                  {isAtLimit ? dict.limit : dict.drag}
                                              </EuiText>
                                          </EuiFlexItem>

                                          <EuiFlexItem grow={false}>
                                              <EuiBadge
                                                  color={isAtLimit ? 'danger' : currentCount > 0 ? 'success' : 'default'}
                                                  style={{
                                                      minWidth: '42px',
                                                      textAlign: 'center'
                                                  }}
                                              >
                                                  {currentCount}/1
                                              </EuiBadge>
                                          </EuiFlexItem>

                                          <EuiFlexItem grow={false} style={{ minWidth: '24px' }}>
                                              {isAtLimit ? (
                                                  <EuiIcon type="lock" color="subdued" size="m" />
                                              ) : (
                                                  <EuiIcon type="grab" color="subdued" size="m" />
                                              )}
                                          </EuiFlexItem>
                                      </EuiFlexGroup>
                                  </EuiPanel>
                              </EuiToolTip>
                          </EuiFlexItem>
                      );
                  })}
              </EuiFlexGroup>
          </EuiPanel>
      </div>
  );
};
