"use client"

import React from "react";
import { useAuth } from "@/hooks/useAuth";
import Loader from "@/app/components/Loader";

export default function AuthCheck({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {

  const { isAuthenticated } = useAuth();

  return isAuthenticated ? <>{children}</> : <Loader />;

}
