// import styles from "./Badge.module.css";

export default function Badge(props: { color: string, children: React.ReactNode }) {
  const color = props.color ? props.color : "var(--primary)"

  return (
    <div style={{
      backgroundColor: color,
      color: "var(--background)",
      borderRadius: "100px",
      padding: "0.5rem 1rem 0.5rem 1rem",
      width: "fit-content",
    }}>
      {props.children}
    </div>
  )
}
