import React from 'react';
import {
  EuiPanel,
  EuiAccordion,
  EuiFlexGroup,
  EuiFlexItem,
  EuiText,
  EuiBadge,
  EuiTitle,
  EuiListGroup,
  EuiIcon,
  EuiListGroupItem,
  EuiButtonIcon,
  EuiFieldText,
  EuiSpacer
} from '@elastic/eui';
import getDict from '@/lib/dict';
const dict = getDict("de");
export const CurrentPageAccessPoints = ({
  currentPageAccessPoints,
  setAccessPoints,
  accessPointTypes,
  editingNodeId,
  startEditingNode,
  handleAccessPointDragStart,
  handleTouchStartAccessPoint,
  editingNodeName,
  setEditingNodeName,
  setEditingNodeId
}) => {
  // Cancel editing
  const cancelEditingNode = () => {
    setEditingNodeId(null);
    setEditingNodeName('');
  };
  // Save node name
  const saveNodeName = () => {
    if (editingNodeName.trim()) {
      setAccessPoints(prev => prev.map(ap =>
          ap.id === editingNodeId
              ? { ...ap, floor: editingNodeName.trim() }
              : ap
      ));
    }
    setEditingNodeId(null);
    setEditingNodeName('');
  };
  const handleEditKeyPress = (e) => {
    e.stopPropagation();
    if (e.key === 'Enter') {
      e.preventDefault();
      saveNodeName();
    } else if (e.key === 'Escape') {
      e.preventDefault();
      cancelEditingNode();
    }
  };

  if (currentPageAccessPoints.length === 0) return null;

  return (
      <div style={{ padding: '24px', background: '#f5f7fa', minHeight: '100vh' }}>
        <EuiPanel paddingSize="m" hasShadow={false} hasBorder>
          <EuiFlexGroup alignItems="center" gutterSize="s" responsive={false}>
            <EuiFlexItem grow={false}>
              <EuiIcon type="bullseye" size="m" color="primary" />
            </EuiFlexItem>
            <EuiFlexItem>
              <EuiTitle size="xs">
                <h3>{dict.current} {dict.accessPoint}</h3>
              </EuiTitle>
            </EuiFlexItem>
          </EuiFlexGroup>
          <EuiSpacer size="s" />
          <div style={{ display: 'flex', flexDirection: 'column', gap: '6px' }}>
            {currentPageAccessPoints.map((ap) => {
              const type = accessPointTypes.find(t => t.id === ap.type);
              const isEditing = editingNodeId === ap.id;

              return (
                  <EuiPanel
                      key={ap.id}
                      paddingSize="s"
                      hasShadow={false}
                      hasBorder
                      style={{
                        cursor: isEditing ? 'default' : 'grab',
                        touchAction: isEditing ? 'auto' : 'none',
                        transition: 'all 0.2s ease',
                        borderColor: '#d3dae6',
                      }}
                      onMouseEnter={(e) => {
                        if (!isEditing) {
                          e.currentTarget.style.borderColor = '#00BFB3';
                          e.currentTarget.style.boxShadow = '0 2px 6px rgba(0, 191, 179, 0.1)';
                        }
                      }}
                      onMouseLeave={(e) => {
                        if (!isEditing) {
                          e.currentTarget.style.borderColor = '#d3dae6';
                          e.currentTarget.style.boxShadow = 'none';
                        }
                      }}
                  >
                    <EuiFlexGroup alignItems="center" gutterSize="s" responsive={false}>
                      <EuiFlexItem grow={false}>
                        <div style={{ position: 'relative', display: 'inline-block' }}>
                          <EuiIcon
                              type={'bullseye'}
                              size="l"
                              color="primary"
                          />
                          <div
                              style={{
                                position: 'absolute',
                                bottom: '-2px',
                                right: '-2px',
                                width: '10px',
                                height: '10px',
                                borderRadius: '50%',
                                backgroundColor: type?.online ? '#10b981' : '#ef4444',
                                border: '2px solid white',
                              }}
                          />
                        </div>
                      </EuiFlexItem>

                      <EuiFlexItem>
                        {isEditing ? (
                            <EuiFlexGroup gutterSize="xs" alignItems="center" responsive={false}>
                              <EuiFlexItem>
                                <EuiFieldText
                                    value={editingNodeName}
                                    onChange={(e) => setEditingNodeName(e.target.value)}
                                    onKeyDown={handleEditKeyPress}
                                    compressed
                                    autoFocus
                                    style={{ fontSize: '14px' }}
                                    onClick={(e) => e.stopPropagation()}
                                />
                              </EuiFlexItem>
                              <EuiFlexItem grow={false}>
                                <EuiButtonIcon
                                    iconType="check"
                                    color="success"
                                    size="s"
                                    onClick={(e) => {
                                      e.stopPropagation();
                                      saveNodeName();
                                    }}
                                    aria-label="Save name"
                                />
                              </EuiFlexItem>
                              <EuiFlexItem grow={false}>
                                <EuiButtonIcon
                                    iconType="cross"
                                    color="danger"
                                    size="s"
                                    onClick={(e) => {
                                      e.stopPropagation();
                                      cancelEditingNode();
                                    }}
                                    aria-label="Cancel edit"
                                />
                              </EuiFlexItem>
                            </EuiFlexGroup>
                        ) : (
                            <div>
                              <EuiText
                                  size="s"
                                  style={{ cursor: 'pointer' }}
                                  onClick={(e) => {
                                    e.stopPropagation();
                                    startEditingNode(ap);
                                  }}
                              >
                                <strong>{ap.name}</strong>
                              </EuiText>
                              <EuiText size="xs" color="subdued" style={{ marginTop: '2px' }}>
                                {dict.floor}: {ap.floor || 0}
                              </EuiText>
                            </div>
                        )}
                      </EuiFlexItem>

                      <EuiFlexItem grow={false} style={{ minWidth: '32px' }}>
                        {!isEditing ? (
                            <EuiButtonIcon
                                iconType="pencil"
                                color="text"
                                size="s"
                                onClick={(e) => {
                                  e.stopPropagation();
                                  startEditingNode(ap);
                                }}
                                aria-label="Rename access point"
                            />
                        ) : (
                            <div style={{ width: '32px' }} />
                        )}
                      </EuiFlexItem>

                      <EuiFlexItem grow={false} style={{ minWidth: '24px' }}>
                        {isEditing ? (
                            <div style={{ width: '24px' }} />
                        ) : (
                            <EuiIcon type="grab" color="subdued" size="m" />
                        )}
                      </EuiFlexItem>
                    </EuiFlexGroup>
                  </EuiPanel>
              );
            })}
          </div>
        </EuiPanel>
      </div>
  );
};
