import React from 'react';
import {
  EuiPanel,
  EuiTitle,
  EuiSpacer,
  EuiFlexGroup,
  EuiFlexItem,
  EuiFilePicker,
  EuiHealth,
  EuiButton,
  EuiNotificationBadge,
  EuiLoadingSpinner,
  EuiText
} from '@elastic/eui';
import { FileUploadComponent } from '@/setupApp/components/forms/FileUploadComponent';
import getDict from '@/lib/dict';
const dict = getDict("de");
export const FileUploader = ({
  pdfFile,
  pdfJsLoaded,
  loadingError,
  apiLoading,
  accessPoints,
  savedProjects,
  onFileUpload,
  onSave,
  onLoad,
  onViewLegend,
  onGeneratePDF,
  isGenerating,
  jsPdfLoaded,
  configSetup
}) => {
  return (
    <EuiPanel>
      {!configSetup ?? <EuiTitle size="m">
        <h2>Upload PDF Map</h2>
      </EuiTitle>}
      <FileUploadComponent onFileSelect={onFileUpload} accept={'.pdf'} apiLoading={apiLoading}/>
      <EuiSpacer size="m" />
      
    </EuiPanel>
  );
};
