import React from 'react';
import {
  EuiOverlayMask,
  EuiModal,
  EuiModalHeader,
  EuiModalHeaderTitle,
  EuiModalBody,
  EuiModalFooter,
  EuiButton,
  EuiFlexGroup,
  EuiFlexItem,
  EuiIcon,
  EuiText,
  EuiSpacer,
  EuiListGroup,
  EuiListGroupItem,
  EuiEmptyPrompt
} from '@elastic/eui';

export const LegendModal = ({
  show,
  onClose,
  accessPointTypes,
  accessPoints
}) => {
  if (!show) return null;

  return (
    <EuiOverlayMask>
      <EuiModal onClose={onClose} maxWidth={600}>
        <EuiModalHeader>
          <EuiModalHeaderTitle>Access Points Legend</EuiModalHeaderTitle>
        </EuiModalHeader>

        <EuiModalBody>
          {accessPointTypes.map((type) => {
            const typePoints = accessPoints.filter(ap => ap.type === type.id);
            if (typePoints.length === 0) return null;

            return (
              <div key={type.id}>
                <EuiFlexGroup alignItems="center" gutterSize="s">
                  <EuiFlexItem grow={false}>
                    <div
                      style={{
                        width: '16px',
                        height: '16px',
                        borderRadius: '50%',
                        backgroundColor: type.color
                      }}
                    />
                  </EuiFlexItem>
                  <EuiFlexItem grow={false}>
                    <EuiIcon type={type.iconType} />
                  </EuiFlexItem>
                  <EuiFlexItem>
                    <EuiText>
                      <strong>{type.name}</strong> ({typePoints.length} points)
                    </EuiText>
                  </EuiFlexItem>
                </EuiFlexGroup>

                <EuiSpacer size="s" />

                <EuiListGroup maxWidth={false} flush>
                  {typePoints.map((point) => (
                    <EuiListGroupItem
                      key={point.id}
                      label={`${point.name} - Page ${point.page + 1}`}
                      size="s"
                      style={{ paddingLeft: '32px' }}
                    />
                  ))}
                </EuiListGroup>

                <EuiSpacer size="m" />
              </div>
            );
          })}

          {accessPoints.length === 0 && (
            <EuiEmptyPrompt
              icon={<EuiIcon type="pin" size="l" />}
              title={<h3>No Access Points Added</h3>}
              body={<p>Add access points to the map to see them in the legend.</p>}
            />
          )}
        </EuiModalBody>

        <EuiModalFooter>
          <EuiButton onClick={onClose} fill>
                        Close
          </EuiButton>
        </EuiModalFooter>
      </EuiModal>
    </EuiOverlayMask>
  );
};
