import React from 'react';
import {
  EuiOverlayMask,
  EuiModal,
  EuiModalHeader,
  EuiModalHeaderTitle,
  EuiModalBody,
  EuiModalFooter,
  EuiButton,
  EuiLoadingSpinner,
  EuiFlexGroup,
  EuiFlexItem,
  EuiText,
  EuiEmptyPrompt,
  EuiIcon,
  EuiListGroup,
  EuiListGroupItem
} from '@elastic/eui';
import getDict from '@/lib/dict';
const dict = getDict("de");

export const LoadProjectModal = ({
  show,
  onClose,
  savedProjects,
  apiLoading,
  onLoadProject
}) => {
  if (!show) return null;

  return (
    <EuiOverlayMask>
      <EuiModal onClose={onClose} maxWidth={600}>
        <EuiModalHeader>
          <EuiModalHeaderTitle>
            {dict.loadProject}
          </EuiModalHeaderTitle>
        </EuiModalHeader>

        <EuiModalBody>
          {apiLoading ? (
            <EuiFlexGroup alignItems="center" justifyContent="center">
              <EuiFlexItem grow={false}>
                <EuiLoadingSpinner size="l" />
              </EuiFlexItem>
              <EuiFlexItem grow={false}>
                <EuiText>Loading projects...</EuiText>
              </EuiFlexItem>
            </EuiFlexGroup>
          ) : savedProjects.length === 0 ? (
            <EuiEmptyPrompt
              icon={<EuiIcon type="folderOpen" size="l" />}
              title={<h3>No Saved Projects</h3>}
              body={<p>Save your current project to see it here.</p>}
            />
          ) : (
            <EuiListGroup maxWidth={false} flush>
              {savedProjects
                .sort((a, b) => b.timestamp - a.timestamp)
                .map((project) => (
                  <EuiListGroupItem
                    key={project.name}
                    label={
                      <EuiFlexGroup alignItems="center" justifyContent="spaceBetween">
                        <EuiFlexItem>
                          <EuiFlexGroup direction="column" gutterSize="xs">
                            <EuiFlexItem>
                              <EuiText size="s">
                                <strong>{project.name}</strong>
                              </EuiText>
                            </EuiFlexItem>
                            <EuiFlexItem>
                              <EuiText size="xs" color="subdued">
                                {project.accessPoints?.length || 0} {dict.accessPoint} • {' '}
                                {project.pdfFile?.name || 'No PDF'} • {' '}
                                {new Date(project.timestamp).toLocaleDateString()}
                              </EuiText>
                            </EuiFlexItem>
                          </EuiFlexGroup>
                        </EuiFlexItem>
                        <EuiFlexItem grow={false}>
                          <EuiFlexGroup gutterSize="xs">
                            <EuiFlexItem grow={false}>
                              <EuiButton
                                onClick={() => onLoadProject(project)}
                                size="s"
                                fill
                                disabled={apiLoading}
                              >
                                {dict.load}
                              </EuiButton>
                            </EuiFlexItem>
                          </EuiFlexGroup>
                        </EuiFlexItem>
                      </EuiFlexGroup>
                    }
                  />
                ))}
            </EuiListGroup>
          )}
        </EuiModalBody>

        <EuiModalFooter>
          <EuiButton onClick={onClose} fill>
            {dict.close}
          </EuiButton>
        </EuiModalFooter>
      </EuiModal>
    </EuiOverlayMask>
  );
};
