// React Dependencies
import React from "react";
// Own Dependencies
import { Wifi, WifiHigh, WifiLow, WifiZero, WifiOff } from "lucide-react";

interface CheckQualityProps {
  value: number;
}
export const CheckQuality: React.FC<CheckQualityProps> = ({ value, ...props }) => {
  if (!value) {
    return (
      <div {...props}>
        <WifiOff color="gray" strokeWidth={3} />
      </div>
    );
  }
  if (value >= -30) {
    return (
      <div {...props}>
        <Wifi color="green" strokeWidth={3} />
      </div>
    );
  }
  if (value >= -60) {
    return (
      <div {...props}>
        <WifiZero color="yellow" strokeWidth={3} />
      </div>
    );
  }
  if (value >= -70) {
    return (
      <div {...props}>
        <WifiLow color="orange" strokeWidth={3} />
      </div>
    );
  }
  if (value >= -80) {
    return (
      <div {...props}>
        <WifiHigh color="red" strokeWidth={3} />
      </div>
    );
  }

  return (
    <div {...props}>
      <WifiOff color="gray" strokeWidth={3} />
    </div>
  );
};
