import React from 'react';
import {
  EuiOverlayMask,
  EuiModal,
  EuiModalHeader,
  EuiModalHeaderTitle,
  EuiModalBody,
  EuiModalFooter,
  EuiFormRow,
  EuiFieldText,
  EuiSpacer,
  EuiText,
  EuiButton
} from '@elastic/eui';
import getDict from '@/lib/dict';
const dict = getDict("de");

export const SaveProjectModal = ({
  show,
  onClose,
  projectName,
  setProjectName,
  onSave,
  apiLoading,
  accessPoints,
  pdfFile
}) => {
  if (!show) return null;

  return (
    <EuiOverlayMask>
      <EuiModal onClose={onClose} maxWidth={400}>
        <EuiModalHeader>
          <EuiModalHeaderTitle>{dict.saveProject}</EuiModalHeaderTitle>
        </EuiModalHeader>

        <EuiModalBody>
          <EuiFormRow label={dict.projectNameText} helpText={dict.name}>
            <EuiFieldText
              value={projectName}
              onChange={(e) => setProjectName(e.target.value)}
              placeholder={dict.name}
              onKeyDown={(e) => e.key === 'Enter' && onSave()}
            />
          </EuiFormRow>

          <EuiSpacer size="m" />

          <EuiText size="s" color="subdued">
            <ul>
              <li>{accessPoints.length} {dict.accessPoint}</li>
              {pdfFile ? (
                <li>PDF file "{pdfFile.name}"</li>
              ) : (
                <li><strong>{dict.uploadText} {dict.accessPoint}</strong></li>
              )}
            </ul>
          </EuiText>
        </EuiModalBody>

        <EuiModalFooter>
          <EuiButton onClick={onClose}>
            {dict.cancelBtn}
          </EuiButton>
          <EuiButton
            onClick={onSave}
            fill
            disabled={!projectName.trim() || !pdfFile}
            isLoading={apiLoading}
          >
            {apiLoading ? dict.saving +'...' : dict.saveProject}
          </EuiButton>
        </EuiModalFooter>
      </EuiModal>
    </EuiOverlayMask>
  );
};
