// React Dependencies
import React from 'react';
// External Libraries Dependencies
import {
  EuiStat,
  EuiFlexItem,
  EuiFlexGroup,
  EuiPanel,
  EuiSpacer,
  EuiTextColor,
  EuiText,
} from '@elastic/eui';
import { Download, Fingerprint, Group, Upload, Wifi, WifiOff } from "lucide-react";
// Own Dependencies
import Network from "@/app/types/Network";
import getDict from "@/lib/dict";

export default function Stats(props: { network: Network}) {
  const dict = getDict("de");
  const capitalizeFirstLetter = (str: string) => {
    if (!str) return str;
    return str.charAt(0).toUpperCase() + str.slice(1);
  }
  return (
    <div>
      <EuiFlexGroup>
        <EuiFlexItem>
          <EuiPanel hasBorder={true}>
            <EuiFlexGroup>
              <EuiText>Data</EuiText>
              <EuiFlexItem>
                <EuiStat
                  title={ props.network.total_download ? (props.network.total_download/1024).toFixed(1) + 'Mb' : '-'}
                  textAlign="center"
                  description={<Download />}
                >
                  {capitalizeFirstLetter(dict.download)}
                </EuiStat>
              </EuiFlexItem>
              <EuiFlexItem>
                <EuiStat
                  title={props.network.total_upload ? (props.network.total_upload/1024).toFixed(1) + 'Mb' : '-'}
                  description={<Upload />}
                  textAlign="center"
                >
                  {capitalizeFirstLetter(dict.upload)}
                </EuiStat>
              </EuiFlexItem>
            </EuiFlexGroup>
          </EuiPanel>
        </EuiFlexItem>
        <EuiFlexItem>
          <EuiPanel hasBorder={true}>
            <EuiFlexGroup>
              <EuiText>{capitalizeFirstLetter(dict.clientStats)}</EuiText>
              <EuiFlexItem>
                <EuiStat
                  title={props.network.total_clients}
                  description={<EuiTextColor color={'green'}><Group /></EuiTextColor>}
                  textAlign="center"
                >
                  Total
                </EuiStat>
              </EuiFlexItem>
              <EuiFlexItem>
                <EuiStat
                  title={props.network.online_clients}
                  titleColor="success"
                  description={<EuiTextColor color={'green'}><Wifi /></EuiTextColor>}
                  textAlign="center"
                >
                  {capitalizeFirstLetter(dict.online)}
                </EuiStat>
              </EuiFlexItem>
              <EuiFlexItem>
                <EuiStat
                  title={props.network.offline_clients}
                  titleColor="danger"
                  description={<EuiTextColor color={'danger'}><WifiOff /></EuiTextColor>}
                  textAlign="center"
                >
                  {capitalizeFirstLetter(dict.offline)}
                </EuiStat>
              </EuiFlexItem>
              <EuiFlexItem>
                <EuiStat
                  title={props.network.authenticated_clients}
                  textAlign="center"
                  description={<Fingerprint />}
                >
                  {capitalizeFirstLetter(dict.authenticated)}
                </EuiStat>
              </EuiFlexItem>
            </EuiFlexGroup>
          </EuiPanel>
        </EuiFlexItem>
      </EuiFlexGroup>
      <EuiSpacer />
    </div>
  );
}
