import React from 'react';
import {
  EuiFlexGroup,
  EuiFlexItem,
  EuiToolTip,
  EuiButtonIcon,
  EuiText
} from '@elastic/eui';

export const ZoomControls = ({
  zoomLevel,
  onZoomIn,
  onZoomOut,
  onZoomReset,
  minZoom,
  maxZoom
}) => {
  return (
    <EuiFlexGroup alignItems="center" gutterSize="s">
      <EuiFlexItem grow={false}>
        <EuiToolTip content="Zoom Out">
          <EuiButtonIcon
            iconType="minusInCircle"
            onClick={onZoomOut}
            disabled={zoomLevel <= minZoom}
            aria-label="Zoom out"
          />
        </EuiToolTip>
      </EuiFlexItem>
      <EuiFlexItem grow={false}>
        <EuiText size="s" style={{ minWidth: '60px', textAlign: 'center' }}>
          {Math.round(zoomLevel * 100)}%
        </EuiText>
      </EuiFlexItem>
      <EuiFlexItem grow={false}>
        <EuiToolTip content="Zoom In">
          <EuiButtonIcon
            iconType="plusInCircle"
            onClick={onZoomIn}
            disabled={zoomLevel >= maxZoom}
            aria-label="Zoom in"
          />
        </EuiToolTip>
      </EuiFlexItem>
      <EuiFlexItem grow={false}>
        <EuiToolTip content="Reset Zoom & Pan">
          <EuiButtonIcon
            iconType="refresh"
            onClick={onZoomReset}
            aria-label="Reset zoom and pan"
          />
        </EuiToolTip>
      </EuiFlexItem>
    </EuiFlexGroup>
  );
};
