import Link from "next/link";
import styles from "./Button.module.css";

type Style = "outlined" | "filled" | "primary-outlined" | "primary-filled";

interface ButtonProps {
  onClick?: () => void;
  href?: string;
  hrefInNewTab?: boolean;
  hrefDownload?: boolean;
  style?: Style;
  type?: "submit" | "reset" | "button";
  children: React.ReactNode;
}

export default function Button( props: ButtonProps) {

  return props.href ? (
    <Link
      href={props.href}
      className={styles[props.style ? props.style : "outlined"]}
      target={props.hrefInNewTab ? "_blank" : undefined}
      download={props.hrefDownload}
    >
      {props.children}
    </Link>
  ) : (
    <button
      onClick={props.onClick}
      className={styles[props.style ? props.style : "outlined"]}
      type={props.type}
    >
      {props.children}
    </button>
  )
}