import getDict from "@/lib/dict";
import { IconProps } from "../Icon";
import Navbar from "./Navbar";
import styles from "./Navigation.module.css";
import Sidebar from "./Sidebar";

export interface MenuItem {
  href: string
  text: string
  icon: IconProps
}

export function getFirstPathElement(path: string) {
  // Split the path by '/' and filter out any empty strings (in case there are leading or trailing slashes)
  const parts = path.split('/').filter(Boolean);

  // Return the first part, or an empty string if no parts exist
  return parts.length > 0 ? parts[0] : '';
}

export default function Navigation({
  children
}: Readonly<{
  children: React.ReactNode;
}>) {
  const dict = getDict("de");

  const menuItems: MenuItem[] = [
    {
      href: "/",
      text: dict.dashboard,
      icon: { name: "dashboard" }
    },
    {
      href: "/networks",
      text: dict.networks,
      icon: { name: "networks" }
    },
    {
      href: "/devices",
      text: dict.devices,
      icon: { name: "devices" }
    },
    {
      href: "/antennas",
      text: dict.antennas,
      icon: { name: "antennas" }
    },
    {
      href: "/internet",
      text: dict.internet,
      icon: { name: "internet" }
    },
    {
      href: "/logs",
      text: dict.logs,
      icon: { name: "logs" }
    },
    {
      href: "/support",
      text: dict.support,
      icon: { name: "support" }
    },
  ]

  return (
    <>
      <Navbar menuItems={menuItems} />
      <div className={styles.belowNavbar}>
        <Sidebar menuItems={menuItems} />
        <div className={styles.content}>
          {children}
        </div>
      </div>
    </>
  );
}
