import Link from "next/link";
import { getFirstPathElement, MenuItem } from "./Navigation";
import styles from "./Sidebar.module.css";
import "./Sidebar.module.css"
import Icon from "../Icon";
import { usePathname } from "next/navigation";

export default function Sidebar(props: { menuItems: MenuItem[] }) {
  const pathName = usePathname();

  return (
    <div className={styles.sidebar}>

      {props.menuItems.map(item => {
        const isActive = getFirstPathElement(pathName) === getFirstPathElement(item.href);

        return (
          <Link
            key={item.href}
            href={item.href}
            className={
              `${styles.menuLink} ${isActive ? styles.activeMenuLink : ""}`
            }>
            <Icon name={item.icon.name} color={isActive ? "var(--primary-text)" : undefined}/>
            {item.text}
          </Link>
        );
      }
      )}

    </div>
  );
}
