"use client"

// React Dependencies
import React from "react";
// Custum hooks
import { useHighlightedItems } from "@/hooks/useHighlightedItems";
import { useFilteredData } from "@/hooks/useFilteredData";
// External Libraries Dependencies
import { EuiInMemoryTable, EuiSelectOption } from "@elastic/eui";
// Own Dependencies
import { DeviceColumns } from "./deviceColumns";
import Device, { DeviceType } from "@/app/types/Device";
import Filters from "@/app/components/Filters";

interface SortConfig {
  field: keyof Device;
  direction: "asc" | "desc";
}
interface TableChangeParams {
  sort?: SortConfig;
}

export const DeviceTable = (props: { data: Device[], showNetworkColumn: boolean}) => {
  const column = DeviceColumns(props.showNetworkColumn);
  const [sortConfig, setSortConfig] = React.useState<SortConfig>({
    field: 'name',
    direction: "asc",
  });

  const onTableChange = ({ sort }: TableChangeParams) => {
    if (sort) {
      setSortConfig(sort);
    }
  };
  const sorting: { sort: SortConfig } = {
    sort: sortConfig,
  };
  const { items, newRowIds } = useHighlightedItems(props.data);
  const { filteredItems, searchText, setSearchText, selectedType, setSelectedType, onlineFilter, setOnlineFilter } =
    useFilteredData(items, true);
  const typeOptions: EuiSelectOption[] = [
    {
      value: '',
      text: 'All'
    },
    ...Array.from(new Set(items.map((item: Device) => item.type))).map((type: DeviceType) => ({
      value: type,
      text: type.charAt(0).toUpperCase() + type.slice(1),
    })),
  ];
  const rowProps = (item: { id: string | number }) => {
    const isNew = newRowIds.includes(item.id);
    return {
      className: isNew ? 'new-row-highlight' : '',
    };
  };

  return(
    <>
      <Filters
        searchText={searchText}
        setSearchText={setSearchText}
        selectedType={selectedType}
        setSelectedType={setSelectedType}
        onlineFilter={onlineFilter}
        setOnlineFilter={setOnlineFilter}
        typeOptions={typeOptions}
        showOnline={true}
      />
      <EuiInMemoryTable
        items={filteredItems as Device[]}
        columns={column}
        onTableChange={onTableChange}
        sorting={sorting}
        rowProps={rowProps}
      />
    </>
  )
}
