import { EuiDescriptionList } from "@elastic/eui";
export const PrintComponent = (props: any) => {

  const selectRows = (array: string | any[], rowIndices: any) => {
    if (!Array.isArray(array)) {
      return [];
    }

    if (!Array.isArray(rowIndices)) {
      return [];
    }

    const selectedRows = [];

    for (const index of rowIndices) {
      if (index >= 0 && index < array.length) {
        selectedRows.push(array[index]);
      }
    }

    return selectedRows;
  }
  return (
    <EuiDescriptionList
      type="column"
      className="print-section"
      listItems={selectRows(props.data, [2,7,8])}
      style={{ maxWidth: '400px' }}
    />
  )
}
