import type { Metadata } from "next";
import "./globals.css";
import branding from "@/lib/branding";
import { Providers } from "@/providers/providers";

export const metadata: Metadata = {
  title: "UB-EDGE",
  description: "UB-EDGE Management Portal",
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {

  interface CssVars extends React.CSSProperties {
    "--background": `#${string}`;
    "--text": `#${string}`;
    "--primary": `#${string}`;
    "--primary-text": `#${string}`;
  }
  const cssVars: CssVars = {
    "--background": branding.background,
    "--text": branding.text,
    "--primary": branding.primaryColor,
    "--primary-text": branding.primaryText
  }

  return (
    <html lang="en" style={cssVars}>
      <body>
        <Providers>{children}</Providers>
      </body>
    </html>
  );
}
