"use client"

import styles from "./page.module.css";
import getDict from "@/lib/dict";
import Button from "@/app/components/form/Button";
import QRCode from "react-qr-code";
import Network, { GuestPassword } from "@/app/types/Network";
import { NetworkManagementFunctions } from "./page";
import { EuiConfirmModal, EuiDescriptionList,
  useGeneratedHtmlId } from "@elastic/eui";
import React from "react";

export default function GuestNetworkDetails(props: { network: Network, guestPassword: GuestPassword, managementFunctions: NetworkManagementFunctions }) {
  const dict = getDict("de");
  const items = props.network.name ? ([
    {
      title: dict.type,
      description: dict[props.network.type]
    },
    {
      title: dict.name,
      description: props.network.name,
    },
    {
      title: dict.password,
      description: props.guestPassword.password,
    },
    {
      title: dict.password + ' QR-Code:',
      description: <>{props.guestPassword ?
        <QRCode value={`WIFI:S:${props.network.name};T:WPA;P:${props.guestPassword};H:false;`} style={{maxWidth: "10rem", height: "auto"}}/>
        : null}</>,
    },
  ]) : [];
  const [isDestroyModalVisible, setIsDestroyModalVisible] = React.useState(false);
  const destroyModalTitleId = useGeneratedHtmlId();
  const closeDestroyModal = () => setIsDestroyModalVisible(false);
  const showDestroyModal = () => setIsDestroyModalVisible(true);
  return (
    <>
      <EuiDescriptionList
        type="column"
        listItems={items}
        style={{ maxWidth: '400px' }}
      />
      <div className={styles.actions}>
        <Button onClick={async () => {
          await props.managementFunctions.renameNetwork(props.network.id)}
        }>{dict.editName}</Button>
        <Button onClick={showDestroyModal} style="primary-filled">{dict.delete}</Button>
        {isDestroyModalVisible ?
          <EuiConfirmModal
            aria-labelledby={destroyModalTitleId}
            title={`${dict.remove} ${props.network.name} ?`}
            titleProps={{id: destroyModalTitleId}}
            onCancel={closeDestroyModal}
            onConfirm={async () => {
              await props.managementFunctions.deleteNetwork(props.network.id);
              setIsDestroyModalVisible(false);
            }}
            cancelButtonText={`${dict.cancel}`}
            confirmButtonText={`${dict.confirm}`}
            buttonColor="danger"
            defaultFocusedButton="confirm"
          >
          </EuiConfirmModal>: null}
      </div>
    </>
  );
}
