"use client"

// React Dependencies
import React from "react";
// NextJs Dependencies
import { useRouter } from 'next/navigation';
// External Libraries Dependencies
import { EuiBasicTableColumn, EuiBetaBadge } from "@elastic/eui";
// Own Dependencies
import Network from "@/app/types/Network";
import getDict from "@/lib/dict";

const dict = getDict("de");
export const NetworkColumns = () => {
  const router = useRouter();
  const [items, setItems] = React.useState<EuiBasicTableColumn<Network>[]>([]);

  React.useEffect(() => {
    const baseColumns: EuiBasicTableColumn<Network>[]=[
      {
        field: 'type',
        name: dict.type,
        render: (item: string, network: Network) => {
          return <EuiBetaBadge
            label={dict[network.type]}
            color={'hollow'}
            size="m"
          />
        }
      },
      {
        field: 'name',
        name: dict.name ?? "",
        sortable: true,
      },
      {
        field: 'total_clients',
        name: dict.total ?? "",
        sortable: (item: Network) => item.total_clients,
        render: (item: string) => item ?? '-',
      },
      {
        field: 'total_upload',
        name: dict.upload ?? "",
        sortable: (item: Network) => item.total_upload,
        render: (item: string) => item ?? '-',
      },
      {
        field: 'total_download',
        name: dict.download ?? "",
        sortable: (item: Network) => item.total_download,
        render: (item: string) => item ?? '-',
      },
      {
        field: 'online_clients',
        name: dict.online ?? "",
        sortable: (item: Network) => item.online_clients,
        render: (item: string) => item ?? '-',
      },
      {
        field: 'offline_clients',
        name: dict.offline ?? "",
        sortable: (item: Network) => item.offline_clients,
        render: (item: string) => item ?? '-',
      },
      {
        field: 'authenticated_clients',
        name: dict.authenticated ?? "",
        sortable: (item: Network) => item.authenticated_clients,
        render: (item: string) => item ?? '-',
      },

      {
        name: dict.actions,
        actions: [
          {
            name: 'Clone',
            description: 'Edit',
            icon: 'pencil',
            type: 'icon',
            onClick: (network: Network) => {
              router.push(`edit?id=${network.id}`);
            },
          },
        ],
      },
    ];

    setItems(baseColumns);
  }, [router]);

  return items;
};
