"use client"

// React Dependencies
import React from "react";
// Custum hooks
import { useFilteredData } from "@/hooks/useFilteredData";
import { useHighlightedItems } from "@/hooks/useHighlightedItems";
// Context
import { useLoader } from "@/context/LoaderContext";
// External Libraries Dependencies
import { EuiInMemoryTable, EuiSelectOption } from "@elastic/eui";
// Own Dependencies
import { NetworkColumns } from "./networkColumns";
import Network, { NetworkType } from "@/app/types/Network";
import Filters from "@/app/components/Filters";

interface SortConfig {
  field: keyof Network;
  direction: "asc" | "desc";
}
interface TableChangeParams {
  sort?: SortConfig;
}

export const NetworkTable = (props: { data: Network[]}) => {
  const column = NetworkColumns();
  const [sortConfig, setSortConfig] = React.useState<SortConfig>({
    field: 'name',
    direction: "asc",
  });

  const onTableChange = ({ sort }: TableChangeParams) => {
    if (sort) {
      setSortConfig(sort);
    }
  };

  const sorting: { sort: SortConfig } = {
    sort: sortConfig,
  };

  const { items, newRowIds } = useHighlightedItems(props.data);
  const { filteredItems, searchText, setSearchText, selectedType, setSelectedType, onlineFilter, setOnlineFilter } =
    useFilteredData(items, false);
  const typeOptions: EuiSelectOption[] = [
    {
      value: '',
      text: 'All'
    },
    ...Array.from(new Set(items.map((item: Network) => item.type))).map((type: NetworkType) => ({
      value: type,
      text: type.charAt(0).toUpperCase() + type.slice(1),
    })),
  ];
  const rowProps = (item: { id: string | number }) => {
    const isNew = newRowIds.includes(item.id);
    return {
      className: isNew ? 'new-row-highlight' : '',
    };
  };
  const { loading } = useLoader();
  return(
    <>
      <Filters
        searchText={searchText}
        setSearchText={setSearchText}
        selectedType={selectedType}
        setSelectedType={setSelectedType}
        onlineFilter={onlineFilter}
        setOnlineFilter={setOnlineFilter}
        typeOptions={typeOptions}
        showOnline={false}
      />
      <EuiInMemoryTable
        items={filteredItems as Network[]}
        columns={column}
        onTableChange={onTableChange}
        sorting={sorting}
        loading={loading}
        rowProps={rowProps}
      />
    </>
  )
}
