"use client";

// React Dependencies
import React from "react";
// External Libraries Dependencies
import {
  EuiFlexGroup,
  EuiSpacer,
  EuiPanel,
  EuiStat,
  EuiHorizontalRule,
  EuiHealth,
  EuiFlexItem,
  EuiCard,
  EuiText,
  EuiTitle,
  EuiIcon,
  EuiBadge,
  EuiLoadingSpinner
} from "@elastic/eui";
// Custum hooks
import { useDomReady } from "@/hooks/useDomReady";
import { useAuth } from "@/hooks/useAuth";
// Service
import { getAccessPoints } from "@/services/accessPoints";
import { getDevices } from "@/services/device";
// Providers
import { useToast } from "@/app/components/ToastProvider";
// Context
import { useLoader } from "@/context/LoaderContext";
// Components
import AuthCheck from "@/app/components/AuthCheck";
import Map, { Data } from "@/app/components/dashboard/Map";
import Navigation from "@/app/components/navigation/Navigation";
import { Node } from "@/app/components/dashboard/Map";
import Loader from "@/app/components/Loader";
// Own Styles
import styles from "./page.module.css";
// Other Dependencies
import getDict from "@/lib/dict";
import AP from "./types/AP";
import Device from "./types/Device";
import { ApiError, getErrorCode } from "@/lib/errorsCodes";
import { checkResponseShape } from "@/lib/checkResponseShape";
import PDFMapEditor from "./components/PDFMapEditor";
import Test from "../setupApp/Test";
import CardsDashboard from "./Cards";


const CheckSignal = (value: number) => {
  if (value <= -80) return 'bad';
  if (value <= -70) return 'moderate';
  if (value <= -60) return 'moderate';
  if (value <= -30) return 'good';
  return 'bad';
}
const dict = getDict("de");

export default function Dashboard() {

  const { addToast } = useToast();
  const domReady = useDomReady();
  const { setLoading, globalAps, setGlobalAps } = useLoader();

  const [aps, setAPs] = React.useState<AP[]>([]);
  const [devices, setDevices] = React.useState<Device[]>([]);
  const { isAuthenticated } = useAuth();
  async function fetchAPs() {
    try {
      setLoading(true);
      const response = await getAccessPoints();
      if (!response.ok) {
        const errorCode = getErrorCode('ACCESS_POINT_FETCH', response.status);
        addToast({
          title: errorCode,
          color: "danger",
          text: dict.apFetchToastFail,
        });
        setLoading(false);
        return;
      }
      const data = await response.json();
      // Dont rely on backend, double check response schema
      if (checkResponseShape(data)) {
        setGlobalAps(data);
      } else {
        addToast({
          title: 'Fetch Error',
          color: "danger",
          text: dict.apFetchToastFail,
        });
      }
      setLoading(false);
    } catch (err) {
      const error = err as ApiError;
      const errorCode = getErrorCode('ACCESS_POINT_EXCEPTION', error.status);
      setLoading(false);
      addToast({
        title: errorCode,
        color: "danger",
        text: dict.apFetchToastFail,
      });
    }
  }
  React.useEffect(() => {
    if (!domReady || !isAuthenticated) return;

    const interval = setInterval(() => {
      fetchAPs();
    }, 5000);

    fetchAPs();
    return () => clearInterval(interval);
  }, [domReady]);
  if (!domReady) {
    return <EuiLoadingSpinner size="s"/>
  }
  return (
    <AuthCheck>
      <Navigation>
        <EuiTitle><h1>{dict.dashboard}</h1></EuiTitle>
        <EuiSpacer />
        <Loader />
        <CardsDashboard devices={devices} dict={dict}/>
        <EuiSpacer />
        <PDFMapEditor aps={globalAps} />
      </Navigation>
    </AuthCheck>)
};
