"use client"

import AuthCheck from "../components/AuthCheck";
import Navigation from "../components/navigation/Navigation";
import getDict from "@/lib/dict";
import styles from "./page.module.css";
import branding from "@/lib/branding";
import React from "react";
import Cookies from "js-cookie";
import { EuiTitle, EuiDescriptionList, EuiButtonEmpty } from "@elastic/eui";

export default function Support() {
  const dict = getDict("de");
  const [userEmail, setUserEmail] = React.useState<string | null>(null);

  // Get user email from cookie
  React.useEffect(() => {
    const savedEmail = Cookies.get('userEmail'); // Access email from cookies
    if (savedEmail) {
      setUserEmail(savedEmail);
    }
  }, []);
  const items = ([
    {
      title: dict.userManual,
      description: <EuiButtonEmpty iconType={"download"} color={"text"} href={branding.userManualLink}>{dict.download}</EuiButtonEmpty>,
    },
    {
      title: dict.supportEmail,
      description: <EuiButtonEmpty iconType={"email"} href={`mailto:${branding.supportEmail}?subject=${branding.productName}: User ${userEmail} Support Request`}>{branding.supportEmail}</EuiButtonEmpty>,
    },
    {
      title: dict.supportHotline,
      description: <EuiButtonEmpty iconType={"mobile"} href={`tel:${branding.supportHotline}`}>{branding.supportHotline}</EuiButtonEmpty>,
    },
  ]);
  return (
    <AuthCheck>
      <Navigation>
        <div className={styles.page}>
          <EuiTitle>
            <h2>{dict.support}</h2>
          </EuiTitle>
          <EuiDescriptionList
            type="column"
            listItems={items}
            style={{ maxWidth: '400px' }}
          />
        </div>
      </Navigation>
    </AuthCheck>
  );
}
