"use client"

import AP from "@/app/types/AP";
import { SCREEN_TYPES } from "@/setupApp/utils/constants";
import React from "react";

// Define the context type
interface LoaderContextType {
  loading: boolean;
  setLoading: (value: boolean) => void;
  currentScreen?: string;
  setCurrentScreen?: (value: string) => void;
  setGlobalAps: (value: []) => void;
  globalAps: [];
  currentStep: number;
  setCurrentStep: React.Dispatch<React.SetStateAction<number>>;
  completedSteps: [];
  setCompletedSteps: (value: []) => void;
  completeCurrentStep: () => void;
  completeStep: (value: number) => void;
}

// Create the context with default values
const LoaderContext = React.createContext<LoaderContextType | undefined>(undefined);

// Custom hook to use the LoaderContext
export const useLoader = () => {
  const context = React.useContext(LoaderContext);
  if (!context) {
    throw new Error("useLoader must be used within a LoaderProvider");
  }
  return context;
};

// Provider component
export const LoaderProvider = ({ children }: { children: React.ReactNode }) => {
  const [loading, setLoading] = React.useState(false);
  const [currentScreen, setCurrentScreen] = React.useState('welcome');
  const [globalAps, setGlobalAps] = React.useState<AP[]>([]);
  const [currentStep, setCurrentStep] = React.useState(0);
  const [completedSteps, setCompletedSteps] = React.useState([]);
  const completeCurrentStep = () => {
    if (!completedSteps.includes(currentStep)) {
      setCompletedSteps(prev => [...prev, currentStep].sort((a, b) => a - b));
    }
  };
  const completeStep = (stepIndex) => {
    if (!completedSteps.includes(stepIndex)) {
      setCompletedSteps(prev => [...prev, stepIndex].sort((a, b) => a - b));
    }
  }
  React.useEffect(() => {
    switch (currentStep) {
      case 0:
        setCurrentScreen(SCREEN_TYPES.WELCOME);
        return;
      case 1:
        setCurrentScreen(SCREEN_TYPES.LOADING_NETWORK);
        return;
      case 2:
        setCurrentScreen(SCREEN_TYPES.LOADING_AP);
        return;
      case 3:
        setCurrentScreen(SCREEN_TYPES.UPLOAD);
        return;
      case 4:
        setCurrentScreen(SCREEN_TYPES.PDF_CROP);
        return;
      case 5:
        setCurrentScreen(SCREEN_TYPES.PROJECT_SETUP);
        return;
      case 6:
        setCurrentScreen(SCREEN_TYPES.PROJECT_MODAL);
        return;
      default:
        setCurrentScreen(SCREEN_TYPES.WELCOME);
        return;

    }
  },[currentStep])
  return (
    <LoaderContext.Provider value={{ loading, setLoading, currentScreen, setCurrentScreen,
      globalAps, setGlobalAps, currentStep, setCurrentStep, completedSteps, setCompletedSteps, completeCurrentStep, completeStep }}>
     {children}
    </LoaderContext.Provider>
  );
};
