import React from 'react';
import {
    EuiFlexGroup,
    EuiFlexItem,
    EuiButtonIcon,
    EuiText,
    EuiButton,
    EuiToolTip
} from '@elastic/eui';
import { useResponsiveLayout } from '../hooks/useResponsiveLayout';

export const ResponsiveZoomControls = ({
                                           zoomLevel,
                                           onZoomIn,
                                           onZoomOut,
                                           onZoomReset,
                                           onZoomToFit,
                                           minZoom,
                                           maxZoom,
                                           className
                                       }) => {
    const { isMobile, isTablet } = useResponsiveLayout();

    if (isMobile) {
        // Mobile: Simpler floating controls
        return (
            <EuiFlexGroup gutterSize="xs" alignItems="center" className={className}>
                <EuiFlexItem grow={false}>
                    <EuiButtonIcon
                        iconType="minusInCircle"
                        onClick={onZoomOut}
                        size="l"
                        disabled={zoomLevel <= minZoom}
                        aria-label="Zoom out"
                        style={{ minWidth: '44px', minHeight: '44px' }}
                    />
                </EuiFlexItem>
                <EuiFlexItem grow={false}>
                    <EuiText size="s" style={{
                        minWidth: '60px',
                        textAlign: 'center',
                        fontWeight: 'bold'
                    }}>
                        {Math.round(zoomLevel * 100)}%
                    </EuiText>
                </EuiFlexItem>
                <EuiFlexItem grow={false}>
                    <EuiButtonIcon
                        iconType="plusInCircle"
                        onClick={onZoomIn}
                        size="l"
                        disabled={zoomLevel >= maxZoom}
                        aria-label="Zoom in"
                        style={{ minWidth: '44px', minHeight: '44px' }}
                    />
                </EuiFlexItem>
                <EuiFlexItem grow={false}>
                    <EuiButtonIcon
                        iconType="fullScreen"
                        onClick={onZoomToFit}
                        size="l"
                        aria-label="Fit to screen"
                        style={{ minWidth: '44px', minHeight: '44px' }}
                    />
                </EuiFlexItem>
            </EuiFlexGroup>
        );
    }

    // Desktop/Tablet: Full controls with tooltips
    return (
        <EuiFlexGroup gutterSize="s" alignItems="center" className={className}>
            <EuiFlexItem grow={false}>
                <EuiToolTip content="Zoom Out (Ctrl + Mouse Wheel)">
                    <EuiButtonIcon
                        iconType="minusInCircle"
                        onClick={onZoomOut}
                        disabled={zoomLevel <= minZoom}
                        aria-label="Zoom out"
                    />
                </EuiToolTip>
            </EuiFlexItem>
            <EuiFlexItem grow={false}>
                <EuiText size="s" style={{ minWidth: '60px', textAlign: 'center' }}>
                    {Math.round(zoomLevel * 100)}%
                </EuiText>
            </EuiFlexItem>
            <EuiFlexItem grow={false}>
                <EuiToolTip content="Zoom In (Ctrl + Mouse Wheel)">
                    <EuiButtonIcon
                        iconType="plusInCircle"
                        onClick={onZoomIn}
                        disabled={zoomLevel >= maxZoom}
                        aria-label="Zoom in"
                    />
                </EuiToolTip>
            </EuiFlexItem>
            <EuiFlexItem grow={false}>
                <EuiToolTip content="Fit to Screen">
                    <EuiButtonIcon
                        iconType="fullScreen"
                        onClick={onZoomToFit}
                        aria-label="Fit to screen"
                    />
                </EuiToolTip>
            </EuiFlexItem>
            <EuiFlexItem grow={false}>
                <EuiToolTip content="Reset Zoom & Pan">
                    <EuiButtonIcon
                        iconType="crosshairs"
                        onClick={onZoomReset}
                        aria-label="Reset zoom and pan"
                    />
                </EuiToolTip>
            </EuiFlexItem>
        </EuiFlexGroup>
    );
};
