"use client"
// React Dependencies
import React from "react";
// NextJs Dependencies
import { useRouter } from "next/navigation";
// Own Dependencies
import { getToken } from "@/hooks/auth";
import Cookies from "js-cookie";

/**
 * Custom react hook to determine if a user is authenticated
 */
export function useAuth() {
  const [isAuthenticated, setIsAuthenticated] = React.useState(false);
  const router = useRouter();
  const logout = () => {

    Cookies.remove("apiKey");

    // Redirect to the login page
    router.push("/login");

  }
  React.useEffect(() => {
    if (typeof window === "undefined") return; // Ensure client-side execution

    const token = getToken();
    if (!token) {
      router.replace("/login"); // Redirect if no valid token
      return;
    }

    setIsAuthenticated(true);
  }, []);

  return { isAuthenticated, logout };
}
