"use client"

// React Dependencies
import React from 'react';

// Own Dependencies
import Network from "@/app/types/Network";
import Device from "@/app/types/Device";

/**
 * Custom hook to manage the filters on a table.
 * @param {Network | Device []} items - The data fetched from the API.
 * @param {boolean} online - Display online filters.
 * @returns {Object} { items, newRowIds }
 */
export const useFilteredData = <T extends Network | Device>(items: T[], online: boolean) => {
  const [searchText, setSearchText] = React.useState('');
  const [selectedType, setSelectedType] = React.useState('');
  const [onlineFilter, setOnlineFilter] = React.useState<boolean | null>(null);

  const filteredItems = React.useMemo(() => {
    return items.filter((item: T) => {
      const nameMatch = searchText === '' || item.name.toLowerCase().includes(searchText.toLowerCase());
      const typeMatch = selectedType === '' || item.type === selectedType;
      let onlineMatch;
      if (online && 'online' in item) {
        onlineMatch = onlineFilter === null || item.online === onlineFilter;
        return nameMatch && typeMatch && onlineMatch;
      }
      return nameMatch && typeMatch;
    });
  }, [items, searchText, selectedType, onlineFilter]);

  return {
    filteredItems,
    searchText,
    setSearchText,
    selectedType,
    setSelectedType,
    onlineFilter,
    setOnlineFilter,
  };
};
