"use client"

import React from "react";
import Network from "@/app/types/Network";
import Device from "@/app/types/Device";

/**
 * Custom hook to manage items and highlight new rows.
 * @param {Network | Device []} apiData - The data fetched from the API.
 * @returns {Object} { items, newRowIds }
 */
export const useHighlightedItems = <T extends Network | Device>(apiData: T[]) => {
  const [items, setItems] = React.useState<T[]>([]);
  const [newRowIds, setNewRowIds] = React.useState<(string | number)[]>([]);
  const isFirstLoad = React.useRef(true);

  React.useEffect(() => {
    if (apiData.length > 0 && isFirstLoad.current) {
      setItems(apiData);
      isFirstLoad.current = false;
      return;
    }
    const existingIds = items.map(item => item.id);
    const newIds = apiData
      .filter(item => !existingIds.includes(item.id))
      .map(item => item.id);

    if (newIds.length > 0) {
      setItems(apiData);
      setNewRowIds(newIds);
      setTimeout(() => {
        setNewRowIds([]);
      }, 3000);
    }
  }, [apiData]);
  return { items, newRowIds };
}
